/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.test.infrastructure.providers;

import org.apache.hadoop.conf.Configuration;
import org.apache.log4j.Logger;
import org.apache.sqoop.test.infrastructure.providers.InfrastructureProvider;
import org.apache.sqoop.test.kdc.KdcRunner;
import org.apache.sqoop.test.kdc.KdcRunnerFactory;
import org.apache.sqoop.test.kdc.MiniKdcRunner;

public class KdcInfrastructureProvider
extends InfrastructureProvider {
    private static final Logger LOG = Logger.getLogger(KdcInfrastructureProvider.class);
    private KdcRunner instance;
    private Configuration conf;

    public KdcInfrastructureProvider() {
        try {
            this.instance = KdcRunnerFactory.getKdc(System.getProperties(), MiniKdcRunner.class);
        }
        catch (Exception e) {
            LOG.error((Object)"Error fetching Kdc runner.", (Throwable)e);
        }
    }

    @Override
    public void start() {
        try {
            this.instance.start();
        }
        catch (Exception e) {
            LOG.error((Object)"Could not start kdc.", (Throwable)e);
        }
    }

    @Override
    public void stop() {
        try {
            this.instance.stop();
        }
        catch (Exception e) {
            LOG.error((Object)"Could not stop kdc.", (Throwable)e);
        }
    }

    public KdcRunner getInstance() {
        return this.instance;
    }

    @Override
    public void setHadoopConfiguration(Configuration conf) {
        this.conf = conf;
    }

    @Override
    public Configuration getHadoopConfiguration() {
        return this.conf;
    }

    @Override
    public void setRootPath(String path) {
        this.instance.setTemporaryPath(path);
    }

    @Override
    public String getRootPath() {
        return this.instance.getTemporaryPath();
    }

    @Override
    public void setKdc(KdcRunner kdc) {
    }
}

