/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.test.infrastructure.providers;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.log4j.Logger;
import org.apache.sqoop.common.test.db.HiveProvider;
import org.apache.sqoop.test.hive.HiveServerRunner;
import org.apache.sqoop.test.hive.HiveServerRunnerFactory;
import org.apache.sqoop.test.hive.InternalHiveServerRunner;
import org.apache.sqoop.test.hive.InternalMetastoreServerRunner;
import org.apache.sqoop.test.hive.MetastoreServerRunner;
import org.apache.sqoop.test.hive.MetastoreServerRunnerFactory;
import org.apache.sqoop.test.infrastructure.providers.InfrastructureProvider;
import org.apache.sqoop.test.kdc.KdcRunner;
import org.apache.sqoop.test.utils.HdfsUtils;

public class HiveInfrastructureProvider
extends InfrastructureProvider {
    private static final Logger LOG = Logger.getLogger(HiveInfrastructureProvider.class);
    private HiveServerRunner hiveServerRunner;
    private MetastoreServerRunner metastoreServerRunner;
    private HiveProvider hiveProvider;
    private FileSystem hdfsClient;

    public HiveInfrastructureProvider() {
        try {
            this.metastoreServerRunner = MetastoreServerRunnerFactory.getRunner(System.getProperties(), InternalMetastoreServerRunner.class);
            this.hiveServerRunner = HiveServerRunnerFactory.getRunner(System.getProperties(), InternalHiveServerRunner.class);
        }
        catch (Exception e) {
            LOG.error((Object)"Error fetching Hadoop runner.", (Throwable)e);
        }
    }

    @Override
    public void start() {
        try {
            LOG.info((Object)("Starting Metastore Server: " + this.metastoreServerRunner.getClass().getName()));
            this.metastoreServerRunner.start();
            LOG.info((Object)("Starting Hive Server: " + this.hiveServerRunner.getClass().getName()));
            this.hiveServerRunner.start();
            LOG.info((Object)("Starting Hive Provider: " + HiveProvider.class.getName()));
            this.hiveProvider = new HiveProvider(this.hiveServerRunner.getUrl());
            this.hiveProvider.start();
        }
        catch (Exception e) {
            LOG.error((Object)"Error starting hive runner.", (Throwable)e);
        }
    }

    @Override
    public void stop() {
        try {
            if (this.hiveProvider != null) {
                LOG.info((Object)("Stopping Hive Provider: " + this.hiveProvider.getClass().getName()));
                this.hiveProvider.stop();
            }
            if (this.hiveServerRunner != null) {
                LOG.info((Object)("Stopping Hive Server: " + this.hiveServerRunner.getClass().getName()));
                this.hiveServerRunner.stop();
            }
            if (this.metastoreServerRunner != null) {
                LOG.info((Object)("Stopping Metastore Server: " + this.metastoreServerRunner.getClass().getName()));
                this.metastoreServerRunner.stop();
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Could not stop hive runner.", (Throwable)e);
        }
    }

    @Override
    public void setHadoopConfiguration(Configuration conf) {
        try {
            this.hdfsClient = FileSystem.get((Configuration)conf);
            String databasePath = HdfsUtils.joinPathFragments(this.getRootPath(), "metastore_db");
            this.metastoreServerRunner.setConfiguration(this.metastoreServerRunner.prepareConfiguration(conf));
            this.metastoreServerRunner.getConfiguration().set(HiveConf.ConfVars.METASTORECONNECTURLKEY.varname, "jdbc:derby:;databaseName=" + databasePath + ";create=true");
            this.ensureWarehouseDirectory((Configuration)this.metastoreServerRunner.getConfiguration());
            this.hiveServerRunner.setConfiguration(this.hiveServerRunner.prepareConfiguration((Configuration)this.metastoreServerRunner.getConfiguration()));
        }
        catch (Exception e) {
            LOG.error((Object)"Could not set configuration.", (Throwable)e);
        }
    }

    @Override
    public Configuration getHadoopConfiguration() {
        return this.hiveServerRunner.getConfiguration();
    }

    @Override
    public void setRootPath(String path) {
        this.metastoreServerRunner.setTemporaryPath(path);
    }

    @Override
    public String getRootPath() {
        return this.metastoreServerRunner.getTemporaryPath();
    }

    @Override
    public void setKdc(KdcRunner kdc) {
    }

    public MetastoreServerRunner getHiveMetastore() {
        return this.metastoreServerRunner;
    }

    public HiveServerRunner getHiveServer() {
        return this.hiveServerRunner;
    }

    public HiveProvider getHiveProvider() {
        return this.hiveProvider;
    }

    private void ensureWarehouseDirectory(Configuration conf) throws Exception {
        String warehouseDirectory = conf.get(HiveConf.ConfVars.METASTOREWAREHOUSE.varname);
        StringBuilder dir = new StringBuilder();
        for (String part : warehouseDirectory.split("/")) {
            dir.append(part).append("/");
            Path path = new Path(dir.toString());
            if (this.hdfsClient.exists(path)) continue;
            this.hdfsClient.mkdirs(path);
        }
        this.hdfsClient.setPermission(new Path(dir.toString()), new FsPermission(1023));
    }
}

