/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.test.infrastructure.providers;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.log4j.Logger;
import org.apache.sqoop.test.hadoop.HadoopMiniClusterRunner;
import org.apache.sqoop.test.hadoop.HadoopRunner;
import org.apache.sqoop.test.hadoop.HadoopRunnerFactory;
import org.apache.sqoop.test.infrastructure.providers.InfrastructureProvider;
import org.apache.sqoop.test.kdc.KdcRunner;

public class HadoopInfrastructureProvider
extends InfrastructureProvider {
    private static final Logger LOG = Logger.getLogger(HadoopInfrastructureProvider.class);
    private HadoopRunner instance;

    public HadoopInfrastructureProvider() {
        try {
            this.instance = HadoopRunnerFactory.getHadoopCluster(System.getProperties(), HadoopMiniClusterRunner.class);
        }
        catch (Exception e) {
            LOG.error((Object)"Error fetching Hadoop runner.", (Throwable)e);
        }
    }

    @Override
    public void start() {
        try {
            this.instance.start();
        }
        catch (Exception e) {
            LOG.error((Object)"Could not start hadoop runner.", (Throwable)e);
        }
    }

    @Override
    public void stop() {
        try {
            this.instance.stop();
        }
        catch (Exception e) {
            LOG.error((Object)"Could not stop hadoop runner.", (Throwable)e);
        }
    }

    @Override
    public void setHadoopConfiguration(Configuration conf) {
        try {
            Configuration newConf = this.instance.prepareConfiguration(conf);
            this.instance.setConfiguration(newConf);
            UserGroupInformation.setConfiguration((Configuration)newConf);
        }
        catch (Exception e) {
            LOG.error((Object)"Could not set configuration.", (Throwable)e);
        }
    }

    @Override
    public Configuration getHadoopConfiguration() {
        return this.instance.getConfiguration();
    }

    @Override
    public void setRootPath(String path) {
        this.instance.setTemporaryPath(path);
    }

    @Override
    public String getRootPath() {
        return this.instance.getTemporaryPath();
    }

    public HadoopRunner getInstance() {
        return this.instance;
    }

    @Override
    public void setKdc(KdcRunner kdc) {
    }
}

