/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.test.infrastructure;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kafka.message.MessageAndMetadata;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.security.token.delegation.web.DelegationTokenAuthenticatedURL;
import org.apache.log4j.Logger;
import org.apache.sqoop.client.SqoopClient;
import org.apache.sqoop.client.SubmissionCallback;
import org.apache.sqoop.common.test.asserts.ProviderAsserts;
import org.apache.sqoop.common.test.db.DatabaseProvider;
import org.apache.sqoop.common.test.db.TableName;
import org.apache.sqoop.common.test.kafka.TestUtil;
import org.apache.sqoop.connector.common.SqoopIDFUtils;
import org.apache.sqoop.connector.hdfs.configuration.ToFormat;
import org.apache.sqoop.model.MAccountableEntity;
import org.apache.sqoop.model.MFromConfig;
import org.apache.sqoop.model.MJob;
import org.apache.sqoop.model.MLink;
import org.apache.sqoop.model.MLinkConfig;
import org.apache.sqoop.model.MSubmission;
import org.apache.sqoop.model.MToConfig;
import org.apache.sqoop.submission.SubmissionStatus;
import org.apache.sqoop.test.asserts.HdfsAsserts;
import org.apache.sqoop.test.data.Cities;
import org.apache.sqoop.test.data.ShortStories;
import org.apache.sqoop.test.data.UbuntuReleases;
import org.apache.sqoop.test.infrastructure.Infrastructure;
import org.apache.sqoop.test.infrastructure.providers.DatabaseInfrastructureProvider;
import org.apache.sqoop.test.infrastructure.providers.HadoopInfrastructureProvider;
import org.apache.sqoop.test.infrastructure.providers.InfrastructureProvider;
import org.apache.sqoop.test.infrastructure.providers.KdcInfrastructureProvider;
import org.apache.sqoop.test.infrastructure.providers.SqoopInfrastructureProvider;
import org.apache.sqoop.test.kdc.KdcRunner;
import org.apache.sqoop.test.kdc.NoKdcRunner;
import org.apache.sqoop.test.utils.HdfsUtils;
import org.apache.sqoop.test.utils.SqoopUtils;
import org.apache.sqoop.utils.UrlSafeUtils;
import org.apache.sqoop.validation.Status;
import org.testng.Assert;
import org.testng.ITest;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.annotations.AfterSuite;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeSuite;

public class SqoopTestCase
implements ITest {
    private static final Logger LOG = Logger.getLogger(SqoopTestCase.class);
    private static final String ROOT_PATH = System.getProperty("sqoop.integration.tmpdir", System.getProperty("java.io.tmpdir", "/tmp")) + "/sqoop-cargo-tests";
    private static final Map<String, InfrastructureProvider> PROVIDERS = new HashMap<String, InfrastructureProvider>();
    protected static final SubmissionCallback DEFAULT_SUBMISSION_CALLBACKS = new SubmissionCallback(){

        public void submitted(MSubmission submission) {
            LOG.info((Object)("Submission submitted: " + submission));
        }

        public void updated(MSubmission submission) {
            LOG.info((Object)("Submission updated: " + submission));
        }

        public void finished(MSubmission submission) {
            LOG.info((Object)("Submission finished: " + submission));
        }
    };
    private static String suiteName;
    protected String methodName;
    private SqoopClient client;
    protected DelegationTokenAuthenticatedURL.Token authToken = new DelegationTokenAuthenticatedURL.Token();
    protected FileSystem hdfsClient;
    protected DatabaseProvider provider;

    @BeforeSuite
    public static void findSuiteName(ITestContext context) {
        suiteName = context.getSuite().getName();
    }

    @BeforeMethod
    public void findMethodName(Method method) {
        this.methodName = method.getName();
    }

    public String getTestName() {
        return this.methodName;
    }

    @BeforeSuite(dependsOnMethods={"findSuiteName"})
    public static void startInfrastructureProviders(ITestContext context) throws Exception {
        HashSet<Class<? extends InfrastructureProvider>> providers = new HashSet<Class<? extends InfrastructureProvider>>();
        for (ITestNGMethod method : context.getSuite().getAllMethods()) {
            Infrastructure ann;
            LOG.debug((Object)("Looking up dependencies on method (" + method.getConstructorOrMethod().getDeclaringClass().getCanonicalName() + "#" + method.getConstructorOrMethod().getMethod().getName() + ")"));
            if (method.getConstructorOrMethod().getMethod() != null && (ann = method.getConstructorOrMethod().getMethod().getAnnotation(Infrastructure.class)) != null && ann.dependencies() != null) {
                LOG.debug((Object)("Found dependencies on method (" + method.getConstructorOrMethod().getDeclaringClass().getCanonicalName() + "#" + method.getConstructorOrMethod().getMethod().getName() + "): " + StringUtils.join((Object[])ann.dependencies(), (String)",")));
                providers.addAll(Arrays.asList(ann.dependencies()));
            }
            if ((ann = method.getConstructorOrMethod().getDeclaringClass().getAnnotation(Infrastructure.class)) == null || ann.dependencies() == null) continue;
            LOG.debug((Object)("Found dependencies on class (" + method.getConstructorOrMethod().getDeclaringClass().getCanonicalName() + "): " + StringUtils.join((Object[])ann.dependencies(), (String)",")));
            providers.addAll(Arrays.asList(ann.dependencies()));
        }
        JobConf conf = new JobConf();
        KdcRunner kdc = null;
        if (providers.contains(KdcInfrastructureProvider.class)) {
            KdcInfrastructureProvider kdcProviderObject = SqoopTestCase.startInfrastructureProvider(KdcInfrastructureProvider.class, (Configuration)conf, null);
            kdc = kdcProviderObject.getInstance();
            providers.remove(KdcInfrastructureProvider.class);
            conf = kdc instanceof NoKdcRunner ? SqoopTestCase.setNonKerberosConfiguration((Configuration)conf) : kdc.prepareHadoopConfiguration((Configuration)conf);
        } else {
            conf = SqoopTestCase.setNonKerberosConfiguration((Configuration)conf);
        }
        if (providers.contains(HadoopInfrastructureProvider.class)) {
            HadoopInfrastructureProvider hadoopProviderObject = SqoopTestCase.startInfrastructureProvider(HadoopInfrastructureProvider.class, (Configuration)conf, kdc);
            if (hadoopProviderObject != null) {
                conf = ((InfrastructureProvider)hadoopProviderObject).getHadoopConfiguration();
            }
            providers.remove(HadoopInfrastructureProvider.class);
        }
        for (Class clazz : providers) {
            SqoopTestCase.startInfrastructureProvider(clazz, (Configuration)conf, kdc);
        }
    }

    private static Configuration setNonKerberosConfiguration(Configuration conf) {
        conf.set("dfs.block.access.token.enable", "false");
        conf.set("hadoop.security.authentication", "simple");
        return conf;
    }

    protected static <T extends InfrastructureProvider> T startInfrastructureProvider(Class<T> providerClass, Configuration hadoopConfiguration, KdcRunner kdc) {
        InfrastructureProvider providerObject;
        try {
            providerObject = (InfrastructureProvider)providerClass.newInstance();
        }
        catch (Exception e) {
            LOG.error((Object)"Could not instantiate new instance of InfrastructureProvider.", (Throwable)e);
            return null;
        }
        providerObject.setRootPath(HdfsUtils.joinPathFragments(ROOT_PATH, suiteName, providerClass.getCanonicalName()));
        providerObject.setHadoopConfiguration(hadoopConfiguration);
        providerObject.setKdc(kdc);
        providerObject.start();
        if (providerObject instanceof SqoopInfrastructureProvider) {
            PROVIDERS.put(SqoopInfrastructureProvider.class.getCanonicalName(), providerObject);
        } else {
            PROVIDERS.put(providerClass.getCanonicalName(), providerObject);
        }
        System.out.println("Infrastructure Provider " + providerClass.getCanonicalName());
        return (T)providerObject;
    }

    @AfterSuite
    public static void stopInfrastructureProviders() {
        for (InfrastructureProvider provider : PROVIDERS.values()) {
            provider.stop();
        }
    }

    public static <T extends InfrastructureProvider> T getInfrastructureProvider(Class<T> providerClass) {
        InfrastructureProvider provider = PROVIDERS.get(providerClass.getCanonicalName());
        return (T)provider;
    }

    public String getMapreduceDirectory() {
        return HdfsUtils.joinPathFragments(SqoopTestCase.getInfrastructureProvider(HadoopInfrastructureProvider.class).getInstance().getTestDirectory(), this.getClass().getName(), UrlSafeUtils.urlPathEncode((String)this.getTestName()));
    }

    public void fillRdbmsLinkConfig(MLink link) {
        DatabaseProvider provider = SqoopTestCase.getInfrastructureProvider(DatabaseInfrastructureProvider.class).getInstance();
        MLinkConfig configs = link.getConnectorLinkConfig();
        configs.getStringInput("linkConfig.jdbcDriver").setValue((Object)provider.getJdbcDriver());
        configs.getStringInput("linkConfig.connectionString").setValue((Object)provider.getConnectionUrl());
        configs.getStringInput("linkConfig.username").setValue((Object)provider.getConnectionUsername());
        configs.getStringInput("linkConfig.password").setValue((Object)provider.getConnectionPassword());
    }

    public void fillRdbmsFromConfig(MJob job, String partitionColumn) {
        MFromConfig fromConfig = job.getFromJobConfig();
        fromConfig.getStringInput("fromJobConfig.tableName").setValue((Object)this.getTableName().getTableName());
        fromConfig.getStringInput("fromJobConfig.partitionColumn").setValue((Object)partitionColumn);
    }

    public void fillRdbmsToConfig(MJob job) {
        MToConfig toConfig = job.getToJobConfig();
        toConfig.getStringInput("toJobConfig.tableName").setValue((Object)this.getTableName().getTableName());
    }

    public void fillHdfsLinkConfig(MLink link) {
        MLinkConfig configs = link.getConnectorLinkConfig();
        configs.getStringInput("linkConfig.confDir").setValue((Object)SqoopTestCase.getInfrastructureProvider(SqoopInfrastructureProvider.class).getInstance().getConfigurationPath());
    }

    public void fillHdfsFromConfig(MJob job) {
        MFromConfig fromConfig = job.getFromJobConfig();
        fromConfig.getStringInput("fromJobConfig.inputDirectory").setValue((Object)this.getMapreduceDirectory());
    }

    public void fillHdfsToConfig(MJob job, ToFormat output) {
        MToConfig toConfig = job.getToJobConfig();
        toConfig.getEnumInput("toJobConfig.outputFormat").setValue((Enum)output);
        toConfig.getStringInput("toJobConfig.outputDirectory").setValue((Object)this.getMapreduceDirectory());
    }

    public void fillHdfsLink(MLink link) {
        MLinkConfig configs = link.getConnectorLinkConfig();
        configs.getStringInput("linkConfig.confDir").setValue((Object)SqoopTestCase.getInfrastructureProvider(SqoopInfrastructureProvider.class).getInstance().getConfigurationPath());
    }

    public String getSqoopServerUrl() {
        if (SqoopTestCase.getInfrastructureProvider(SqoopInfrastructureProvider.class) == null) {
            return null;
        }
        return SqoopTestCase.getInfrastructureProvider(SqoopInfrastructureProvider.class).getInstance().getServerUrl();
    }

    public SqoopClient getClient() {
        return this.client;
    }

    public DelegationTokenAuthenticatedURL.Token getAuthToken() {
        return this.authToken;
    }

    @BeforeMethod
    public void init() throws Exception {
        this.initSqoopClient(this.getSqoopServerUrl());
        if (SqoopTestCase.getInfrastructureProvider(HadoopInfrastructureProvider.class) != null) {
            this.hdfsClient = FileSystem.get((Configuration)SqoopTestCase.getInfrastructureProvider(HadoopInfrastructureProvider.class).getHadoopConfiguration());
            this.hdfsClient.delete(new Path(this.getMapreduceDirectory()), true);
        }
        if (SqoopTestCase.getInfrastructureProvider(DatabaseInfrastructureProvider.class) != null) {
            this.provider = SqoopTestCase.getInfrastructureProvider(DatabaseInfrastructureProvider.class).getInstance();
        }
    }

    protected void initSqoopClient(String serverUrl) throws Exception {
        if (serverUrl != null) {
            this.client = new SqoopClient(serverUrl);
            KdcInfrastructureProvider kdcProvider = SqoopTestCase.getInfrastructureProvider(KdcInfrastructureProvider.class);
            if (kdcProvider != null) {
                kdcProvider.getInstance().authenticateWithSqoopServer(this.client);
                kdcProvider.getInstance().authenticateWithSqoopServer(new URL(serverUrl), this.authToken);
            }
        }
    }

    public void saveLink(MLink link) {
        SqoopUtils.fillObjectName((MAccountableEntity)link);
        Assert.assertEquals((Object)Status.OK, (Object)this.getClient().saveLink(link));
    }

    public void saveJob(MJob job) {
        SqoopUtils.fillObjectName((MAccountableEntity)job);
        Assert.assertEquals((Object)Status.OK, (Object)this.getClient().saveJob(job));
    }

    public void executeJob(String jobName, boolean isAssertStatus) throws Exception {
        MSubmission finalSubmission = this.getClient().startJob(jobName, DEFAULT_SUBMISSION_CALLBACKS, 100L);
        if (finalSubmission.getStatus().isFailure()) {
            LOG.error((Object)("Submission has failed: " + finalSubmission.getError().getErrorSummary()));
            LOG.error((Object)("Corresponding error details: " + finalSubmission.getError().getErrorDetails()));
        }
        if (isAssertStatus) {
            Assert.assertEquals((Object)finalSubmission.getStatus(), (Object)SubmissionStatus.SUCCEEDED, (String)("Submission finished with error: " + finalSubmission.getError().getErrorSummary()));
        }
    }

    protected void executeJob(MJob job) throws Exception {
        this.executeJob(job.getName(), true);
    }

    public TableName getTableName() {
        return new TableName(this.getClass().getSimpleName());
    }

    public void createTable(String primaryKey, String ... columns) {
        SqoopTestCase.getInfrastructureProvider(DatabaseInfrastructureProvider.class).getInstance().createTable(this.getTableName(), primaryKey, columns);
    }

    public void dropTable() {
        SqoopTestCase.getInfrastructureProvider(DatabaseInfrastructureProvider.class).getInstance().dropTable(this.getTableName());
    }

    public void insertRow(Object ... values) {
        SqoopTestCase.getInfrastructureProvider(DatabaseInfrastructureProvider.class).getInstance().insertRow(this.getTableName(), values);
    }

    public long rowCount() {
        return SqoopTestCase.getInfrastructureProvider(DatabaseInfrastructureProvider.class).getInstance().rowCount(this.getTableName());
    }

    public void dumpTable() {
        SqoopTestCase.getInfrastructureProvider(DatabaseInfrastructureProvider.class).getInstance().dumpTable(this.getTableName());
    }

    public void createAndLoadTableCities() {
        new Cities(SqoopTestCase.getInfrastructureProvider(DatabaseInfrastructureProvider.class).getInstance(), this.getTableName()).createTables().loadBasicData();
    }

    public void createTableUbuntuReleases() {
        new UbuntuReleases(SqoopTestCase.getInfrastructureProvider(DatabaseInfrastructureProvider.class).getInstance(), this.getTableName()).createTables();
    }

    public void createAndLoadTableUbuntuReleases() {
        new UbuntuReleases(SqoopTestCase.getInfrastructureProvider(DatabaseInfrastructureProvider.class).getInstance(), this.getTableName()).createTables().loadBasicData();
    }

    public void createTableShortStories() {
        new ShortStories(SqoopTestCase.getInfrastructureProvider(DatabaseInfrastructureProvider.class).getInstance(), this.getTableName()).createTables();
    }

    public void createAndLoadTableShortStories() {
        new ShortStories(SqoopTestCase.getInfrastructureProvider(DatabaseInfrastructureProvider.class).getInstance(), this.getTableName()).createTables().loadBasicData();
    }

    public void clearJob() {
        for (MJob job : this.getClient().getJobs()) {
            this.getClient().deleteJob(job.getName());
        }
    }

    public void clearLink() {
        for (MLink link : this.getClient().getLinks()) {
            this.getClient().deleteLink(link.getName());
        }
    }

    protected void assertTo(String ... lines) throws IOException {
        HdfsAsserts.assertMapreduceOutput(this.hdfsClient, this.getMapreduceDirectory(), lines);
    }

    protected void assertToFiles(int expectedFiles) throws IOException {
        HdfsAsserts.assertMapreduceOutputFiles(this.hdfsClient, this.getMapreduceDirectory(), expectedFiles);
    }

    protected void assertRow(Object[] conditions, Object ... values) {
        DatabaseProvider provider = SqoopTestCase.getInfrastructureProvider(DatabaseInfrastructureProvider.class).getInstance();
        ProviderAsserts.assertRow((DatabaseProvider)provider, (TableName)this.getTableName(), (Object[])conditions, (Object[])values);
    }

    protected void assertRowInCities(Object ... values) {
        this.assertRow(new Object[]{"id", values[0]}, values);
    }

    protected void createFromFile(String filename, String ... lines) throws IOException {
        this.createFromFile(this.hdfsClient, filename, lines);
    }

    protected void createFromFile(FileSystem hdfsClient, String filename, String ... lines) throws IOException {
        HdfsUtils.createFile(hdfsClient, HdfsUtils.joinPathFragments(this.getMapreduceDirectory(), filename), lines);
    }

    protected void createTableCities() {
        DatabaseProvider provider = SqoopTestCase.getInfrastructureProvider(DatabaseInfrastructureProvider.class).getInstance();
        new Cities(provider, this.getTableName()).createTables();
    }

    protected void fillKafkaLinkConfig(MLink link) {
        MLinkConfig configs = link.getConnectorLinkConfig();
        configs.getStringInput("linkConfig.brokerList").setValue((Object)TestUtil.getInstance().getKafkaServerUrl());
        configs.getStringInput("linkConfig.zookeeperConnect").setValue((Object)TestUtil.getInstance().getZkUrl());
    }

    protected void fillKafkaToConfig(MJob job, String topic) {
        MToConfig toConfig = job.getToJobConfig();
        toConfig.getStringInput("toJobConfig.topic").setValue((Object)topic);
        ArrayList<String> topics = new ArrayList<String>(1);
        topics.add(topic);
        TestUtil.getInstance().initTopicList(topics);
    }

    protected void validateContent(String[] content, String topic) throws UnsupportedEncodingException {
        HashSet<String> inputSet = new HashSet<String>(Arrays.asList(content));
        HashSet<String> outputSet = new HashSet<String>();
        for (int i = 0; i < content.length; ++i) {
            MessageAndMetadata fetchedMsg = TestUtil.getInstance().getNextMessageFromConsumer(topic);
            outputSet.add(SqoopIDFUtils.toText((String)new String((byte[])fetchedMsg.message(), "UTF-8")));
        }
        Assert.assertEquals(inputSet, outputSet);
    }

    protected String getTemporaryPath() {
        return HdfsUtils.joinPathFragments(ROOT_PATH, suiteName);
    }

    protected String getSqoopMiniClusterTemporaryPath() {
        return SqoopTestCase.getInfrastructureProvider(SqoopInfrastructureProvider.class).getRootPath();
    }

    protected Configuration getHadoopConf() {
        Configuration hadoopConf = null;
        hadoopConf = SqoopTestCase.getInfrastructureProvider(HadoopInfrastructureProvider.class) != null ? SqoopTestCase.getInfrastructureProvider(HadoopInfrastructureProvider.class).getHadoopConfiguration() : new Configuration();
        return hadoopConf;
    }

    protected MLink createLink(String linkName, String connectorName) {
        MLink link = this.getClient().createLink(connectorName);
        link.setName(linkName);
        this.saveLink(link);
        return link;
    }
}

