/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.test.hive;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStore;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.hive.thrift.HadoopThriftAuthBridge;
import org.apache.log4j.Logger;
import org.apache.sqoop.common.test.utils.NetworkUtils;
import org.apache.sqoop.test.hive.MetastoreServerRunner;

public class InternalMetastoreServerRunner
extends MetastoreServerRunner {
    private static final Logger LOG = Logger.getLogger(InternalMetastoreServerRunner.class);
    private ExecutorService executor = Executors.newSingleThreadExecutor();

    public InternalMetastoreServerRunner(String hostname, int port) throws Exception {
        super(hostname, port);
    }

    @Override
    public void start() throws Exception {
        Long start = System.currentTimeMillis();
        final int metastorePort = this.getPort();
        final HiveConf conf = this.getConfiguration();
        Callable<Void> metastoreService = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    HiveMetaStore.startMetaStore((int)metastorePort, (HadoopThriftAuthBridge)ShimLoader.getHadoopThriftAuthBridge(), (HiveConf)conf);
                    while (true) {
                        // Infinite loop
                    }
                }
                catch (Throwable e) {
                    throw new Exception("Error starting metastore", e);
                }
            }
        };
        this.executor.submit(metastoreService);
        NetworkUtils.waitForStartUp((String)this.getHostName(), (int)this.getPort(), (int)5, (long)1000L);
        Long end = System.currentTimeMillis();
        LOG.debug((Object)("Metastore service took " + (end - start) + "ms to start"));
    }

    @Override
    public void stop() throws Exception {
        this.executor.shutdownNow();
    }
}

