/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.test.hadoop;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;
import org.apache.sqoop.test.hadoop.HadoopRunner;

public class HadoopRealClusterRunner
extends HadoopRunner {
    private static final Logger LOG = Logger.getLogger(HadoopRealClusterRunner.class);

    @Override
    public Configuration prepareConfiguration(Configuration config) throws Exception {
        String configPath = System.getProperty("sqoop.hadoop.localconfig.path", "/etc/hadoop/conf");
        LOG.debug((Object)("Config path is: " + configPath));
        File dir = new File(configPath);
        String[] files = dir.list(new HRCRRilenameFilter());
        if (files == null) {
            throw new FileNotFoundException("Hadoop config files not found: " + configPath);
        }
        for (String file : files) {
            LOG.info((Object)("Found hadoop configuration file " + file));
            config.addResource(new Path(configPath, file));
        }
        return config;
    }

    @Override
    public void start() throws Exception {
    }

    @Override
    public void stop() throws Exception {
    }

    private static class HRCRRilenameFilter
    implements FilenameFilter {
        private HRCRRilenameFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith("-site.xml");
        }
    }
}

