/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.test.hadoop;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.log4j.Logger;
import org.apache.sqoop.test.hadoop.HadoopRunner;

public class HadoopMiniClusterRunner
extends HadoopRunner {
    private static final Logger LOG = Logger.getLogger(HadoopMiniClusterRunner.class);
    protected MiniDFSCluster dfsCluster;
    protected MiniMRCluster mrCluster;

    @Override
    public Configuration prepareConfiguration(Configuration config) throws Exception {
        config.set("dfs.permissions", "true");
        config.set("mapred.tasktracker.map.tasks.maximum", "1");
        config.set("mapred.tasktracker.reduce.tasks.maximum", "1");
        config.set("mapred.submit.replication", "1");
        config.set("yarn.resourcemanager.scheduler.class", "org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler");
        config.set("yarn.application.classpath", System.getProperty("java.class.path"));
        config.set("dfs.datanode.address", "0.0.0.0:0");
        config.set("dfs.datanode.ipc.address", "0.0.0.0:0");
        config.set("dfs.datanode.http.address", "0.0.0.0:0");
        config.set("dfs.datanode.https.address", "0.0.0.0:0");
        config.set("dfs.namenode.http-address", "0.0.0.0:0");
        config.set("dfs.namenode.https-address", "0.0.0.0:0");
        return config;
    }

    @Override
    public void start() throws Exception {
        System.setProperty("test.build.data", this.getDataDir());
        LOG.info((Object)("test.build.data set to: " + this.getDataDir()));
        System.setProperty("hadoop.log.dir", this.getLogDir());
        LOG.info((Object)("log dir set to: " + this.getLogDir()));
        LOG.info((Object)"Starting DFS cluster...");
        this.dfsCluster = new MiniDFSCluster.Builder(this.config).numDataNodes(1).format(true).racks(null).checkDataNodeAddrConfig(true).build();
        if (this.dfsCluster.isClusterUp()) {
            LOG.info((Object)("Started DFS cluster on port: " + this.dfsCluster.getNameNodePort()));
        } else {
            LOG.error((Object)"Could not start DFS cluster");
        }
        LOG.info((Object)"Starting MR cluster");
        this.mrCluster = new MiniMRCluster(0, 0, 1, this.dfsCluster.getFileSystem().getUri().toString(), 1, null, null, null, new JobConf(this.config));
        LOG.info((Object)"Started MR cluster");
        this.config = this.prepareConfiguration((Configuration)this.mrCluster.createJobConf());
    }

    @Override
    public void stop() throws Exception {
        LOG.info((Object)"Stopping MR cluster");
        this.mrCluster.shutdown();
        LOG.info((Object)"Stopped MR cluster");
        LOG.info((Object)"Stopping DFS cluster");
        this.dfsCluster.shutdown();
        LOG.info((Object)"Stopped DFS cluster");
    }
}

