/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.test.testcases;

import java.io.IOException;
import org.apache.log4j.Logger;
import org.apache.sqoop.client.SqoopClient;
import org.apache.sqoop.test.asserts.HdfsAsserts;
import org.apache.sqoop.test.minicluster.TomcatSqoopMiniCluster;
import org.apache.sqoop.test.utils.HdfsUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.TestName;

public abstract class TomcatTestCase {
    private static final Logger LOG = Logger.getLogger(TomcatTestCase.class);
    @Rule
    public TestName name = new TestName();
    private static final String TMP_PATH_BASE = System.getProperty("sqoop.integration.tmpdir", System.getProperty("java.io.tmpdir", "/tmp")) + "/sqoop-cargo-tests/";
    private String tmpPath;
    private TomcatSqoopMiniCluster cluster;
    private SqoopClient client;

    @Before
    public void startServer() throws Exception {
        this.tmpPath = TMP_PATH_BASE + this.getClass().getName() + "/" + this.name.getMethodName() + "/";
        this.cluster = new TomcatSqoopMiniCluster(this.getTemporaryPath());
        this.cluster.start();
        this.client = new SqoopClient(this.getServerUrl());
    }

    @After
    public void stopServer() throws Exception {
        this.cluster.stop();
    }

    public SqoopClient getClient() {
        return this.client;
    }

    public String getTemporaryPath() {
        return this.tmpPath;
    }

    public String getServerUrl() {
        return this.cluster.getServerUrl();
    }

    public String getMapreduceDirectory() {
        return this.getTemporaryPath() + "/mapreduce-job-io";
    }

    protected void assertMapreduceOutput(String ... lines) throws IOException {
        HdfsAsserts.assertMapreduceOutput(this.getMapreduceDirectory(), lines);
    }

    protected void assertMapreduceOutputFiles(int expectedFiles) {
        HdfsAsserts.assertMapreduceOutputFiles(this.getMapreduceDirectory(), expectedFiles);
    }

    protected void createInputMapreduceFile(String filename, String ... lines) throws IOException {
        HdfsUtils.createFile(this.getMapreduceDirectory(), filename, lines);
    }
}

