/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.test.db;

import java.net.InetAddress;
import org.apache.derby.drda.NetworkServerControl;
import org.apache.log4j.Logger;
import org.apache.sqoop.test.db.DatabaseProvider;

public class DerbyProvider
extends DatabaseProvider {
    private static final Logger LOG = Logger.getLogger(DerbyProvider.class);
    public static final String DRIVER = "org.apache.derby.jdbc.ClientDriver";
    NetworkServerControl server = null;

    @Override
    public void start() {
        try {
            this.server = new NetworkServerControl(InetAddress.getByName("localhost"), 1527);
            this.server.start(null);
        }
        catch (Exception e) {
            LOG.error((Object)"Can't start Derby network server", (Throwable)e);
            throw new RuntimeException("Can't derby server", e);
        }
        super.start();
    }

    @Override
    public void stop() {
        super.stop();
        try {
            this.server.shutdown();
        }
        catch (Exception e) {
            LOG.info((Object)"Can't shut down embedded server", (Throwable)e);
        }
    }

    @Override
    public String escapeColumnName(String columnName) {
        return this.escape(columnName);
    }

    @Override
    public String escapeTableName(String tableName) {
        return this.escape(tableName);
    }

    @Override
    public String escapeValueString(String value) {
        return "'" + value + "'";
    }

    @Override
    public boolean isSupportingScheme() {
        return true;
    }

    public String escape(String entity) {
        return "\"" + entity + "\"";
    }

    @Override
    public String getJdbcDriver() {
        return DRIVER;
    }

    @Override
    public String getConnectionUrl() {
        return "jdbc:derby://localhost:1527/memory:sqoop;create=true";
    }

    @Override
    public String getConnectionUsername() {
        return null;
    }

    @Override
    public String getConnectionPassword() {
        return null;
    }
}

