/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.test.db;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public abstract class DatabaseProvider {
    private static final Logger LOG = Logger.getLogger(DatabaseProvider.class);
    private Connection connection;

    public abstract String getConnectionUrl();

    public abstract String getConnectionUsername();

    public abstract String getConnectionPassword();

    public abstract String escapeColumnName(String var1);

    public abstract String escapeTableName(String var1);

    public abstract String escapeValueString(String var1);

    public String nullConstant() {
        return "NULL";
    }

    public boolean isSupportingScheme() {
        return false;
    }

    public String getJdbcDriver() {
        return null;
    }

    public void start() {
        if (this.getJdbcDriver() != null) {
            this.loadClass(this.getJdbcDriver());
        }
        try {
            this.setConnection(DriverManager.getConnection(this.getConnectionUrl(), this.getConnectionUsername(), this.getConnectionPassword()));
        }
        catch (SQLException e) {
            LOG.error((Object)"Can't create connection", (Throwable)e);
            throw new RuntimeException("Can't create connection", e);
        }
    }

    public void stop() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (SQLException e) {
                LOG.info((Object)"Ignored exception on closing connection", (Throwable)e);
            }
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    protected void setConnection(Connection connection) {
        this.connection = connection;
    }

    public void executeUpdate(String query) {
        LOG.info((Object)("Executing query: " + query));
        Statement stmt = null;
        try {
            stmt = this.connection.createStatement();
            stmt.executeUpdate(query);
        }
        catch (SQLException e) {
            LOG.error((Object)"Error in executing query", (Throwable)e);
            throw new RuntimeException("Error in executing query", e);
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException e) {
                LOG.info((Object)"Cant' close statement", (Throwable)e);
            }
        }
    }

    public ResultSet executeQuery(String query) {
        LOG.info((Object)("Executing query: " + query));
        Statement stmt = null;
        try {
            stmt = this.connection.createStatement();
            return stmt.executeQuery(query);
        }
        catch (SQLException e) {
            LOG.error((Object)"Error in executing query", (Throwable)e);
            throw new RuntimeException("Error in executing query", e);
        }
    }

    public void createTable(String name, String primaryKey, String ... columns) {
        if (columns.length == 0 || columns.length % 2 != 0) {
            throw new RuntimeException("Incorrect number of parameters.");
        }
        this.dropTable(name);
        StringBuilder sb = new StringBuilder("CREATE TABLE ");
        sb.append(this.escapeTableName(name)).append("(");
        LinkedList<String> columnList = new LinkedList<String>();
        for (int i = 0; i < columns.length; i += 2) {
            String column = this.escapeColumnName(columns[i]) + " " + columns[i + 1];
            columnList.add(column);
        }
        sb.append(StringUtils.join(columnList, (String)", "));
        if (primaryKey != null) {
            sb.append(", PRIMARY KEY(").append(this.escapeColumnName(primaryKey)).append(")");
        }
        sb.append(")");
        this.executeUpdate(sb.toString());
    }

    public void insertRow(String tableName, Object ... values) {
        StringBuilder sb = new StringBuilder("INSERT INTO ");
        sb.append(this.escapeTableName(tableName));
        sb.append(" VALUES (");
        LinkedList<String> valueList = new LinkedList<String>();
        for (Object value : values) {
            valueList.add(this.convertObjectToQueryString(value));
        }
        sb.append(StringUtils.join(valueList, (String)", "));
        sb.append(")");
        this.executeUpdate(sb.toString());
    }

    public ResultSet getRows(String tableName, Object[] conditions) {
        if (conditions.length % 2 != 0) {
            throw new RuntimeException("Incorrect number of parameters.");
        }
        StringBuilder sb = new StringBuilder("SELECT * FROM ");
        sb.append(this.escapeTableName(tableName));
        LinkedList<String> conditionList = new LinkedList<String>();
        for (int i = 0; i < conditions.length; i += 2) {
            Object columnName = conditions[i];
            Object value = conditions[i + 1];
            if (!(columnName instanceof String)) {
                throw new RuntimeException("Each odd item should be a string with column name.");
            }
            if (value == null) {
                conditionList.add(this.escapeColumnName((String)columnName) + " IS NULL");
                continue;
            }
            conditionList.add(this.escapeColumnName((String)columnName) + " = " + this.convertObjectToQueryString(value));
        }
        if (conditionList.size() != 0) {
            sb.append(" WHERE ").append(StringUtils.join(conditionList, (String)" AND "));
        }
        return this.executeQuery(sb.toString());
    }

    public String convertObjectToQueryString(Object value) {
        if (value == null) {
            return this.nullConstant();
        }
        if (value.getClass() == String.class) {
            return this.escapeValueString((String)value);
        }
        return value.toString();
    }

    public void dropTable(String tableName) {
        StringBuilder sb = new StringBuilder("DROP TABLE ");
        sb.append(this.escapeTableName(tableName));
        try {
            this.executeUpdate(sb.toString());
        }
        catch (RuntimeException e) {
            LOG.info((Object)("Ignoring exception: " + e));
        }
    }

    public long rowCount(String tableName) {
        StringBuilder sb = new StringBuilder("SELECT COUNT(*) FROM ");
        sb.append(this.escapeTableName(tableName));
        ResultSet rs = null;
        try {
            rs = this.executeQuery(sb.toString());
            if (!rs.next()) {
                throw new RuntimeException("Row count query did not returned any rows.");
            }
            long l = rs.getLong(1);
            return l;
        }
        catch (SQLException e) {
            LOG.error((Object)"Can't get number of rows: ", (Throwable)e);
            throw new RuntimeException("Can't get number of rows: ", e);
        }
        finally {
            this.closeResultSetWithStatement(rs);
        }
    }

    public void closeResultSetWithStatement(ResultSet rs) {
        if (rs != null) {
            try {
                Statement stmt = rs.getStatement();
                rs.close();
                stmt.close();
            }
            catch (SQLException e) {
                LOG.info((Object)"Ignoring exception: ", (Throwable)e);
            }
        }
    }

    public void loadClass(String className) {
        try {
            Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Class not found: " + className, e);
        }
    }
}

