/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.test.asserts;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.apache.sqoop.test.db.DatabaseProvider;
import org.junit.Assert;

public class ProviderAsserts {
    private static final Logger LOG = Logger.getLogger(ProviderAsserts.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assertRow(DatabaseProvider provider, String tableName, Object[] conditions, Object ... values) {
        ResultSet rs = null;
        try {
            rs = provider.getRows(tableName, conditions);
            if (!rs.next()) {
                Assert.fail((String)"No rows found.");
            }
            int i = 1;
            for (Object expectedValue : values) {
                Object actualValue = rs.getObject(i);
                Assert.assertEquals((String)("Columns do not match on position: " + i), (Object)expectedValue, (Object)actualValue);
                ++i;
            }
            if (rs.next()) {
                Assert.fail((String)"Found more than one row.");
            }
        }
        catch (SQLException e) {
            LOG.error((Object)"Unexpected SQLException", (Throwable)e);
            Assert.fail((String)("Unexpected SQLException: " + e));
        }
        finally {
            provider.closeResultSetWithStatement(rs);
        }
    }

    private ProviderAsserts() {
    }
}

