/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.test.asserts;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.sqoop.test.utils.HdfsUtils;
import org.junit.Assert;

public class HdfsAsserts {
    private static final Logger LOG = Logger.getLogger(HdfsAsserts.class);

    public static void assertMapreduceOutput(String directory, String ... lines) throws IOException {
        String[] files;
        HashSet<String> setLines = new HashSet<String>(Arrays.asList(lines));
        LinkedList<String> notFound = new LinkedList<String>();
        for (String file : files = HdfsUtils.getOutputMapreduceFiles(directory)) {
            String line;
            String filePath = directory + "/" + file;
            BufferedReader br = new BufferedReader(new FileReader(filePath));
            while ((line = br.readLine()) != null) {
                if (setLines.remove(line)) continue;
                notFound.add(line);
            }
            br.close();
        }
        if (!setLines.isEmpty() || !notFound.isEmpty()) {
            LOG.error((Object)"Expected lines that weren't present in the files:");
            LOG.error((Object)("\t" + StringUtils.join(setLines, (String)"\n\t")));
            LOG.error((Object)"Extra lines in files that weren't expected:");
            LOG.error((Object)("\t" + StringUtils.join(notFound, (String)"\n\t")));
            Assert.fail((String)"Output do not match expectations.");
        }
    }

    public static void assertMapreduceOutputFiles(String directory, int expectedFiles) {
        String[] files = HdfsUtils.getOutputMapreduceFiles(directory);
        Assert.assertEquals((long)expectedFiles, (long)files.length);
    }

    private HdfsAsserts() {
    }
}

