/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.test.db;

import org.apache.sqoop.test.db.DatabaseProvider;

public class SqlServerProvider
extends DatabaseProvider {
    public static final String DRIVER = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
    private static final String CONNECTION = System.getProperties().getProperty("sqoop.provider.sqlserver.jdbc", "jdbc:sqlserver://localhost");
    private static final String USERNAME = System.getProperties().getProperty("sqoop.provider.sqlserver.username", "sqoop");
    private static final String PASSWORD = System.getProperties().getProperty("sqoop.provider.sqlserver.password", "sqoop");

    @Override
    public String getConnectionUrl() {
        return CONNECTION;
    }

    @Override
    public String getConnectionUsername() {
        return USERNAME;
    }

    @Override
    public String getConnectionPassword() {
        return PASSWORD;
    }

    @Override
    public String escapeColumnName(String columnName) {
        return this.escape(columnName);
    }

    @Override
    public String escapeTableName(String tableName) {
        return this.escape(tableName);
    }

    @Override
    public String escapeValueString(String value) {
        return "'" + value + "'";
    }

    @Override
    public boolean isSupportingScheme() {
        return true;
    }

    @Override
    public String getJdbcDriver() {
        return DRIVER;
    }

    public String escape(String entity) {
        return "[" + entity + "]";
    }
}

