/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.test.db;

import org.apache.sqoop.test.db.DatabaseProvider;

public class MySQLProvider
extends DatabaseProvider {
    public static final String DRIVER = "com.mysql.jdbc.Driver";
    private static final String CONNECTION = System.getProperties().getProperty("sqoop.provider.mysql.jdbc", "jdbc:mysql://localhost/test");
    private static final String USERNAME = System.getProperties().getProperty("sqoop.provider.mysql.username", "sqoop");
    private static final String PASSWORD = System.getProperties().getProperty("sqoop.provider.mysql.password", "sqoop");

    @Override
    public String getConnectionUrl() {
        return CONNECTION;
    }

    @Override
    public String getConnectionUsername() {
        return USERNAME;
    }

    @Override
    public String getConnectionPassword() {
        return PASSWORD;
    }

    @Override
    public String escapeColumnName(String columnName) {
        return this.escape(columnName);
    }

    @Override
    public String escapeTableName(String tableName) {
        return this.escape(tableName);
    }

    @Override
    public String escapeValueString(String value) {
        return "\"" + value + "\"";
    }

    @Override
    public String getJdbcDriver() {
        return DRIVER;
    }

    public String escape(String entity) {
        return "`" + entity + "`";
    }
}

