/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.test.db;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public abstract class DatabaseProvider {
    private static final Logger LOG = Logger.getLogger(DatabaseProvider.class);
    private Connection connection;

    public abstract String getConnectionUrl();

    public abstract String getConnectionUsername();

    public abstract String getConnectionPassword();

    public abstract String escapeColumnName(String var1);

    public abstract String escapeTableName(String var1);

    public abstract String escapeValueString(String var1);

    public String nullConstant() {
        return "NULL";
    }

    public boolean isSupportingScheme() {
        return false;
    }

    public String getJdbcDriver() {
        return null;
    }

    public void start() {
        if (this.getJdbcDriver() != null) {
            this.loadClass(this.getJdbcDriver());
        }
        try {
            this.setConnection(DriverManager.getConnection(this.getConnectionUrl(), this.getConnectionUsername(), this.getConnectionPassword()));
        }
        catch (SQLException e) {
            LOG.error((Object)"Can't create connection", (Throwable)e);
            throw new RuntimeException("Can't create connection", e);
        }
    }

    public void stop() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (SQLException e) {
                LOG.info((Object)"Ignored exception on closing connection", (Throwable)e);
            }
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    protected void setConnection(Connection connection) {
        this.connection = connection;
    }

    public void executeUpdate(String query) {
        LOG.info((Object)("Executing query: " + query));
        Statement stmt = null;
        try {
            stmt = this.connection.createStatement();
            stmt.executeUpdate(query);
        }
        catch (SQLException e) {
            LOG.error((Object)"Error in executing query", (Throwable)e);
            throw new RuntimeException("Error in executing query", e);
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException e) {
                LOG.info((Object)"Cant' close statement", (Throwable)e);
            }
        }
    }

    public void createTable(String name, String primaryKey, String ... columns) {
        if (columns.length == 0 || columns.length % 2 != 0) {
            throw new RuntimeException("Incorrect number of parameters.");
        }
        this.dropTable(name);
        StringBuilder sb = new StringBuilder("CREATE TABLE ");
        sb.append(this.escapeTableName(name)).append("(");
        LinkedList<String> columnList = new LinkedList<String>();
        for (int i = 0; i < columns.length; i += 2) {
            String column = this.escapeColumnName(columns[i]) + " " + columns[i + 1];
            columnList.add(column);
        }
        sb.append(StringUtils.join(columnList, (String)", "));
        if (primaryKey != null) {
            sb.append(", PRIMARY KEY(").append(this.escapeColumnName(primaryKey)).append(")");
        }
        sb.append(")");
        this.executeUpdate(sb.toString());
    }

    public void insertRow(String tableName, Object ... values) {
        StringBuilder sb = new StringBuilder("INSERT INTO ");
        sb.append(this.escapeTableName(tableName));
        sb.append(" VALUES (");
        LinkedList<String> valueList = new LinkedList<String>();
        for (Object value : values) {
            if (value == null) {
                valueList.add(this.nullConstant());
                continue;
            }
            if (value.getClass() == String.class) {
                valueList.add(this.escapeValueString((String)value));
                continue;
            }
            valueList.add(value.toString());
        }
        sb.append(StringUtils.join(valueList, (String)", "));
        sb.append(")");
        this.executeUpdate(sb.toString());
    }

    public void dropTable(String tableName) {
        StringBuilder sb = new StringBuilder("DROP TABLE ");
        sb.append(this.escapeTableName(tableName));
        try {
            this.executeUpdate(sb.toString());
        }
        catch (RuntimeException e) {
            LOG.info((Object)("Ignoring exception: " + e));
        }
    }

    public void loadClass(String className) {
        try {
            Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Class not found: " + className, e);
        }
    }
}

