/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.repository.postgresql;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.apache.sqoop.common.Direction;
import org.apache.sqoop.common.ErrorCode;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.error.code.PostgresqlRepoError;
import org.apache.sqoop.repository.JdbcRepositoryContext;
import org.apache.sqoop.repository.common.CommonRepositoryHandler;
import org.apache.sqoop.repository.postgresql.PostgresqlSchemaCreateQuery;
import org.apache.sqoop.repository.postgresql.PostgresqlSchemaQuery;
import org.apache.sqoop.repository.postgresql.PostgresqlSchemaUpgradeQuery;

@SuppressWarnings(value={"SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING"})
public class PostgresqlRepositoryHandler
extends CommonRepositoryHandler {
    private static final Logger LOG = Logger.getLogger(PostgresqlRepositoryHandler.class);
    private JdbcRepositoryContext repoContext;

    public String name() {
        return "PostgreSQL";
    }

    public synchronized void initialize(JdbcRepositoryContext ctx) {
        this.repoContext = ctx;
        LOG.info((Object)"PostgresqlRepositoryHandler initialized.");
    }

    public synchronized void shutdown() {
    }

    /*
     * Exception decompiling
     */
    public int detectRepositoryVersion(Connection conn) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void createOrUpgradeRepository(Connection conn) {
        int version = this.detectRepositoryVersion(conn);
        LOG.info((Object)("Detected repository version: " + version));
        if (version == 2) {
            return;
        }
        if (version < 1) {
            this.runQuery(PostgresqlSchemaCreateQuery.QUERY_CREATE_SCHEMA_SQOOP, conn, new Object[0]);
            this.runQuery(PostgresqlSchemaCreateQuery.QUERY_CREATE_TABLE_SQ_CONFIGURABLE, conn, new Object[0]);
            this.runQuery(PostgresqlSchemaCreateQuery.QUERY_CREATE_TABLE_SQ_CONFIG, conn, new Object[0]);
            this.runQuery(PostgresqlSchemaCreateQuery.QUERY_CREATE_TABLE_SQ_INPUT, conn, new Object[0]);
            this.runQuery(PostgresqlSchemaCreateQuery.QUERY_CREATE_TABLE_SQ_INPUT_RELATION, conn, new Object[0]);
            this.runQuery(PostgresqlSchemaCreateQuery.QUERY_CREATE_TABLE_SQ_LINK, conn, new Object[0]);
            this.runQuery(PostgresqlSchemaCreateQuery.QUERY_CREATE_TABLE_SQ_JOB, conn, new Object[0]);
            this.runQuery(PostgresqlSchemaCreateQuery.QUERY_CREATE_TABLE_SQ_LINK_INPUT, conn, new Object[0]);
            this.runQuery(PostgresqlSchemaCreateQuery.QUERY_CREATE_TABLE_SQ_JOB_INPUT, conn, new Object[0]);
            this.runQuery(PostgresqlSchemaCreateQuery.QUERY_CREATE_TABLE_SQ_SUBMISSION, conn, new Object[0]);
            this.runQuery(PostgresqlSchemaCreateQuery.QUERY_CREATE_TABLE_SQ_COUNTER_GROUP, conn, new Object[0]);
            this.runQuery(PostgresqlSchemaCreateQuery.QUERY_CREATE_TABLE_SQ_COUNTER, conn, new Object[0]);
            this.runQuery(PostgresqlSchemaCreateQuery.QUERY_CREATE_TABLE_SQ_COUNTER_SUBMISSION, conn, new Object[0]);
            this.runQuery(PostgresqlSchemaCreateQuery.QUERY_CREATE_TABLE_SQ_SYSTEM, conn, new Object[0]);
            this.runQuery(PostgresqlSchemaCreateQuery.QUERY_CREATE_TABLE_SQ_DIRECTION, conn, new Object[0]);
            this.runQuery(PostgresqlSchemaCreateQuery.QUERY_CREATE_TABLE_SQ_CONNECTOR_DIRECTIONS, conn, new Object[0]);
            this.runQuery(PostgresqlSchemaCreateQuery.QUERY_CREATE_TABLE_SQ_CONFIG_DIRECTIONS, conn, new Object[0]);
            this.insertDirections(conn);
        }
        if (version < 2) {
            this.runQuery(PostgresqlSchemaCreateQuery.QUERY_CREATE_TABLE_SQ_CONTEXT_TYPE, conn, new Object[0]);
            this.runQuery(PostgresqlSchemaCreateQuery.QUERY_CREATE_TABLE_SQ_CONTEXT_PROPERTY, conn, new Object[0]);
            this.runQuery(PostgresqlSchemaCreateQuery.QUERY_CREATE_TABLE_SQ_CONTEXT, conn, new Object[0]);
            this.runQuery(PostgresqlSchemaUpgradeQuery.QUERY_UPGRADE_TABLE_SQ_LINK_UPDATE_COLUMN_SQ_LINK_NAME, conn, new Object[0]);
            this.runQuery(PostgresqlSchemaUpgradeQuery.QUERY_UPGRADE_TABLE_SQ_LINK_ALTER_COLUMN_SQ_LINK_NAME_NOT_NULL, conn, new Object[0]);
            this.runQuery(PostgresqlSchemaUpgradeQuery.QUERY_UPGRADE_TABLE_SQ_JOB_UPDATE_COLUMN_SQB_NAME, conn, new Object[0]);
            this.runQuery(PostgresqlSchemaUpgradeQuery.QUERY_UPGRADE_TABLE_SQ_JOB_ALTER_COLUMN_SQB_NAME_NOT_NULL, conn, new Object[0]);
            this.runQuery(PostgresqlSchemaUpgradeQuery.QUERY_UPGRADE_TABLE_SQ_CONFIGURABLE_ALTER_COLUMN_SQB_NAME_NOT_NULL, conn, new Object[0]);
            this.runQuery(PostgresqlSchemaUpgradeQuery.QUERY_CREATE_TABLE_SQ_MASTER_KEY, conn, new Object[0]);
            this.runQuery(PostgresqlSchemaUpgradeQuery.QUERY_UPGRADE_TABLE_SQ_JOB_INPUT_WITH_ENCRYPTED, conn, new Object[0]);
            this.runQuery(PostgresqlSchemaUpgradeQuery.QUERY_UPGRADE_TABLE_SQ_JOB_INPUT_WITH_IV, conn, new Object[0]);
            this.runQuery(PostgresqlSchemaUpgradeQuery.QUERY_UPGRADE_TABLE_SQ_JOB_INPUT_WITH_HMAC, conn, new Object[0]);
            this.runQuery(PostgresqlSchemaUpgradeQuery.QUERY_UPGRADE_TABLE_SQ_LINK_INPUT_WITH_ENCRYPTED, conn, new Object[0]);
            this.runQuery(PostgresqlSchemaUpgradeQuery.QUERY_UPGRADE_TABLE_SQ_LINK_INPUT_WITH_IV, conn, new Object[0]);
            this.runQuery(PostgresqlSchemaUpgradeQuery.QUERY_UPGRADE_TABLE_SQ_LINK_INPUT_WITH_HMAC, conn, new Object[0]);
        }
        try (PreparedStatement stmtDel = conn.prepareStatement(PostgresqlSchemaQuery.STMT_DELETE_SYSTEM);
             PreparedStatement stmtInsert = conn.prepareStatement(PostgresqlSchemaQuery.STMT_INSERT_SYSTEM);){
            stmtDel.setString(1, "repository.version");
            stmtDel.executeUpdate();
            stmtInsert.setString(1, "repository.version");
            stmtInsert.setString(2, Integer.toString(2));
            stmtInsert.executeUpdate();
        }
        catch (SQLException e) {
            LOG.error((Object)"Can't persist the repository version", (Throwable)e);
        }
    }

    protected Map<Direction, Long> insertDirections(Connection conn) {
        TreeMap<Direction, Long> directionMap = new TreeMap<Direction, Long>();
        PreparedStatement insertDirectionStmt = null;
        try {
            for (Direction direction : Direction.values()) {
                insertDirectionStmt = conn.prepareStatement(PostgresqlSchemaQuery.STMT_INSERT_DIRECTION, 1);
                insertDirectionStmt.setString(1, direction.toString());
                if (insertDirectionStmt.executeUpdate() != 1) {
                    throw new SqoopException((ErrorCode)PostgresqlRepoError.POSTGRESQLREPO_0003, "Could not add directions FROM and TO.");
                }
                ResultSet directionId = insertDirectionStmt.getGeneratedKeys();
                if (directionId.next()) {
                    if (LOG.isInfoEnabled()) {
                        LOG.info((Object)("Loaded direction: " + directionId.getLong(1)));
                    }
                } else {
                    throw new SqoopException((ErrorCode)PostgresqlRepoError.POSTGRESQLREPO_0004, "Could not get ID of direction " + direction);
                }
                directionMap.put(direction, directionId.getLong(1));
            }
        }
        catch (SQLException e) {
            try {
                throw new SqoopException((ErrorCode)PostgresqlRepoError.POSTGRESQLREPO_0000, (Throwable)e);
            }
            catch (Throwable throwable) {
                this.closeStatements(new Statement[]{insertDirectionStmt});
                throw throwable;
            }
        }
        this.closeStatements(new Statement[]{insertDirectionStmt});
        return directionMap;
    }

    public boolean isRepositorySuitableForUse(Connection conn) {
        int version = this.detectRepositoryVersion(conn);
        return version == 2;
    }

    public String validationQuery() {
        return "values(1)";
    }
}

