/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.yarn.security;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.token.Token;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.deploy.yarn.security.ConfigurableCredentialManager;
import org.apache.spark.deploy.yarn.security.HBaseCredentialProvider;
import org.apache.spark.deploy.yarn.security.HiveCredentialProvider;
import org.apache.spark.deploy.yarn.security.TestCredentialProvider;
import org.scalactic.Equality;
import org.scalactic.Explicitly;
import org.scalactic.Tolerance;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfter;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.Entry;
import org.scalatest.FunSuiteLike;
import org.scalatest.Matchers;
import org.scalatest.Matchers$AllCollected$;
import org.scalatest.Matchers$AtLeastCollected$;
import org.scalatest.Matchers$AtMostCollected$;
import org.scalatest.Matchers$BetweenCollected$;
import org.scalatest.Matchers$EveryCollected$;
import org.scalatest.Matchers$ExactlyCollected$;
import org.scalatest.Matchers$NoCollected$;
import org.scalatest.Matchers$ShouldMethodHelper$;
import org.scalatest.Status;
import org.scalatest.Tag;
import org.scalatest.enablers.Collecting;
import org.scalatest.matchers.Matcher;
import org.scalatest.matchers.MatcherFactory1;
import org.scalatest.words.BeWord;
import org.scalatest.words.CompileWord;
import org.scalatest.words.ContainWord;
import org.scalatest.words.DefinedWord;
import org.scalatest.words.EmptyWord;
import org.scalatest.words.EndWithWord;
import org.scalatest.words.ExistWord;
import org.scalatest.words.FullyMatchWord;
import org.scalatest.words.HaveWord;
import org.scalatest.words.IncludeWord;
import org.scalatest.words.LengthWord;
import org.scalatest.words.MatchPatternWord;
import org.scalatest.words.MatcherWords;
import org.scalatest.words.NoExceptionWord;
import org.scalatest.words.NotWord;
import org.scalatest.words.ReadableWord;
import org.scalatest.words.ResultOfATypeInvocation;
import org.scalatest.words.ResultOfAllOfApplication;
import org.scalatest.words.ResultOfAnTypeInvocation;
import org.scalatest.words.ResultOfAtLeastOneOfApplication;
import org.scalatest.words.ResultOfAtMostOneOfApplication;
import org.scalatest.words.ResultOfDefinedAt;
import org.scalatest.words.ResultOfGreaterThanComparison;
import org.scalatest.words.ResultOfGreaterThanOrEqualToComparison;
import org.scalatest.words.ResultOfInOrderApplication;
import org.scalatest.words.ResultOfInOrderOnlyApplication;
import org.scalatest.words.ResultOfLessThanComparison;
import org.scalatest.words.ResultOfLessThanOrEqualToComparison;
import org.scalatest.words.ResultOfMessageWordApplication;
import org.scalatest.words.ResultOfNoneOfApplication;
import org.scalatest.words.ResultOfOfTypeInvocation;
import org.scalatest.words.ResultOfOneOfApplication;
import org.scalatest.words.ResultOfOnlyApplication;
import org.scalatest.words.ResultOfTheSameElementsAsApplication;
import org.scalatest.words.ResultOfTheSameElementsInOrderAsApplication;
import org.scalatest.words.ResultOfTheTypeInvocation;
import org.scalatest.words.ResultOfThrownByApplication;
import org.scalatest.words.ShouldVerb;
import org.scalatest.words.SizeWord;
import org.scalatest.words.SortedWord;
import org.scalatest.words.StartWithWord;
import org.scalatest.words.TypeCheckWord;
import org.scalatest.words.WritableWord;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Symbol;
import scala.collection.GenTraversable;
import scala.collection.Seq;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.Manifest;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001]3A!\u0001\u0002\u0001\u001f\t\u00113i\u001c8gS\u001e,(/\u00192mK\u000e\u0013X\rZ3oi&\fG.T1oC\u001e,'oU;ji\u0016T!a\u0001\u0003\u0002\u0011M,7-\u001e:jifT!!\u0002\u0004\u0002\te\f'O\u001c\u0006\u0003\u000f!\ta\u0001Z3qY>L(BA\u0005\u000b\u0003\u0015\u0019\b/\u0019:l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M!\u0001\u0001\u0005\u000b\u001b!\t\t\"#D\u0001\t\u0013\t\u0019\u0002BA\u0007Ta\u0006\u00148NR;o'VLG/\u001a\t\u0003+ai\u0011A\u0006\u0006\u0003/1\t\u0011b]2bY\u0006$Xm\u001d;\n\u0005e1\"\u0001C'bi\u000eDWM]:\u0011\u0005UY\u0012B\u0001\u000f\u0017\u00059\u0011UMZ8sK\u0006sG-\u00114uKJDQA\b\u0001\u0005\u0002}\ta\u0001P5oSRtD#\u0001\u0011\u0011\u0005\u0005\u0002Q\"\u0001\u0002\t\u000f\r\u0002\u0001\u0019!C\u0005I\u0005\t2M]3eK:$\u0018.\u00197NC:\fw-\u001a:\u0016\u0003\u0015\u0002\"!\t\u0014\n\u0005\u001d\u0012!!H\"p]\u001aLw-\u001e:bE2,7I]3eK:$\u0018.\u00197NC:\fw-\u001a:\t\u000f%\u0002\u0001\u0019!C\u0005U\u0005)2M]3eK:$\u0018.\u00197NC:\fw-\u001a:`I\u0015\fHCA\u00162!\tas&D\u0001.\u0015\u0005q\u0013!B:dC2\f\u0017B\u0001\u0019.\u0005\u0011)f.\u001b;\t\u000fIB\u0013\u0011!a\u0001K\u0005\u0019\u0001\u0010J\u0019\t\rQ\u0002\u0001\u0015)\u0003&\u0003I\u0019'/\u001a3f]RL\u0017\r\\'b]\u0006<WM\u001d\u0011\t\u000fY\u0002\u0001\u0019!C\u0005o\u0005I1\u000f]1sW\u000e{gNZ\u000b\u0002qA\u0011\u0011#O\u0005\u0003u!\u0011\u0011b\u00159be.\u001cuN\u001c4\t\u000fq\u0002\u0001\u0019!C\u0005{\u0005i1\u000f]1sW\u000e{gNZ0%KF$\"a\u000b \t\u000fIZ\u0014\u0011!a\u0001q!1\u0001\t\u0001Q!\na\n!b\u001d9be.\u001cuN\u001c4!\u0011\u001d\u0011\u0005\u00011A\u0005\n\r\u000b!\u0002[1e_>\u00048i\u001c8g+\u0005!\u0005CA#K\u001b\u00051%BA$I\u0003\u0011\u0019wN\u001c4\u000b\u0005%S\u0011A\u00025bI>|\u0007/\u0003\u0002L\r\ni1i\u001c8gS\u001e,(/\u0019;j_:Dq!\u0014\u0001A\u0002\u0013%a*\u0001\biC\u0012|w\u000e]\"p]\u001a|F%Z9\u0015\u0005-z\u0005b\u0002\u001aM\u0003\u0003\u0005\r\u0001\u0012\u0005\u0007#\u0002\u0001\u000b\u0015\u0002#\u0002\u0017!\fGm\\8q\u0007>tg\r\t\u0005\u0006'\u0002!\t\u0005V\u0001\nE\u00164wN]3BY2$\u0012a\u000b\u0005\u0006-\u0002!\t\u0005V\u0001\tC\u001a$XM]!mY\u0002")
public class ConfigurableCredentialManagerSuite
extends SparkFunSuite
implements Matchers,
BeforeAndAfter {
    private ConfigurableCredentialManager org$apache$spark$deploy$yarn$security$ConfigurableCredentialManagerSuite$$credentialManager;
    private SparkConf org$apache$spark$deploy$yarn$security$ConfigurableCredentialManagerSuite$$sparkConf;
    private Configuration org$apache$spark$deploy$yarn$security$ConfigurableCredentialManagerSuite$$hadoopConf;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    private final Matchers.KeyWord key;
    private final Matchers.ValueWord value;
    private final Matchers.AWord a;
    private final Matchers.AnWord an;
    private final Matchers.TheSameInstanceAsPhrase theSameInstanceAs;
    private final Matchers.RegexWord regex;
    private final Explicitly.DecidedWord decided;
    private final Explicitly.DeterminedWord determined;
    private final Explicitly.TheAfterWord after;
    private final FullyMatchWord fullyMatch;
    private final StartWithWord startWith;
    private final EndWithWord endWith;
    private final IncludeWord include;
    private final HaveWord have;
    private final BeWord be;
    private final ContainWord contain;
    private final NotWord not;
    private final LengthWord length;
    private final SizeWord size;
    private final SortedWord sorted;
    private final DefinedWord defined;
    private final NoExceptionWord noException;
    private final ExistWord exist;
    private final ReadableWord readable;
    private final WritableWord writable;
    private final EmptyWord empty;
    private final CompileWord compile;
    private final TypeCheckWord typeCheck;
    private final MatchPatternWord matchPattern;
    private volatile Matchers$AllCollected$ org$scalatest$Matchers$$AllCollected$module;
    private volatile Matchers$EveryCollected$ org$scalatest$Matchers$$EveryCollected$module;
    private volatile Matchers$BetweenCollected$ org$scalatest$Matchers$$BetweenCollected$module;
    private volatile Matchers$AtLeastCollected$ org$scalatest$Matchers$$AtLeastCollected$module;
    private volatile Matchers$AtMostCollected$ org$scalatest$Matchers$$AtMostCollected$module;
    private volatile Matchers$NoCollected$ org$scalatest$Matchers$$NoCollected$module;
    private volatile Matchers$ExactlyCollected$ org$scalatest$Matchers$$ExactlyCollected$module;
    private volatile Matchers$ShouldMethodHelper$ org$scalatest$Matchers$$ShouldMethodHelper$module;

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$runTest(String testName, Args args) {
        return FunSuiteLike.class.runTest((FunSuiteLike)this, (String)testName, (Args)args);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$run(Option testName, Args args) {
        return BeforeAndAfterAll.class.run((BeforeAndAfterAll)this, (Option)testName, (Args)args);
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    public void before(Function0<Object> fun) {
        BeforeAndAfter.class.before((BeforeAndAfter)this, fun);
    }

    public void after(Function0<Object> fun) {
        BeforeAndAfter.class.after((BeforeAndAfter)this, fun);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfter.class.runTest((BeforeAndAfter)this, (String)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfter.class.run((BeforeAndAfter)this, testName, (Args)args);
    }

    public Matchers.KeyWord key() {
        return this.key;
    }

    public Matchers.ValueWord value() {
        return this.value;
    }

    public Matchers.AWord a() {
        return this.a;
    }

    public Matchers.AnWord an() {
        return this.an;
    }

    public Matchers.TheSameInstanceAsPhrase theSameInstanceAs() {
        return this.theSameInstanceAs;
    }

    public Matchers.RegexWord regex() {
        return this.regex;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Matchers$AllCollected$ org$scalatest$Matchers$$AllCollected$lzycompute() {
        ConfigurableCredentialManagerSuite configurableCredentialManagerSuite = this;
        synchronized (configurableCredentialManagerSuite) {
            if (this.org$scalatest$Matchers$$AllCollected$module != null) return this.org$scalatest$Matchers$$AllCollected$module;
            this.org$scalatest$Matchers$$AllCollected$module = new Matchers$AllCollected$((Matchers)this);
            return this.org$scalatest$Matchers$$AllCollected$module;
        }
    }

    public final Matchers$AllCollected$ org$scalatest$Matchers$$AllCollected() {
        return this.org$scalatest$Matchers$$AllCollected$module == null ? this.org$scalatest$Matchers$$AllCollected$lzycompute() : this.org$scalatest$Matchers$$AllCollected$module;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Matchers$EveryCollected$ org$scalatest$Matchers$$EveryCollected$lzycompute() {
        ConfigurableCredentialManagerSuite configurableCredentialManagerSuite = this;
        synchronized (configurableCredentialManagerSuite) {
            if (this.org$scalatest$Matchers$$EveryCollected$module != null) return this.org$scalatest$Matchers$$EveryCollected$module;
            this.org$scalatest$Matchers$$EveryCollected$module = new Matchers$EveryCollected$((Matchers)this);
            return this.org$scalatest$Matchers$$EveryCollected$module;
        }
    }

    public final Matchers$EveryCollected$ org$scalatest$Matchers$$EveryCollected() {
        return this.org$scalatest$Matchers$$EveryCollected$module == null ? this.org$scalatest$Matchers$$EveryCollected$lzycompute() : this.org$scalatest$Matchers$$EveryCollected$module;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Matchers$BetweenCollected$ org$scalatest$Matchers$$BetweenCollected$lzycompute() {
        ConfigurableCredentialManagerSuite configurableCredentialManagerSuite = this;
        synchronized (configurableCredentialManagerSuite) {
            if (this.org$scalatest$Matchers$$BetweenCollected$module != null) return this.org$scalatest$Matchers$$BetweenCollected$module;
            this.org$scalatest$Matchers$$BetweenCollected$module = new Matchers$BetweenCollected$((Matchers)this);
            return this.org$scalatest$Matchers$$BetweenCollected$module;
        }
    }

    public final Matchers$BetweenCollected$ org$scalatest$Matchers$$BetweenCollected() {
        return this.org$scalatest$Matchers$$BetweenCollected$module == null ? this.org$scalatest$Matchers$$BetweenCollected$lzycompute() : this.org$scalatest$Matchers$$BetweenCollected$module;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Matchers$AtLeastCollected$ org$scalatest$Matchers$$AtLeastCollected$lzycompute() {
        ConfigurableCredentialManagerSuite configurableCredentialManagerSuite = this;
        synchronized (configurableCredentialManagerSuite) {
            if (this.org$scalatest$Matchers$$AtLeastCollected$module != null) return this.org$scalatest$Matchers$$AtLeastCollected$module;
            this.org$scalatest$Matchers$$AtLeastCollected$module = new Matchers$AtLeastCollected$((Matchers)this);
            return this.org$scalatest$Matchers$$AtLeastCollected$module;
        }
    }

    public final Matchers$AtLeastCollected$ org$scalatest$Matchers$$AtLeastCollected() {
        return this.org$scalatest$Matchers$$AtLeastCollected$module == null ? this.org$scalatest$Matchers$$AtLeastCollected$lzycompute() : this.org$scalatest$Matchers$$AtLeastCollected$module;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Matchers$AtMostCollected$ org$scalatest$Matchers$$AtMostCollected$lzycompute() {
        ConfigurableCredentialManagerSuite configurableCredentialManagerSuite = this;
        synchronized (configurableCredentialManagerSuite) {
            if (this.org$scalatest$Matchers$$AtMostCollected$module != null) return this.org$scalatest$Matchers$$AtMostCollected$module;
            this.org$scalatest$Matchers$$AtMostCollected$module = new Matchers$AtMostCollected$((Matchers)this);
            return this.org$scalatest$Matchers$$AtMostCollected$module;
        }
    }

    public final Matchers$AtMostCollected$ org$scalatest$Matchers$$AtMostCollected() {
        return this.org$scalatest$Matchers$$AtMostCollected$module == null ? this.org$scalatest$Matchers$$AtMostCollected$lzycompute() : this.org$scalatest$Matchers$$AtMostCollected$module;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Matchers$NoCollected$ org$scalatest$Matchers$$NoCollected$lzycompute() {
        ConfigurableCredentialManagerSuite configurableCredentialManagerSuite = this;
        synchronized (configurableCredentialManagerSuite) {
            if (this.org$scalatest$Matchers$$NoCollected$module != null) return this.org$scalatest$Matchers$$NoCollected$module;
            this.org$scalatest$Matchers$$NoCollected$module = new Matchers$NoCollected$((Matchers)this);
            return this.org$scalatest$Matchers$$NoCollected$module;
        }
    }

    public final Matchers$NoCollected$ org$scalatest$Matchers$$NoCollected() {
        return this.org$scalatest$Matchers$$NoCollected$module == null ? this.org$scalatest$Matchers$$NoCollected$lzycompute() : this.org$scalatest$Matchers$$NoCollected$module;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Matchers$ExactlyCollected$ org$scalatest$Matchers$$ExactlyCollected$lzycompute() {
        ConfigurableCredentialManagerSuite configurableCredentialManagerSuite = this;
        synchronized (configurableCredentialManagerSuite) {
            if (this.org$scalatest$Matchers$$ExactlyCollected$module != null) return this.org$scalatest$Matchers$$ExactlyCollected$module;
            this.org$scalatest$Matchers$$ExactlyCollected$module = new Matchers$ExactlyCollected$((Matchers)this);
            return this.org$scalatest$Matchers$$ExactlyCollected$module;
        }
    }

    public final Matchers$ExactlyCollected$ org$scalatest$Matchers$$ExactlyCollected() {
        return this.org$scalatest$Matchers$$ExactlyCollected$module == null ? this.org$scalatest$Matchers$$ExactlyCollected$lzycompute() : this.org$scalatest$Matchers$$ExactlyCollected$module;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Matchers$ShouldMethodHelper$ org$scalatest$Matchers$$ShouldMethodHelper$lzycompute() {
        ConfigurableCredentialManagerSuite configurableCredentialManagerSuite = this;
        synchronized (configurableCredentialManagerSuite) {
            if (this.org$scalatest$Matchers$$ShouldMethodHelper$module != null) return this.org$scalatest$Matchers$$ShouldMethodHelper$module;
            this.org$scalatest$Matchers$$ShouldMethodHelper$module = new Matchers$ShouldMethodHelper$((Matchers)this);
            return this.org$scalatest$Matchers$$ShouldMethodHelper$module;
        }
    }

    public final Matchers$ShouldMethodHelper$ org$scalatest$Matchers$$ShouldMethodHelper() {
        return this.org$scalatest$Matchers$$ShouldMethodHelper$module == null ? this.org$scalatest$Matchers$$ShouldMethodHelper$lzycompute() : this.org$scalatest$Matchers$$ShouldMethodHelper$module;
    }

    public void org$scalatest$Matchers$_setter_$key_$eq(Matchers.KeyWord x$1) {
        this.key = x$1;
    }

    public void org$scalatest$Matchers$_setter_$value_$eq(Matchers.ValueWord x$1) {
        this.value = x$1;
    }

    public void org$scalatest$Matchers$_setter_$a_$eq(Matchers.AWord x$1) {
        this.a = x$1;
    }

    public void org$scalatest$Matchers$_setter_$an_$eq(Matchers.AnWord x$1) {
        this.an = x$1;
    }

    public void org$scalatest$Matchers$_setter_$theSameInstanceAs_$eq(Matchers.TheSameInstanceAsPhrase x$1) {
        this.theSameInstanceAs = x$1;
    }

    public void org$scalatest$Matchers$_setter_$regex_$eq(Matchers.RegexWord x$1) {
        this.regex = x$1;
    }

    public Matchers.HavePropertyMatcherGenerator convertSymbolToHavePropertyMatcherGenerator(Symbol symbol) {
        return Matchers.class.convertSymbolToHavePropertyMatcherGenerator((Matchers)this, (Symbol)symbol);
    }

    public <T> Matcher<T> equal(TripleEqualsSupport.Spread<T> spread) {
        return Matchers.class.equal((Matchers)this, spread);
    }

    public Matcher<Object> equal(Null$ o) {
        return Matchers.class.equal((Matchers)this, (Null$)o);
    }

    public <T> ResultOfLessThanComparison<T> $less(T right, Ordering<T> evidence$1) {
        return Matchers.class.$less((Matchers)this, right, evidence$1);
    }

    public <T> ResultOfGreaterThanComparison<T> $greater(T right, Ordering<T> evidence$2) {
        return Matchers.class.$greater((Matchers)this, right, evidence$2);
    }

    public <T> ResultOfLessThanOrEqualToComparison<T> $less$eq(T right, Ordering<T> evidence$3) {
        return Matchers.class.$less$eq((Matchers)this, right, evidence$3);
    }

    public <T> ResultOfGreaterThanOrEqualToComparison<T> $greater$eq(T right, Ordering<T> evidence$4) {
        return Matchers.class.$greater$eq((Matchers)this, right, evidence$4);
    }

    public <T> ResultOfDefinedAt<T> definedAt(T right) {
        return Matchers.class.definedAt((Matchers)this, right);
    }

    public Matchers.ResultOfEvaluatingApplication evaluating(Function0<Object> fun) {
        return Matchers.class.evaluating((Matchers)this, fun);
    }

    public <T> Matchers.ResultOfProduceInvocation<T> produce(Manifest<T> evidence$5) {
        return Matchers.class.produce((Matchers)this, evidence$5);
    }

    public ResultOfOneOfApplication oneOf(Object firstEle, Object secondEle, Seq<Object> remainingEles) {
        return Matchers.class.oneOf((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles);
    }

    public ResultOfAtLeastOneOfApplication atLeastOneOf(Object firstEle, Object secondEle, Seq<Object> remainingEles) {
        return Matchers.class.atLeastOneOf((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles);
    }

    public ResultOfNoneOfApplication noneOf(Object firstEle, Object secondEle, Seq<Object> remainingEles) {
        return Matchers.class.noneOf((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles);
    }

    public ResultOfTheSameElementsAsApplication theSameElementsAs(GenTraversable<?> xs) {
        return Matchers.class.theSameElementsAs((Matchers)this, xs);
    }

    public ResultOfTheSameElementsInOrderAsApplication theSameElementsInOrderAs(GenTraversable<?> xs) {
        return Matchers.class.theSameElementsInOrderAs((Matchers)this, xs);
    }

    public ResultOfOnlyApplication only(Seq<Object> xs) {
        return Matchers.class.only((Matchers)this, xs);
    }

    public <T> ResultOfInOrderOnlyApplication inOrderOnly(Object firstEle, Object secondEle, Seq<Object> remainingEles) {
        return Matchers.class.inOrderOnly((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles);
    }

    public ResultOfAllOfApplication allOf(Object firstEle, Object secondEle, Seq<Object> remainingEles) {
        return Matchers.class.allOf((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles);
    }

    public ResultOfInOrderApplication inOrder(Object firstEle, Object secondEle, Seq<Object> remainingEles) {
        return Matchers.class.inOrder((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles);
    }

    public ResultOfAtMostOneOfApplication atMostOneOf(Object firstEle, Object secondEle, Seq<Object> remainingEles) {
        return Matchers.class.atMostOneOf((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles);
    }

    public ResultOfThrownByApplication thrownBy(Function0<Object> fun) {
        return Matchers.class.thrownBy((Matchers)this, fun);
    }

    public ResultOfMessageWordApplication message(String expectedMessage) {
        return Matchers.class.message((Matchers)this, (String)expectedMessage);
    }

    public <T> void doCollected(Matchers.Collected collected, GenTraversable<T> xs, Object original, String methodName, int stackDepth, Function1<T, BoxedUnit> fun) {
        Matchers.class.doCollected((Matchers)this, (Matchers.Collected)collected, xs, (Object)original, (String)methodName, (int)stackDepth, fun);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> all(C xs, Collecting<E, C> collecting) {
        return Matchers.class.all((Matchers)this, xs, collecting);
    }

    public <K, V, JMAP extends Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> all(JMAP xs, Collecting<Entry<K, V>, JMAP> collecting) {
        return Matchers.class.all((Matchers)this, xs, collecting);
    }

    public Matchers.ResultOfCollectedAny<Object> all(String xs, Collecting<Object, String> collecting) {
        return Matchers.class.all((Matchers)this, (String)xs, collecting);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> atLeast(int num, C xs, Collecting<E, C> collecting) {
        return Matchers.class.atLeast((Matchers)this, (int)num, xs, collecting);
    }

    public <K, V, JMAP extends Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> atLeast(int num, JMAP xs, Collecting<Entry<K, V>, JMAP> collecting) {
        return Matchers.class.atLeast((Matchers)this, (int)num, xs, collecting);
    }

    public Matchers.ResultOfCollectedAny<Object> atLeast(int num, String xs, Collecting<Object, String> collecting) {
        return Matchers.class.atLeast((Matchers)this, (int)num, (String)xs, collecting);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> every(C xs, Collecting<E, C> collecting) {
        return Matchers.class.every((Matchers)this, xs, collecting);
    }

    public <K, V, JMAP extends Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> every(JMAP xs, Collecting<Entry<K, V>, JMAP> collecting) {
        return Matchers.class.every((Matchers)this, xs, collecting);
    }

    public Matchers.ResultOfCollectedAny<Object> every(String xs, Collecting<Object, String> collecting) {
        return Matchers.class.every((Matchers)this, (String)xs, collecting);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> exactly(int num, C xs, Collecting<E, C> collecting) {
        return Matchers.class.exactly((Matchers)this, (int)num, xs, collecting);
    }

    public <K, V, JMAP extends Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> exactly(int num, JMAP xs, Collecting<Entry<K, V>, JMAP> collecting) {
        return Matchers.class.exactly((Matchers)this, (int)num, xs, collecting);
    }

    public Matchers.ResultOfCollectedAny<Object> exactly(int num, String xs, Collecting<Object, String> collecting) {
        return Matchers.class.exactly((Matchers)this, (int)num, (String)xs, collecting);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> no(C xs, Collecting<E, C> collecting) {
        return Matchers.class.no((Matchers)this, xs, collecting);
    }

    public <K, V, JMAP extends Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> no(JMAP xs, Collecting<Entry<K, V>, JMAP> collecting) {
        return Matchers.class.no((Matchers)this, xs, collecting);
    }

    public Matchers.ResultOfCollectedAny<Object> no(String xs, Collecting<Object, String> collecting) {
        return Matchers.class.no((Matchers)this, (String)xs, collecting);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> between(int from, int upTo, C xs, Collecting<E, C> collecting) {
        return Matchers.class.between((Matchers)this, (int)from, (int)upTo, xs, collecting);
    }

    public <K, V, JMAP extends Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> between(int from, int upTo, JMAP xs, Collecting<Entry<K, V>, JMAP> collecting) {
        return Matchers.class.between((Matchers)this, (int)from, (int)upTo, xs, collecting);
    }

    public Matchers.ResultOfCollectedAny<Object> between(int from, int upTo, String xs, Collecting<Object, String> collecting) {
        return Matchers.class.between((Matchers)this, (int)from, (int)upTo, (String)xs, collecting);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> atMost(int num, C xs, Collecting<E, C> collecting) {
        return Matchers.class.atMost((Matchers)this, (int)num, xs, collecting);
    }

    public <K, V, JMAP extends Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> atMost(int num, JMAP xs, Collecting<Entry<K, V>, JMAP> collecting) {
        return Matchers.class.atMost((Matchers)this, (int)num, xs, collecting);
    }

    public Matchers.ResultOfCollectedAny<Object> atMost(int num, String xs, Collecting<Object, String> collecting) {
        return Matchers.class.atMost((Matchers)this, (int)num, (String)xs, collecting);
    }

    public <T> ResultOfATypeInvocation<T> a(Manifest<T> evidence$6) {
        return Matchers.class.a((Matchers)this, evidence$6);
    }

    public <T> ResultOfAnTypeInvocation<T> an(Manifest<T> evidence$7) {
        return Matchers.class.an((Matchers)this, evidence$7);
    }

    public <T> ResultOfTheTypeInvocation<T> the(Manifest<T> evidence$8) {
        return Matchers.class.the((Matchers)this, evidence$8);
    }

    public <T> Matchers.AnyShouldWrapper<T> convertToAnyShouldWrapper(T o) {
        return Matchers.class.convertToAnyShouldWrapper((Matchers)this, o);
    }

    public Matchers.StringShouldWrapper convertToStringShouldWrapper(String o) {
        return Matchers.class.convertToStringShouldWrapper((Matchers)this, (String)o);
    }

    public Matchers.RegexWrapper convertToRegexWrapper(Regex o) {
        return Matchers.class.convertToRegexWrapper((Matchers)this, (Regex)o);
    }

    public <T> ResultOfOfTypeInvocation<T> of(Manifest<T> ev) {
        return Matchers.class.of((Matchers)this, ev);
    }

    public Explicitly.DecidedWord decided() {
        return this.decided;
    }

    public Explicitly.DeterminedWord determined() {
        return this.determined;
    }

    public Explicitly.TheAfterWord after() {
        return this.after;
    }

    public void org$scalactic$Explicitly$_setter_$decided_$eq(Explicitly.DecidedWord x$1) {
        this.decided = x$1;
    }

    public void org$scalactic$Explicitly$_setter_$determined_$eq(Explicitly.DeterminedWord x$1) {
        this.determined = x$1;
    }

    public void org$scalactic$Explicitly$_setter_$after_$eq(Explicitly.TheAfterWord x$1) {
        this.after = x$1;
    }

    public FullyMatchWord fullyMatch() {
        return this.fullyMatch;
    }

    public StartWithWord startWith() {
        return this.startWith;
    }

    public EndWithWord endWith() {
        return this.endWith;
    }

    public IncludeWord include() {
        return this.include;
    }

    public HaveWord have() {
        return this.have;
    }

    public BeWord be() {
        return this.be;
    }

    public ContainWord contain() {
        return this.contain;
    }

    public NotWord not() {
        return this.not;
    }

    public LengthWord length() {
        return this.length;
    }

    public SizeWord size() {
        return this.size;
    }

    public SortedWord sorted() {
        return this.sorted;
    }

    public DefinedWord defined() {
        return this.defined;
    }

    public NoExceptionWord noException() {
        return this.noException;
    }

    public ExistWord exist() {
        return this.exist;
    }

    public ReadableWord readable() {
        return this.readable;
    }

    public WritableWord writable() {
        return this.writable;
    }

    public EmptyWord empty() {
        return this.empty;
    }

    public CompileWord compile() {
        return this.compile;
    }

    public TypeCheckWord typeCheck() {
        return this.typeCheck;
    }

    public MatchPatternWord matchPattern() {
        return this.matchPattern;
    }

    public void org$scalatest$words$MatcherWords$_setter_$fullyMatch_$eq(FullyMatchWord x$1) {
        this.fullyMatch = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$startWith_$eq(StartWithWord x$1) {
        this.startWith = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$endWith_$eq(EndWithWord x$1) {
        this.endWith = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$include_$eq(IncludeWord x$1) {
        this.include = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$have_$eq(HaveWord x$1) {
        this.have = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$be_$eq(BeWord x$1) {
        this.be = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$contain_$eq(ContainWord x$1) {
        this.contain = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$not_$eq(NotWord x$1) {
        this.not = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$length_$eq(LengthWord x$1) {
        this.length = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$size_$eq(SizeWord x$1) {
        this.size = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$sorted_$eq(SortedWord x$1) {
        this.sorted = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$defined_$eq(DefinedWord x$1) {
        this.defined = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$noException_$eq(NoExceptionWord x$1) {
        this.noException = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$exist_$eq(ExistWord x$1) {
        this.exist = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$readable_$eq(ReadableWord x$1) {
        this.readable = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$writable_$eq(WritableWord x$1) {
        this.writable = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$empty_$eq(EmptyWord x$1) {
        this.empty = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$compile_$eq(CompileWord x$1) {
        this.compile = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$typeCheck_$eq(TypeCheckWord x$1) {
        this.typeCheck = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$matchPattern_$eq(MatchPatternWord x$1) {
        this.matchPattern = x$1;
    }

    public MatcherFactory1<Object, Equality> equal(Object right) {
        return MatcherWords.class.equal((MatcherWords)this, (Object)right);
    }

    public <T> Tolerance.PlusOrMinusWrapper<T> convertNumericToPlusOrMinusWrapper(T pivot, Numeric<T> evidence$2) {
        return Tolerance.class.convertNumericToPlusOrMinusWrapper((Tolerance)this, pivot, evidence$2);
    }

    public ConfigurableCredentialManager org$apache$spark$deploy$yarn$security$ConfigurableCredentialManagerSuite$$credentialManager() {
        return this.org$apache$spark$deploy$yarn$security$ConfigurableCredentialManagerSuite$$credentialManager;
    }

    public void org$apache$spark$deploy$yarn$security$ConfigurableCredentialManagerSuite$$credentialManager_$eq(ConfigurableCredentialManager x$1) {
        this.org$apache$spark$deploy$yarn$security$ConfigurableCredentialManagerSuite$$credentialManager = x$1;
    }

    public SparkConf org$apache$spark$deploy$yarn$security$ConfigurableCredentialManagerSuite$$sparkConf() {
        return this.org$apache$spark$deploy$yarn$security$ConfigurableCredentialManagerSuite$$sparkConf;
    }

    private void org$apache$spark$deploy$yarn$security$ConfigurableCredentialManagerSuite$$sparkConf_$eq(SparkConf x$1) {
        this.org$apache$spark$deploy$yarn$security$ConfigurableCredentialManagerSuite$$sparkConf = x$1;
    }

    public Configuration org$apache$spark$deploy$yarn$security$ConfigurableCredentialManagerSuite$$hadoopConf() {
        return this.org$apache$spark$deploy$yarn$security$ConfigurableCredentialManagerSuite$$hadoopConf;
    }

    private void org$apache$spark$deploy$yarn$security$ConfigurableCredentialManagerSuite$$hadoopConf_$eq(Configuration x$1) {
        this.org$apache$spark$deploy$yarn$security$ConfigurableCredentialManagerSuite$$hadoopConf = x$1;
    }

    public void beforeAll() {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this);
        this.org$apache$spark$deploy$yarn$security$ConfigurableCredentialManagerSuite$$sparkConf_$eq(new SparkConf());
        this.org$apache$spark$deploy$yarn$security$ConfigurableCredentialManagerSuite$$hadoopConf_$eq(new Configuration());
        System.setProperty("SPARK_YARN_MODE", "true");
    }

    public void afterAll() {
        System.clearProperty("SPARK_YARN_MODE");
        super.afterAll();
    }

    public ConfigurableCredentialManagerSuite() {
        Tolerance.class.$init$((Tolerance)this);
        ShouldVerb.class.$init$((ShouldVerb)this);
        MatcherWords.class.$init$((MatcherWords)this);
        Explicitly.class.$init$((Explicitly)this);
        Matchers.class.$init$((Matchers)this);
        BeforeAndAfter.class.$init$((BeforeAndAfter)this);
        this.org$apache$spark$deploy$yarn$security$ConfigurableCredentialManagerSuite$$credentialManager = null;
        this.org$apache$spark$deploy$yarn$security$ConfigurableCredentialManagerSuite$$sparkConf = null;
        this.org$apache$spark$deploy$yarn$security$ConfigurableCredentialManagerSuite$$hadoopConf = null;
        this.test("Correctly load default credential providers", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConfigurableCredentialManagerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$apache$spark$deploy$yarn$security$ConfigurableCredentialManagerSuite$$credentialManager_$eq(new ConfigurableCredentialManager(this.$outer.org$apache$spark$deploy$yarn$security$ConfigurableCredentialManagerSuite$$sparkConf(), this.$outer.org$apache$spark$deploy$yarn$security$ConfigurableCredentialManagerSuite$$hadoopConf()));
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$apache$spark$deploy$yarn$security$ConfigurableCredentialManagerSuite$$credentialManager().getServiceCredentialProvider("hdfs")).should(this.$outer.not()).be((Object)None$.MODULE$);
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$apache$spark$deploy$yarn$security$ConfigurableCredentialManagerSuite$$credentialManager().getServiceCredentialProvider("hbase")).should(this.$outer.not()).be((Object)None$.MODULE$);
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$apache$spark$deploy$yarn$security$ConfigurableCredentialManagerSuite$$credentialManager().getServiceCredentialProvider("hive")).should(this.$outer.not()).be((Object)None$.MODULE$);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("disable hive credential provider", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConfigurableCredentialManagerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$apache$spark$deploy$yarn$security$ConfigurableCredentialManagerSuite$$sparkConf().set("spark.yarn.security.credentials.hive.enabled", "false");
                this.$outer.org$apache$spark$deploy$yarn$security$ConfigurableCredentialManagerSuite$$credentialManager_$eq(new ConfigurableCredentialManager(this.$outer.org$apache$spark$deploy$yarn$security$ConfigurableCredentialManagerSuite$$sparkConf(), this.$outer.org$apache$spark$deploy$yarn$security$ConfigurableCredentialManagerSuite$$hadoopConf()));
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$apache$spark$deploy$yarn$security$ConfigurableCredentialManagerSuite$$credentialManager().getServiceCredentialProvider("hdfs")).should(this.$outer.not()).be((Object)None$.MODULE$);
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$apache$spark$deploy$yarn$security$ConfigurableCredentialManagerSuite$$credentialManager().getServiceCredentialProvider("hbase")).should(this.$outer.not()).be((Object)None$.MODULE$);
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$apache$spark$deploy$yarn$security$ConfigurableCredentialManagerSuite$$credentialManager().getServiceCredentialProvider("hive")).should(this.$outer.be().apply((Object)None$.MODULE$));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("using deprecated configurations", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConfigurableCredentialManagerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$apache$spark$deploy$yarn$security$ConfigurableCredentialManagerSuite$$sparkConf().set("spark.yarn.security.tokens.hdfs.enabled", "false");
                this.$outer.org$apache$spark$deploy$yarn$security$ConfigurableCredentialManagerSuite$$sparkConf().set("spark.yarn.security.tokens.hive.enabled", "false");
                this.$outer.org$apache$spark$deploy$yarn$security$ConfigurableCredentialManagerSuite$$credentialManager_$eq(new ConfigurableCredentialManager(this.$outer.org$apache$spark$deploy$yarn$security$ConfigurableCredentialManagerSuite$$sparkConf(), this.$outer.org$apache$spark$deploy$yarn$security$ConfigurableCredentialManagerSuite$$hadoopConf()));
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$apache$spark$deploy$yarn$security$ConfigurableCredentialManagerSuite$$credentialManager().getServiceCredentialProvider("hdfs")).should(this.$outer.be().apply((Object)None$.MODULE$));
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$apache$spark$deploy$yarn$security$ConfigurableCredentialManagerSuite$$credentialManager().getServiceCredentialProvider("hive")).should(this.$outer.be().apply((Object)None$.MODULE$));
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$apache$spark$deploy$yarn$security$ConfigurableCredentialManagerSuite$$credentialManager().getServiceCredentialProvider("test")).should(this.$outer.not()).be((Object)None$.MODULE$);
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$apache$spark$deploy$yarn$security$ConfigurableCredentialManagerSuite$$credentialManager().getServiceCredentialProvider("hbase")).should(this.$outer.not()).be((Object)None$.MODULE$);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("verify obtaining credentials from provider", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConfigurableCredentialManagerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$apache$spark$deploy$yarn$security$ConfigurableCredentialManagerSuite$$credentialManager_$eq(new ConfigurableCredentialManager(this.$outer.org$apache$spark$deploy$yarn$security$ConfigurableCredentialManagerSuite$$sparkConf(), this.$outer.org$apache$spark$deploy$yarn$security$ConfigurableCredentialManagerSuite$$hadoopConf()));
                Credentials creds = new Credentials();
                this.$outer.org$apache$spark$deploy$yarn$security$ConfigurableCredentialManagerSuite$$credentialManager().obtainCredentials(this.$outer.org$apache$spark$deploy$yarn$security$ConfigurableCredentialManagerSuite$$hadoopConf(), creds);
                Collection tokens = creds.getAllTokens();
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)tokens.size())).should(this.$outer.be().apply((Object)BoxesRunTime.boxToInteger((int)1)));
                this.$outer.convertToAnyShouldWrapper(((Token)tokens.iterator().next()).getService()).should(this.$outer.be().apply((Object)new Text("test")));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("verify getting credential renewal info", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConfigurableCredentialManagerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$apache$spark$deploy$yarn$security$ConfigurableCredentialManagerSuite$$credentialManager_$eq(new ConfigurableCredentialManager(this.$outer.org$apache$spark$deploy$yarn$security$ConfigurableCredentialManagerSuite$$sparkConf(), this.$outer.org$apache$spark$deploy$yarn$security$ConfigurableCredentialManagerSuite$$hadoopConf()));
                Credentials creds = new Credentials();
                TestCredentialProvider testCredentialProvider = (TestCredentialProvider)this.$outer.org$apache$spark$deploy$yarn$security$ConfigurableCredentialManagerSuite$$credentialManager().getServiceCredentialProvider("test").get();
                long nextRenewal = this.$outer.org$apache$spark$deploy$yarn$security$ConfigurableCredentialManagerSuite$$credentialManager().obtainCredentials(this.$outer.org$apache$spark$deploy$yarn$security$ConfigurableCredentialManagerSuite$$hadoopConf(), creds);
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)nextRenewal)).should(this.$outer.be().apply((Object)BoxesRunTime.boxToLong((long)testCredentialProvider.timeOfNextTokenRenewal())));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("obtain tokens For HiveMetastore", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConfigurableCredentialManagerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Configuration hadoopConf = new Configuration();
                hadoopConf.set("hive.metastore.kerberos.principal", "bob");
                hadoopConf.set("hive.metastore.uris", "http://localhost:0");
                HiveCredentialProvider hiveCredentialProvider = new HiveCredentialProvider();
                Credentials credentials = new Credentials();
                hiveCredentialProvider.obtainCredentials(hadoopConf, this.$outer.org$apache$spark$deploy$yarn$security$ConfigurableCredentialManagerSuite$$sparkConf(), credentials);
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)credentials.getAllTokens().size())).should(this.$outer.be().apply((Object)BoxesRunTime.boxToInteger((int)0)));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Obtain tokens For HBase", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConfigurableCredentialManagerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Configuration hadoopConf = new Configuration();
                hadoopConf.set("hbase.security.authentication", "kerberos");
                HBaseCredentialProvider hbaseTokenProvider = new HBaseCredentialProvider();
                Credentials creds = new Credentials();
                hbaseTokenProvider.obtainCredentials(hadoopConf, this.$outer.org$apache$spark$deploy$yarn$security$ConfigurableCredentialManagerSuite$$sparkConf(), creds);
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)creds.getAllTokens().size())).should(this.$outer.be().apply((Object)BoxesRunTime.boxToInteger((int)0)));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

