/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.yarn;

import com.google.common.io.Files;
import java.io.File;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.spark.TestUtils$;
import org.apache.spark.deploy.yarn.BaseYarnClusterSuite;
import org.apache.spark.deploy.yarn.SparkContextTimeoutApp$;
import org.apache.spark.deploy.yarn.YarnClasspathTest$;
import org.apache.spark.deploy.yarn.YarnClusterDriver$;
import org.apache.spark.deploy.yarn.YarnClusterDriverUseSparkHadoopUtilConf$;
import org.apache.spark.deploy.yarn.YarnClusterDriverWithFailure$;
import org.apache.spark.deploy.yarn.YarnClusterSuite$;
import org.apache.spark.deploy.yarn.YarnLauncherTestApp$;
import org.apache.spark.deploy.yarn.config.package$;
import org.apache.spark.launcher.SparkAppHandle;
import org.apache.spark.launcher.SparkLauncher;
import org.apache.spark.tags.ExtendedYarnTest;
import org.scalatest.Tag;
import org.scalatest.concurrent.Eventually$;
import org.scalatest.time.Span$;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ExtendedYarnTest
@ScalaSignature(bytes="\u0006\u0001=4A!\u0001\u0002\u0001\u001b\t\u0001\u0012,\u0019:o\u00072,8\u000f^3s'VLG/\u001a\u0006\u0003\u0007\u0011\tA!_1s]*\u0011QAB\u0001\u0007I\u0016\u0004Hn\\=\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001\u001dA\u0011q\u0002E\u0007\u0002\u0005%\u0011\u0011C\u0001\u0002\u0015\u0005\u0006\u001cX-W1s]\u000ecWo\u001d;feN+\u0018\u000e^3\t\u000bM\u0001A\u0011\u0001\u000b\u0002\rqJg.\u001b;?)\u0005)\u0002CA\b\u0001\u0011\u00159\u0002\u0001\"\u0011\u0019\u00035qWm^-be:\u001cuN\u001c4jOR\t\u0011\u0004\u0005\u0002\u001bA5\t1D\u0003\u0002\u001d;\u0005!1m\u001c8g\u0015\t\u0019aD\u0003\u0002 \u0011\u00051\u0001.\u00193p_BL!!I\u000e\u0003#e\u000b'O\\\"p]\u001aLw-\u001e:bi&|g\u000eC\u0004$\u0001\t\u0007I\u0011\u0002\u0013\u0002\u0017Q+5\u000bV0Q3\u001aKE*R\u000b\u0002KA\u0011a\u0005\f\b\u0003O)j\u0011\u0001\u000b\u0006\u0002S\u0005)1oY1mC&\u00111\u0006K\u0001\u0007!J,G-\u001a4\n\u00055r#AB*ue&twM\u0003\u0002,Q!1\u0001\u0007\u0001Q\u0001\n\u0015\nA\u0002V#T)~\u0003\u0016LR%M\u000b\u0002BqA\r\u0001C\u0002\u0013%A%A\u0007U\u000bN#v\fU-N\u001f\u0012+F*\u0012\u0005\u0007i\u0001\u0001\u000b\u0011B\u0013\u0002\u001dQ+5\u000bV0Q36{E)\u0016'FA!)a\u0007\u0001C\u0005o\u0005\u0001B/Z:u\u0005\u0006\u001c\u0018nY-be:\f\u0005\u000f\u001d\u000b\u0004qm\u0002\u0005CA\u0014:\u0013\tQ\u0004F\u0001\u0003V]&$\b\"\u0002\u001f6\u0001\u0004i\u0014AC2mS\u0016tG/T8eKB\u0011qEP\u0005\u0003\u007f!\u0012qAQ8pY\u0016\fg\u000eC\u0004\u001dkA\u0005\t\u0019A!\u0011\t\u0019\u0012U%J\u0005\u0003\u0007:\u00121!T1q\u0011\u0015)\u0005\u0001\"\u0003G\u0003\u0005\"Xm\u001d;ZCJt\u0017\t\u001d9Vg\u0016\u001c\u0006/\u0019:l\u0011\u0006$wn\u001c9Vi&d7i\u001c8g)\u0005A\u0004\"\u0002%\u0001\t\u0013I\u0015A\u0004;fgR<\u0016\u000e\u001e5BI\u0012T\u0015M\u001d\u000b\u0003q)CQ\u0001P$A\u0002uBQ\u0001\u0014\u0001\u0005\n5\u000b1\u0002^3tiBK8\u000b]1sWR!\u0001HT(R\u0011\u0015a4\n1\u0001>\u0011\u001d\u00016\n%AA\u0002\u0005\u000b\u0011\"\u001a=ue\u0006\u001cuN\u001c4\t\u000fI[\u0005\u0013!a\u0001\u0003\u0006AQ\r\u001f;sC\u0016sg\u000fC\u0003U\u0001\u0011%Q+A\u000buKN$Xk]3DY\u0006\u001c8\u000fU1uQ\u001aK'o\u001d;\u0015\u0005a2\u0006\"\u0002\u001fT\u0001\u0004i\u0004b\u0002-\u0001#\u0003%I!W\u0001\u001bi\u0016\u001cHOQ1tS\u000eL\u0016M\u001d8BaB$C-\u001a4bk2$HEM\u000b\u00025*\u0012\u0011iW\u0016\u00029B\u0011QLY\u0007\u0002=*\u0011q\fY\u0001\nk:\u001c\u0007.Z2lK\u0012T!!\u0019\u0015\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002d=\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u000f\u0015\u0004\u0011\u0013!C\u00053\u0006)B/Z:u!f\u001c\u0006/\u0019:lI\u0011,g-Y;mi\u0012\u0012\u0004bB4\u0001#\u0003%I!W\u0001\u0016i\u0016\u001cH\u000fU=Ta\u0006\u00148\u000e\n3fM\u0006,H\u000e\u001e\u00134Q\t\u0001\u0011\u000e\u0005\u0002k[6\t1N\u0003\u0002m\r\u0005!A/Y4t\u0013\tq7N\u0001\tFqR,g\u000eZ3e3\u0006\u0014h\u000eV3ti\u0002")
public class YarnClusterSuite
extends BaseYarnClusterSuite {
    private final String TEST_PYFILE = new StringOps(Predef$.MODULE$.augmentString("\n    |import mod1, mod2\n    |import sys\n    |from operator import add\n    |\n    |from pyspark import SparkConf , SparkContext\n    |if __name__ == \"__main__\":\n    |    if len(sys.argv) != 2:\n    |        print >> sys.stderr, \"Usage: test.py [result file]\"\n    |        exit(-1)\n    |    sc = SparkContext(conf=SparkConf())\n    |    status = open(sys.argv[1],'w')\n    |    result = \"failure\"\n    |    rdd = sc.parallelize(range(10)).map(lambda x: x * mod1.func() * mod2.func())\n    |    cnt = rdd.count()\n    |    if cnt == 10:\n    |        result = \"success\"\n    |    status.write(result)\n    |    status.close()\n    |    sc.stop()\n    ")).stripMargin();
    private final String TEST_PYMODULE = new StringOps(Predef$.MODULE$.augmentString("\n    |def func():\n    |    return 42\n    ")).stripMargin();

    @Override
    public YarnConfiguration newYarnConfig() {
        return new YarnConfiguration();
    }

    private String TEST_PYFILE() {
        return this.TEST_PYFILE;
    }

    private String TEST_PYMODULE() {
        return this.TEST_PYMODULE;
    }

    public void org$apache$spark$deploy$yarn$YarnClusterSuite$$testBasicYarnApp(boolean clientMode, Map<String, String> conf) {
        File result = File.createTempFile("result", null, this.tempDir());
        boolean x$13 = clientMode;
        String x$14 = this.mainClassName(YarnClusterDriver$.MODULE$.getClass());
        Seq x$15 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{result.getAbsolutePath()}));
        Map<String, String> x$16 = conf;
        Seq<Tuple2<String, String>> x$17 = this.runSpark$default$4();
        Seq<String> x$18 = this.runSpark$default$5();
        Seq<String> x$19 = this.runSpark$default$6();
        Map<String, String> x$20 = this.runSpark$default$8();
        SparkAppHandle.State finalState = this.runSpark(x$13, x$14, (Seq<String>)x$15, x$17, x$18, x$19, x$16, x$20);
        this.checkResult(finalState, result);
    }

    public Map<String, String> org$apache$spark$deploy$yarn$YarnClusterSuite$$testBasicYarnApp$default$2() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
    }

    public void org$apache$spark$deploy$yarn$YarnClusterSuite$$testYarnAppUseSparkHadoopUtilConf() {
        File result = File.createTempFile("result", null, this.tempDir());
        boolean x$21 = false;
        String x$22 = this.mainClassName(YarnClusterDriverUseSparkHadoopUtilConf$.MODULE$.getClass());
        Seq x$23 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key=value", result.getAbsolutePath()}));
        Map x$24 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.hadoop.key"), (Object)"value")}));
        Seq<Tuple2<String, String>> x$25 = this.runSpark$default$4();
        Seq<String> x$26 = this.runSpark$default$5();
        Seq<String> x$27 = this.runSpark$default$6();
        Map<String, String> x$28 = this.runSpark$default$8();
        SparkAppHandle.State finalState = this.runSpark(x$21, x$22, (Seq<String>)x$23, x$25, x$26, x$27, (Map<String, String>)x$24, x$28);
        this.checkResult(finalState, result);
    }

    public void org$apache$spark$deploy$yarn$YarnClusterSuite$$testWithAddJar(boolean clientMode) {
        URL originalJar = TestUtils$.MODULE$.createJarWithFiles((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test.resource"), (Object)"ORIGINAL")})), this.tempDir());
        File driverResult = File.createTempFile("driver", null, this.tempDir());
        File executorResult = File.createTempFile("executor", null, this.tempDir());
        boolean x$29 = clientMode;
        String x$30 = this.mainClassName(YarnClasspathTest$.MODULE$.getClass());
        Seq x$31 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{driverResult.getAbsolutePath(), executorResult.getAbsolutePath()}));
        Seq x$32 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{originalJar.getPath()}));
        Seq x$33 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder().append((Object)"local:").append((Object)originalJar.getPath()).toString()}));
        Seq<Tuple2<String, String>> x$34 = this.runSpark$default$4();
        Map<String, String> x$35 = this.runSpark$default$7();
        Map<String, String> x$36 = this.runSpark$default$8();
        SparkAppHandle.State finalState = this.runSpark(x$29, x$30, (Seq<String>)x$31, x$34, (Seq<String>)x$32, (Seq<String>)x$33, x$35, x$36);
        this.checkResult(finalState, driverResult, "ORIGINAL");
        this.checkResult(finalState, executorResult, "ORIGINAL");
    }

    public void org$apache$spark$deploy$yarn$YarnClusterSuite$$testPySpark(boolean clientMode, Map<String, String> extraConf, Map<String, String> extraEnv) {
        File file;
        File primaryPyFile = new File(this.tempDir(), "test.py");
        Files.write((CharSequence)this.TEST_PYFILE(), (File)primaryPyFile, (Charset)StandardCharsets.UTF_8);
        String sparkHome = (String)scala.sys.package$.MODULE$.props().apply((Object)"spark.test.home");
        Seq pythonPath = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/python/lib/py4j-0.10.4-src.zip"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sparkHome})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/python"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sparkHome}))}));
        Map extraEnvVars = ((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"PYSPARK_ARCHIVES_PATH"), (Object)((TraversableOnce)pythonPath.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(String x$1) {
                return new StringBuilder().append((Object)"local:").append((Object)x$1).toString();
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString(File.pathSeparator)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"PYTHONPATH"), (Object)pythonPath.mkString(File.pathSeparator))}))).$plus$plus(extraEnv);
        if (clientMode) {
            file = this.tempDir();
        } else {
            File subdir = new File(this.tempDir(), "pyModules");
            subdir.mkdir();
            file = subdir;
        }
        File moduleDir = file;
        File pyModule = new File(moduleDir, "mod1.py");
        Files.write((CharSequence)this.TEST_PYMODULE(), (File)pyModule, (Charset)StandardCharsets.UTF_8);
        URL mod2Archive = TestUtils$.MODULE$.createJarWithFiles((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"mod2.py"), (Object)this.TEST_PYMODULE())})), moduleDir);
        String pyFiles = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{pyModule.getAbsolutePath(), mod2Archive.getPath()}))).mkString(",");
        File result = File.createTempFile("result", null, this.tempDir());
        boolean x$37 = clientMode;
        String x$38 = primaryPyFile.getAbsolutePath();
        Seq x$39 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"--py-files"), (Object)pyFiles)}));
        Seq x$40 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{result.getAbsolutePath()}));
        Map x$41 = extraEnvVars;
        Map<String, String> x$42 = extraConf;
        Seq<String> x$43 = this.runSpark$default$5();
        Seq<String> x$44 = this.runSpark$default$6();
        SparkAppHandle.State finalState = this.runSpark(x$37, x$38, (Seq<String>)x$40, (Seq<Tuple2<String, String>>)x$39, x$43, x$44, x$42, (Map<String, String>)x$41);
        this.checkResult(finalState, result);
    }

    public Map<String, String> org$apache$spark$deploy$yarn$YarnClusterSuite$$testPySpark$default$2() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
    }

    public Map<String, String> org$apache$spark$deploy$yarn$YarnClusterSuite$$testPySpark$default$3() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
    }

    public void org$apache$spark$deploy$yarn$YarnClusterSuite$$testUseClassPathFirst(boolean clientMode) {
        URL originalJar = TestUtils$.MODULE$.createJarWithFiles((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test.resource"), (Object)"ORIGINAL")})), this.tempDir());
        URL userJar = TestUtils$.MODULE$.createJarWithFiles((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test.resource"), (Object)"OVERRIDDEN")})), this.tempDir());
        File driverResult = File.createTempFile("driver", null, this.tempDir());
        File executorResult = File.createTempFile("executor", null, this.tempDir());
        boolean x$45 = clientMode;
        String x$46 = this.mainClassName(YarnClasspathTest$.MODULE$.getClass());
        Seq x$47 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{driverResult.getAbsolutePath(), executorResult.getAbsolutePath()}));
        Seq x$48 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{originalJar.getPath()}));
        Seq x$49 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder().append((Object)"local:").append((Object)userJar.getPath()).toString()}));
        Map x$50 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.driver.userClassPathFirst"), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.executor.userClassPathFirst"), (Object)"true")}));
        Seq<Tuple2<String, String>> x$51 = this.runSpark$default$4();
        Map<String, String> x$52 = this.runSpark$default$8();
        SparkAppHandle.State finalState = this.runSpark(x$45, x$46, (Seq<String>)x$47, x$51, (Seq<String>)x$48, (Seq<String>)x$49, (Map<String, String>)x$50, x$52);
        this.checkResult(finalState, driverResult, "OVERRIDDEN");
        this.checkResult(finalState, executorResult, "OVERRIDDEN");
    }

    public YarnClusterSuite() {
        this.test("run Spark in yarn-client mode", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ YarnClusterSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$apache$spark$deploy$yarn$YarnClusterSuite$$testBasicYarnApp(true, this.$outer.org$apache$spark$deploy$yarn$YarnClusterSuite$$testBasicYarnApp$default$2());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("run Spark in yarn-cluster mode", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ YarnClusterSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$apache$spark$deploy$yarn$YarnClusterSuite$$testBasicYarnApp(false, this.$outer.org$apache$spark$deploy$yarn$YarnClusterSuite$$testBasicYarnApp$default$2());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("run Spark in yarn-client mode with different configurations", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ YarnClusterSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$apache$spark$deploy$yarn$YarnClusterSuite$$testBasicYarnApp(true, (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.driver.memory"), (Object)"512m"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.executor.cores"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.executor.memory"), (Object)"512m"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.executor.instances"), (Object)"2")}))));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("run Spark in yarn-cluster mode with different configurations", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ YarnClusterSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$apache$spark$deploy$yarn$YarnClusterSuite$$testBasicYarnApp(false, (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.driver.memory"), (Object)"512m"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.driver.cores"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.executor.cores"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.executor.memory"), (Object)"512m"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.executor.instances"), (Object)"2")}))));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("run Spark in yarn-cluster mode with using SparkHadoopUtil.conf", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ YarnClusterSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$apache$spark$deploy$yarn$YarnClusterSuite$$testYarnAppUseSparkHadoopUtilConf();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("run Spark in yarn-client mode with additional jar", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ YarnClusterSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$apache$spark$deploy$yarn$YarnClusterSuite$$testWithAddJar(true);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("run Spark in yarn-cluster mode with additional jar", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ YarnClusterSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$apache$spark$deploy$yarn$YarnClusterSuite$$testWithAddJar(false);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("run Spark in yarn-cluster mode unsuccessfully", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ YarnClusterSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SparkAppHandle.State finalState = this.$outer.runSpark(false, this.$outer.mainClassName(YarnClusterDriver$.MODULE$.getClass()), this.$outer.runSpark$default$3(), this.$outer.runSpark$default$4(), this.$outer.runSpark$default$5(), this.$outer.runSpark$default$6(), this.$outer.runSpark$default$7(), this.$outer.runSpark$default$8());
                this.$outer.convertToAnyShouldWrapper(finalState).should(this.$outer.be().apply((Object)SparkAppHandle.State.FAILED));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("run Spark in yarn-cluster mode failure after sc initialized", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ YarnClusterSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SparkAppHandle.State finalState = this.$outer.runSpark(false, this.$outer.mainClassName(YarnClusterDriverWithFailure$.MODULE$.getClass()), this.$outer.runSpark$default$3(), this.$outer.runSpark$default$4(), this.$outer.runSpark$default$5(), this.$outer.runSpark$default$6(), this.$outer.runSpark$default$7(), this.$outer.runSpark$default$8());
                this.$outer.convertToAnyShouldWrapper(finalState).should(this.$outer.be().apply((Object)SparkAppHandle.State.FAILED));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("run Python application in yarn-client mode", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ YarnClusterSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$apache$spark$deploy$yarn$YarnClusterSuite$$testPySpark(true, this.$outer.org$apache$spark$deploy$yarn$YarnClusterSuite$$testPySpark$default$2(), this.$outer.org$apache$spark$deploy$yarn$YarnClusterSuite$$testPySpark$default$3());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("run Python application in yarn-cluster mode", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ YarnClusterSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$apache$spark$deploy$yarn$YarnClusterSuite$$testPySpark(false, this.$outer.org$apache$spark$deploy$yarn$YarnClusterSuite$$testPySpark$default$2(), this.$outer.org$apache$spark$deploy$yarn$YarnClusterSuite$$testPySpark$default$3());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("run Python application in yarn-cluster mode using  spark.yarn.appMasterEnv to override local envvar", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ YarnClusterSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$apache$spark$deploy$yarn$YarnClusterSuite$$testPySpark(false, (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.yarn.appMasterEnv.PYSPARK_DRIVER_PYTHON"), scala.sys.package$.MODULE$.env().getOrElse((Object)"PYSPARK_DRIVER_PYTHON", (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "python";
                    }
                })), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.yarn.appMasterEnv.PYSPARK_PYTHON"), scala.sys.package$.MODULE$.env().getOrElse((Object)"PYSPARK_PYTHON", (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "python";
                    }
                }))}))), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"PYSPARK_DRIVER_PYTHON"), (Object)"not python"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"PYSPARK_PYTHON"), (Object)"not python")}))));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("user class path first in client mode", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ YarnClusterSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$apache$spark$deploy$yarn$YarnClusterSuite$$testUseClassPathFirst(true);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("user class path first in cluster mode", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ YarnClusterSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$apache$spark$deploy$yarn$YarnClusterSuite$$testUseClassPathFirst(false);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("monitor app using launcher library", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ YarnClusterSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            /*
             * WARNING - void declaration
             */
            public void apply$mcV$sp() {
                HashMap<String, String> env = new HashMap<String, String>();
                env.put("YARN_CONF_DIR", this.$outer.hadoopConfDir().getAbsolutePath());
                String propsFile = this.$outer.createConfFile(this.$outer.createConfFile$default$1(), this.$outer.createConfFile$default$2());
                SparkAppHandle handle = new SparkLauncher(env).setSparkHome((String)scala.sys.package$.MODULE$.props().apply((Object)"spark.test.home")).setConf("spark.ui.enabled", "false").setPropertiesFile(propsFile).setMaster("yarn").setDeployMode("client").setAppResource("spark-internal").setMainClass(this.$outer.mainClassName(YarnLauncherTestApp$.MODULE$.getClass())).startApplication(new SparkAppHandle.Listener[0]);
                try {
                    Eventually$.MODULE$.eventually(Eventually$.MODULE$.timeout(Span$.MODULE$.convertDurationToSpan((Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(30)).seconds())), Eventually$.MODULE$.interval(Span$.MODULE$.convertDurationToSpan((Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(100)).millis())), (Function0)new Serializable(this, handle){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$15 $outer;
                        private final SparkAppHandle handle$1;

                        public final void apply() {
                            this.apply$mcV$sp();
                        }

                        public void apply$mcV$sp() {
                            this.$outer.org$apache$spark$deploy$yarn$YarnClusterSuite$$anonfun$$$outer().convertToAnyShouldWrapper(this.handle$1.getState()).should(this.$outer.org$apache$spark$deploy$yarn$YarnClusterSuite$$anonfun$$$outer().be().apply((Object)SparkAppHandle.State.RUNNING));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.handle$1 = handle$1;
                        }
                    });
                    this.$outer.convertToStringShouldWrapper(handle.getAppId()).should(this.$outer.not()).be(null, Predef$.MODULE$.$conforms());
                    this.$outer.convertToStringShouldWrapper(handle.getAppId()).should(this.$outer.startWith().apply("application_"));
                    handle.stop();
                    Eventually$.MODULE$.eventually(Eventually$.MODULE$.timeout(Span$.MODULE$.convertDurationToSpan((Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(30)).seconds())), Eventually$.MODULE$.interval(Span$.MODULE$.convertDurationToSpan((Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(100)).millis())), (Function0)new Serializable(this, handle){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$15 $outer;
                        private final SparkAppHandle handle$1;

                        public final void apply() {
                            this.apply$mcV$sp();
                        }

                        public void apply$mcV$sp() {
                            this.$outer.org$apache$spark$deploy$yarn$YarnClusterSuite$$anonfun$$$outer().convertToAnyShouldWrapper(this.handle$1.getState()).should(this.$outer.org$apache$spark$deploy$yarn$YarnClusterSuite$$anonfun$$$outer().be().apply((Object)SparkAppHandle.State.KILLED));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.handle$1 = handle$1;
                        }
                    });
                }
                catch (Throwable throwable) {
                    void var3_3;
                    var3_3.kill();
                    throw throwable;
                }
                handle.kill();
            }

            public /* synthetic */ YarnClusterSuite org$apache$spark$deploy$yarn$YarnClusterSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("timeout to get SparkContext in cluster mode triggers failure", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ YarnClusterSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int timeout = 2000;
                boolean x$5 = false;
                String x$6 = this.$outer.mainClassName(SparkContextTimeoutApp$.MODULE$.getClass());
                Seq x$7 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{((Object)BoxesRunTime.boxToInteger((int)(timeout * 4))).toString()}));
                Map x$8 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)package$.MODULE$.AM_MAX_WAIT_TIME().key()), (Object)((Object)BoxesRunTime.boxToInteger((int)timeout)).toString())}));
                Seq<Tuple2<String, String>> x$9 = this.$outer.runSpark$default$4();
                Seq<String> x$10 = this.$outer.runSpark$default$5();
                Seq<String> x$11 = this.$outer.runSpark$default$6();
                Map<String, String> x$12 = this.$outer.runSpark$default$8();
                SparkAppHandle.State finalState = this.$outer.runSpark(x$5, x$6, (Seq<String>)x$7, x$9, x$10, x$11, (Map<String, String>)x$8, x$12);
                this.$outer.convertToAnyShouldWrapper(finalState).should(this.$outer.be().apply((Object)SparkAppHandle.State.FAILED));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

