/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.yarn;

import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.client.api.AMRMClient;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.spark.SecurityManager;
import org.apache.spark.SecurityManager$;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.deploy.yarn.MockResolver;
import org.apache.spark.deploy.yarn.SparkRackResolver;
import org.apache.spark.deploy.yarn.YarnAllocator;
import org.apache.spark.deploy.yarn.YarnAllocator$;
import org.apache.spark.deploy.yarn.YarnSparkHadoopUtil$;
import org.apache.spark.deploy.yarn.config.package$;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.scheduler.SplitInfo;
import org.apache.spark.util.Clock;
import org.apache.spark.util.ManualClock;
import org.mockito.Mockito;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality;
import org.scalactic.Equality$;
import org.scalactic.Explicitly;
import org.scalactic.Tolerance;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.ConfigMap;
import org.scalatest.Entry;
import org.scalatest.FunSuiteLike;
import org.scalatest.Matchers;
import org.scalatest.Matchers$AllCollected$;
import org.scalatest.Matchers$AtLeastCollected$;
import org.scalatest.Matchers$AtMostCollected$;
import org.scalatest.Matchers$BetweenCollected$;
import org.scalatest.Matchers$EveryCollected$;
import org.scalatest.Matchers$ExactlyCollected$;
import org.scalatest.Matchers$NoCollected$;
import org.scalatest.Matchers$ShouldMethodHelper$;
import org.scalatest.Status;
import org.scalatest.Tag;
import org.scalatest.TestData;
import org.scalatest.enablers.Collecting;
import org.scalatest.enablers.Containing$;
import org.scalatest.matchers.Matcher;
import org.scalatest.matchers.MatcherFactory1;
import org.scalatest.words.BeWord;
import org.scalatest.words.CompileWord;
import org.scalatest.words.ContainWord;
import org.scalatest.words.DefinedWord;
import org.scalatest.words.EmptyWord;
import org.scalatest.words.EndWithWord;
import org.scalatest.words.ExistWord;
import org.scalatest.words.FullyMatchWord;
import org.scalatest.words.HaveWord;
import org.scalatest.words.IncludeWord;
import org.scalatest.words.LengthWord;
import org.scalatest.words.MatchPatternWord;
import org.scalatest.words.MatcherWords;
import org.scalatest.words.NoExceptionWord;
import org.scalatest.words.NotWord;
import org.scalatest.words.ReadableWord;
import org.scalatest.words.ResultOfATypeInvocation;
import org.scalatest.words.ResultOfAllOfApplication;
import org.scalatest.words.ResultOfAnTypeInvocation;
import org.scalatest.words.ResultOfAtLeastOneOfApplication;
import org.scalatest.words.ResultOfAtMostOneOfApplication;
import org.scalatest.words.ResultOfDefinedAt;
import org.scalatest.words.ResultOfGreaterThanComparison;
import org.scalatest.words.ResultOfGreaterThanOrEqualToComparison;
import org.scalatest.words.ResultOfInOrderApplication;
import org.scalatest.words.ResultOfInOrderOnlyApplication;
import org.scalatest.words.ResultOfLessThanComparison;
import org.scalatest.words.ResultOfLessThanOrEqualToComparison;
import org.scalatest.words.ResultOfMessageWordApplication;
import org.scalatest.words.ResultOfNoneOfApplication;
import org.scalatest.words.ResultOfOfTypeInvocation;
import org.scalatest.words.ResultOfOneOfApplication;
import org.scalatest.words.ResultOfOnlyApplication;
import org.scalatest.words.ResultOfTheSameElementsAsApplication;
import org.scalatest.words.ResultOfTheSameElementsInOrderAsApplication;
import org.scalatest.words.ResultOfTheTypeInvocation;
import org.scalatest.words.ResultOfThrownByApplication;
import org.scalatest.words.ShouldVerb;
import org.scalatest.words.SizeWord;
import org.scalatest.words.SortedWord;
import org.scalatest.words.StartWithWord;
import org.scalatest.words.TypeCheckWord;
import org.scalatest.words.WritableWord;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Symbol;
import scala.collection.GenTraversable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.Manifest;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\u0005]e\u0001B\u0001\u0003\u00015\u0011!#W1s]\u0006cGn\\2bi>\u00148+^5uK*\u00111\u0001B\u0001\u0005s\u0006\u0014hN\u0003\u0002\u0006\r\u00051A-\u001a9m_fT!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001'\u0011\u0001aB\u0005\r\u0011\u0005=\u0001R\"\u0001\u0004\n\u0005E1!!D*qCJ\\g)\u001e8Tk&$X\r\u0005\u0002\u0014-5\tAC\u0003\u0002\u0016\u0015\u0005I1oY1mCR,7\u000f^\u0005\u0003/Q\u0011\u0001\"T1uG\",'o\u001d\t\u0003'eI!A\u0007\u000b\u0003%\t+gm\u001c:f\u0003:$\u0017I\u001a;fe\u0016\u000b7\r\u001b\u0005\u00069\u0001!\t!H\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003y\u0001\"a\b\u0001\u000e\u0003\tAq!\t\u0001C\u0002\u0013\u0005!%\u0001\u0003d_:4W#A\u0012\u0011\u0005\u0011JS\"A\u0013\u000b\u0005\u00052#BA\u0002(\u0015\tA\u0003\"\u0001\u0004iC\u0012|w\u000e]\u0005\u0003U\u0015\u0012\u0011#W1s]\u000e{gNZ5hkJ\fG/[8o\u0011\u0019a\u0003\u0001)A\u0005G\u0005)1m\u001c8gA!9a\u0006\u0001b\u0001\n\u0003y\u0013!C:qCJ\\7i\u001c8g+\u0005\u0001\u0004CA\b2\u0013\t\u0011dAA\u0005Ta\u0006\u00148nQ8oM\"1A\u0007\u0001Q\u0001\nA\n!b\u001d9be.\u001cuN\u001c4!\u0011\u001d1\u0004A1A\u0005\u0002]\nA\"\u00199q\u0003R$X-\u001c9u\u0013\u0012,\u0012\u0001\u000f\t\u0003syj\u0011A\u000f\u0006\u0003wq\nqA]3d_J$7O\u0003\u0002>M\u0005\u0019\u0011\r]5\n\u0005}R$\u0001F!qa2L7-\u0019;j_:\fE\u000f^3naRLE\r\u0003\u0004B\u0001\u0001\u0006I\u0001O\u0001\u000eCB\u0004\u0018\t\u001e;f[B$\u0018\n\u001a\u0011\t\u000f\r\u0003!\u0019!C\u0001\t\u0006\t2m\u001c8uC&tWM\u001d*fg>,(oY3\u0016\u0003\u0015\u0003\"!\u000f$\n\u0005\u001dS$\u0001\u0003*fg>,(oY3\t\r%\u0003\u0001\u0015!\u0003F\u0003I\u0019wN\u001c;bS:,'OU3t_V\u00148-\u001a\u0011\t\u0013-\u0003\u0001\u0019!a\u0001\n\u0003a\u0015\u0001\u0003:n\u00072LWM\u001c;\u0016\u00035\u00032A\u0014*U\u001b\u0005y%BA\u001fQ\u0015\t\tf%\u0001\u0004dY&,g\u000e^\u0005\u0003'>\u0013!\"Q'S\u001b\u000ec\u0017.\u001a8u!\t)vM\u0004\u0002WK:\u0011q\u000b\u001a\b\u00031\u000et!!\u00172\u000f\u0005i\u000bgBA.a\u001d\tav,D\u0001^\u0015\tqF\"\u0001\u0004=e>|GOP\u0005\u0002\u0017%\u0011\u0011BC\u0005\u0003Q!I!aA\u0014\n\u0005E3\u0013BA\u001fQ\u0013\t1w*\u0001\u0006B\u001bJk5\t\\5f]RL!\u0001[5\u0003!\r{g\u000e^1j]\u0016\u0014(+Z9vKN$(B\u00014P\u0011%Y\u0007\u00011AA\u0002\u0013\u0005A.\u0001\u0007s[\u000ec\u0017.\u001a8u?\u0012*\u0017\u000f\u0006\u0002ngB\u0011a.]\u0007\u0002_*\t\u0001/A\u0003tG\u0006d\u0017-\u0003\u0002s_\n!QK\\5u\u0011\u001d!(.!AA\u00025\u000b1\u0001\u001f\u00132\u0011\u00191\b\u0001)Q\u0005\u001b\u0006I!/\\\"mS\u0016tG\u000f\t\u0005\bq\u0002\u0001\r\u0011\"\u0001z\u00031\u0019wN\u001c;bS:,'OT;n+\u0005Q\bC\u00018|\u0013\taxNA\u0002J]RDqA \u0001A\u0002\u0013\u0005q0\u0001\td_:$\u0018-\u001b8fe:+Xn\u0018\u0013fcR\u0019Q.!\u0001\t\u000fQl\u0018\u0011!a\u0001u\"9\u0011Q\u0001\u0001!B\u0013Q\u0018!D2p]R\f\u0017N\\3s\u001dVl\u0007\u0005C\u0004\u0002\n\u0001!\t%a\u0003\u0002\u0015\t,gm\u001c:f\u000b\u0006\u001c\u0007\u000eF\u0001n\u0011\u001d\ty\u0001\u0001C!\u0003\u0017\t\u0011\"\u00194uKJ,\u0015m\u00195\u0007\r\u0005M\u0001\u0001AA\u000b\u00055iunY6Ta2LG/\u00138g_N!\u0011\u0011CA\f!\u0011\tI\"a\b\u000e\u0005\u0005m!bAA\u000f\r\u0005I1o\u00195fIVdWM]\u0005\u0005\u0003C\tYBA\u0005Ta2LG/\u00138g_\"i\u0011QEA\t\u0005\u0003\u0005\u000b\u0011BA\u0014\u0003k\tA\u0001[8tiB!\u0011\u0011FA\u0018\u001d\rq\u00171F\u0005\u0004\u0003[y\u0017A\u0002)sK\u0012,g-\u0003\u0003\u00022\u0005M\"AB*ue&twMC\u0002\u0002.=LA!a\u000e\u0002 \u0005a\u0001n\\:u\u0019>\u001c\u0017\r^5p]\"9A$!\u0005\u0005\u0002\u0005mB\u0003BA\u001f\u0003\u0003\u0002B!a\u0010\u0002\u00125\t\u0001\u0001\u0003\u0005\u0002&\u0005e\u0002\u0019AA\u0014\u0011!\t)%!\u0005\u0005B\u0005\u001d\u0013\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0003iD\u0001\"a\u0013\u0002\u0012\u0011\u0005\u0013QJ\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005=\u0013Q\u000b\t\u0004]\u0006E\u0013bAA*_\n9!i\\8mK\u0006t\u0007\u0002CA,\u0003\u0013\u0002\r!!\u0017\u0002\u000b=$\b.\u001a:\u0011\u00079\fY&C\u0002\u0002^=\u00141!\u00118z\u0011\u001d\t\t\u0007\u0001C\u0001\u0003G\nqb\u0019:fCR,\u0017\t\u001c7pG\u0006$xN\u001d\u000b\u0005\u0003K\nY\u0007E\u0002 \u0003OJ1!!\u001b\u0003\u00055I\u0016M\u001d8BY2|7-\u0019;pe\"I\u0011QNA0!\u0003\u0005\rA_\u0001\r[\u0006DX\t_3dkR|'o\u001d\u0005\b\u0003c\u0002A\u0011AA:\u0003=\u0019'/Z1uK\u000e{g\u000e^1j]\u0016\u0014H\u0003BA;\u0003w\u00022!OA<\u0013\r\tIH\u000f\u0002\n\u0007>tG/Y5oKJD\u0001\"!\n\u0002p\u0001\u0007\u0011q\u0005\u0005\n\u0003\u007f\u0002\u0011\u0013!C\u0001\u0003\u0003\u000b\u0011d\u0019:fCR,\u0017\t\u001c7pG\u0006$xN\u001d\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u00111\u0011\u0016\u0004u\u0006\u00155FAAD!\u0011\tI)a%\u000e\u0005\u0005-%\u0002BAG\u0003\u001f\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005Eu.\u0001\u0006b]:|G/\u0019;j_:LA!!&\u0002\f\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public class YarnAllocatorSuite
extends SparkFunSuite
implements Matchers,
BeforeAndAfterEach {
    private final YarnConfiguration conf;
    private final SparkConf sparkConf;
    private final ApplicationAttemptId appAttemptId;
    private final Resource containerResource;
    private AMRMClient<AMRMClient.ContainerRequest> rmClient;
    private int containerNum;
    private final Matchers.KeyWord key;
    private final Matchers.ValueWord value;
    private final Matchers.AWord a;
    private final Matchers.AnWord an;
    private final Matchers.TheSameInstanceAsPhrase theSameInstanceAs;
    private final Matchers.RegexWord regex;
    private final Explicitly.DecidedWord decided;
    private final Explicitly.DeterminedWord determined;
    private final Explicitly.TheAfterWord after;
    private final FullyMatchWord fullyMatch;
    private final StartWithWord startWith;
    private final EndWithWord endWith;
    private final IncludeWord include;
    private final HaveWord have;
    private final BeWord be;
    private final ContainWord contain;
    private final NotWord not;
    private final LengthWord length;
    private final SizeWord size;
    private final SortedWord sorted;
    private final DefinedWord defined;
    private final NoExceptionWord noException;
    private final ExistWord exist;
    private final ReadableWord readable;
    private final WritableWord writable;
    private final EmptyWord empty;
    private final CompileWord compile;
    private final TypeCheckWord typeCheck;
    private final MatchPatternWord matchPattern;
    private volatile Matchers$AllCollected$ org$scalatest$Matchers$$AllCollected$module;
    private volatile Matchers$EveryCollected$ org$scalatest$Matchers$$EveryCollected$module;
    private volatile Matchers$BetweenCollected$ org$scalatest$Matchers$$BetweenCollected$module;
    private volatile Matchers$AtLeastCollected$ org$scalatest$Matchers$$AtLeastCollected$module;
    private volatile Matchers$AtMostCollected$ org$scalatest$Matchers$$AtMostCollected$module;
    private volatile Matchers$NoCollected$ org$scalatest$Matchers$$NoCollected$module;
    private volatile Matchers$ExactlyCollected$ org$scalatest$Matchers$$ExactlyCollected$module;
    private volatile Matchers$ShouldMethodHelper$ org$scalatest$Matchers$$ShouldMethodHelper$module;

    public /* synthetic */ Status org$scalatest$BeforeAndAfterEach$$super$runTest(String testName, Args args) {
        return FunSuiteLike.class.runTest((FunSuiteLike)this, (String)testName, (Args)args);
    }

    public void beforeEach(ConfigMap configMap) {
        BeforeAndAfterEach.class.beforeEach((BeforeAndAfterEach)this, (ConfigMap)configMap);
    }

    public void beforeEach(TestData testData) {
        BeforeAndAfterEach.class.beforeEach((BeforeAndAfterEach)this, (TestData)testData);
    }

    public void afterEach(ConfigMap configMap) {
        BeforeAndAfterEach.class.afterEach((BeforeAndAfterEach)this, (ConfigMap)configMap);
    }

    public void afterEach(TestData testData) {
        BeforeAndAfterEach.class.afterEach((BeforeAndAfterEach)this, (TestData)testData);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfterEach.class.runTest((BeforeAndAfterEach)this, (String)testName, (Args)args);
    }

    public Matchers.KeyWord key() {
        return this.key;
    }

    public Matchers.ValueWord value() {
        return this.value;
    }

    public Matchers.AWord a() {
        return this.a;
    }

    public Matchers.AnWord an() {
        return this.an;
    }

    public Matchers.TheSameInstanceAsPhrase theSameInstanceAs() {
        return this.theSameInstanceAs;
    }

    public Matchers.RegexWord regex() {
        return this.regex;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Matchers$AllCollected$ org$scalatest$Matchers$$AllCollected$lzycompute() {
        YarnAllocatorSuite yarnAllocatorSuite = this;
        synchronized (yarnAllocatorSuite) {
            if (this.org$scalatest$Matchers$$AllCollected$module != null) return this.org$scalatest$Matchers$$AllCollected$module;
            this.org$scalatest$Matchers$$AllCollected$module = new Matchers$AllCollected$((Matchers)this);
            return this.org$scalatest$Matchers$$AllCollected$module;
        }
    }

    public final Matchers$AllCollected$ org$scalatest$Matchers$$AllCollected() {
        return this.org$scalatest$Matchers$$AllCollected$module == null ? this.org$scalatest$Matchers$$AllCollected$lzycompute() : this.org$scalatest$Matchers$$AllCollected$module;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Matchers$EveryCollected$ org$scalatest$Matchers$$EveryCollected$lzycompute() {
        YarnAllocatorSuite yarnAllocatorSuite = this;
        synchronized (yarnAllocatorSuite) {
            if (this.org$scalatest$Matchers$$EveryCollected$module != null) return this.org$scalatest$Matchers$$EveryCollected$module;
            this.org$scalatest$Matchers$$EveryCollected$module = new Matchers$EveryCollected$((Matchers)this);
            return this.org$scalatest$Matchers$$EveryCollected$module;
        }
    }

    public final Matchers$EveryCollected$ org$scalatest$Matchers$$EveryCollected() {
        return this.org$scalatest$Matchers$$EveryCollected$module == null ? this.org$scalatest$Matchers$$EveryCollected$lzycompute() : this.org$scalatest$Matchers$$EveryCollected$module;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Matchers$BetweenCollected$ org$scalatest$Matchers$$BetweenCollected$lzycompute() {
        YarnAllocatorSuite yarnAllocatorSuite = this;
        synchronized (yarnAllocatorSuite) {
            if (this.org$scalatest$Matchers$$BetweenCollected$module != null) return this.org$scalatest$Matchers$$BetweenCollected$module;
            this.org$scalatest$Matchers$$BetweenCollected$module = new Matchers$BetweenCollected$((Matchers)this);
            return this.org$scalatest$Matchers$$BetweenCollected$module;
        }
    }

    public final Matchers$BetweenCollected$ org$scalatest$Matchers$$BetweenCollected() {
        return this.org$scalatest$Matchers$$BetweenCollected$module == null ? this.org$scalatest$Matchers$$BetweenCollected$lzycompute() : this.org$scalatest$Matchers$$BetweenCollected$module;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Matchers$AtLeastCollected$ org$scalatest$Matchers$$AtLeastCollected$lzycompute() {
        YarnAllocatorSuite yarnAllocatorSuite = this;
        synchronized (yarnAllocatorSuite) {
            if (this.org$scalatest$Matchers$$AtLeastCollected$module != null) return this.org$scalatest$Matchers$$AtLeastCollected$module;
            this.org$scalatest$Matchers$$AtLeastCollected$module = new Matchers$AtLeastCollected$((Matchers)this);
            return this.org$scalatest$Matchers$$AtLeastCollected$module;
        }
    }

    public final Matchers$AtLeastCollected$ org$scalatest$Matchers$$AtLeastCollected() {
        return this.org$scalatest$Matchers$$AtLeastCollected$module == null ? this.org$scalatest$Matchers$$AtLeastCollected$lzycompute() : this.org$scalatest$Matchers$$AtLeastCollected$module;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Matchers$AtMostCollected$ org$scalatest$Matchers$$AtMostCollected$lzycompute() {
        YarnAllocatorSuite yarnAllocatorSuite = this;
        synchronized (yarnAllocatorSuite) {
            if (this.org$scalatest$Matchers$$AtMostCollected$module != null) return this.org$scalatest$Matchers$$AtMostCollected$module;
            this.org$scalatest$Matchers$$AtMostCollected$module = new Matchers$AtMostCollected$((Matchers)this);
            return this.org$scalatest$Matchers$$AtMostCollected$module;
        }
    }

    public final Matchers$AtMostCollected$ org$scalatest$Matchers$$AtMostCollected() {
        return this.org$scalatest$Matchers$$AtMostCollected$module == null ? this.org$scalatest$Matchers$$AtMostCollected$lzycompute() : this.org$scalatest$Matchers$$AtMostCollected$module;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Matchers$NoCollected$ org$scalatest$Matchers$$NoCollected$lzycompute() {
        YarnAllocatorSuite yarnAllocatorSuite = this;
        synchronized (yarnAllocatorSuite) {
            if (this.org$scalatest$Matchers$$NoCollected$module != null) return this.org$scalatest$Matchers$$NoCollected$module;
            this.org$scalatest$Matchers$$NoCollected$module = new Matchers$NoCollected$((Matchers)this);
            return this.org$scalatest$Matchers$$NoCollected$module;
        }
    }

    public final Matchers$NoCollected$ org$scalatest$Matchers$$NoCollected() {
        return this.org$scalatest$Matchers$$NoCollected$module == null ? this.org$scalatest$Matchers$$NoCollected$lzycompute() : this.org$scalatest$Matchers$$NoCollected$module;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Matchers$ExactlyCollected$ org$scalatest$Matchers$$ExactlyCollected$lzycompute() {
        YarnAllocatorSuite yarnAllocatorSuite = this;
        synchronized (yarnAllocatorSuite) {
            if (this.org$scalatest$Matchers$$ExactlyCollected$module != null) return this.org$scalatest$Matchers$$ExactlyCollected$module;
            this.org$scalatest$Matchers$$ExactlyCollected$module = new Matchers$ExactlyCollected$((Matchers)this);
            return this.org$scalatest$Matchers$$ExactlyCollected$module;
        }
    }

    public final Matchers$ExactlyCollected$ org$scalatest$Matchers$$ExactlyCollected() {
        return this.org$scalatest$Matchers$$ExactlyCollected$module == null ? this.org$scalatest$Matchers$$ExactlyCollected$lzycompute() : this.org$scalatest$Matchers$$ExactlyCollected$module;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Matchers$ShouldMethodHelper$ org$scalatest$Matchers$$ShouldMethodHelper$lzycompute() {
        YarnAllocatorSuite yarnAllocatorSuite = this;
        synchronized (yarnAllocatorSuite) {
            if (this.org$scalatest$Matchers$$ShouldMethodHelper$module != null) return this.org$scalatest$Matchers$$ShouldMethodHelper$module;
            this.org$scalatest$Matchers$$ShouldMethodHelper$module = new Matchers$ShouldMethodHelper$((Matchers)this);
            return this.org$scalatest$Matchers$$ShouldMethodHelper$module;
        }
    }

    public final Matchers$ShouldMethodHelper$ org$scalatest$Matchers$$ShouldMethodHelper() {
        return this.org$scalatest$Matchers$$ShouldMethodHelper$module == null ? this.org$scalatest$Matchers$$ShouldMethodHelper$lzycompute() : this.org$scalatest$Matchers$$ShouldMethodHelper$module;
    }

    public void org$scalatest$Matchers$_setter_$key_$eq(Matchers.KeyWord x$1) {
        this.key = x$1;
    }

    public void org$scalatest$Matchers$_setter_$value_$eq(Matchers.ValueWord x$1) {
        this.value = x$1;
    }

    public void org$scalatest$Matchers$_setter_$a_$eq(Matchers.AWord x$1) {
        this.a = x$1;
    }

    public void org$scalatest$Matchers$_setter_$an_$eq(Matchers.AnWord x$1) {
        this.an = x$1;
    }

    public void org$scalatest$Matchers$_setter_$theSameInstanceAs_$eq(Matchers.TheSameInstanceAsPhrase x$1) {
        this.theSameInstanceAs = x$1;
    }

    public void org$scalatest$Matchers$_setter_$regex_$eq(Matchers.RegexWord x$1) {
        this.regex = x$1;
    }

    public Matchers.HavePropertyMatcherGenerator convertSymbolToHavePropertyMatcherGenerator(Symbol symbol) {
        return Matchers.class.convertSymbolToHavePropertyMatcherGenerator((Matchers)this, (Symbol)symbol);
    }

    public <T> Matcher<T> equal(TripleEqualsSupport.Spread<T> spread) {
        return Matchers.class.equal((Matchers)this, spread);
    }

    public Matcher<Object> equal(Null$ o) {
        return Matchers.class.equal((Matchers)this, (Null$)o);
    }

    public <T> ResultOfLessThanComparison<T> $less(T right, Ordering<T> evidence$1) {
        return Matchers.class.$less((Matchers)this, right, evidence$1);
    }

    public <T> ResultOfGreaterThanComparison<T> $greater(T right, Ordering<T> evidence$2) {
        return Matchers.class.$greater((Matchers)this, right, evidence$2);
    }

    public <T> ResultOfLessThanOrEqualToComparison<T> $less$eq(T right, Ordering<T> evidence$3) {
        return Matchers.class.$less$eq((Matchers)this, right, evidence$3);
    }

    public <T> ResultOfGreaterThanOrEqualToComparison<T> $greater$eq(T right, Ordering<T> evidence$4) {
        return Matchers.class.$greater$eq((Matchers)this, right, evidence$4);
    }

    public <T> ResultOfDefinedAt<T> definedAt(T right) {
        return Matchers.class.definedAt((Matchers)this, right);
    }

    public Matchers.ResultOfEvaluatingApplication evaluating(Function0<Object> fun) {
        return Matchers.class.evaluating((Matchers)this, fun);
    }

    public <T> Matchers.ResultOfProduceInvocation<T> produce(Manifest<T> evidence$5) {
        return Matchers.class.produce((Matchers)this, evidence$5);
    }

    public ResultOfOneOfApplication oneOf(Object firstEle, Object secondEle, Seq<Object> remainingEles) {
        return Matchers.class.oneOf((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles);
    }

    public ResultOfAtLeastOneOfApplication atLeastOneOf(Object firstEle, Object secondEle, Seq<Object> remainingEles) {
        return Matchers.class.atLeastOneOf((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles);
    }

    public ResultOfNoneOfApplication noneOf(Object firstEle, Object secondEle, Seq<Object> remainingEles) {
        return Matchers.class.noneOf((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles);
    }

    public ResultOfTheSameElementsAsApplication theSameElementsAs(GenTraversable<?> xs) {
        return Matchers.class.theSameElementsAs((Matchers)this, xs);
    }

    public ResultOfTheSameElementsInOrderAsApplication theSameElementsInOrderAs(GenTraversable<?> xs) {
        return Matchers.class.theSameElementsInOrderAs((Matchers)this, xs);
    }

    public ResultOfOnlyApplication only(Seq<Object> xs) {
        return Matchers.class.only((Matchers)this, xs);
    }

    public <T> ResultOfInOrderOnlyApplication inOrderOnly(Object firstEle, Object secondEle, Seq<Object> remainingEles) {
        return Matchers.class.inOrderOnly((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles);
    }

    public ResultOfAllOfApplication allOf(Object firstEle, Object secondEle, Seq<Object> remainingEles) {
        return Matchers.class.allOf((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles);
    }

    public ResultOfInOrderApplication inOrder(Object firstEle, Object secondEle, Seq<Object> remainingEles) {
        return Matchers.class.inOrder((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles);
    }

    public ResultOfAtMostOneOfApplication atMostOneOf(Object firstEle, Object secondEle, Seq<Object> remainingEles) {
        return Matchers.class.atMostOneOf((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles);
    }

    public ResultOfThrownByApplication thrownBy(Function0<Object> fun) {
        return Matchers.class.thrownBy((Matchers)this, fun);
    }

    public ResultOfMessageWordApplication message(String expectedMessage) {
        return Matchers.class.message((Matchers)this, (String)expectedMessage);
    }

    public <T> void doCollected(Matchers.Collected collected, GenTraversable<T> xs, Object original, String methodName, int stackDepth, Function1<T, BoxedUnit> fun) {
        Matchers.class.doCollected((Matchers)this, (Matchers.Collected)collected, xs, (Object)original, (String)methodName, (int)stackDepth, fun);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> all(C xs, Collecting<E, C> collecting) {
        return Matchers.class.all((Matchers)this, xs, collecting);
    }

    public <K, V, JMAP extends Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> all(JMAP xs, Collecting<Entry<K, V>, JMAP> collecting) {
        return Matchers.class.all((Matchers)this, xs, collecting);
    }

    public Matchers.ResultOfCollectedAny<Object> all(String xs, Collecting<Object, String> collecting) {
        return Matchers.class.all((Matchers)this, (String)xs, collecting);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> atLeast(int num, C xs, Collecting<E, C> collecting) {
        return Matchers.class.atLeast((Matchers)this, (int)num, xs, collecting);
    }

    public <K, V, JMAP extends Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> atLeast(int num, JMAP xs, Collecting<Entry<K, V>, JMAP> collecting) {
        return Matchers.class.atLeast((Matchers)this, (int)num, xs, collecting);
    }

    public Matchers.ResultOfCollectedAny<Object> atLeast(int num, String xs, Collecting<Object, String> collecting) {
        return Matchers.class.atLeast((Matchers)this, (int)num, (String)xs, collecting);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> every(C xs, Collecting<E, C> collecting) {
        return Matchers.class.every((Matchers)this, xs, collecting);
    }

    public <K, V, JMAP extends Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> every(JMAP xs, Collecting<Entry<K, V>, JMAP> collecting) {
        return Matchers.class.every((Matchers)this, xs, collecting);
    }

    public Matchers.ResultOfCollectedAny<Object> every(String xs, Collecting<Object, String> collecting) {
        return Matchers.class.every((Matchers)this, (String)xs, collecting);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> exactly(int num, C xs, Collecting<E, C> collecting) {
        return Matchers.class.exactly((Matchers)this, (int)num, xs, collecting);
    }

    public <K, V, JMAP extends Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> exactly(int num, JMAP xs, Collecting<Entry<K, V>, JMAP> collecting) {
        return Matchers.class.exactly((Matchers)this, (int)num, xs, collecting);
    }

    public Matchers.ResultOfCollectedAny<Object> exactly(int num, String xs, Collecting<Object, String> collecting) {
        return Matchers.class.exactly((Matchers)this, (int)num, (String)xs, collecting);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> no(C xs, Collecting<E, C> collecting) {
        return Matchers.class.no((Matchers)this, xs, collecting);
    }

    public <K, V, JMAP extends Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> no(JMAP xs, Collecting<Entry<K, V>, JMAP> collecting) {
        return Matchers.class.no((Matchers)this, xs, collecting);
    }

    public Matchers.ResultOfCollectedAny<Object> no(String xs, Collecting<Object, String> collecting) {
        return Matchers.class.no((Matchers)this, (String)xs, collecting);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> between(int from, int upTo, C xs, Collecting<E, C> collecting) {
        return Matchers.class.between((Matchers)this, (int)from, (int)upTo, xs, collecting);
    }

    public <K, V, JMAP extends Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> between(int from, int upTo, JMAP xs, Collecting<Entry<K, V>, JMAP> collecting) {
        return Matchers.class.between((Matchers)this, (int)from, (int)upTo, xs, collecting);
    }

    public Matchers.ResultOfCollectedAny<Object> between(int from, int upTo, String xs, Collecting<Object, String> collecting) {
        return Matchers.class.between((Matchers)this, (int)from, (int)upTo, (String)xs, collecting);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> atMost(int num, C xs, Collecting<E, C> collecting) {
        return Matchers.class.atMost((Matchers)this, (int)num, xs, collecting);
    }

    public <K, V, JMAP extends Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> atMost(int num, JMAP xs, Collecting<Entry<K, V>, JMAP> collecting) {
        return Matchers.class.atMost((Matchers)this, (int)num, xs, collecting);
    }

    public Matchers.ResultOfCollectedAny<Object> atMost(int num, String xs, Collecting<Object, String> collecting) {
        return Matchers.class.atMost((Matchers)this, (int)num, (String)xs, collecting);
    }

    public <T> ResultOfATypeInvocation<T> a(Manifest<T> evidence$6) {
        return Matchers.class.a((Matchers)this, evidence$6);
    }

    public <T> ResultOfAnTypeInvocation<T> an(Manifest<T> evidence$7) {
        return Matchers.class.an((Matchers)this, evidence$7);
    }

    public <T> ResultOfTheTypeInvocation<T> the(Manifest<T> evidence$8) {
        return Matchers.class.the((Matchers)this, evidence$8);
    }

    public <T> Matchers.AnyShouldWrapper<T> convertToAnyShouldWrapper(T o) {
        return Matchers.class.convertToAnyShouldWrapper((Matchers)this, o);
    }

    public Matchers.StringShouldWrapper convertToStringShouldWrapper(String o) {
        return Matchers.class.convertToStringShouldWrapper((Matchers)this, (String)o);
    }

    public Matchers.RegexWrapper convertToRegexWrapper(Regex o) {
        return Matchers.class.convertToRegexWrapper((Matchers)this, (Regex)o);
    }

    public <T> ResultOfOfTypeInvocation<T> of(Manifest<T> ev) {
        return Matchers.class.of((Matchers)this, ev);
    }

    public Explicitly.DecidedWord decided() {
        return this.decided;
    }

    public Explicitly.DeterminedWord determined() {
        return this.determined;
    }

    public Explicitly.TheAfterWord after() {
        return this.after;
    }

    public void org$scalactic$Explicitly$_setter_$decided_$eq(Explicitly.DecidedWord x$1) {
        this.decided = x$1;
    }

    public void org$scalactic$Explicitly$_setter_$determined_$eq(Explicitly.DeterminedWord x$1) {
        this.determined = x$1;
    }

    public void org$scalactic$Explicitly$_setter_$after_$eq(Explicitly.TheAfterWord x$1) {
        this.after = x$1;
    }

    public FullyMatchWord fullyMatch() {
        return this.fullyMatch;
    }

    public StartWithWord startWith() {
        return this.startWith;
    }

    public EndWithWord endWith() {
        return this.endWith;
    }

    public IncludeWord include() {
        return this.include;
    }

    public HaveWord have() {
        return this.have;
    }

    public BeWord be() {
        return this.be;
    }

    public ContainWord contain() {
        return this.contain;
    }

    public NotWord not() {
        return this.not;
    }

    public LengthWord length() {
        return this.length;
    }

    public SizeWord size() {
        return this.size;
    }

    public SortedWord sorted() {
        return this.sorted;
    }

    public DefinedWord defined() {
        return this.defined;
    }

    public NoExceptionWord noException() {
        return this.noException;
    }

    public ExistWord exist() {
        return this.exist;
    }

    public ReadableWord readable() {
        return this.readable;
    }

    public WritableWord writable() {
        return this.writable;
    }

    public EmptyWord empty() {
        return this.empty;
    }

    public CompileWord compile() {
        return this.compile;
    }

    public TypeCheckWord typeCheck() {
        return this.typeCheck;
    }

    public MatchPatternWord matchPattern() {
        return this.matchPattern;
    }

    public void org$scalatest$words$MatcherWords$_setter_$fullyMatch_$eq(FullyMatchWord x$1) {
        this.fullyMatch = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$startWith_$eq(StartWithWord x$1) {
        this.startWith = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$endWith_$eq(EndWithWord x$1) {
        this.endWith = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$include_$eq(IncludeWord x$1) {
        this.include = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$have_$eq(HaveWord x$1) {
        this.have = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$be_$eq(BeWord x$1) {
        this.be = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$contain_$eq(ContainWord x$1) {
        this.contain = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$not_$eq(NotWord x$1) {
        this.not = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$length_$eq(LengthWord x$1) {
        this.length = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$size_$eq(SizeWord x$1) {
        this.size = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$sorted_$eq(SortedWord x$1) {
        this.sorted = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$defined_$eq(DefinedWord x$1) {
        this.defined = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$noException_$eq(NoExceptionWord x$1) {
        this.noException = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$exist_$eq(ExistWord x$1) {
        this.exist = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$readable_$eq(ReadableWord x$1) {
        this.readable = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$writable_$eq(WritableWord x$1) {
        this.writable = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$empty_$eq(EmptyWord x$1) {
        this.empty = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$compile_$eq(CompileWord x$1) {
        this.compile = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$typeCheck_$eq(TypeCheckWord x$1) {
        this.typeCheck = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$matchPattern_$eq(MatchPatternWord x$1) {
        this.matchPattern = x$1;
    }

    public MatcherFactory1<Object, Equality> equal(Object right) {
        return MatcherWords.class.equal((MatcherWords)this, (Object)right);
    }

    public <T> Tolerance.PlusOrMinusWrapper<T> convertNumericToPlusOrMinusWrapper(T pivot, Numeric<T> evidence$2) {
        return Tolerance.class.convertNumericToPlusOrMinusWrapper((Tolerance)this, pivot, evidence$2);
    }

    public YarnConfiguration conf() {
        return this.conf;
    }

    public SparkConf sparkConf() {
        return this.sparkConf;
    }

    public ApplicationAttemptId appAttemptId() {
        return this.appAttemptId;
    }

    public Resource containerResource() {
        return this.containerResource;
    }

    public AMRMClient<AMRMClient.ContainerRequest> rmClient() {
        return this.rmClient;
    }

    public void rmClient_$eq(AMRMClient<AMRMClient.ContainerRequest> x$1) {
        this.rmClient = x$1;
    }

    public int containerNum() {
        return this.containerNum;
    }

    public void containerNum_$eq(int x$1) {
        this.containerNum = x$1;
    }

    public void beforeEach() {
        BeforeAndAfterEach.class.beforeEach((BeforeAndAfterEach)this);
        this.rmClient_$eq((AMRMClient<AMRMClient.ContainerRequest>)AMRMClient.createAMRMClient());
        this.rmClient().init((Configuration)this.conf());
        this.rmClient().start();
    }

    public void afterEach() {
        try {
            this.rmClient().stop();
            return;
        }
        finally {
            BeforeAndAfterEach.class.afterEach((BeforeAndAfterEach)this);
        }
    }

    public YarnAllocator createAllocator(int maxExecutors) {
        String[] args = (String[])((Object[])new String[]{"--jar", "somejar.jar", "--class", "SomeClass"});
        SparkConf sparkConfClone = this.sparkConf().clone();
        sparkConfClone.set("spark.executor.instances", ((Object)BoxesRunTime.boxToInteger((int)maxExecutors)).toString()).set("spark.executor.cores", "5").set("spark.executor.memory", "2048");
        return new YarnAllocator("not used", (RpcEndpointRef)Mockito.mock(RpcEndpointRef.class), this.conf(), sparkConfClone, this.rmClient(), this.appAttemptId(), new SecurityManager(this.sparkConf(), SecurityManager$.MODULE$.$lessinit$greater$default$2()), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (SparkRackResolver)new MockResolver());
    }

    public int createAllocator$default$1() {
        return 5;
    }

    public Container createContainer(String host) {
        ContainerId containerId = ContainerId.newInstance((ApplicationAttemptId)this.appAttemptId(), (int)this.containerNum());
        this.containerNum_$eq(this.containerNum() + 1);
        NodeId nodeId = NodeId.newInstance((String)host, (int)1000);
        return Container.newInstance((ContainerId)containerId, (NodeId)nodeId, (String)"", (Resource)this.containerResource(), (Priority)YarnSparkHadoopUtil$.MODULE$.RM_REQUEST_PRIORITY(), null);
    }

    public YarnAllocatorSuite() {
        Tolerance.class.$init$((Tolerance)this);
        ShouldVerb.class.$init$((ShouldVerb)this);
        MatcherWords.class.$init$((MatcherWords)this);
        Explicitly.class.$init$((Explicitly)this);
        Matchers.class.$init$((Matchers)this);
        BeforeAndAfterEach.class.$init$((BeforeAndAfterEach)this);
        this.conf = new YarnConfiguration();
        this.sparkConf = new SparkConf();
        this.sparkConf().set("spark.driver.host", "localhost");
        this.sparkConf().set("spark.driver.port", "4040");
        this.sparkConf().set(package$.MODULE$.SPARK_JARS(), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"notarealjar.jar"})));
        this.sparkConf().set("spark.yarn.launchContainers", "false");
        this.appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)0), (int)0);
        this.containerResource = Resource.newInstance((int)3072, (int)6);
        this.containerNum = 0;
        this.test("single container allocated", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ YarnAllocatorSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                YarnAllocator handler = this.$outer.createAllocator(1);
                handler.updateResourceRequests();
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)handler.getNumExecutorsRunning())).should(this.$outer.be().apply((Object)BoxesRunTime.boxToInteger((int)0)));
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)handler.getPendingAllocate().size())).should(this.$outer.be().apply((Object)BoxesRunTime.boxToInteger((int)1)));
                Container container = this.$outer.createContainer("host1");
                handler.handleAllocatedContainers((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Container[]{container}));
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)handler.getNumExecutorsRunning())).should(this.$outer.be().apply((Object)BoxesRunTime.boxToInteger((int)1)));
                this.$outer.convertToStringShouldWrapper((String)handler.allocatedContainerToHostMap().get((Object)container.getId()).get()).should(this.$outer.be().apply((Object)"host1"));
                this.$outer.convertToAnyShouldWrapper(handler.allocatedHostToContainersMap().get((Object)"host1").get()).should(this.$outer.contain().apply((Object)container.getId()), (Object)Containing$.MODULE$.containingNatureOfGenTraversable(Equality$.MODULE$.default()));
                int size = this.$outer.rmClient().getMatchingRequests(container.getPriority(), "host1", this.$outer.containerResource()).size();
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)size)).should(this.$outer.be().apply((Object)BoxesRunTime.boxToInteger((int)0)));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("container should not be created if requested number if met", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ YarnAllocatorSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                YarnAllocator handler = this.$outer.createAllocator(1);
                handler.updateResourceRequests();
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)handler.getNumExecutorsRunning())).should(this.$outer.be().apply((Object)BoxesRunTime.boxToInteger((int)0)));
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)handler.getPendingAllocate().size())).should(this.$outer.be().apply((Object)BoxesRunTime.boxToInteger((int)1)));
                Container container = this.$outer.createContainer("host1");
                handler.handleAllocatedContainers((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Container[]{container}));
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)handler.getNumExecutorsRunning())).should(this.$outer.be().apply((Object)BoxesRunTime.boxToInteger((int)1)));
                this.$outer.convertToStringShouldWrapper((String)handler.allocatedContainerToHostMap().get((Object)container.getId()).get()).should(this.$outer.be().apply((Object)"host1"));
                this.$outer.convertToAnyShouldWrapper(handler.allocatedHostToContainersMap().get((Object)"host1").get()).should(this.$outer.contain().apply((Object)container.getId()), (Object)Containing$.MODULE$.containingNatureOfGenTraversable(Equality$.MODULE$.default()));
                Container container2 = this.$outer.createContainer("host2");
                handler.handleAllocatedContainers((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Container[]{container2}));
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)handler.getNumExecutorsRunning())).should(this.$outer.be().apply((Object)BoxesRunTime.boxToInteger((int)1)));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("some containers allocated", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ YarnAllocatorSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                YarnAllocator handler = this.$outer.createAllocator(4);
                handler.updateResourceRequests();
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)handler.getNumExecutorsRunning())).should(this.$outer.be().apply((Object)BoxesRunTime.boxToInteger((int)0)));
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)handler.getPendingAllocate().size())).should(this.$outer.be().apply((Object)BoxesRunTime.boxToInteger((int)4)));
                Container container1 = this.$outer.createContainer("host1");
                Container container2 = this.$outer.createContainer("host1");
                Container container3 = this.$outer.createContainer("host2");
                handler.handleAllocatedContainers((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Container[]{container1, container2, container3}));
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)handler.getNumExecutorsRunning())).should(this.$outer.be().apply((Object)BoxesRunTime.boxToInteger((int)3)));
                this.$outer.convertToStringShouldWrapper((String)handler.allocatedContainerToHostMap().get((Object)container1.getId()).get()).should(this.$outer.be().apply((Object)"host1"));
                this.$outer.convertToStringShouldWrapper((String)handler.allocatedContainerToHostMap().get((Object)container2.getId()).get()).should(this.$outer.be().apply((Object)"host1"));
                this.$outer.convertToStringShouldWrapper((String)handler.allocatedContainerToHostMap().get((Object)container3.getId()).get()).should(this.$outer.be().apply((Object)"host2"));
                this.$outer.convertToAnyShouldWrapper(handler.allocatedHostToContainersMap().get((Object)"host1").get()).should(this.$outer.contain().apply((Object)container1.getId()), (Object)Containing$.MODULE$.containingNatureOfGenTraversable(Equality$.MODULE$.default()));
                this.$outer.convertToAnyShouldWrapper(handler.allocatedHostToContainersMap().get((Object)"host1").get()).should(this.$outer.contain().apply((Object)container2.getId()), (Object)Containing$.MODULE$.containingNatureOfGenTraversable(Equality$.MODULE$.default()));
                this.$outer.convertToAnyShouldWrapper(handler.allocatedHostToContainersMap().get((Object)"host2").get()).should(this.$outer.contain().apply((Object)container3.getId()), (Object)Containing$.MODULE$.containingNatureOfGenTraversable(Equality$.MODULE$.default()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("receive more containers than requested", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ YarnAllocatorSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                YarnAllocator handler = this.$outer.createAllocator(2);
                handler.updateResourceRequests();
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)handler.getNumExecutorsRunning())).should(this.$outer.be().apply((Object)BoxesRunTime.boxToInteger((int)0)));
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)handler.getPendingAllocate().size())).should(this.$outer.be().apply((Object)BoxesRunTime.boxToInteger((int)2)));
                Container container1 = this.$outer.createContainer("host1");
                Container container2 = this.$outer.createContainer("host2");
                Container container3 = this.$outer.createContainer("host4");
                handler.handleAllocatedContainers((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Container[]{container1, container2, container3}));
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)handler.getNumExecutorsRunning())).should(this.$outer.be().apply((Object)BoxesRunTime.boxToInteger((int)2)));
                this.$outer.convertToStringShouldWrapper((String)handler.allocatedContainerToHostMap().get((Object)container1.getId()).get()).should(this.$outer.be().apply((Object)"host1"));
                this.$outer.convertToStringShouldWrapper((String)handler.allocatedContainerToHostMap().get((Object)container2.getId()).get()).should(this.$outer.be().apply((Object)"host2"));
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)handler.allocatedContainerToHostMap().contains((Object)container3.getId()))).should(this.$outer.be().apply(false));
                this.$outer.convertToAnyShouldWrapper(handler.allocatedHostToContainersMap().get((Object)"host1").get()).should(this.$outer.contain().apply((Object)container1.getId()), (Object)Containing$.MODULE$.containingNatureOfGenTraversable(Equality$.MODULE$.default()));
                this.$outer.convertToAnyShouldWrapper(handler.allocatedHostToContainersMap().get((Object)"host2").get()).should(this.$outer.contain().apply((Object)container2.getId()), (Object)Containing$.MODULE$.containingNatureOfGenTraversable(Equality$.MODULE$.default()));
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)handler.allocatedHostToContainersMap().contains((Object)"host4"))).should(this.$outer.be().apply(false));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("decrease total requested executors", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ YarnAllocatorSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                YarnAllocator handler = this.$outer.createAllocator(4);
                handler.updateResourceRequests();
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)handler.getNumExecutorsRunning())).should(this.$outer.be().apply((Object)BoxesRunTime.boxToInteger((int)0)));
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)handler.getPendingAllocate().size())).should(this.$outer.be().apply((Object)BoxesRunTime.boxToInteger((int)4)));
                handler.requestTotalExecutorsWithPreferredLocalities(3, 0, Predef$.MODULE$.Map().empty());
                handler.updateResourceRequests();
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)handler.getPendingAllocate().size())).should(this.$outer.be().apply((Object)BoxesRunTime.boxToInteger((int)3)));
                Container container = this.$outer.createContainer("host1");
                handler.handleAllocatedContainers((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Container[]{container}));
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)handler.getNumExecutorsRunning())).should(this.$outer.be().apply((Object)BoxesRunTime.boxToInteger((int)1)));
                this.$outer.convertToStringShouldWrapper((String)handler.allocatedContainerToHostMap().get((Object)container.getId()).get()).should(this.$outer.be().apply((Object)"host1"));
                this.$outer.convertToAnyShouldWrapper(handler.allocatedHostToContainersMap().get((Object)"host1").get()).should(this.$outer.contain().apply((Object)container.getId()), (Object)Containing$.MODULE$.containingNatureOfGenTraversable(Equality$.MODULE$.default()));
                handler.requestTotalExecutorsWithPreferredLocalities(2, 0, Predef$.MODULE$.Map().empty());
                handler.updateResourceRequests();
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)handler.getPendingAllocate().size())).should(this.$outer.be().apply((Object)BoxesRunTime.boxToInteger((int)1)));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("decrease total requested executors to less than currently running", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ YarnAllocatorSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                YarnAllocator handler = this.$outer.createAllocator(4);
                handler.updateResourceRequests();
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)handler.getNumExecutorsRunning())).should(this.$outer.be().apply((Object)BoxesRunTime.boxToInteger((int)0)));
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)handler.getPendingAllocate().size())).should(this.$outer.be().apply((Object)BoxesRunTime.boxToInteger((int)4)));
                handler.requestTotalExecutorsWithPreferredLocalities(3, 0, Predef$.MODULE$.Map().empty());
                handler.updateResourceRequests();
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)handler.getPendingAllocate().size())).should(this.$outer.be().apply((Object)BoxesRunTime.boxToInteger((int)3)));
                Container container1 = this.$outer.createContainer("host1");
                Container container2 = this.$outer.createContainer("host2");
                handler.handleAllocatedContainers((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Container[]{container1, container2}));
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)handler.getNumExecutorsRunning())).should(this.$outer.be().apply((Object)BoxesRunTime.boxToInteger((int)2)));
                handler.requestTotalExecutorsWithPreferredLocalities(1, 0, Predef$.MODULE$.Map().empty());
                handler.updateResourceRequests();
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)handler.getPendingAllocate().size())).should(this.$outer.be().apply((Object)BoxesRunTime.boxToInteger((int)0)));
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)handler.getNumExecutorsRunning())).should(this.$outer.be().apply((Object)BoxesRunTime.boxToInteger((int)2)));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("kill executors", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ YarnAllocatorSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                YarnAllocator handler = this.$outer.createAllocator(4);
                handler.updateResourceRequests();
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)handler.getNumExecutorsRunning())).should(this.$outer.be().apply((Object)BoxesRunTime.boxToInteger((int)0)));
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)handler.getPendingAllocate().size())).should(this.$outer.be().apply((Object)BoxesRunTime.boxToInteger((int)4)));
                Container container1 = this.$outer.createContainer("host1");
                Container container2 = this.$outer.createContainer("host2");
                handler.handleAllocatedContainers((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Container[]{container1, container2}));
                handler.requestTotalExecutorsWithPreferredLocalities(1, 0, Predef$.MODULE$.Map().empty());
                handler.executorIdToContainer().keys().foreach((Function1)new Serializable(this, handler){
                    public static final long serialVersionUID = 0L;
                    private final YarnAllocator handler$1;

                    public final void apply(String id) {
                        this.handler$1.killExecutor(id);
                    }
                    {
                        this.handler$1 = handler$1;
                    }
                });
                Seq statuses = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Container[]{container1, container2}))).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ContainerStatus apply(Container c) {
                        return ContainerStatus.newInstance((ContainerId)c.getId(), (ContainerState)ContainerState.COMPLETE, (String)"Finished", (int)0);
                    }
                }, Seq$.MODULE$.canBuildFrom());
                handler.updateResourceRequests();
                handler.processCompletedContainers(statuses.toSeq());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)handler.getNumExecutorsRunning())).should(this.$outer.be().apply((Object)BoxesRunTime.boxToInteger((int)0)));
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)handler.getPendingAllocate().size())).should(this.$outer.be().apply((Object)BoxesRunTime.boxToInteger((int)1)));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("lost executor removed from backend", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ YarnAllocatorSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                YarnAllocator handler = this.$outer.createAllocator(4);
                handler.updateResourceRequests();
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)handler.getNumExecutorsRunning())).should(this.$outer.be().apply((Object)BoxesRunTime.boxToInteger((int)0)));
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)handler.getPendingAllocate().size())).should(this.$outer.be().apply((Object)BoxesRunTime.boxToInteger((int)4)));
                Container container1 = this.$outer.createContainer("host1");
                Container container2 = this.$outer.createContainer("host2");
                handler.handleAllocatedContainers((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Container[]{container1, container2}));
                handler.requestTotalExecutorsWithPreferredLocalities(2, 0, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$));
                Seq statuses = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Container[]{container1, container2}))).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ContainerStatus apply(Container c) {
                        return ContainerStatus.newInstance((ContainerId)c.getId(), (ContainerState)ContainerState.COMPLETE, (String)"Failed", (int)-1);
                    }
                }, Seq$.MODULE$.canBuildFrom());
                handler.updateResourceRequests();
                handler.processCompletedContainers(statuses.toSeq());
                handler.updateResourceRequests();
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)handler.getNumExecutorsRunning())).should(this.$outer.be().apply((Object)BoxesRunTime.boxToInteger((int)0)));
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)handler.getPendingAllocate().size())).should(this.$outer.be().apply((Object)BoxesRunTime.boxToInteger((int)2)));
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)handler.getNumExecutorsFailed())).should(this.$outer.be().apply((Object)BoxesRunTime.boxToInteger((int)2)));
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)handler.getNumUnexpectedContainerRelease())).should(this.$outer.be().apply((Object)BoxesRunTime.boxToInteger((int)2)));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("memory exceeded diagnostic regexes", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ YarnAllocatorSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String diagnostics = "Container [pid=12465,containerID=container_1412887393566_0003_01_000002] is running beyond physical memory limits. Current usage: 2.1 MB of 2 GB physical memory used; 5.8 GB of 4.2 GB virtual memory used. Killing container.";
                String vmemMsg = YarnAllocator$.MODULE$.memLimitExceededLogMessage(diagnostics, YarnAllocator$.MODULE$.VMEM_EXCEEDED_PATTERN());
                String pmemMsg = YarnAllocator$.MODULE$.memLimitExceededLogMessage(diagnostics, YarnAllocator$.MODULE$.PMEM_EXCEEDED_PATTERN());
                String $org_scalatest_assert_macro_left = vmemMsg;
                String $org_scalatest_assert_macro_right = "5.8 GB of 4.2 GB virtual memory used.";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                String $org_scalatest_assert_macro_left2 = pmemMsg;
                String $org_scalatest_assert_macro_right2 = "2.1 MB of 2 GB physical memory used.";
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("window based failure executor counting", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ YarnAllocatorSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.sparkConf().set("spark.yarn.executor.failuresValidityInterval", "100s");
                YarnAllocator handler = this.$outer.createAllocator(4);
                ManualClock clock = new ManualClock(0L);
                handler.setClock((Clock)clock);
                handler.updateResourceRequests();
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)handler.getNumExecutorsRunning())).should(this.$outer.be().apply((Object)BoxesRunTime.boxToInteger((int)0)));
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)handler.getPendingAllocate().size())).should(this.$outer.be().apply((Object)BoxesRunTime.boxToInteger((int)4)));
                Seq containers = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Container[]{this.$outer.createContainer("host1"), this.$outer.createContainer("host2"), this.$outer.createContainer("host3"), this.$outer.createContainer("host4")}));
                handler.handleAllocatedContainers(containers);
                Seq failedStatuses = (Seq)containers.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ContainerStatus apply(Container c) {
                        return ContainerStatus.newInstance((ContainerId)c.getId(), (ContainerState)ContainerState.COMPLETE, (String)"Failed", (int)-1);
                    }
                }, Seq$.MODULE$.canBuildFrom());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)handler.getNumExecutorsFailed())).should(this.$outer.be().apply((Object)BoxesRunTime.boxToInteger((int)0)));
                clock.advance(100000L);
                handler.processCompletedContainers((Seq)failedStatuses.slice(0, 1));
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)handler.getNumExecutorsFailed())).should(this.$outer.be().apply((Object)BoxesRunTime.boxToInteger((int)1)));
                clock.advance(101000L);
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)handler.getNumExecutorsFailed())).should(this.$outer.be().apply((Object)BoxesRunTime.boxToInteger((int)0)));
                handler.processCompletedContainers((Seq)failedStatuses.slice(1, 3));
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)handler.getNumExecutorsFailed())).should(this.$outer.be().apply((Object)BoxesRunTime.boxToInteger((int)2)));
                clock.advance(50000L);
                handler.processCompletedContainers((Seq)failedStatuses.slice(3, 4));
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)handler.getNumExecutorsFailed())).should(this.$outer.be().apply((Object)BoxesRunTime.boxToInteger((int)3)));
                clock.advance(51000L);
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)handler.getNumExecutorsFailed())).should(this.$outer.be().apply((Object)BoxesRunTime.boxToInteger((int)1)));
                clock.advance(50000L);
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)handler.getNumExecutorsFailed())).should(this.$outer.be().apply((Object)BoxesRunTime.boxToInteger((int)0)));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public class MockSplitInfo
    extends SplitInfo {
        public int hashCode() {
            return 0;
        }

        public boolean equals(Object other) {
            return false;
        }

        public /* synthetic */ YarnAllocatorSuite org$apache$spark$deploy$yarn$YarnAllocatorSuite$MockSplitInfo$$$outer() {
            return YarnAllocatorSuite.this;
        }

        public MockSplitInfo(String host) {
            if (YarnAllocatorSuite.this == null) {
                throw null;
            }
            super(null, host, null, 1L, null);
        }
    }
}

