/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.yarn;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.deploy.yarn.LocalityPlacementStrategySuite$;
import org.apache.spark.deploy.yarn.LocalityPreferredContainerPlacementStrategy;
import org.apache.spark.deploy.yarn.MockResolver;
import org.apache.spark.deploy.yarn.SparkRackResolver;
import org.mockito.Mockito;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u00012A!\u0001\u0002\u0001\u001b\tqBj\\2bY&$\u0018\u0010\u00157bG\u0016lWM\u001c;TiJ\fG/Z4z'VLG/\u001a\u0006\u0003\u0007\u0011\tA!_1s]*\u0011QAB\u0001\u0007I\u0016\u0004Hn\\=\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001\u001dA\u0011q\u0002E\u0007\u0002\r%\u0011\u0011C\u0002\u0002\u000e'B\f'o\u001b$v]N+\u0018\u000e^3\t\u000bM\u0001A\u0011\u0001\u000b\u0002\rqJg.\u001b;?)\u0005)\u0002C\u0001\f\u0001\u001b\u0005\u0011\u0001\"\u0002\r\u0001\t\u0013I\u0012a\u0002:v]R+7\u000f\u001e\u000b\u00025A\u00111DH\u0007\u00029)\tQ$A\u0003tG\u0006d\u0017-\u0003\u0002 9\t!QK\\5u\u0001")
public class LocalityPlacementStrategySuite
extends SparkFunSuite {
    public void org$apache$spark$deploy$yarn$LocalityPlacementStrategySuite$$runTest() {
        YarnConfiguration yarnConf = new YarnConfiguration();
        Resource resource = Resource.newInstance((int)8192, (int)4);
        LocalityPreferredContainerPlacementStrategy strategy = new LocalityPreferredContainerPlacementStrategy(new SparkConf(), (Configuration)yarnConf, resource, (SparkRackResolver)new MockResolver());
        int totalTasks = 32768;
        int totalContainers = totalTasks / 16;
        int totalHosts = totalContainers / 16;
        ContainerId mockId = (ContainerId)Mockito.mock(ContainerId.class);
        Map hosts = ((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), totalHosts).map((Function1)new Serializable(this, totalTasks){
            public static final long serialVersionUID = 0L;
            private final int totalTasks$1;

            public final Tuple2<String, Object> apply(int i) {
                return new Tuple2((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"host_", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})), (Object)BoxesRunTime.boxToInteger((int)(this.totalTasks$1 % i)));
            }
            {
                this.totalTasks$1 = totalTasks$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        IndexedSeq containers = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), totalContainers).map((Function1)new Serializable(this, mockId){
            public static final long serialVersionUID = 0L;
            private final ContainerId mockId$1;

            public final ContainerId apply(int i) {
                return this.mockId$1;
            }
            {
                this.mockId$1 = mockId$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        int count = containers.size() / hosts.size() / 2;
        HashMap hostToContainerMap = new HashMap();
        ((IterableLike)((IterableLike)hosts.keys().take(hosts.size() / 2)).zipWithIndex(Iterable$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this, containers, count, hostToContainerMap){
            public static final long serialVersionUID = 0L;
            private final IndexedSeq containers$1;
            private final int count$1;
            private final HashMap hostToContainerMap$1;

            public final void apply(Tuple2<String, Object> x0$1) {
                Tuple2<String, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    String host = (String)tuple2._1();
                    int i = tuple2._2$mcI$sp();
                    HashSet hostContainers = new HashSet();
                    ((IterableLike)((IterableLike)this.containers$1.drop(this.count$1 * i)).take(i)).foreach((Function1)new Serializable(this, hostContainers){
                        public static final long serialVersionUID = 0L;
                        private final HashSet hostContainers$1;

                        public final HashSet<ContainerId> apply(ContainerId c) {
                            return this.hostContainers$1.$plus$eq((Object)c);
                        }
                        {
                            this.hostContainers$1 = hostContainers$1;
                        }
                    });
                    this.hostToContainerMap$1.update((Object)host, (Object)hostContainers);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.containers$1 = containers$1;
                this.count$1 = count$1;
                this.hostToContainerMap$1 = hostToContainerMap$1;
            }
        });
        strategy.localityOfRequestedContainers(containers.size() * 2, totalTasks, hosts, hostToContainerMap, (Seq)Nil$.MODULE$);
    }

    public LocalityPlacementStrategySuite() {
        this.test("handle large number of containers and tasks (SPARK-18750)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LocalityPlacementStrategySuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ObjectRef error2 = ObjectRef.create(null);
                Runnable runnable = new Runnable(this, error2){
                    private final /* synthetic */ $anonfun$1 $outer;
                    private final ObjectRef error$1;

                    public void run() {
                        try {
                            this.$outer.org$apache$spark$deploy$yarn$LocalityPlacementStrategySuite$$anonfun$$$outer().org$apache$spark$deploy$yarn$LocalityPlacementStrategySuite$$runTest();
                        }
                        catch (Throwable throwable) {
                            this.error$1.elem = throwable;
                        }
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.error$1 = error$1;
                    }
                };
                Thread thread = new Thread(new ThreadGroup("test"), runnable, "test-thread", 32768L);
                thread.start();
                thread.join();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer((Throwable)error2.elem);
                Null$ $org_scalatest_assert_macro_right = null;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", null, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }

            public /* synthetic */ LocalityPlacementStrategySuite org$apache$spark$deploy$yarn$LocalityPlacementStrategySuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

