/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.yarn;

import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.api.records.URL;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.deploy.yarn.ClientDistributedCacheManager;
import org.apache.spark.deploy.yarn.config.package$;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Tag;
import org.scalatest.mock.MockitoSugar;
import scala.Function0;
import scala.None$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.Map;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;

@ScalaSignature(bytes="\u0006\u0001i3A!\u0001\u0002\u0001\u001b\t\u00113\t\\5f]R$\u0015n\u001d;sS\n,H/\u001a3DC\u000eDW-T1oC\u001e,'oU;ji\u0016T!a\u0001\u0003\u0002\te\f'O\u001c\u0006\u0003\u000b\u0019\ta\u0001Z3qY>L(BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M\u0019\u0001A\u0004\n\u0011\u0005=\u0001R\"\u0001\u0004\n\u0005E1!!D*qCJ\\g)\u001e8Tk&$X\r\u0005\u0002\u001415\tAC\u0003\u0002\u0016-\u0005!Qn\\2l\u0015\t9\"\"A\u0005tG\u0006d\u0017\r^3ti&\u0011\u0011\u0004\u0006\u0002\r\u001b>\u001c7.\u001b;p'V<\u0017M\u001d\u0005\u00067\u0001!\t\u0001H\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003u\u0001\"A\b\u0001\u000e\u0003\t1A\u0001\t\u0001\u0001C\t\tSj\\2l\u00072LWM\u001c;ESN$(/\u001b2vi\u0016$7)Y2iK6\u000bg.Y4feN\u0011qD\t\t\u0003=\rJ!\u0001\n\u0002\u0003;\rc\u0017.\u001a8u\t&\u001cHO]5ckR,GmQ1dQ\u0016l\u0015M\\1hKJDQaG\u0010\u0005\u0002\u0019\"\u0012a\n\t\u0003Q}i\u0011\u0001\u0001\u0005\u0006U}!\teK\u0001\u000eO\u0016$h+[:jE&d\u0017\u000e^=\u0015\t1:d\b\u0013\t\u0003[Uj\u0011A\f\u0006\u0003_A\nqA]3d_J$7O\u0003\u00022e\u0005\u0019\u0011\r]5\u000b\u0005\r\u0019$B\u0001\u001b\t\u0003\u0019A\u0017\rZ8pa&\u0011aG\f\u0002\u0018\u0019>\u001c\u0017\r\u001c*fg>,(oY3WSNL'-\u001b7jifDQ\u0001O\u0015A\u0002e\nAaY8oMB\u0011!\bP\u0007\u0002w)\u0011\u0001hM\u0005\u0003{m\u0012QbQ8oM&<WO]1uS>t\u0007\"B *\u0001\u0004\u0001\u0015aA;sSB\u0011\u0011IR\u0007\u0002\u0005*\u00111\tR\u0001\u0004]\u0016$(\"A#\u0002\t)\fg/Y\u0005\u0003\u000f\n\u00131!\u0016*J\u0011\u0015I\u0015\u00061\u0001K\u0003%\u0019H/\u0019;DC\u000eDW\r\u0005\u0003L%\u0002#V\"\u0001'\u000b\u00055s\u0015aB7vi\u0006\u0014G.\u001a\u0006\u0003\u001fB\u000b!bY8mY\u0016\u001cG/[8o\u0015\u0005\t\u0016!B:dC2\f\u0017BA*M\u0005\ri\u0015\r\u001d\t\u0003+bk\u0011A\u0016\u0006\u0003/N\n!AZ:\n\u0005e3&A\u0003$jY\u0016\u001cF/\u0019;vg\u0002")
public class ClientDistributedCacheManagerSuite
extends SparkFunSuite
implements MockitoSugar {
    public <T> T mock(Manifest<T> manifest) {
        return (T)MockitoSugar.class.mock((MockitoSugar)this, manifest);
    }

    public <T> T mock(Answer<?> defaultAnswer, Manifest<T> manifest) {
        return (T)MockitoSugar.class.mock((MockitoSugar)this, defaultAnswer, manifest);
    }

    public <T> T mock(MockSettings mockSettings, Manifest<T> manifest) {
        return (T)MockitoSugar.class.mock((MockitoSugar)this, (MockSettings)mockSettings, manifest);
    }

    public <T> T mock(String name, Manifest<T> manifest) {
        return (T)MockitoSugar.class.mock((MockitoSugar)this, (String)name, manifest);
    }

    public ClientDistributedCacheManagerSuite() {
        MockitoSugar.class.$init$((MockitoSugar)this);
        this.test("test getFileStatus empty", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ClientDistributedCacheManagerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ClientDistributedCacheManager distMgr = new ClientDistributedCacheManager();
                FileSystem fs = (FileSystem)this.$outer.mock(ManifestFactory$.MODULE$.classType(FileSystem.class));
                URI uri = new URI("/tmp/testing");
                Mockito.when((Object)fs.getFileStatus(new Path(uri))).thenReturn((Object)new FileStatus());
                Map statCache = (Map)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
                FileStatus stat = distMgr.getFileStatus(fs, uri, statCache);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(stat.getPath());
                Null$ $org_scalatest_assert_macro_right = null;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", null, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("test getFileStatus cached", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ClientDistributedCacheManagerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ClientDistributedCacheManager distMgr = new ClientDistributedCacheManager();
                FileSystem fs = (FileSystem)this.$outer.mock(ManifestFactory$.MODULE$.classType(FileSystem.class));
                URI uri = new URI("/tmp/testing");
                FileStatus realFileStatus = new FileStatus(10L, false, 1, 1024L, 10L, 10L, null, "testOwner", null, new Path("/tmp/testing"));
                Mockito.when((Object)fs.getFileStatus(new Path(uri))).thenReturn((Object)new FileStatus());
                Map statCache = (Map)HashMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)uri), (Object)realFileStatus)}));
                FileStatus stat = distMgr.getFileStatus(fs, uri, statCache);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(stat.getPath().toString());
                String $org_scalatest_assert_macro_right = "/tmp/testing";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("test addResource", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ClientDistributedCacheManagerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                MockClientDistributedCacheManager distMgr = this.$outer.new MockClientDistributedCacheManager();
                FileSystem fs = (FileSystem)this.$outer.mock(ManifestFactory$.MODULE$.classType(FileSystem.class));
                Configuration conf = new Configuration();
                Path destPath = new Path("file:///foo.invalid.com:8080/tmp/testing");
                HashMap localResources = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
                Map statCache = (Map)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
                Mockito.when((Object)fs.getFileStatus(destPath)).thenReturn((Object)new FileStatus());
                distMgr.addResource(fs, conf, destPath, localResources, LocalResourceType.FILE, "link", statCache, false);
                LocalResource resource = (LocalResource)localResources.apply((Object)"link");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(resource.getVisibility());
                LocalResourceVisibility $org_scalatest_assert_macro_right = LocalResourceVisibility.PRIVATE;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(ConverterUtils.getPathFromYarnURL((URL)resource.getResource()));
                Path $org_scalatest_assert_macro_right2 = destPath;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)resource.getTimestamp()));
                int $org_scalatest_assert_macro_right3 = 0;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)resource.getSize()));
                int $org_scalatest_assert_macro_right4 = 0;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(resource.getType());
                LocalResourceType $org_scalatest_assert_macro_right5 = LocalResourceType.FILE;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                SparkConf sparkConf = new SparkConf(false);
                distMgr.updateConfiguration(sparkConf);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(sparkConf.get(package$.MODULE$.CACHED_FILES()));
                Seq $org_scalatest_assert_macro_right6 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"file:/foo.invalid.com:8080/tmp/testing#link"}));
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.$outer.convertToEqualizer(sparkConf.get(package$.MODULE$.CACHED_FILES_TIMESTAMPS()));
                Seq $org_scalatest_assert_macro_right7 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}));
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.$outer.convertToEqualizer(sparkConf.get(package$.MODULE$.CACHED_FILES_SIZES()));
                Seq $org_scalatest_assert_macro_right8 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}));
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)$org_scalatest_assert_macro_right8, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.$outer.convertToEqualizer(sparkConf.get(package$.MODULE$.CACHED_FILES_VISIBILITIES()));
                Seq $org_scalatest_assert_macro_right9 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{LocalResourceVisibility.PRIVATE.name()}));
                Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)$org_scalatest_assert_macro_right9, $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)$org_scalatest_assert_macro_right9, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.$outer.convertToEqualizer(sparkConf.get(package$.MODULE$.CACHED_FILES_TYPES()));
                Seq $org_scalatest_assert_macro_right10 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{LocalResourceType.FILE.name()}));
                Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)$org_scalatest_assert_macro_right10, $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)$org_scalatest_assert_macro_right10, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"");
                FileStatus realFileStatus = new FileStatus(20L, false, 1, 1024L, 10L, 30L, null, "testOwner", null, new Path("/tmp/testing2"));
                Path destPath2 = new Path("file:///foo.invalid.com:8080/tmp/testing2");
                Mockito.when((Object)fs.getFileStatus(destPath2)).thenReturn((Object)realFileStatus);
                distMgr.addResource(fs, conf, destPath2, localResources, LocalResourceType.FILE, "link2", statCache, false);
                LocalResource resource2 = (LocalResource)localResources.apply((Object)"link2");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left11 = this.$outer.convertToEqualizer(resource2.getVisibility());
                LocalResourceVisibility $org_scalatest_assert_macro_right11 = LocalResourceVisibility.PRIVATE;
                Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "===", (Object)$org_scalatest_assert_macro_right11, $org_scalatest_assert_macro_left11.$eq$eq$eq((Object)$org_scalatest_assert_macro_right11, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left12 = this.$outer.convertToEqualizer(ConverterUtils.getPathFromYarnURL((URL)resource2.getResource()));
                Path $org_scalatest_assert_macro_right12 = destPath2;
                Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "===", (Object)$org_scalatest_assert_macro_right12, $org_scalatest_assert_macro_left12.$eq$eq$eq((Object)$org_scalatest_assert_macro_right12, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left13 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)resource2.getTimestamp()));
                int $org_scalatest_assert_macro_right13 = 10;
                Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left13, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right13), $org_scalatest_assert_macro_left13.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right13), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left14 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)resource2.getSize()));
                int $org_scalatest_assert_macro_right14 = 20;
                Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left14, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right14), $org_scalatest_assert_macro_left14.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right14), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left15 = this.$outer.convertToEqualizer(resource2.getType());
                LocalResourceType $org_scalatest_assert_macro_right15 = LocalResourceType.FILE;
                Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left15, "===", (Object)$org_scalatest_assert_macro_right15, $org_scalatest_assert_macro_left15.$eq$eq$eq((Object)$org_scalatest_assert_macro_right15, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"");
                SparkConf sparkConf2 = new SparkConf(false);
                distMgr.updateConfiguration(sparkConf2);
                Seq files = (Seq)sparkConf2.get(package$.MODULE$.CACHED_FILES());
                Seq sizes = (Seq)sparkConf2.get(package$.MODULE$.CACHED_FILES_SIZES());
                Seq timestamps = (Seq)sparkConf2.get(package$.MODULE$.CACHED_FILES_TIMESTAMPS());
                Seq visibilities = (Seq)sparkConf2.get(package$.MODULE$.CACHED_FILES_VISIBILITIES());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left16 = this.$outer.convertToEqualizer(files.apply(0));
                String $org_scalatest_assert_macro_right16 = "file:/foo.invalid.com:8080/tmp/testing#link";
                Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left16, "===", (Object)$org_scalatest_assert_macro_right16, $org_scalatest_assert_macro_left16.$eq$eq$eq((Object)$org_scalatest_assert_macro_right16, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left17 = this.$outer.convertToEqualizer(timestamps.apply(0));
                int $org_scalatest_assert_macro_right17 = 0;
                Bool $org_scalatest_assert_macro_expr17 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left17, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right17), $org_scalatest_assert_macro_left17.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right17), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr17, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left18 = this.$outer.convertToEqualizer(sizes.apply(0));
                int $org_scalatest_assert_macro_right18 = 0;
                Bool $org_scalatest_assert_macro_expr18 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left18, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right18), $org_scalatest_assert_macro_left18.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right18), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr18, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left19 = this.$outer.convertToEqualizer(visibilities.apply(0));
                String $org_scalatest_assert_macro_right19 = LocalResourceVisibility.PRIVATE.name();
                Bool $org_scalatest_assert_macro_expr19 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left19, "===", (Object)$org_scalatest_assert_macro_right19, $org_scalatest_assert_macro_left19.$eq$eq$eq((Object)$org_scalatest_assert_macro_right19, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr19, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left20 = this.$outer.convertToEqualizer(files.apply(1));
                String $org_scalatest_assert_macro_right20 = "file:/foo.invalid.com:8080/tmp/testing2#link2";
                Bool $org_scalatest_assert_macro_expr20 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left20, "===", (Object)$org_scalatest_assert_macro_right20, $org_scalatest_assert_macro_left20.$eq$eq$eq((Object)$org_scalatest_assert_macro_right20, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr20, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left21 = this.$outer.convertToEqualizer(timestamps.apply(1));
                int $org_scalatest_assert_macro_right21 = 10;
                Bool $org_scalatest_assert_macro_expr21 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left21, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right21), $org_scalatest_assert_macro_left21.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right21), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr21, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left22 = this.$outer.convertToEqualizer(sizes.apply(1));
                int $org_scalatest_assert_macro_right22 = 20;
                Bool $org_scalatest_assert_macro_expr22 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left22, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right22), $org_scalatest_assert_macro_left22.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right22), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr22, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left23 = this.$outer.convertToEqualizer(visibilities.apply(1));
                String $org_scalatest_assert_macro_right23 = LocalResourceVisibility.PRIVATE.name();
                Bool $org_scalatest_assert_macro_expr23 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left23, "===", (Object)$org_scalatest_assert_macro_right23, $org_scalatest_assert_macro_left23.$eq$eq$eq((Object)$org_scalatest_assert_macro_right23, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr23, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("test addResource link null", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ClientDistributedCacheManagerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                MockClientDistributedCacheManager distMgr = this.$outer.new MockClientDistributedCacheManager();
                FileSystem fs = (FileSystem)this.$outer.mock(ManifestFactory$.MODULE$.classType(FileSystem.class));
                Configuration conf = new Configuration();
                Path destPath = new Path("file:///foo.invalid.com:8080/tmp/testing");
                HashMap localResources = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
                Map statCache = (Map)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
                Mockito.when((Object)fs.getFileStatus(destPath)).thenReturn((Object)new FileStatus());
                this.$outer.intercept((Function0)new Serializable(this, distMgr, fs, conf, destPath, localResources, statCache){
                    public static final long serialVersionUID = 0L;
                    private final MockClientDistributedCacheManager distMgr$1;
                    private final FileSystem fs$1;
                    private final Configuration conf$1;
                    private final Path destPath$1;
                    private final HashMap localResources$1;
                    private final Map statCache$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.distMgr$1.addResource(this.fs$1, this.conf$1, this.destPath$1, this.localResources$1, LocalResourceType.FILE, null, this.statCache$1, false);
                    }
                    {
                        this.distMgr$1 = distMgr$1;
                        this.fs$1 = fs$1;
                        this.conf$1 = conf$1;
                        this.destPath$1 = destPath$1;
                        this.localResources$1 = localResources$1;
                        this.statCache$1 = statCache$1;
                    }
                }, ManifestFactory$.MODULE$.classType(Exception.class));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(localResources.get((Object)"link"));
                None$ $org_scalatest_assert_macro_right = None$.MODULE$;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)localResources.size()));
                int $org_scalatest_assert_macro_right2 = 0;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("test addResource appmaster only", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ClientDistributedCacheManagerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                MockClientDistributedCacheManager distMgr = this.$outer.new MockClientDistributedCacheManager();
                FileSystem fs = (FileSystem)this.$outer.mock(ManifestFactory$.MODULE$.classType(FileSystem.class));
                Configuration conf = new Configuration();
                Path destPath = new Path("file:///foo.invalid.com:8080/tmp/testing");
                HashMap localResources = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
                Map statCache = (Map)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
                FileStatus realFileStatus = new FileStatus(20L, false, 1, 1024L, 10L, 30L, null, "testOwner", null, new Path("/tmp/testing"));
                Mockito.when((Object)fs.getFileStatus(destPath)).thenReturn((Object)realFileStatus);
                distMgr.addResource(fs, conf, destPath, localResources, LocalResourceType.ARCHIVE, "link", statCache, true);
                LocalResource resource = (LocalResource)localResources.apply((Object)"link");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(resource.getVisibility());
                LocalResourceVisibility $org_scalatest_assert_macro_right = LocalResourceVisibility.PRIVATE;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(ConverterUtils.getPathFromYarnURL((URL)resource.getResource()));
                Path $org_scalatest_assert_macro_right2 = destPath;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)resource.getTimestamp()));
                int $org_scalatest_assert_macro_right3 = 10;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)resource.getSize()));
                int $org_scalatest_assert_macro_right4 = 20;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(resource.getType());
                LocalResourceType $org_scalatest_assert_macro_right5 = LocalResourceType.ARCHIVE;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                SparkConf sparkConf = new SparkConf(false);
                distMgr.updateConfiguration(sparkConf);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(sparkConf.get(package$.MODULE$.CACHED_FILES()));
                Nil$ $org_scalatest_assert_macro_right6 = Nil$.MODULE$;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.$outer.convertToEqualizer(sparkConf.get(package$.MODULE$.CACHED_FILES_TIMESTAMPS()));
                Nil$ $org_scalatest_assert_macro_right7 = Nil$.MODULE$;
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.$outer.convertToEqualizer(sparkConf.get(package$.MODULE$.CACHED_FILES_SIZES()));
                Nil$ $org_scalatest_assert_macro_right8 = Nil$.MODULE$;
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)$org_scalatest_assert_macro_right8, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.$outer.convertToEqualizer(sparkConf.get(package$.MODULE$.CACHED_FILES_VISIBILITIES()));
                Nil$ $org_scalatest_assert_macro_right9 = Nil$.MODULE$;
                Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)$org_scalatest_assert_macro_right9, $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)$org_scalatest_assert_macro_right9, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.$outer.convertToEqualizer(sparkConf.get(package$.MODULE$.CACHED_FILES_TYPES()));
                Nil$ $org_scalatest_assert_macro_right10 = Nil$.MODULE$;
                Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)$org_scalatest_assert_macro_right10, $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)$org_scalatest_assert_macro_right10, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("test addResource archive", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ClientDistributedCacheManagerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                MockClientDistributedCacheManager distMgr = this.$outer.new MockClientDistributedCacheManager();
                FileSystem fs = (FileSystem)this.$outer.mock(ManifestFactory$.MODULE$.classType(FileSystem.class));
                Configuration conf = new Configuration();
                Path destPath = new Path("file:///foo.invalid.com:8080/tmp/testing");
                HashMap localResources = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
                Map statCache = (Map)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
                FileStatus realFileStatus = new FileStatus(20L, false, 1, 1024L, 10L, 30L, null, "testOwner", null, new Path("/tmp/testing"));
                Mockito.when((Object)fs.getFileStatus(destPath)).thenReturn((Object)realFileStatus);
                distMgr.addResource(fs, conf, destPath, localResources, LocalResourceType.ARCHIVE, "link", statCache, false);
                LocalResource resource = (LocalResource)localResources.apply((Object)"link");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(resource.getVisibility());
                LocalResourceVisibility $org_scalatest_assert_macro_right = LocalResourceVisibility.PRIVATE;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(ConverterUtils.getPathFromYarnURL((URL)resource.getResource()));
                Path $org_scalatest_assert_macro_right2 = destPath;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)resource.getTimestamp()));
                int $org_scalatest_assert_macro_right3 = 10;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)resource.getSize()));
                int $org_scalatest_assert_macro_right4 = 20;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(resource.getType());
                LocalResourceType $org_scalatest_assert_macro_right5 = LocalResourceType.ARCHIVE;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                SparkConf sparkConf = new SparkConf(false);
                distMgr.updateConfiguration(sparkConf);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(sparkConf.get(package$.MODULE$.CACHED_FILES()));
                Seq $org_scalatest_assert_macro_right6 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"file:/foo.invalid.com:8080/tmp/testing#link"}));
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.$outer.convertToEqualizer(sparkConf.get(package$.MODULE$.CACHED_FILES_SIZES()));
                Seq $org_scalatest_assert_macro_right7 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{20L}));
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.$outer.convertToEqualizer(sparkConf.get(package$.MODULE$.CACHED_FILES_TIMESTAMPS()));
                Seq $org_scalatest_assert_macro_right8 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{10L}));
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)$org_scalatest_assert_macro_right8, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.$outer.convertToEqualizer(sparkConf.get(package$.MODULE$.CACHED_FILES_VISIBILITIES()));
                Seq $org_scalatest_assert_macro_right9 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{LocalResourceVisibility.PRIVATE.name()}));
                Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)$org_scalatest_assert_macro_right9, $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)$org_scalatest_assert_macro_right9, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.$outer.convertToEqualizer(sparkConf.get(package$.MODULE$.CACHED_FILES_TYPES()));
                Seq $org_scalatest_assert_macro_right10 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{LocalResourceType.ARCHIVE.name()}));
                Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)$org_scalatest_assert_macro_right10, $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)$org_scalatest_assert_macro_right10, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public class MockClientDistributedCacheManager
    extends ClientDistributedCacheManager {
        public LocalResourceVisibility getVisibility(Configuration conf, URI uri, Map<URI, FileStatus> statCache) {
            return LocalResourceVisibility.PRIVATE;
        }

        public /* synthetic */ ClientDistributedCacheManagerSuite org$apache$spark$deploy$yarn$ClientDistributedCacheManagerSuite$MockClientDistributedCacheManager$$$outer() {
            return ClientDistributedCacheManagerSuite.this;
        }

        public MockClientDistributedCacheManager() {
            if (ClientDistributedCacheManagerSuite.this == null) {
                throw null;
            }
        }
    }
}

