/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.kafka010;

import java.io.Serializable;
import java.util.NoSuchElementException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.kafka010.KafkaTokenClusterConf;
import org.apache.spark.kafka010.KafkaTokenSparkConf$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfterEach;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u000514AAI\u0012\u0001Y!)\u0011\u0007\u0001C\u0001e!9Q\u0007\u0001b\u0001\n\u00131\u0004BB \u0001A\u0003%q\u0007C\u0004A\u0001\t\u0007I\u0011\u0002\u001c\t\r\u0005\u0003\u0001\u0015!\u00038\u0011\u001d\u0011\u0005A1A\u0005\nYBaa\u0011\u0001!\u0002\u00139\u0004b\u0002#\u0001\u0005\u0004%IA\u000e\u0005\u0007\u000b\u0002\u0001\u000b\u0011B\u001c\t\u000f\u0019\u0003!\u0019!C\u0005m!1q\t\u0001Q\u0001\n]Bq\u0001\u0013\u0001C\u0002\u0013%a\u0007\u0003\u0004J\u0001\u0001\u0006Ia\u000e\u0005\b\u0015\u0002\u0011\r\u0011\"\u00037\u0011\u0019Y\u0005\u0001)A\u0005o!9A\n\u0001b\u0001\n\u00131\u0004BB'\u0001A\u0003%q\u0007C\u0004O\u0001\t\u0007I\u0011\u0002\u001c\t\r=\u0003\u0001\u0015!\u00038\u0011\u001d\u0001\u0006A1A\u0005\nYBa!\u0015\u0001!\u0002\u00139\u0004b\u0002*\u0001\u0005\u0004%IA\u000e\u0005\u0007'\u0002\u0001\u000b\u0011B\u001c\t\u000fQ\u0003!\u0019!C\u0005m!1Q\u000b\u0001Q\u0001\n]BqA\u0016\u0001C\u0002\u0013%a\u0007\u0003\u0004X\u0001\u0001\u0006Ia\u000e\u0005\b1\u0002\u0011\r\u0011\"\u00037\u0011\u0019I\u0006\u0001)A\u0005o!9!\f\u0001a\u0001\n\u0013Y\u0006bB0\u0001\u0001\u0004%I\u0001\u0019\u0005\u0007S\u0002\u0001\u000b\u0015\u0002/\t\u000b)\u0004A\u0011I6\u00031-\u000bgm[1U_.,gn\u00159be.\u001cuN\u001c4Tk&$XM\u0003\u0002%K\u0005A1.\u00194lCB\n\u0004G\u0003\u0002'O\u0005)1\u000f]1sW*\u0011\u0001&K\u0001\u0007CB\f7\r[3\u000b\u0003)\n1a\u001c:h\u0007\u0001\u0019\"\u0001A\u0017\u0011\u00059zS\"A\u0013\n\u0005A*#!D*qCJ\\g)\u001e8Tk&$X-\u0001\u0004=S:LGO\u0010\u000b\u0002gA\u0011A\u0007A\u0007\u0002G\u0005Y\u0011\u000eZ3oi&4\u0017.\u001a:2+\u00059\u0004C\u0001\u001d>\u001b\u0005I$B\u0001\u001e<\u0003\u0011a\u0017M\\4\u000b\u0003q\nAA[1wC&\u0011a(\u000f\u0002\u0007'R\u0014\u0018N\\4\u0002\u0019%$WM\u001c;jM&,'/\r\u0011\u0002\u0017%$WM\u001c;jM&,'OM\u0001\rS\u0012,g\u000e^5gS\u0016\u0014(\u0007I\u0001\u0015CV$\bNQ8piN#(/\u00199TKJ4XM]:\u0002+\u0005,H\u000f\u001b\"p_R\u001cFO]1q'\u0016\u0014h/\u001a:tA\u0005\u0011B/\u0019:hKR\u001cVM\u001d<feN\u0014VmZ3y\u0003M!\u0018M]4fiN+'O^3sgJ+w-\u001a=!\u0003A\u0019XmY;sSRL\bK]8u_\u000e|G.A\ttK\u000e,(/\u001b;z!J|Go\\2pY\u0002\n1c[3sE\u0016\u0014xn]*feZL7-\u001a(b[\u0016\fAc[3sE\u0016\u0014xn]*feZL7-\u001a(b[\u0016\u0004\u0013A\u0004;skN$8\u000b^8sKRK\b/Z\u0001\u0010iJ,8\u000f^*u_J,G+\u001f9fA\u0005\u0011BO];tiN#xN]3M_\u000e\fG/[8o\u0003M!(/^:u'R|'/\u001a'pG\u0006$\u0018n\u001c8!\u0003I!(/^:u'R|'/\u001a)bgN<xN\u001d3\u0002'Q\u0014Xo\u001d;Ti>\u0014X\rU1tg^|'\u000f\u001a\u0011\u0002\u0019-,\u0017p\u0015;pe\u0016$\u0016\u0010]3\u0002\u001b-,\u0017p\u0015;pe\u0016$\u0016\u0010]3!\u0003AYW-_*u_J,Gj\\2bi&|g.A\tlKf\u001cFo\u001c:f\u0019>\u001c\u0017\r^5p]\u0002\n\u0001c[3z'R|'/\u001a)bgN<xN\u001d3\u0002#-,\u0017p\u0015;pe\u0016\u0004\u0016m]:x_J$\u0007%A\u0006lKf\u0004\u0016m]:x_J$\u0017\u0001D6fsB\u000b7o]<pe\u0012\u0004\u0013A\u0004;pW\u0016tW*Z2iC:L7/\\\u0001\u0010i>\\WM\\'fG\"\fg.[:nA\u0005I1\u000f]1sW\u000e{gNZ\u000b\u00029B\u0011a&X\u0005\u0003=\u0016\u0012\u0011b\u00159be.\u001cuN\u001c4\u0002\u001bM\u0004\u0018M]6D_:4w\fJ3r)\t\tw\r\u0005\u0002cK6\t1MC\u0001e\u0003\u0015\u00198-\u00197b\u0013\t17M\u0001\u0003V]&$\bb\u00025 \u0003\u0003\u0005\r\u0001X\u0001\u0004q\u0012\n\u0014AC:qCJ\\7i\u001c8gA\u0005Q!-\u001a4pe\u0016,\u0015m\u00195\u0015\u0003\u0005\u0004")
public class KafkaTokenSparkConfSuite
extends SparkFunSuite {
    private final String identifier1;
    private final String identifier2;
    private final String authBootStrapServers;
    private final String targetServersRegex;
    private final String securityProtocol;
    private final String kerberosServiceName;
    private final String trustStoreType;
    private final String trustStoreLocation;
    private final String trustStorePassword;
    private final String keyStoreType;
    private final String keyStoreLocation;
    private final String keyStorePassword;
    private final String keyPassword;
    private final String tokenMechanism;
    private SparkConf sparkConf;

    private String identifier1() {
        return this.identifier1;
    }

    private String identifier2() {
        return this.identifier2;
    }

    private String authBootStrapServers() {
        return this.authBootStrapServers;
    }

    private String targetServersRegex() {
        return this.targetServersRegex;
    }

    private String securityProtocol() {
        return this.securityProtocol;
    }

    private String kerberosServiceName() {
        return this.kerberosServiceName;
    }

    private String trustStoreType() {
        return this.trustStoreType;
    }

    private String trustStoreLocation() {
        return this.trustStoreLocation;
    }

    private String trustStorePassword() {
        return this.trustStorePassword;
    }

    private String keyStoreType() {
        return this.keyStoreType;
    }

    private String keyStoreLocation() {
        return this.keyStoreLocation;
    }

    private String keyStorePassword() {
        return this.keyStorePassword;
    }

    private String keyPassword() {
        return this.keyPassword;
    }

    private String tokenMechanism() {
        return this.tokenMechanism;
    }

    private SparkConf sparkConf() {
        return this.sparkConf;
    }

    private void sparkConf_$eq(SparkConf x$1) {
        this.sparkConf = x$1;
    }

    public void beforeEach() {
        BeforeAndAfterEach.beforeEach$((BeforeAndAfterEach)this);
        this.sparkConf_$eq(new SparkConf());
    }

    public KafkaTokenSparkConfSuite() {
        this.identifier1 = "cluster1";
        this.identifier2 = "cluster2";
        this.authBootStrapServers = "127.0.0.1:0";
        this.targetServersRegex = "127.0.0.*:0";
        this.securityProtocol = SecurityProtocol.SSL.name;
        this.kerberosServiceName = "kafka1";
        this.trustStoreType = "customTrustStoreType";
        this.trustStoreLocation = "/path/to/trustStore";
        this.trustStorePassword = "trustStoreSecret";
        this.keyStoreType = "customKeyStoreType";
        this.keyStoreLocation = "/path/to/keyStore";
        this.keyStorePassword = "keyStoreSecret";
        this.keyPassword = "keySecret";
        this.tokenMechanism = "SCRAM-SHA-256";
        this.sparkConf = null;
        this.test("getClusterConfig should trow exception when not exists", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            NoSuchElementException thrown = (NoSuchElementException)this.intercept((Function0 & Serializable)() -> KafkaTokenSparkConf$.MODULE$.getClusterConfig(this.sparkConf(), "invalid"), ClassTag$.MODULE$.apply(NoSuchElementException.class), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 48));
            String $org_scalatest_assert_macro_left = thrown.getMessage();
            String $org_scalatest_assert_macro_right = "spark.kafka.clusters.invalid.auth.bootstrap.servers";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 51));
        }, new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 47));
        this.test("getClusterConfig should return entry with defaults", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            this.sparkConf().set("spark.kafka.clusters." + this.identifier1() + ".auth.bootstrap.servers", this.authBootStrapServers());
            KafkaTokenClusterConf clusterConfig = KafkaTokenSparkConf$.MODULE$.getClusterConfig(this.sparkConf(), this.identifier1());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(clusterConfig.identifier());
            String $org_scalatest_assert_macro_right = this.identifier1();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 58));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(clusterConfig.authBootstrapServers());
            String $org_scalatest_assert_macro_right2 = this.authBootStrapServers();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 59));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(clusterConfig.targetServersRegex());
            String $org_scalatest_assert_macro_right3 = KafkaTokenSparkConf$.MODULE$.DEFAULT_TARGET_SERVERS_REGEX();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 60));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(clusterConfig.securityProtocol());
            String $org_scalatest_assert_macro_right4 = SecurityProtocol.SASL_SSL.name;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(clusterConfig.kerberosServiceName());
            String $org_scalatest_assert_macro_right5 = KafkaTokenSparkConf$.MODULE$.DEFAULT_SASL_KERBEROS_SERVICE_NAME();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(clusterConfig.trustStoreType());
            None$ $org_scalatest_assert_macro_right6 = None$.MODULE$;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(clusterConfig.trustStoreLocation());
            None$ $org_scalatest_assert_macro_right7 = None$.MODULE$;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(clusterConfig.trustStorePassword());
            None$ $org_scalatest_assert_macro_right8 = None$.MODULE$;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)$org_scalatest_assert_macro_right8, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.convertToEqualizer(clusterConfig.keyStoreType());
            None$ $org_scalatest_assert_macro_right9 = None$.MODULE$;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)$org_scalatest_assert_macro_right9, $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)$org_scalatest_assert_macro_right9, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.convertToEqualizer(clusterConfig.keyStoreLocation());
            None$ $org_scalatest_assert_macro_right10 = None$.MODULE$;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)$org_scalatest_assert_macro_right10, $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)$org_scalatest_assert_macro_right10, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left11 = this.convertToEqualizer(clusterConfig.keyStorePassword());
            None$ $org_scalatest_assert_macro_right11 = None$.MODULE$;
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "===", (Object)$org_scalatest_assert_macro_right11, $org_scalatest_assert_macro_left11.$eq$eq$eq((Object)$org_scalatest_assert_macro_right11, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left12 = this.convertToEqualizer(clusterConfig.keyPassword());
            None$ $org_scalatest_assert_macro_right12 = None$.MODULE$;
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "===", (Object)$org_scalatest_assert_macro_right12, $org_scalatest_assert_macro_left12.$eq$eq$eq((Object)$org_scalatest_assert_macro_right12, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left13 = this.convertToEqualizer(clusterConfig.tokenMechanism());
            String $org_scalatest_assert_macro_right13 = KafkaTokenSparkConf$.MODULE$.DEFAULT_SASL_TOKEN_MECHANISM();
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left13, "===", (Object)$org_scalatest_assert_macro_right13, $org_scalatest_assert_macro_left13.$eq$eq$eq((Object)$org_scalatest_assert_macro_right13, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 71));
        }, new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 54));
        this.test("getClusterConfig should return entry overwrite defaults", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            this.sparkConf().set("spark.kafka.clusters." + this.identifier1() + ".auth.bootstrap.servers", this.authBootStrapServers());
            this.sparkConf().set("spark.kafka.clusters." + this.identifier1() + ".target.bootstrap.servers.regex", this.targetServersRegex());
            this.sparkConf().set("spark.kafka.clusters." + this.identifier1() + ".security.protocol", this.securityProtocol());
            this.sparkConf().set("spark.kafka.clusters." + this.identifier1() + ".sasl.kerberos.service.name", this.kerberosServiceName());
            this.sparkConf().set("spark.kafka.clusters." + this.identifier1() + ".ssl.truststore.type", this.trustStoreType());
            this.sparkConf().set("spark.kafka.clusters." + this.identifier1() + ".ssl.truststore.location", this.trustStoreLocation());
            this.sparkConf().set("spark.kafka.clusters." + this.identifier1() + ".ssl.truststore.password", this.trustStorePassword());
            this.sparkConf().set("spark.kafka.clusters." + this.identifier1() + ".ssl.keystore.type", this.keyStoreType());
            this.sparkConf().set("spark.kafka.clusters." + this.identifier1() + ".ssl.keystore.location", this.keyStoreLocation());
            this.sparkConf().set("spark.kafka.clusters." + this.identifier1() + ".ssl.keystore.password", this.keyStorePassword());
            this.sparkConf().set("spark.kafka.clusters." + this.identifier1() + ".ssl.key.password", this.keyPassword());
            this.sparkConf().set("spark.kafka.clusters." + this.identifier1() + ".sasl.token.mechanism", this.tokenMechanism());
            KafkaTokenClusterConf clusterConfig = KafkaTokenSparkConf$.MODULE$.getClusterConfig(this.sparkConf(), this.identifier1());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(clusterConfig.identifier());
            String $org_scalatest_assert_macro_right = this.identifier1();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(clusterConfig.authBootstrapServers());
            String $org_scalatest_assert_macro_right2 = this.authBootStrapServers();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 92));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(clusterConfig.targetServersRegex());
            String $org_scalatest_assert_macro_right3 = this.targetServersRegex();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(clusterConfig.securityProtocol());
            String $org_scalatest_assert_macro_right4 = this.securityProtocol();
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 94));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(clusterConfig.kerberosServiceName());
            String $org_scalatest_assert_macro_right5 = this.kerberosServiceName();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(clusterConfig.trustStoreType());
            Some $org_scalatest_assert_macro_right6 = new Some((Object)this.trustStoreType());
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 96));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(clusterConfig.trustStoreLocation());
            Some $org_scalatest_assert_macro_right7 = new Some((Object)this.trustStoreLocation());
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(clusterConfig.trustStorePassword());
            Some $org_scalatest_assert_macro_right8 = new Some((Object)this.trustStorePassword());
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)$org_scalatest_assert_macro_right8, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 98));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.convertToEqualizer(clusterConfig.keyStoreType());
            Some $org_scalatest_assert_macro_right9 = new Some((Object)this.keyStoreType());
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)$org_scalatest_assert_macro_right9, $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)$org_scalatest_assert_macro_right9, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 99));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.convertToEqualizer(clusterConfig.keyStoreLocation());
            Some $org_scalatest_assert_macro_right10 = new Some((Object)this.keyStoreLocation());
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)$org_scalatest_assert_macro_right10, $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)$org_scalatest_assert_macro_right10, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 100));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left11 = this.convertToEqualizer(clusterConfig.keyStorePassword());
            Some $org_scalatest_assert_macro_right11 = new Some((Object)this.keyStorePassword());
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "===", (Object)$org_scalatest_assert_macro_right11, $org_scalatest_assert_macro_left11.$eq$eq$eq((Object)$org_scalatest_assert_macro_right11, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 101));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left12 = this.convertToEqualizer(clusterConfig.keyPassword());
            Some $org_scalatest_assert_macro_right12 = new Some((Object)this.keyPassword());
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "===", (Object)$org_scalatest_assert_macro_right12, $org_scalatest_assert_macro_left12.$eq$eq$eq((Object)$org_scalatest_assert_macro_right12, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left13 = this.convertToEqualizer(clusterConfig.tokenMechanism());
            String $org_scalatest_assert_macro_right13 = this.tokenMechanism();
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left13, "===", (Object)$org_scalatest_assert_macro_right13, $org_scalatest_assert_macro_left13.$eq$eq$eq((Object)$org_scalatest_assert_macro_right13, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
        }, new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
        this.test("getClusterConfig should return specified kafka params", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            this.sparkConf().set("spark.kafka.clusters." + this.identifier1() + ".auth.bootstrap.servers", this.authBootStrapServers());
            this.sparkConf().set("spark.kafka.clusters." + this.identifier1() + ".kafka.customKey", "customValue");
            KafkaTokenClusterConf clusterConfig = KafkaTokenSparkConf$.MODULE$.getClusterConfig(this.sparkConf(), this.identifier1());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(clusterConfig.identifier());
            String $org_scalatest_assert_macro_right = this.identifier1();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 111));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(clusterConfig.authBootstrapServers());
            String $org_scalatest_assert_macro_right2 = this.authBootStrapServers();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(clusterConfig.specifiedKafkaParams());
            Map $org_scalatest_assert_macro_right3 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"customKey"), (Object)"customValue")}));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 113));
        }, new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 106));
        this.test("getAllClusterConfigs should return empty list when nothing configured", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Set $org_scalatest_assert_macro_left = KafkaTokenSparkConf$.MODULE$.getAllClusterConfigs(this.sparkConf());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 117));
        }, new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 116));
        this.test("getAllClusterConfigs should return empty list with malformed configuration", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            this.sparkConf().set("spark.kafka.clusters.", this.authBootStrapServers());
            Set $org_scalatest_assert_macro_left = KafkaTokenSparkConf$.MODULE$.getAllClusterConfigs(this.sparkConf());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 122));
        }, new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 120));
        this.test("getAllClusterConfigs should return multiple entries", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.sparkConf().set("spark.kafka.clusters." + this.identifier1() + ".auth.bootstrap.servers", this.authBootStrapServers());
            this.sparkConf().set("spark.kafka.clusters." + this.identifier2() + ".auth.bootstrap.servers", this.authBootStrapServers());
            Set clusterConfigs = KafkaTokenSparkConf$.MODULE$.getAllClusterConfigs(this.sparkConf());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)clusterConfigs.size()));
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130));
            clusterConfigs.foreach((Function1 & Serializable)clusterConfig -> {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(clusterConfig.authBootstrapServers());
                String $org_scalatest_assert_macro_right = this.authBootStrapServers();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 132));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(clusterConfig.targetServersRegex());
                String $org_scalatest_assert_macro_right2 = KafkaTokenSparkConf$.MODULE$.DEFAULT_TARGET_SERVERS_REGEX();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 133));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(clusterConfig.securityProtocol());
                String $org_scalatest_assert_macro_right3 = SecurityProtocol.SASL_SSL.name;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 134));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(clusterConfig.kerberosServiceName());
                String $org_scalatest_assert_macro_right4 = KafkaTokenSparkConf$.MODULE$.DEFAULT_SASL_KERBEROS_SERVICE_NAME();
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 135));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(clusterConfig.trustStoreType());
                None$ $org_scalatest_assert_macro_right5 = None$.MODULE$;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 137));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(clusterConfig.trustStoreLocation());
                None$ $org_scalatest_assert_macro_right6 = None$.MODULE$;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 138));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(clusterConfig.trustStorePassword());
                None$ $org_scalatest_assert_macro_right7 = None$.MODULE$;
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 139));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(clusterConfig.keyStoreType());
                None$ $org_scalatest_assert_macro_right8 = None$.MODULE$;
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)$org_scalatest_assert_macro_right8, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 140));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.convertToEqualizer(clusterConfig.keyStoreLocation());
                None$ $org_scalatest_assert_macro_right9 = None$.MODULE$;
                Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)$org_scalatest_assert_macro_right9, $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)$org_scalatest_assert_macro_right9, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 141));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.convertToEqualizer(clusterConfig.keyStorePassword());
                None$ $org_scalatest_assert_macro_right10 = None$.MODULE$;
                Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)$org_scalatest_assert_macro_right10, $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)$org_scalatest_assert_macro_right10, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 142));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left11 = this.convertToEqualizer(clusterConfig.keyPassword());
                None$ $org_scalatest_assert_macro_right11 = None$.MODULE$;
                Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "===", (Object)$org_scalatest_assert_macro_right11, $org_scalatest_assert_macro_left11.$eq$eq$eq((Object)$org_scalatest_assert_macro_right11, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 143));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left12 = this.convertToEqualizer(clusterConfig.tokenMechanism());
                String $org_scalatest_assert_macro_right12 = KafkaTokenSparkConf$.MODULE$.DEFAULT_SASL_TOKEN_MECHANISM();
                Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "===", (Object)$org_scalatest_assert_macro_right12, $org_scalatest_assert_macro_left12.$eq$eq$eq((Object)$org_scalatest_assert_macro_right12, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 144));
            });
        }, new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 125));
    }
}

