/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.kinesis;

import com.amazonaws.services.kinesis.clientlibrary.lib.worker.InitialPositionInStream;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.KinesisClientLibConfiguration;
import com.amazonaws.services.kinesis.metrics.interfaces.MetricsLevel;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.Seconds$;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.TestServer;
import org.apache.spark.streaming.TestSuiteBase;
import org.apache.spark.streaming.dstream.DStream;
import org.apache.spark.streaming.kinesis.DefaultCredentials$;
import org.apache.spark.streaming.kinesis.KinesisInitialPosition;
import org.apache.spark.streaming.kinesis.KinesisInitialPositions;
import org.apache.spark.streaming.kinesis.KinesisInputDStream;
import org.apache.spark.streaming.kinesis.KinesisInputDStream$;
import org.apache.spark.streaming.kinesis.SparkAWSCredentials;
import org.mockito.MockSettings;
import org.mockito.stubbing.Answer;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Tag;
import org.scalatest.concurrent.PatienceConfiguration;
import org.scalatestplus.mockito.MockitoSugar;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001]3Aa\u0003\u0007\u0001/!)a\u0006\u0001C\u0001_!9!\u0007\u0001b\u0001\n\u0013\u0019\u0004BB\u001c\u0001A\u0003%A\u0007C\u00049\u0001\t\u0007I\u0011B\u001d\t\r\t\u0003\u0001\u0015!\u0003;\u0011\u001d\u0019\u0005A1A\u0005\neBa\u0001\u0012\u0001!\u0002\u0013Q\u0004\"B#\u0001\t\u00131\u0005\"\u0002(\u0001\t\u00131\u0005\"B(\u0001\t\u0003\u0002&aH&j]\u0016\u001c\u0018n]%oaV$Hi\u0015;sK\u0006l')^5mI\u0016\u00148+^5uK*\u0011QBD\u0001\bW&tWm]5t\u0015\ty\u0001#A\u0005tiJ,\u0017-\\5oO*\u0011\u0011CE\u0001\u0006gB\f'o\u001b\u0006\u0003'Q\ta!\u00199bG\",'\"A\u000b\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000b\u0001AB\u0004\t\u0014\u0011\u0005eQR\"\u0001\t\n\u0005m\u0001\"!D*qCJ\\g)\u001e8Tk&$X\r\u0005\u0002\u001e=5\ta\"\u0003\u0002 \u001d\tiA+Z:u'VLG/\u001a\"bg\u0016\u0004\"!\t\u0013\u000e\u0003\tR!a\t\u000b\u0002\u0013M\u001c\u0017\r\\1uKN$\u0018BA\u0013#\u0005I\u0011UMZ8sK\u0006sG-\u00114uKJ,\u0015m\u00195\u0011\u0005\u001dbS\"\u0001\u0015\u000b\u0005%R\u0013aB7pG.LGo\u001c\u0006\u0003WQ\tQb]2bY\u0006$Xm\u001d;qYV\u001c\u0018BA\u0017)\u00051iunY6ji>\u001cVoZ1s\u0003\u0019a\u0014N\\5u}Q\t\u0001\u0007\u0005\u00022\u00015\tA\"A\u0002tg\u000e,\u0012\u0001\u000e\t\u0003;UJ!A\u000e\b\u0003!M#(/Z1nS:<7i\u001c8uKb$\u0018\u0001B:tG\u0002\n!b\u001d;sK\u0006lg*Y7f+\u0005Q\u0004CA\u001eA\u001b\u0005a$BA\u001f?\u0003\u0011a\u0017M\\4\u000b\u0003}\nAA[1wC&\u0011\u0011\t\u0010\u0002\u0007'R\u0014\u0018N\\4\u0002\u0017M$(/Z1n\u001d\u0006lW\rI\u0001\u0012G\",7m\u001b9pS:$\u0018\t\u001d9OC6,\u0017AE2iK\u000e\\\u0007o\\5oi\u0006\u0003\bOT1nK\u0002\n1BY1tK\n+\u0018\u000e\u001c3feV\tq\t\u0005\u0002I\u0017:\u0011\u0011'S\u0005\u0003\u00152\t1cS5oKNL7/\u00138qkR$5\u000b\u001e:fC6L!\u0001T'\u0003\u000f\t+\u0018\u000e\u001c3fe*\u0011!\nD\u0001\bEVLG\u000eZ3s\u0003!\tg\r^3s\u00032dG#A)\u0011\u0005I+V\"A*\u000b\u0003Q\u000bQa]2bY\u0006L!AV*\u0003\tUs\u0017\u000e\u001e")
public class KinesisInputDStreamBuilderSuite
extends SparkFunSuite
implements TestSuiteBase,
MockitoSugar {
    private final StreamingContext ssc;
    private final String streamName;
    private final String checkpointAppName;
    private String checkpointDir;
    private final SparkConf conf;
    private final PatienceConfiguration.Timeout eventuallyTimeout;
    private volatile boolean bitmap$0;

    public <T> T mock(ClassTag<T> classTag) {
        return (T)MockitoSugar.mock$((MockitoSugar)this, classTag);
    }

    public <T> T mock(Answer<?> defaultAnswer, ClassTag<T> classTag) {
        return (T)MockitoSugar.mock$((MockitoSugar)this, defaultAnswer, classTag);
    }

    public <T> T mock(MockSettings mockSettings, ClassTag<T> classTag) {
        return (T)MockitoSugar.mock$((MockitoSugar)this, (MockSettings)mockSettings, classTag);
    }

    public <T> T mock(String name, ClassTag<T> classTag) {
        return (T)MockitoSugar.mock$((MockitoSugar)this, (String)name, classTag);
    }

    public /* synthetic */ void org$apache$spark$streaming$TestSuiteBase$$super$beforeEach() {
        BeforeAndAfterEach.beforeEach$((BeforeAndAfterEach)this);
    }

    public /* synthetic */ void org$apache$spark$streaming$TestSuiteBase$$super$afterEach() {
        BeforeAndAfterEach.afterEach$((BeforeAndAfterEach)this);
    }

    public String framework() {
        return TestSuiteBase.framework$((TestSuiteBase)this);
    }

    public String master() {
        return TestSuiteBase.master$((TestSuiteBase)this);
    }

    public Duration batchDuration() {
        return TestSuiteBase.batchDuration$((TestSuiteBase)this);
    }

    public int numInputPartitions() {
        return TestSuiteBase.numInputPartitions$((TestSuiteBase)this);
    }

    public int maxWaitTimeMillis() {
        return TestSuiteBase.maxWaitTimeMillis$((TestSuiteBase)this);
    }

    public boolean useManualClock() {
        return TestSuiteBase.useManualClock$((TestSuiteBase)this);
    }

    public boolean actuallyWait() {
        return TestSuiteBase.actuallyWait$((TestSuiteBase)this);
    }

    public void beforeFunction() {
        TestSuiteBase.beforeFunction$((TestSuiteBase)this);
    }

    public void afterFunction() {
        TestSuiteBase.afterFunction$((TestSuiteBase)this);
    }

    public void beforeEach() {
        TestSuiteBase.beforeEach$((TestSuiteBase)this);
    }

    public void afterEach() {
        TestSuiteBase.afterEach$((TestSuiteBase)this);
    }

    public <R> R withStreamingContext(StreamingContext ssc, Function1<StreamingContext, R> block) {
        return (R)TestSuiteBase.withStreamingContext$((TestSuiteBase)this, (StreamingContext)ssc, block);
    }

    public <R> R withTestServer(TestServer testServer, Function1<TestServer, R> block) {
        return (R)TestSuiteBase.withTestServer$((TestSuiteBase)this, (TestServer)testServer, block);
    }

    public <U, V> StreamingContext setupStreams(Seq<Seq<U>> input, Function1<DStream<U>, DStream<V>> operation, int numPartitions, ClassTag<U> evidence$4, ClassTag<V> evidence$5) {
        return TestSuiteBase.setupStreams$((TestSuiteBase)this, input, operation, (int)numPartitions, evidence$4, evidence$5);
    }

    public <U, V> int setupStreams$default$3() {
        return TestSuiteBase.setupStreams$default$3$((TestSuiteBase)this);
    }

    public <U, V, W> StreamingContext setupStreams(Seq<Seq<U>> input1, Seq<Seq<V>> input2, Function2<DStream<U>, DStream<V>, DStream<W>> operation, ClassTag<U> evidence$6, ClassTag<V> evidence$7, ClassTag<W> evidence$8) {
        return TestSuiteBase.setupStreams$((TestSuiteBase)this, input1, input2, operation, evidence$6, evidence$7, evidence$8);
    }

    public <V> Seq<Seq<V>> runStreams(StreamingContext ssc, int numBatches, int numExpectedOutput, Function0<BoxedUnit> preStop, ClassTag<V> evidence$9) {
        return TestSuiteBase.runStreams$((TestSuiteBase)this, (StreamingContext)ssc, (int)numBatches, (int)numExpectedOutput, preStop, evidence$9);
    }

    public <V> Function0<BoxedUnit> runStreams$default$4() {
        return TestSuiteBase.runStreams$default$4$((TestSuiteBase)this);
    }

    public <V> Seq<Seq<Seq<V>>> runStreamsWithPartitions(StreamingContext ssc, int numBatches, int numExpectedOutput, Function0<BoxedUnit> preStop, ClassTag<V> evidence$10) {
        return TestSuiteBase.runStreamsWithPartitions$((TestSuiteBase)this, (StreamingContext)ssc, (int)numBatches, (int)numExpectedOutput, preStop, evidence$10);
    }

    public <V> Function0<BoxedUnit> runStreamsWithPartitions$default$4() {
        return TestSuiteBase.runStreamsWithPartitions$default$4$((TestSuiteBase)this);
    }

    public <V> void verifyOutput(Seq<Seq<V>> output, Seq<Seq<V>> expectedOutput, boolean useSet, ClassTag<V> evidence$11) {
        TestSuiteBase.verifyOutput$((TestSuiteBase)this, output, expectedOutput, (boolean)useSet, evidence$11);
    }

    public <U, V> void testOperation(Seq<Seq<U>> input, Function1<DStream<U>, DStream<V>> operation, Seq<Seq<V>> expectedOutput, boolean useSet, ClassTag<U> evidence$12, ClassTag<V> evidence$13) {
        TestSuiteBase.testOperation$((TestSuiteBase)this, input, operation, expectedOutput, (boolean)useSet, evidence$12, evidence$13);
    }

    public <U, V> boolean testOperation$default$4() {
        return TestSuiteBase.testOperation$default$4$((TestSuiteBase)this);
    }

    public <U, V> void testOperation(Seq<Seq<U>> input, Function1<DStream<U>, DStream<V>> operation, Seq<Seq<V>> expectedOutput, int numBatches, boolean useSet, ClassTag<U> evidence$14, ClassTag<V> evidence$15) {
        TestSuiteBase.testOperation$((TestSuiteBase)this, input, operation, expectedOutput, (int)numBatches, (boolean)useSet, evidence$14, evidence$15);
    }

    public <U, V, W> void testOperation(Seq<Seq<U>> input1, Seq<Seq<V>> input2, Function2<DStream<U>, DStream<V>, DStream<W>> operation, Seq<Seq<W>> expectedOutput, boolean useSet, ClassTag<U> evidence$16, ClassTag<V> evidence$17, ClassTag<W> evidence$18) {
        TestSuiteBase.testOperation$((TestSuiteBase)this, input1, input2, operation, expectedOutput, (boolean)useSet, evidence$16, evidence$17, evidence$18);
    }

    public <U, V, W> void testOperation(Seq<Seq<U>> input1, Seq<Seq<V>> input2, Function2<DStream<U>, DStream<V>, DStream<W>> operation, Seq<Seq<W>> expectedOutput, int numBatches, boolean useSet, ClassTag<U> evidence$19, ClassTag<V> evidence$20, ClassTag<W> evidence$21) {
        TestSuiteBase.testOperation$((TestSuiteBase)this, input1, input2, operation, expectedOutput, (int)numBatches, (boolean)useSet, evidence$19, evidence$20, evidence$21);
    }

    private String checkpointDir$lzycompute() {
        KinesisInputDStreamBuilderSuite kinesisInputDStreamBuilderSuite = this;
        synchronized (kinesisInputDStreamBuilderSuite) {
            if (!this.bitmap$0) {
                this.checkpointDir = TestSuiteBase.checkpointDir$((TestSuiteBase)this);
                this.bitmap$0 = true;
            }
        }
        return this.checkpointDir;
    }

    public String checkpointDir() {
        if (!this.bitmap$0) {
            return this.checkpointDir$lzycompute();
        }
        return this.checkpointDir;
    }

    public SparkConf conf() {
        return this.conf;
    }

    public PatienceConfiguration.Timeout eventuallyTimeout() {
        return this.eventuallyTimeout;
    }

    public void org$apache$spark$streaming$TestSuiteBase$_setter_$conf_$eq(SparkConf x$1) {
        this.conf = x$1;
    }

    public void org$apache$spark$streaming$TestSuiteBase$_setter_$eventuallyTimeout_$eq(PatienceConfiguration.Timeout x$1) {
        this.eventuallyTimeout = x$1;
    }

    private StreamingContext ssc() {
        return this.ssc;
    }

    private String streamName() {
        return this.streamName;
    }

    private String checkpointAppName() {
        return this.checkpointAppName;
    }

    private KinesisInputDStream.Builder baseBuilder() {
        return KinesisInputDStream$.MODULE$.builder();
    }

    private KinesisInputDStream.Builder builder() {
        return this.baseBuilder().streamingContext(this.ssc()).streamName(this.streamName()).checkpointAppName(this.checkpointAppName());
    }

    public void afterAll() {
        try {
            this.ssc().stop(this.ssc().stop$default$1());
        }
        finally {
            super.afterAll();
        }
    }

    public KinesisInputDStreamBuilderSuite() {
        TestSuiteBase.$init$((TestSuiteBase)this);
        MockitoSugar.$init$((MockitoSugar)this);
        this.ssc = new StreamingContext(this.conf(), this.batchDuration());
        this.streamName = "a-very-nice-kinesis-stream-name";
        this.checkpointAppName = "a-very-nice-kcl-app-name";
        this.test("should raise an exception if the StreamingContext is missing", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> this.baseBuilder().streamName(this.streamName()).checkpointAppName(this.checkpointAppName()).build(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("KinesisInputDStreamBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 54)), new Position("KinesisInputDStreamBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53));
        this.test("should raise an exception if the stream name is missing", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> this.baseBuilder().streamingContext(this.ssc()).checkpointAppName(this.checkpointAppName()).build(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("KinesisInputDStreamBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 60)), new Position("KinesisInputDStreamBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 59));
        this.test("should raise an exception if the checkpoint app name is missing", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> this.baseBuilder().streamingContext(this.ssc()).streamName(this.streamName()).build(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("KinesisInputDStreamBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66)), new Position("KinesisInputDStreamBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
        this.test("should propagate required values to KinesisInputDStream", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            KinesisInputDStream dstream = this.builder().build();
            StreamingContext $org_scalatest_assert_macro_left = dstream.context();
            StreamingContext $org_scalatest_assert_macro_right = this.ssc();
            StreamingContext streamingContext = $org_scalatest_assert_macro_left;
            StreamingContext streamingContext2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(streamingContext != null ? !streamingContext.equals(streamingContext2) : streamingContext2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KinesisInputDStreamBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
            String $org_scalatest_assert_macro_left2 = dstream.streamName();
            String $org_scalatest_assert_macro_right2 = this.streamName();
            String string = $org_scalatest_assert_macro_left2;
            String string2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("KinesisInputDStreamBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
            String $org_scalatest_assert_macro_left3 = dstream.checkpointAppName();
            String $org_scalatest_assert_macro_right3 = this.checkpointAppName();
            String string3 = $org_scalatest_assert_macro_left3;
            String string4 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("KinesisInputDStreamBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75));
        }, new Position("KinesisInputDStreamBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 71));
        this.test("should propagate default values to KinesisInputDStream", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            KinesisInputDStream dstream = this.builder().build();
            String $org_scalatest_assert_macro_left = dstream.endpointUrl();
            String $org_scalatest_assert_macro_right = KinesisInputDStream$.MODULE$.DEFAULT_KINESIS_ENDPOINT_URL();
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KinesisInputDStreamBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 80));
            String $org_scalatest_assert_macro_left2 = dstream.regionName();
            String $org_scalatest_assert_macro_right2 = KinesisInputDStream$.MODULE$.DEFAULT_KINESIS_REGION_NAME();
            String string3 = $org_scalatest_assert_macro_left2;
            String string4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("KinesisInputDStreamBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
            KinesisInitialPosition $org_scalatest_assert_macro_left3 = dstream.initialPosition();
            KinesisInitialPosition $org_scalatest_assert_macro_right3 = KinesisInputDStream$.MODULE$.DEFAULT_INITIAL_POSITION();
            KinesisInitialPosition kinesisInitialPosition = $org_scalatest_assert_macro_left3;
            KinesisInitialPosition kinesisInitialPosition2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(kinesisInitialPosition != null ? !kinesisInitialPosition.equals(kinesisInitialPosition2) : kinesisInitialPosition2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("KinesisInputDStreamBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 82));
            Duration $org_scalatest_assert_macro_left4 = dstream.checkpointInterval();
            Duration $org_scalatest_assert_macro_right4 = this.batchDuration();
            Duration duration = $org_scalatest_assert_macro_left4;
            Duration duration2 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(duration != null ? !duration.equals(duration2) : duration2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("KinesisInputDStreamBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 83));
            StorageLevel $org_scalatest_assert_macro_left5 = dstream._storageLevel();
            StorageLevel $org_scalatest_assert_macro_right5 = KinesisInputDStream$.MODULE$.DEFAULT_STORAGE_LEVEL();
            StorageLevel storageLevel = $org_scalatest_assert_macro_left5;
            StorageLevel storageLevel2 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right5, !(storageLevel != null ? !storageLevel.equals(storageLevel2) : storageLevel2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("KinesisInputDStreamBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
            SparkAWSCredentials $org_scalatest_assert_macro_left6 = dstream.kinesisCreds();
            DefaultCredentials$ $org_scalatest_assert_macro_right6 = DefaultCredentials$.MODULE$;
            SparkAWSCredentials sparkAWSCredentials = $org_scalatest_assert_macro_left6;
            DefaultCredentials$ defaultCredentials$ = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "==", (Object)$org_scalatest_assert_macro_right6, !(sparkAWSCredentials != null ? !sparkAWSCredentials.equals(defaultCredentials$) : defaultCredentials$ != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("KinesisInputDStreamBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
            Option $org_scalatest_assert_macro_left7 = dstream.dynamoDBCreds();
            None$ $org_scalatest_assert_macro_right7 = None$.MODULE$;
            Option option = $org_scalatest_assert_macro_left7;
            None$ none$ = $org_scalatest_assert_macro_right7;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "==", (Object)$org_scalatest_assert_macro_right7, !(option != null ? !option.equals(none$) : none$ != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("KinesisInputDStreamBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86));
            Option $org_scalatest_assert_macro_left8 = dstream.cloudWatchCreds();
            None$ $org_scalatest_assert_macro_right8 = None$.MODULE$;
            Option option2 = $org_scalatest_assert_macro_left8;
            None$ none$2 = $org_scalatest_assert_macro_right8;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", (Object)$org_scalatest_assert_macro_right8, !(option2 != null ? !option2.equals(none$2) : none$2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("KinesisInputDStreamBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 87));
            MetricsLevel $org_scalatest_assert_macro_left9 = dstream.metricsLevel();
            MetricsLevel $org_scalatest_assert_macro_right9 = KinesisInputDStream$.MODULE$.DEFAULT_METRICS_LEVEL();
            MetricsLevel metricsLevel = $org_scalatest_assert_macro_left9;
            MetricsLevel metricsLevel2 = $org_scalatest_assert_macro_right9;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "==", (Object)$org_scalatest_assert_macro_right9, !(metricsLevel != null ? !metricsLevel.equals(metricsLevel2) : metricsLevel2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("KinesisInputDStreamBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 88));
            Set $org_scalatest_assert_macro_left10 = dstream.metricsEnabledDimensions();
            Set $org_scalatest_assert_macro_right10 = KinesisInputDStream$.MODULE$.DEFAULT_METRICS_ENABLED_DIMENSIONS();
            Set set = $org_scalatest_assert_macro_left10;
            Set set2 = $org_scalatest_assert_macro_right10;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "==", (Object)$org_scalatest_assert_macro_right10, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("KinesisInputDStreamBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
        }, new Position("KinesisInputDStreamBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 78));
        this.test("should propagate custom non-auth values to KinesisInputDStream", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String customEndpointUrl = "https://kinesis.us-west-2.amazonaws.com";
            String customRegion = "us-west-2";
            KinesisInitialPositions.TrimHorizon customInitialPosition = new KinesisInitialPositions.TrimHorizon();
            String customAppName = "a-very-nice-kinesis-app";
            Duration customCheckpointInterval = Seconds$.MODULE$.apply(30L);
            StorageLevel customStorageLevel = StorageLevel$.MODULE$.MEMORY_ONLY();
            SparkAWSCredentials customKinesisCreds = (SparkAWSCredentials)this.mock(ClassTag$.MODULE$.apply(SparkAWSCredentials.class));
            SparkAWSCredentials customDynamoDBCreds = (SparkAWSCredentials)this.mock(ClassTag$.MODULE$.apply(SparkAWSCredentials.class));
            SparkAWSCredentials customCloudWatchCreds = (SparkAWSCredentials)this.mock(ClassTag$.MODULE$.apply(SparkAWSCredentials.class));
            MetricsLevel customMetricsLevel = MetricsLevel.NONE;
            Set customMetricsEnabledDimensions = ((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(KinesisClientLibConfiguration.METRICS_ALWAYS_ENABLED_DIMENSIONS).asScala()).toSet();
            KinesisInputDStream dstream = this.builder().endpointUrl(customEndpointUrl).regionName(customRegion).initialPosition((KinesisInitialPosition)customInitialPosition).checkpointAppName(customAppName).checkpointInterval(customCheckpointInterval).storageLevel(customStorageLevel).kinesisCredentials(customKinesisCreds).dynamoDBCredentials(customDynamoDBCreds).cloudWatchCredentials(customCloudWatchCreds).metricsLevel(customMetricsLevel).metricsEnabledDimensions(customMetricsEnabledDimensions).build();
            String $org_scalatest_assert_macro_left = dstream.endpointUrl();
            String $org_scalatest_assert_macro_right = customEndpointUrl;
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KinesisInputDStreamBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 119));
            String $org_scalatest_assert_macro_left2 = dstream.regionName();
            String $org_scalatest_assert_macro_right2 = customRegion;
            String string3 = $org_scalatest_assert_macro_left2;
            String string4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("KinesisInputDStreamBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 120));
            KinesisInitialPosition $org_scalatest_assert_macro_left3 = dstream.initialPosition();
            KinesisInitialPositions.TrimHorizon $org_scalatest_assert_macro_right3 = customInitialPosition;
            KinesisInitialPosition kinesisInitialPosition = $org_scalatest_assert_macro_left3;
            KinesisInitialPositions.TrimHorizon trimHorizon = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(kinesisInitialPosition != null ? !kinesisInitialPosition.equals(trimHorizon) : trimHorizon != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("KinesisInputDStreamBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 121));
            String $org_scalatest_assert_macro_left4 = dstream.checkpointAppName();
            String $org_scalatest_assert_macro_right4 = customAppName;
            String string5 = $org_scalatest_assert_macro_left4;
            String string6 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("KinesisInputDStreamBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 122));
            Duration $org_scalatest_assert_macro_left5 = dstream.checkpointInterval();
            Duration $org_scalatest_assert_macro_right5 = customCheckpointInterval;
            Duration duration = $org_scalatest_assert_macro_left5;
            Duration duration2 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right5, !(duration != null ? !duration.equals(duration2) : duration2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("KinesisInputDStreamBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 123));
            StorageLevel $org_scalatest_assert_macro_left6 = dstream._storageLevel();
            StorageLevel $org_scalatest_assert_macro_right6 = customStorageLevel;
            StorageLevel storageLevel = $org_scalatest_assert_macro_left6;
            StorageLevel storageLevel2 = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "==", (Object)$org_scalatest_assert_macro_right6, !(storageLevel != null ? !storageLevel.equals(storageLevel2) : storageLevel2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("KinesisInputDStreamBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 124));
            SparkAWSCredentials $org_scalatest_assert_macro_left7 = dstream.kinesisCreds();
            SparkAWSCredentials $org_scalatest_assert_macro_right7 = customKinesisCreds;
            SparkAWSCredentials sparkAWSCredentials = $org_scalatest_assert_macro_left7;
            SparkAWSCredentials sparkAWSCredentials2 = $org_scalatest_assert_macro_right7;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "==", (Object)$org_scalatest_assert_macro_right7, !(sparkAWSCredentials != null ? !sparkAWSCredentials.equals(sparkAWSCredentials2) : sparkAWSCredentials2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("KinesisInputDStreamBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 125));
            Option $org_scalatest_assert_macro_left8 = dstream.dynamoDBCreds();
            Option $org_scalatest_assert_macro_right8 = Option$.MODULE$.apply((Object)customDynamoDBCreds);
            Option option = $org_scalatest_assert_macro_left8;
            Option option2 = $org_scalatest_assert_macro_right8;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", (Object)$org_scalatest_assert_macro_right8, !(option != null ? !option.equals(option2) : option2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("KinesisInputDStreamBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 126));
            Option $org_scalatest_assert_macro_left9 = dstream.cloudWatchCreds();
            Option $org_scalatest_assert_macro_right9 = Option$.MODULE$.apply((Object)customCloudWatchCreds);
            Option option3 = $org_scalatest_assert_macro_left9;
            Option option4 = $org_scalatest_assert_macro_right9;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "==", (Object)$org_scalatest_assert_macro_right9, !(option3 != null ? !option3.equals(option4) : option4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("KinesisInputDStreamBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 127));
            MetricsLevel $org_scalatest_assert_macro_left10 = dstream.metricsLevel();
            MetricsLevel $org_scalatest_assert_macro_right10 = customMetricsLevel;
            MetricsLevel metricsLevel = $org_scalatest_assert_macro_left10;
            MetricsLevel metricsLevel2 = $org_scalatest_assert_macro_right10;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "==", (Object)$org_scalatest_assert_macro_right10, !(metricsLevel != null ? !metricsLevel.equals(metricsLevel2) : metricsLevel2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("KinesisInputDStreamBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 128));
            Set $org_scalatest_assert_macro_left11 = dstream.metricsEnabledDimensions();
            Set $org_scalatest_assert_macro_right11 = customMetricsEnabledDimensions;
            Set set = $org_scalatest_assert_macro_left11;
            Set set2 = $org_scalatest_assert_macro_right11;
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "==", (Object)$org_scalatest_assert_macro_right11, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("KinesisInputDStreamBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 129));
            Calendar cal = Calendar.getInstance();
            cal.add(5, -1);
            Date timestamp = cal.getTime();
            KinesisInitialPositions.AtTimestamp initialPositionAtTimestamp = new KinesisInitialPositions.AtTimestamp(timestamp);
            KinesisInputDStream dstreamAtTimestamp = this.builder().endpointUrl(customEndpointUrl).regionName(customRegion).initialPosition((KinesisInitialPosition)initialPositionAtTimestamp).checkpointAppName(customAppName).checkpointInterval(customCheckpointInterval).storageLevel(customStorageLevel).kinesisCredentials(customKinesisCreds).dynamoDBCredentials(customDynamoDBCreds).cloudWatchCredentials(customCloudWatchCreds).metricsLevel(customMetricsLevel).metricsEnabledDimensions(customMetricsEnabledDimensions).build();
            String $org_scalatest_assert_macro_left12 = dstreamAtTimestamp.endpointUrl();
            String $org_scalatest_assert_macro_right12 = customEndpointUrl;
            String string7 = $org_scalatest_assert_macro_left12;
            String string8 = $org_scalatest_assert_macro_right12;
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "==", (Object)$org_scalatest_assert_macro_right12, !(string7 != null ? !string7.equals(string8) : string8 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("KinesisInputDStreamBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 150));
            String $org_scalatest_assert_macro_left13 = dstreamAtTimestamp.regionName();
            String $org_scalatest_assert_macro_right13 = customRegion;
            String string9 = $org_scalatest_assert_macro_left13;
            String string10 = $org_scalatest_assert_macro_right13;
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left13, "==", (Object)$org_scalatest_assert_macro_right13, !(string9 != null ? !string9.equals(string10) : string10 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("KinesisInputDStreamBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 151));
            InitialPositionInStream $org_scalatest_assert_macro_left14 = dstreamAtTimestamp.initialPosition().getPosition();
            InitialPositionInStream $org_scalatest_assert_macro_right14 = initialPositionAtTimestamp.getPosition();
            InitialPositionInStream initialPositionInStream = $org_scalatest_assert_macro_left14;
            InitialPositionInStream initialPositionInStream2 = $org_scalatest_assert_macro_right14;
            Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left14, "==", (Object)$org_scalatest_assert_macro_right14, !(initialPositionInStream != null ? !initialPositionInStream.equals(initialPositionInStream2) : initialPositionInStream2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("KinesisInputDStreamBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 152));
            Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.simpleMacroBool(((KinesisInitialPositions.AtTimestamp)dstreamAtTimestamp.initialPosition()).getTimestamp().equals(timestamp), "dstreamAtTimestamp.initialPosition.asInstanceOf[org.apache.spark.streaming.kinesis.KinesisInitialPositions.AtTimestamp].getTimestamp().equals(timestamp)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("KinesisInputDStreamBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 154));
            String $org_scalatest_assert_macro_left15 = dstreamAtTimestamp.checkpointAppName();
            String $org_scalatest_assert_macro_right15 = customAppName;
            String string11 = $org_scalatest_assert_macro_left15;
            String string12 = $org_scalatest_assert_macro_right15;
            Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left15, "==", (Object)$org_scalatest_assert_macro_right15, !(string11 != null ? !string11.equals(string12) : string12 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"", Prettifier$.MODULE$.default(), new Position("KinesisInputDStreamBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 156));
            Duration $org_scalatest_assert_macro_left16 = dstreamAtTimestamp.checkpointInterval();
            Duration $org_scalatest_assert_macro_right16 = customCheckpointInterval;
            Duration duration3 = $org_scalatest_assert_macro_left16;
            Duration duration4 = $org_scalatest_assert_macro_right16;
            Bool $org_scalatest_assert_macro_expr17 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left16, "==", (Object)$org_scalatest_assert_macro_right16, !(duration3 != null ? !duration3.equals(duration4) : duration4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr17, (Object)"", Prettifier$.MODULE$.default(), new Position("KinesisInputDStreamBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 157));
            StorageLevel $org_scalatest_assert_macro_left17 = dstreamAtTimestamp._storageLevel();
            StorageLevel $org_scalatest_assert_macro_right17 = customStorageLevel;
            StorageLevel storageLevel3 = $org_scalatest_assert_macro_left17;
            StorageLevel storageLevel4 = $org_scalatest_assert_macro_right17;
            Bool $org_scalatest_assert_macro_expr18 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left17, "==", (Object)$org_scalatest_assert_macro_right17, !(storageLevel3 != null ? !storageLevel3.equals(storageLevel4) : storageLevel4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr18, (Object)"", Prettifier$.MODULE$.default(), new Position("KinesisInputDStreamBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 158));
            SparkAWSCredentials $org_scalatest_assert_macro_left18 = dstreamAtTimestamp.kinesisCreds();
            SparkAWSCredentials $org_scalatest_assert_macro_right18 = customKinesisCreds;
            SparkAWSCredentials sparkAWSCredentials3 = $org_scalatest_assert_macro_left18;
            SparkAWSCredentials sparkAWSCredentials4 = $org_scalatest_assert_macro_right18;
            Bool $org_scalatest_assert_macro_expr19 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left18, "==", (Object)$org_scalatest_assert_macro_right18, !(sparkAWSCredentials3 != null ? !sparkAWSCredentials3.equals(sparkAWSCredentials4) : sparkAWSCredentials4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr19, (Object)"", Prettifier$.MODULE$.default(), new Position("KinesisInputDStreamBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 159));
            Option $org_scalatest_assert_macro_left19 = dstreamAtTimestamp.dynamoDBCreds();
            Option $org_scalatest_assert_macro_right19 = Option$.MODULE$.apply((Object)customDynamoDBCreds);
            Option option5 = $org_scalatest_assert_macro_left19;
            Option option6 = $org_scalatest_assert_macro_right19;
            Bool $org_scalatest_assert_macro_expr20 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left19, "==", (Object)$org_scalatest_assert_macro_right19, !(option5 != null ? !option5.equals(option6) : option6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr20, (Object)"", Prettifier$.MODULE$.default(), new Position("KinesisInputDStreamBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 160));
            Option $org_scalatest_assert_macro_left20 = dstreamAtTimestamp.cloudWatchCreds();
            Option $org_scalatest_assert_macro_right20 = Option$.MODULE$.apply((Object)customCloudWatchCreds);
            Option option7 = $org_scalatest_assert_macro_left20;
            Option option8 = $org_scalatest_assert_macro_right20;
            Bool $org_scalatest_assert_macro_expr21 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left20, "==", (Object)$org_scalatest_assert_macro_right20, !(option7 != null ? !option7.equals(option8) : option8 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr21, (Object)"", Prettifier$.MODULE$.default(), new Position("KinesisInputDStreamBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 161));
            MetricsLevel $org_scalatest_assert_macro_left21 = dstreamAtTimestamp.metricsLevel();
            MetricsLevel $org_scalatest_assert_macro_right21 = customMetricsLevel;
            MetricsLevel metricsLevel3 = $org_scalatest_assert_macro_left21;
            MetricsLevel metricsLevel4 = $org_scalatest_assert_macro_right21;
            Bool $org_scalatest_assert_macro_expr22 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left21, "==", (Object)$org_scalatest_assert_macro_right21, !(metricsLevel3 != null ? !metricsLevel3.equals(metricsLevel4) : metricsLevel4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr22, (Object)"", Prettifier$.MODULE$.default(), new Position("KinesisInputDStreamBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 162));
            Set $org_scalatest_assert_macro_left22 = dstreamAtTimestamp.metricsEnabledDimensions();
            Set $org_scalatest_assert_macro_right22 = customMetricsEnabledDimensions;
            Set set3 = $org_scalatest_assert_macro_left22;
            Set set4 = $org_scalatest_assert_macro_right22;
            Bool $org_scalatest_assert_macro_expr23 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left22, "==", (Object)$org_scalatest_assert_macro_right22, !(set3 != null ? !set3.equals(set4) : set4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr23, (Object)"", Prettifier$.MODULE$.default(), new Position("KinesisInputDStreamBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 163));
        }, new Position("KinesisInputDStreamBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 92));
        this.test("old Api should throw UnsupportedOperationExceptionexception with AT_TIMESTAMP", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String streamName = "a-very-nice-stream-name";
            String endpointUrl = "https://kinesis.us-west-2.amazonaws.com";
            String region = "us-west-2";
            String appName = "a-very-nice-kinesis-app";
            Duration checkpointInterval = Seconds$.MODULE$.apply(30L);
            StorageLevel storageLevel = StorageLevel$.MODULE$.MEMORY_ONLY();
            return (UnsupportedOperationException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                KinesisInputDStream kinesisDStream = KinesisInputDStream$.MODULE$.builder().streamingContext(this.ssc()).streamName(streamName).endpointUrl(endpointUrl).regionName(region).initialPositionInStream(InitialPositionInStream.AT_TIMESTAMP).checkpointAppName(appName).checkpointInterval(checkpointInterval).storageLevel(storageLevel).build();
            }, ClassTag$.MODULE$.apply(UnsupportedOperationException.class), new Position("KinesisInputDStreamBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 177));
        }, new Position("KinesisInputDStreamBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 166));
    }
}

