/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.kinesis;

import java.io.Serializable;
import org.apache.spark.LocalSparkContext;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkException;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockManager;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.apache.spark.storage.StreamBlockId;
import org.apache.spark.streaming.kinesis.KPLBasedKinesisTestUtils;
import org.apache.spark.streaming.kinesis.KPLBasedKinesisTestUtils$;
import org.apache.spark.streaming.kinesis.KinesisBackedBlockRDD;
import org.apache.spark.streaming.kinesis.KinesisBackedBlockRDD$;
import org.apache.spark.streaming.kinesis.KinesisFunSuite;
import org.apache.spark.streaming.kinesis.KinesisTestUtils;
import org.apache.spark.streaming.kinesis.SequenceNumberRange;
import org.apache.spark.streaming.kinesis.SequenceNumberRanges;
import org.apache.spark.streaming.kinesis.SequenceNumberRanges$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.compatible.Assertion;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u00055g!\u0002\u0013&\u0003\u0003\u0001\u0004\u0002\u0003\"\u0001\u0005\u0003\u0005\u000b\u0011B\"\t\u000b%\u0003A\u0011\u0001&\t\u000f5\u0003!\u0019!C\u0005\u001d\"11\f\u0001Q\u0001\n=Cq\u0001\u0018\u0001A\u0002\u0013%Q\fC\u0004b\u0001\u0001\u0007I\u0011\u00022\t\r!\u0004\u0001\u0015)\u0003_\u0011\u001dI\u0007\u00011A\u0005\n)D\u0001b \u0001A\u0002\u0013%\u0011\u0011\u0001\u0005\b\u0003\u000b\u0001\u0001\u0015)\u0003l\u0011%\t9\u0001\u0001a\u0001\n\u0013\tI\u0001C\u0005\u0002\u001a\u0001\u0001\r\u0011\"\u0003\u0002\u001c!A\u0011q\u0004\u0001!B\u0013\tY\u0001C\u0005\u0002\"\u0001\u0001\r\u0011\"\u0003\u0002$!I\u0011q\u0005\u0001A\u0002\u0013%\u0011\u0011\u0006\u0005\t\u0003[\u0001\u0001\u0015)\u0003\u0002&!I\u0011q\u0006\u0001A\u0002\u0013%\u0011\u0011\u0007\u0005\n\u0003{\u0001\u0001\u0019!C\u0005\u0003\u007fA\u0001\"a\u0011\u0001A\u0003&\u00111\u0007\u0005\n\u0003\u000b\u0002\u0001\u0019!C\u0005\u0003\u000fB\u0011\"!\u0015\u0001\u0001\u0004%I!a\u0015\t\u0011\u0005]\u0003\u0001)Q\u0005\u0003\u0013B\u0011\"!\u0017\u0001\u0001\u0004%I!a\u0017\t\u0013\u0005}\u0003\u00011A\u0005\n\u0005\u0005\u0004\u0002CA3\u0001\u0001\u0006K!!\u0018\t\u0013\u0005\u001d\u0004\u00011A\u0005\n\u0005%\u0004\"CA<\u0001\u0001\u0007I\u0011BA=\u0011!\ti\b\u0001Q!\n\u0005-\u0004bBA@\u0001\u0011\u0005\u0013\u0011\u0011\u0005\b\u0003\u0007\u0003A\u0011IAA\u0011\u001d\t)\t\u0001C!\u0003\u0003Cq!a\"\u0001\t\u0013\tI\tC\u0005\u0002 \u0002\t\n\u0011\"\u0003\u0002\"\"I\u0011q\u0017\u0001\u0012\u0002\u0013%\u0011\u0011\u0015\u0005\b\u0003s\u0003A\u0011BA^\u0005iY\u0015N\\3tSN\u0014\u0015mY6fI\ncwnY6S\t\u0012#Vm\u001d;t\u0015\t1s%A\u0004lS:,7/[:\u000b\u0005!J\u0013!C:ue\u0016\fW.\u001b8h\u0015\tQ3&A\u0003ta\u0006\u00148N\u0003\u0002-[\u00051\u0011\r]1dQ\u0016T\u0011AL\u0001\u0004_J<7\u0001A\n\u0006\u0001E*\u0014h\u0010\t\u0003eMj\u0011!K\u0005\u0003i%\u0012Qb\u00159be.4UO\\*vSR,\u0007C\u0001\u001c8\u001b\u0005)\u0013B\u0001\u001d&\u0005=Y\u0015N\\3tSN4UO\\*vSR,\u0007C\u0001\u001e>\u001b\u0005Y$B\u0001\u001f.\u0003%\u00198-\u00197bi\u0016\u001cH/\u0003\u0002?w\t\u0011\")\u001a4pe\u0016\fe\u000eZ!gi\u0016\u0014X)Y2i!\t\u0011\u0004)\u0003\u0002BS\t\tBj\\2bYN\u0003\u0018M]6D_:$X\r\u001f;\u0002#\u0005<wM]3hCR,G+Z:u\t\u0006$\u0018\r\u0005\u0002E\u000f6\tQIC\u0001G\u0003\u0015\u00198-\u00197b\u0013\tAUIA\u0004C_>dW-\u00198\u0002\rqJg.\u001b;?)\tYE\n\u0005\u00027\u0001!)!I\u0001a\u0001\u0007\u0006AA/Z:u\t\u0006$\u0018-F\u0001P!\t\u0001\u0006L\u0004\u0002R-6\t!K\u0003\u0002T)\u0006I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0003+\u0016\u000b!bY8mY\u0016\u001cG/[8o\u0013\t9&+A\u0003SC:<W-\u0003\u0002Z5\nI\u0011J\\2mkNLg/\u001a\u0006\u0003/J\u000b\u0011\u0002^3ti\u0012\u000bG/\u0019\u0011\u0002\u0013Q,7\u000f^+uS2\u001cX#\u00010\u0011\u0005Yz\u0016B\u00011&\u0005AY\u0015N\\3tSN$Vm\u001d;Vi&d7/A\u0007uKN$X\u000b^5mg~#S-\u001d\u000b\u0003G\u001a\u0004\"\u0001\u00123\n\u0005\u0015,%\u0001B+oSRDqa\u001a\u0004\u0002\u0002\u0003\u0007a,A\u0002yIE\n!\u0002^3tiV#\u0018\u000e\\:!\u0003!\u0019\b.\u0019:e\u0013\u0012\u001cX#A6\u0011\u00071$xO\u0004\u0002ne:\u0011a.]\u0007\u0002_*\u0011\u0001oL\u0001\u0007yI|w\u000e\u001e \n\u0003\u0019K!a]#\u0002\u000fA\f7m[1hK&\u0011QO\u001e\u0002\u0004'\u0016\f(BA:F!\tAHP\u0004\u0002zuB\u0011a.R\u0005\u0003w\u0016\u000ba\u0001\u0015:fI\u00164\u0017BA?\u007f\u0005\u0019\u0019FO]5oO*\u001110R\u0001\rg\"\f'\u000fZ%eg~#S-\u001d\u000b\u0004G\u0006\r\u0001bB4\n\u0003\u0003\u0005\ra[\u0001\ng\"\f'\u000fZ%eg\u0002\nQb\u001d5be\u0012LE\rV8ECR\fWCAA\u0006!\u0019A\u0018QB<\u0002\u0012%\u0019\u0011q\u0002@\u0003\u00075\u000b\u0007\u000f\u0005\u0003mi\u0006M\u0001c\u0001#\u0002\u0016%\u0019\u0011qC#\u0003\u0007%sG/A\ttQ\u0006\u0014H-\u00133U_\u0012\u000bG/Y0%KF$2aYA\u000f\u0011!9G\"!AA\u0002\u0005-\u0011AD:iCJ$\u0017\n\u001a+p\t\u0006$\u0018\rI\u0001\u0014g\"\f'\u000fZ%e)>\u001cV-\u001d(v[\n,'o]\u000b\u0003\u0003K\u0001R\u0001_A\u0007o.\fqc\u001d5be\u0012LE\rV8TKFtU/\u001c2feN|F%Z9\u0015\u0007\r\fY\u0003\u0003\u0005h\u001f\u0005\u0005\t\u0019AA\u0013\u0003Q\u0019\b.\u0019:e\u0013\u0012$vnU3r\u001dVl'-\u001a:tA\u0005Q2\u000f[1sI&#Gk\u001c#bi\u0006\fe\u000eZ*fc:+XNY3sgV\u0011\u00111\u0007\t\u0007q\u00065q/!\u000e\u0011\t1$\u0018q\u0007\t\u0007\t\u0006e\u00121C<\n\u0007\u0005mRI\u0001\u0004UkBdWMM\u0001\u001fg\"\f'\u000fZ%e)>$\u0015\r^1B]\u0012\u001cV-\u001d(v[\n,'o]0%KF$2aYA!\u0011!9'#!AA\u0002\u0005M\u0012aG:iCJ$\u0017\n\u001a+p\t\u0006$\u0018-\u00118e'\u0016\fh*^7cKJ\u001c\b%\u0001\btQ\u0006\u0014H-\u00133U_J\u000bgnZ3\u0016\u0005\u0005%\u0003C\u0002=\u0002\u000e]\fY\u0005E\u00027\u0003\u001bJ1!a\u0014&\u0005M\u0019V-];f]\u000e,g*^7cKJ\u0014\u0016M\\4f\u0003I\u0019\b.\u0019:e\u0013\u0012$vNU1oO\u0016|F%Z9\u0015\u0007\r\f)\u0006\u0003\u0005h+\u0005\u0005\t\u0019AA%\u0003=\u0019\b.\u0019:e\u0013\u0012$vNU1oO\u0016\u0004\u0013!C1mYJ\u000bgnZ3t+\t\ti\u0006\u0005\u0003mi\u0006-\u0013!D1mYJ\u000bgnZ3t?\u0012*\u0017\u000fF\u0002d\u0003GB\u0001b\u001a\r\u0002\u0002\u0003\u0007\u0011QL\u0001\u000bC2d'+\u00198hKN\u0004\u0013\u0001\u00042m_\u000e\\W*\u00198bO\u0016\u0014XCAA6!\u0011\ti'a\u001d\u000e\u0005\u0005=$bAA9S\u000591\u000f^8sC\u001e,\u0017\u0002BA;\u0003_\u0012AB\u00117pG.l\u0015M\\1hKJ\f\u0001C\u00197pG.l\u0015M\\1hKJ|F%Z9\u0015\u0007\r\fY\b\u0003\u0005h7\u0005\u0005\t\u0019AA6\u00035\u0011Gn\\2l\u001b\u0006t\u0017mZ3sA\u0005I!-\u001a4pe\u0016\fE\u000e\u001c\u000b\u0002G\u0006Q!-\u001a4pe\u0016,\u0015m\u00195\u0002\u0011\u00054G/\u001a:BY2\fq\u0001^3tiJ#E\tF\u0006d\u0003\u0017\u000by)a%\u0002\u0018\u0006m\u0005bBAGA\u0001\u0007\u00111C\u0001\u000e]Vl\u0007+\u0019:uSRLwN\\:\t\u000f\u0005E\u0005\u00051\u0001\u0002\u0014\u0005\tb.^7QCJ$\u0018\u000e^5p]NLeNQ'\t\u000f\u0005U\u0005\u00051\u0001\u0002\u0014\u00051b.^7QCJ$\u0018\u000e^5p]NLenS5oKNL7\u000f\u0003\u0005\u0002\u001a\u0002\u0002\n\u00111\u0001D\u0003A!Xm\u001d;Jg\ncwnY6WC2LG\r\u0003\u0005\u0002\u001e\u0002\u0002\n\u00111\u0001D\u0003=!Xm\u001d;CY>\u001c7NU3n_Z,\u0017!\u0005;fgR\u0014F\t\u0012\u0013eK\u001a\fW\u000f\u001c;%iU\u0011\u00111\u0015\u0016\u0004\u0007\u0006\u00156FAAT!\u0011\tI+a-\u000e\u0005\u0005-&\u0002BAW\u0003_\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005EV)\u0001\u0006b]:|G/\u0019;j_:LA!!.\u0002,\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002#Q,7\u000f\u001e*E\t\u0012\"WMZ1vYR$S'\u0001\u0007gC.,'\t\\8dW&#7\u000f\u0006\u0003\u0002>\u0006%\u0007#\u0002#\u0002@\u0006\r\u0017bAAa\u000b\n)\u0011I\u001d:bsB!\u0011QNAc\u0013\u0011\t9-a\u001c\u0003\u000f\tcwnY6JI\"9\u00111Z\u0012A\u0002\u0005M\u0011a\u00018v[\u0002")
public abstract class KinesisBackedBlockRDDTests
extends SparkFunSuite
implements KinesisFunSuite,
LocalSparkContext {
    private final boolean aggregateTestData;
    private final Range.Inclusive testData;
    private KinesisTestUtils testUtils;
    private Seq<String> shardIds;
    private Map<String, Seq<Object>> shardIdToData;
    private Map<String, Seq<String>> shardIdToSeqNumbers;
    private Map<String, Seq<Tuple2<Object, String>>> shardIdToDataAndSeqNumbers;
    private Map<String, SequenceNumberRange> shardIdToRange;
    private Seq<SequenceNumberRange> allRanges;
    private BlockManager blockManager;
    private transient SparkContext sc;

    public /* synthetic */ void org$apache$spark$LocalSparkContext$$super$beforeAll() {
        super.beforeAll();
    }

    public /* synthetic */ void org$apache$spark$LocalSparkContext$$super$afterEach() {
        BeforeAndAfterEach.afterEach$((BeforeAndAfterEach)this);
    }

    public void afterEach() {
        LocalSparkContext.afterEach$((LocalSparkContext)this);
    }

    public void resetSparkContext() {
        LocalSparkContext.resetSparkContext$((LocalSparkContext)this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$streaming$kinesis$KinesisFunSuite$$super$test(String testName, Seq testTags, Function0 testBody, Position pos) {
        super.test(testName, testTags, testBody, pos);
    }

    @Override
    public void testIfEnabled(String testName, Function0<BoxedUnit> testBody) {
        KinesisFunSuite.testIfEnabled$(this, testName, testBody);
    }

    @Override
    public void runIfTestsEnabled(String message, Function0<BoxedUnit> body) {
        KinesisFunSuite.runIfTestsEnabled$(this, message, body);
    }

    public SparkContext sc() {
        return this.sc;
    }

    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    private Range.Inclusive testData() {
        return this.testData;
    }

    private KinesisTestUtils testUtils() {
        return this.testUtils;
    }

    private void testUtils_$eq(KinesisTestUtils x$1) {
        this.testUtils = x$1;
    }

    private Seq<String> shardIds() {
        return this.shardIds;
    }

    private void shardIds_$eq(Seq<String> x$1) {
        this.shardIds = x$1;
    }

    private Map<String, Seq<Object>> shardIdToData() {
        return this.shardIdToData;
    }

    private void shardIdToData_$eq(Map<String, Seq<Object>> x$1) {
        this.shardIdToData = x$1;
    }

    private Map<String, Seq<String>> shardIdToSeqNumbers() {
        return this.shardIdToSeqNumbers;
    }

    private void shardIdToSeqNumbers_$eq(Map<String, Seq<String>> x$1) {
        this.shardIdToSeqNumbers = x$1;
    }

    private Map<String, Seq<Tuple2<Object, String>>> shardIdToDataAndSeqNumbers() {
        return this.shardIdToDataAndSeqNumbers;
    }

    private void shardIdToDataAndSeqNumbers_$eq(Map<String, Seq<Tuple2<Object, String>>> x$1) {
        this.shardIdToDataAndSeqNumbers = x$1;
    }

    private Map<String, SequenceNumberRange> shardIdToRange() {
        return this.shardIdToRange;
    }

    private void shardIdToRange_$eq(Map<String, SequenceNumberRange> x$1) {
        this.shardIdToRange = x$1;
    }

    private Seq<SequenceNumberRange> allRanges() {
        return this.allRanges;
    }

    private void allRanges_$eq(Seq<SequenceNumberRange> x$1) {
        this.allRanges = x$1;
    }

    private BlockManager blockManager() {
        return this.blockManager;
    }

    private void blockManager_$eq(BlockManager x$1) {
        this.blockManager = x$1;
    }

    public void beforeAll() {
        LocalSparkContext.beforeAll$((LocalSparkContext)this);
        this.runIfTestsEnabled("Prepare KinesisTestUtils", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.testUtils_$eq(new KPLBasedKinesisTestUtils(KPLBasedKinesisTestUtils$.MODULE$.$lessinit$greater$default$1()));
            this.testUtils().createStream();
            this.shardIdToDataAndSeqNumbers_$eq((Map<String, Seq<Tuple2<Object, String>>>)this.testUtils().pushData((Seq)this.testData(), $this.aggregateTestData));
            Predef$.MODULE$.require(this.shardIdToDataAndSeqNumbers().size() > 1, (Function0 & Serializable & scala.Serializable)() -> "Need data to be sent to multiple shards");
            this.shardIds_$eq((Seq<String>)this.shardIdToDataAndSeqNumbers().keySet().toSeq());
            this.shardIdToData_$eq((Map<String, Seq<Object>>)this.shardIdToDataAndSeqNumbers().mapValues((Function1 & Serializable & scala.Serializable)x$1 -> (Seq)x$1.map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2._1$mcI$sp()), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
            this.shardIdToSeqNumbers_$eq((Map<String, Seq<String>>)this.shardIdToDataAndSeqNumbers().mapValues((Function1 & Serializable & scala.Serializable)x$3 -> (Seq)x$3.map((Function1 & Serializable & scala.Serializable)x$4 -> (String)x$4._2(), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
            this.shardIdToRange_$eq((Map<String, SequenceNumberRange>)((Map)this.shardIdToSeqNumbers().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String shardId = (String)tuple2._1();
                    Seq seqNumbers = (Seq)tuple2._2();
                    SequenceNumberRange seqNumRange = new SequenceNumberRange(this.testUtils().streamName(), shardId, (String)seqNumbers.head(), (String)seqNumbers.last(), seqNumbers.size());
                    return new Tuple2((Object)shardId, (Object)seqNumRange);
                }
                throw new MatchError((Object)tuple2);
            }, Map$.MODULE$.canBuildFrom())));
            this.allRanges_$eq((Seq<SequenceNumberRange>)this.shardIdToRange().values().toSeq());
        });
    }

    public void beforeEach() {
        BeforeAndAfterEach.beforeEach$((BeforeAndAfterEach)this);
        SparkConf conf = new SparkConf().setMaster("local[4]").setAppName("KinesisBackedBlockRDDSuite");
        this.sc_$eq(new SparkContext(conf));
        this.blockManager_$eq(this.sc().env().blockManager());
    }

    public void afterAll() {
        try {
            if (this.testUtils() != null) {
                this.testUtils().deleteStream();
            }
        }
        finally {
            super.afterAll();
        }
    }

    private void testRDD(int numPartitions, int numPartitionsInBM, int numPartitionsInKinesis, boolean testIsBlockValid, boolean testBlockRemove) {
        Object object;
        Predef$.MODULE$.require(this.shardIds().size() > 1, (Function0 & Serializable & scala.Serializable)() -> "Need at least 2 shards to test");
        Predef$.MODULE$.require(numPartitionsInBM <= this.shardIds().size(), (Function0 & Serializable & scala.Serializable)() -> "Number of partitions in BlockManager cannot be more than the Kinesis test shards available");
        Predef$.MODULE$.require(numPartitionsInKinesis <= this.shardIds().size(), (Function0 & Serializable & scala.Serializable)() -> "Number of partitions in Kinesis cannot be more than the Kinesis test shards available");
        Predef$.MODULE$.require(numPartitionsInBM <= numPartitions, (Function0 & Serializable & scala.Serializable)() -> "Number of partitions in BlockManager cannot be more than that in RDD");
        Predef$.MODULE$.require(numPartitionsInKinesis <= numPartitions, (Function0 & Serializable & scala.Serializable)() -> "Number of partitions in Kinesis cannot be more than that in RDD");
        BlockId[] blockIds = this.fakeBlockIds(numPartitions);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])blockIds)).foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
            KinesisBackedBlockRDDTests.$anonfun$testRDD$6(this, x$5);
            return BoxedUnit.UNIT;
        });
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numPartitionsInBM).foreach((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)i -> {
            Iterator blockData = ((IterableLike)this.shardIdToData().apply(this.shardIds().apply(i))).iterator().map((Function1 & Serializable & scala.Serializable)x$6 -> KinesisBackedBlockRDDTests.$anonfun$testRDD$8(BoxesRunTime.unboxToInt((Object)x$6)));
            BlockManager qual$2 = this.blockManager();
            BlockId x$3 = blockIds[i];
            Iterator x$4 = blockData;
            StorageLevel x$5 = StorageLevel$.MODULE$.MEMORY_ONLY();
            boolean x$62 = qual$2.putIterator$default$4();
            return qual$2.putIterator(x$3, x$4, x$5, x$62, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
        });
        SequenceNumberRanges[] fakeRanges = (SequenceNumberRanges[])Array$.MODULE$.fill(numPartitions - numPartitionsInKinesis, (Function0 & Serializable & scala.Serializable)() -> SequenceNumberRanges$.MODULE$.apply(new SequenceNumberRange("fakeStream", "fakeShardId", "xxx", "yyy", 1)), ClassTag$.MODULE$.apply(SequenceNumberRanges.class));
        SequenceNumberRanges[] realRanges = (SequenceNumberRanges[])Array$.MODULE$.tabulate(numPartitionsInKinesis, (Function1 & Serializable & scala.Serializable)i -> KinesisBackedBlockRDDTests.$anonfun$testRDD$10(this, numPartitions, numPartitionsInKinesis, BoxesRunTime.unboxToInt((Object)i)), ClassTag$.MODULE$.apply(SequenceNumberRanges.class));
        SequenceNumberRanges[] ranges = (SequenceNumberRanges[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fakeRanges)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])realRanges)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(SequenceNumberRanges.class)));
        Predef$.MODULE$.require(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])blockIds)).take(numPartitionsInBM))).forall((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)KinesisBackedBlockRDDTests.$anonfun$testRDD$11(this, x$7))), (Function0 & Serializable & scala.Serializable)() -> "Expected blocks not in BlockManager");
        Predef$.MODULE$.require(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])blockIds)).drop(numPartitionsInBM))).forall((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)KinesisBackedBlockRDDTests.$anonfun$testRDD$13(this, x$8))), (Function0 & Serializable & scala.Serializable)() -> "Unexpected blocks in BlockManager");
        Predef$.MODULE$.require(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ranges)).takeRight(numPartitionsInKinesis))).forall((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)KinesisBackedBlockRDDTests.$anonfun$testRDD$15(this, x$9))), (Function0 & Serializable & scala.Serializable)() -> "Incorrect configuration of RDD, expected ranges not set: ");
        Predef$.MODULE$.require(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ranges)).dropRight(numPartitionsInKinesis))).forall((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)KinesisBackedBlockRDDTests.$anonfun$testRDD$18(this, x$11))), (Function0 & Serializable & scala.Serializable)() -> "Incorrect configuration of RDD, unexpected ranges set");
        KinesisBackedBlockRDD rdd = new KinesisBackedBlockRDD(this.sc(), this.testUtils().regionName(), this.testUtils().endpointUrl(), blockIds, ranges, KinesisBackedBlockRDD$.MODULE$.$lessinit$greater$default$6(), KinesisBackedBlockRDD$.MODULE$.$lessinit$greater$default$7(), KinesisBackedBlockRDD$.MODULE$.$lessinit$greater$default$8(), KinesisBackedBlockRDD$.MODULE$.$lessinit$greater$default$9(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
        int[] collectedData = (int[])rdd.map((Function1 & Serializable & scala.Serializable)bytes -> BoxesRunTime.boxToInteger((int)KinesisBackedBlockRDDTests.$anonfun$testRDD$21(bytes)), ClassTag$.MODULE$.Int()).collect();
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(collectedData)).toSet());
        Set $org_scalatest_assert_macro_right = this.testData().toSet();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KinesisBackedBlockRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 221));
        if (testIsBlockValid) {
            Predef$.MODULE$.require(this.convertToEqualizer(BoxesRunTime.boxToInteger((int)numPartitionsInBM)).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)numPartitions), Equality$.MODULE$.default()), (Function0 & Serializable & scala.Serializable)() -> "All partitions must be in BlockManager");
            Predef$.MODULE$.require(this.convertToEqualizer(BoxesRunTime.boxToInteger((int)numPartitionsInKinesis)).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)0), Equality$.MODULE$.default()), (Function0 & Serializable & scala.Serializable)() -> "No partitions must be in Kinesis");
            KinesisBackedBlockRDD rdd2 = new KinesisBackedBlockRDD(this.sc(), this.testUtils().regionName(), this.testUtils().endpointUrl(), (BlockId[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])blockIds)).toArray(ClassTag$.MODULE$.apply(BlockId.class)), ranges, (boolean[])Array$.MODULE$.fill(blockIds.length, (Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false, ClassTag$.MODULE$.Boolean()), KinesisBackedBlockRDD$.MODULE$.$lessinit$greater$default$7(), KinesisBackedBlockRDD$.MODULE$.$lessinit$greater$default$8(), KinesisBackedBlockRDD$.MODULE$.$lessinit$greater$default$9(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
            object = this.intercept((Function0 & Serializable & scala.Serializable)() -> (byte[][])rdd2.collect(), ClassTag$.MODULE$.apply(SparkException.class), new Position("KinesisBackedBlockRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 233));
        } else {
            object = BoxedUnit.UNIT;
        }
        if (testBlockRemove) {
            Predef$.MODULE$.require(this.convertToEqualizer(BoxesRunTime.boxToInteger((int)numPartitions)).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)numPartitionsInKinesis), Equality$.MODULE$.default()), (Function0 & Serializable & scala.Serializable)() -> "All partitions must be in WAL for this test");
            Predef$.MODULE$.require(numPartitionsInBM > 0, (Function0 & Serializable & scala.Serializable)() -> "Some partitions must be in BlockManager for this test");
            rdd.removeBlocks();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])rdd.map((Function1 & Serializable & scala.Serializable)bytes -> BoxesRunTime.boxToInteger((int)KinesisBackedBlockRDDTests.$anonfun$testRDD$28(bytes)), ClassTag$.MODULE$.Int()).collect())).toSet());
            Set $org_scalatest_assert_macro_right2 = this.testData().toSet();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("KinesisBackedBlockRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 245));
            return;
        }
    }

    private boolean testRDD$default$4() {
        return false;
    }

    private boolean testRDD$default$5() {
        return false;
    }

    private BlockId[] fakeBlockIds(int num) {
        return (BlockId[])Array$.MODULE$.tabulate(num, (Function1 & Serializable & scala.Serializable)i -> KinesisBackedBlockRDDTests.$anonfun$fakeBlockIds$1(BoxesRunTime.unboxToInt((Object)i)), ClassTag$.MODULE$.apply(BlockId.class));
    }

    public static final /* synthetic */ int $anonfun$new$2(byte[] bytes) {
        return new StringOps(Predef$.MODULE$.augmentString(new String(bytes))).toInt();
    }

    public static final /* synthetic */ int $anonfun$new$4(byte[] bytes) {
        return new StringOps(Predef$.MODULE$.augmentString(new String(bytes))).toInt();
    }

    public static final /* synthetic */ int $anonfun$new$6(byte[] bytes) {
        return new StringOps(Predef$.MODULE$.augmentString(new String(bytes))).toInt();
    }

    public static final /* synthetic */ Assertion $anonfun$new$7(KinesisBackedBlockRDDTests $this, int[][] receivedData3$1, int i) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(receivedData3$1[i])).toSeq());
        Seq $org_scalatest_assert_macro_right = (Seq)$this.shardIdToData().apply((Object)((SequenceNumberRange)$this.allRanges().apply(i)).shardId());
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KinesisBackedBlockRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 100));
    }

    public static final /* synthetic */ void $anonfun$testRDD$6(KinesisBackedBlockRDDTests $this, BlockId x$5) {
        BlockManager qual$1 = $this.blockManager();
        BlockId x$1 = x$5;
        boolean x$2 = qual$1.removeBlock$default$2();
        qual$1.removeBlock(x$1, x$2);
    }

    public static final /* synthetic */ byte[] $anonfun$testRDD$8(int x$6) {
        return Integer.toString(x$6).getBytes();
    }

    public static final /* synthetic */ SequenceNumberRanges $anonfun$testRDD$10(KinesisBackedBlockRDDTests $this, int numPartitions$1, int numPartitionsInKinesis$1, int i) {
        SequenceNumberRange range = (SequenceNumberRange)$this.shardIdToRange().apply($this.shardIds().apply(i + (numPartitions$1 - numPartitionsInKinesis$1)));
        return new SequenceNumberRanges((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceNumberRange[]{range}));
    }

    public static final /* synthetic */ boolean $anonfun$testRDD$11(KinesisBackedBlockRDDTests $this, BlockId x$7) {
        return $this.blockManager().get(x$7, ClassTag$.MODULE$.Nothing()).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$testRDD$13(KinesisBackedBlockRDDTests $this, BlockId x$8) {
        return $this.blockManager().get(x$8, ClassTag$.MODULE$.Nothing()).isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$testRDD$16(KinesisBackedBlockRDDTests $this, SequenceNumberRange x$10) {
        String string = x$10.streamName();
        String string2 = $this.testUtils().streamName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testRDD$15(KinesisBackedBlockRDDTests $this, SequenceNumberRanges x$9) {
        return x$9.ranges().forall((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)KinesisBackedBlockRDDTests.$anonfun$testRDD$16($this, x$10)));
    }

    public static final /* synthetic */ boolean $anonfun$testRDD$19(KinesisBackedBlockRDDTests $this, SequenceNumberRange x$12) {
        String string = x$12.streamName();
        String string2 = $this.testUtils().streamName();
        return string == null ? string2 != null : !string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testRDD$18(KinesisBackedBlockRDDTests $this, SequenceNumberRanges x$11) {
        return x$11.ranges().forall((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)KinesisBackedBlockRDDTests.$anonfun$testRDD$19($this, x$12)));
    }

    public static final /* synthetic */ int $anonfun$testRDD$21(byte[] bytes) {
        return new StringOps(Predef$.MODULE$.augmentString(new String(bytes))).toInt();
    }

    public static final /* synthetic */ int $anonfun$testRDD$28(byte[] bytes) {
        return new StringOps(Predef$.MODULE$.augmentString(new String(bytes))).toInt();
    }

    public static final /* synthetic */ StreamBlockId $anonfun$fakeBlockIds$1(int i) {
        return new StreamBlockId(0, (long)i);
    }

    public KinesisBackedBlockRDDTests(boolean aggregateTestData) {
        this.aggregateTestData = aggregateTestData;
        KinesisFunSuite.$init$(this);
        LocalSparkContext.$init$((LocalSparkContext)this);
        this.testData = RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 8);
        this.testUtils = null;
        this.shardIds = null;
        this.shardIdToData = null;
        this.shardIdToSeqNumbers = null;
        this.shardIdToDataAndSeqNumbers = null;
        this.shardIdToRange = null;
        this.allRanges = null;
        this.blockManager = null;
        this.testIfEnabled("Basic reading from Kinesis", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            int[] receivedData1 = (int[])new KinesisBackedBlockRDD(this.sc(), this.testUtils().regionName(), this.testUtils().endpointUrl(), this.fakeBlockIds(1), (SequenceNumberRanges[])((Object[])new SequenceNumberRanges[]{new SequenceNumberRanges((Seq)Predef$.MODULE$.wrapRefArray((Object[])this.allRanges().toArray(ClassTag$.MODULE$.apply(SequenceNumberRange.class))))}), KinesisBackedBlockRDD$.MODULE$.$lessinit$greater$default$6(), KinesisBackedBlockRDD$.MODULE$.$lessinit$greater$default$7(), KinesisBackedBlockRDD$.MODULE$.$lessinit$greater$default$8(), KinesisBackedBlockRDD$.MODULE$.$lessinit$greater$default$9(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE))).map((Function1 & Serializable & scala.Serializable)bytes -> BoxesRunTime.boxToInteger((int)KinesisBackedBlockRDDTests.$anonfun$new$2(bytes)), ClassTag$.MODULE$.Int()).collect();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(receivedData1)).toSet());
            Set $org_scalatest_assert_macro_right = this.testData().toSet();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KinesisBackedBlockRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
            int[] receivedData2 = (int[])new KinesisBackedBlockRDD(this.sc(), this.testUtils().regionName(), this.testUtils().endpointUrl(), this.fakeBlockIds(this.allRanges().size()), (SequenceNumberRanges[])((TraversableOnce)this.allRanges().map((Function1 & Serializable & scala.Serializable)range -> new SequenceNumberRanges((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceNumberRange[]{range})), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(SequenceNumberRanges.class)), KinesisBackedBlockRDD$.MODULE$.$lessinit$greater$default$6(), KinesisBackedBlockRDD$.MODULE$.$lessinit$greater$default$7(), KinesisBackedBlockRDD$.MODULE$.$lessinit$greater$default$8(), KinesisBackedBlockRDD$.MODULE$.$lessinit$greater$default$9(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE))).map((Function1 & Serializable & scala.Serializable)bytes -> BoxesRunTime.boxToInteger((int)KinesisBackedBlockRDDTests.$anonfun$new$4(bytes)), ClassTag$.MODULE$.Int()).collect();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(receivedData2)).toSet());
            Set $org_scalatest_assert_macro_right2 = this.testData().toSet();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("KinesisBackedBlockRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91));
            int[][] receivedData3 = (int[][])new KinesisBackedBlockRDD(this.sc(), this.testUtils().regionName(), this.testUtils().endpointUrl(), this.fakeBlockIds(this.allRanges().size()), (SequenceNumberRanges[])((TraversableOnce)this.allRanges().map((Function1 & Serializable & scala.Serializable)range -> new SequenceNumberRanges((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceNumberRange[]{range})), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(SequenceNumberRanges.class)), KinesisBackedBlockRDD$.MODULE$.$lessinit$greater$default$6(), KinesisBackedBlockRDD$.MODULE$.$lessinit$greater$default$7(), KinesisBackedBlockRDD$.MODULE$.$lessinit$greater$default$8(), KinesisBackedBlockRDD$.MODULE$.$lessinit$greater$default$9(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE))).map((Function1 & Serializable & scala.Serializable)bytes -> BoxesRunTime.boxToInteger((int)KinesisBackedBlockRDDTests.$anonfun$new$6(bytes)), ClassTag$.MODULE$.Int()).collectPartitions();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)receivedData3.length));
            int $org_scalatest_assert_macro_right3 = this.allRanges().size();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("KinesisBackedBlockRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 98));
            this.allRanges().indices().foreach((Function1 & Serializable & scala.Serializable)i -> KinesisBackedBlockRDDTests.$anonfun$new$7(this, receivedData3, BoxesRunTime.unboxToInt((Object)i)));
        });
        this.testIfEnabled("Read data available in both block manager and Kinesis", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testRDD(2, 2, 2, this.testRDD$default$4(), this.testRDD$default$5()));
        this.testIfEnabled("Read data available only in block manager, not in Kinesis", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testRDD(2, 2, 0, this.testRDD$default$4(), this.testRDD$default$5()));
        this.testIfEnabled("Read data available only in Kinesis, not in block manager", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testRDD(2, 0, 2, this.testRDD$default$4(), this.testRDD$default$5()));
        this.testIfEnabled("Read data available partially in block manager, rest in Kinesis", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testRDD(2, 1, 1, this.testRDD$default$4(), this.testRDD$default$5()));
        this.testIfEnabled("Test isBlockValid skips block fetching from block manager", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testRDD(2, 2, 0, true, this.testRDD$default$5()));
        this.testIfEnabled("Test whether RDD is valid after removing blocks from block manager", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            int x$1 = 2;
            int x$2 = 2;
            int x$3 = 2;
            boolean x$4 = true;
            boolean x$5 = this.testRDD$default$4();
            this.testRDD(x$1, x$2, x$3, x$5, x$4);
        });
    }
}

