/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.kinesis;

import com.amazonaws.services.kinesis.producer.KinesisProducer;
import com.amazonaws.services.kinesis.producer.KinesisProducerConfiguration;
import com.amazonaws.services.kinesis.producer.UserRecordResult;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.Executor;
import org.apache.spark.streaming.kinesis.KinesisDataGenerator;
import org.apache.spark.util.ThreadUtils$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashMap;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001M3Q!\u0002\u0004\u0001\rAA\u0001b\u0007\u0001\u0003\u0002\u0003\u0006I!\b\u0005\u0006Q\u0001!\t!\u000b\u0005\tY\u0001A)\u0019!C\u0005[!)!\b\u0001C!w\t\u00012\n\u0015'ECR\fw)\u001a8fe\u0006$xN\u001d\u0006\u0003\u000f!\tqa[5oKNL7O\u0003\u0002\n\u0015\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003\u00171\tQa\u001d9be.T!!\u0004\b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0011aA8sON\u0019\u0001!E\f\u0011\u0005I)R\"A\n\u000b\u0003Q\tQa]2bY\u0006L!AF\n\u0003\r\u0005s\u0017PU3g!\tA\u0012$D\u0001\u0007\u0013\tQbA\u0001\u000bLS:,7/[:ECR\fw)\u001a8fe\u0006$xN]\u0001\u000be\u0016<\u0017n\u001c8OC6,7\u0001\u0001\t\u0003=\u0015r!aH\u0012\u0011\u0005\u0001\u001aR\"A\u0011\u000b\u0005\tb\u0012A\u0002\u001fs_>$h(\u0003\u0002%'\u00051\u0001K]3eK\u001aL!AJ\u0014\u0003\rM#(/\u001b8h\u0015\t!3#\u0001\u0004=S:LGO\u0010\u000b\u0003U-\u0002\"\u0001\u0007\u0001\t\u000bm\u0011\u0001\u0019A\u000f\u0002\u0011A\u0014x\u000eZ;dKJ,\u0012A\f\t\u0003_aj\u0011\u0001\r\u0006\u0003YER!a\u0002\u001a\u000b\u0005M\"\u0014\u0001C:feZL7-Z:\u000b\u0005U2\u0014!C1nCj|g.Y<t\u0015\u00059\u0014aA2p[&\u0011\u0011\b\r\u0002\u0010\u0017&tWm]5t!J|G-^2fe\u0006A1/\u001a8e\t\u0006$\u0018\rF\u0002=\u001dB\u0003BAH\u001f\u001e\u007f%\u0011ah\n\u0002\u0004\u001b\u0006\u0004\bc\u0001!F\u0011:\u0011\u0011i\u0011\b\u0003A\tK\u0011\u0001F\u0005\u0003\tN\tq\u0001]1dW\u0006<W-\u0003\u0002G\u000f\n\u00191+Z9\u000b\u0005\u0011\u001b\u0002\u0003\u0002\nJ\u0017vI!AS\n\u0003\rQ+\b\u000f\\33!\t\u0011B*\u0003\u0002N'\t\u0019\u0011J\u001c;\t\u000b=#\u0001\u0019A\u000f\u0002\u0015M$(/Z1n\u001d\u0006lW\rC\u0003R\t\u0001\u0007!+\u0001\u0003eCR\f\u0007c\u0001!F\u0017\u0002")
public class KPLDataGenerator
implements KinesisDataGenerator {
    private KinesisProducer producer;
    private final String regionName;
    private volatile boolean bitmap$0;

    private KinesisProducer producer$lzycompute() {
        KPLDataGenerator kPLDataGenerator = this;
        synchronized (kPLDataGenerator) {
            if (!this.bitmap$0) {
                KinesisProducerConfiguration conf = new KinesisProducerConfiguration().setRecordMaxBufferedTime(1000L).setMaxConnections(1L).setRegion(this.regionName).setMetricsLevel("none");
                this.producer = new KinesisProducer(conf);
                this.bitmap$0 = true;
            }
        }
        return this.producer;
    }

    private KinesisProducer producer() {
        if (!this.bitmap$0) {
            return this.producer$lzycompute();
        }
        return this.producer;
    }

    public Map<String, Seq<Tuple2<Object, String>>> sendData(String streamName, Seq<Object> data) {
        HashMap shardIdToSeqNumbers = new HashMap();
        data.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)num -> {
            String str = Integer.toString(num);
            ByteBuffer data = ByteBuffer.wrap(str.getBytes(StandardCharsets.UTF_8));
            ListenableFuture future = this.producer().addUserRecord(streamName, str, data);
            FutureCallback<UserRecordResult> kinesisCallBack = new FutureCallback<UserRecordResult>(null, shardIdToSeqNumbers, num){
                private final HashMap shardIdToSeqNumbers$1;
                private final int num$1;

                public void onFailure(Throwable t) {
                }

                public void onSuccess(UserRecordResult result) {
                    String shardId = result.getShardId();
                    String seqNumber = result.getSequenceNumber();
                    ArrayBuffer sentSeqNumbers = (ArrayBuffer)this.shardIdToSeqNumbers$1.getOrElseUpdate((Object)shardId, (Function0 & Serializable & scala.Serializable)() -> new ArrayBuffer());
                    sentSeqNumbers.$plus$eq((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)this.num$1), (Object)seqNumber));
                }
                {
                    this.shardIdToSeqNumbers$1 = shardIdToSeqNumbers$1;
                    this.num$1 = num$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onSuccess$1()}, serializedLambda);
                }
            };
            Futures.addCallback((ListenableFuture)future, (FutureCallback)kinesisCallBack, (Executor)ThreadUtils$.MODULE$.sameThreadExecutorService());
        });
        this.producer().flushSync();
        return shardIdToSeqNumbers.mapValues((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toSeq()).toMap(Predef$.MODULE$.$conforms());
    }

    public KPLDataGenerator(String regionName) {
        this.regionName = regionName;
    }
}

