/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.kinesis;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.RegionUtils;
import java.io.Serializable;
import java.net.URI;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class KinesisTestUtils$ {
    public static KinesisTestUtils$ MODULE$;
    private boolean shouldRunTests;
    private String endpointUrl;
    private final String envVarNameForEnablingTests;
    private final String endVarNameForEndpoint;
    private final String defaultEndpointUrl;
    private volatile byte bitmap$0;

    static {
        new KinesisTestUtils$();
    }

    public int $lessinit$greater$default$1() {
        return 2;
    }

    public String envVarNameForEnablingTests() {
        return this.envVarNameForEnablingTests;
    }

    public String endVarNameForEndpoint() {
        return this.endVarNameForEndpoint;
    }

    public String defaultEndpointUrl() {
        return this.defaultEndpointUrl;
    }

    public String getRegionNameByEndpoint(String endpoint) {
        URI uri = new URI(endpoint);
        return (String)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(RegionUtils.getRegionsForService((String)"kinesis")).asScala()).find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)KinesisTestUtils$.$anonfun$getRegionNameByEndpoint$1(uri, x$1))).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getName()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(39).append("Could not resolve region for endpoint: ").append(endpoint).toString());
        });
    }

    /*
     * WARNING - void declaration
     */
    private boolean shouldRunTests$lzycompute() {
        KinesisTestUtils$ kinesisTestUtils$ = this;
        synchronized (kinesisTestUtils$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                void var2_3;
                boolean isEnvSet;
                Option option = package$.MODULE$.env().get((Object)this.envVarNameForEnablingTests());
                Some some = new Some((Object)"1");
                boolean bl = !(option != null ? !option.equals(some) : some != null) ? true : (isEnvSet = false);
                if (isEnvSet) {
                    Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(536).append("\n          |Kinesis tests that actually send data has been enabled by setting the environment\n          |variable ").append(this.envVarNameForEnablingTests()).append(" to 1. This will create Kinesis Streams and\n          |DynamoDB tables in AWS. Please be aware that this may incur some AWS costs.\n          |By default, the tests use the endpoint URL ").append(this.defaultEndpointUrl()).append(" to create Kinesis streams.\n          |To change this endpoint URL to a different region, you can set the environment variable\n          |").append(this.endVarNameForEndpoint()).append(" to the desired endpoint URL\n          |(e.g. ").append(this.endVarNameForEndpoint()).append("=\"https://kinesis.us-west-2.amazonaws.com\").\n        ").toString())).stripMargin());
                }
                this.shouldRunTests = var2_3;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.shouldRunTests;
    }

    public boolean shouldRunTests() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.shouldRunTests$lzycompute();
        }
        return this.shouldRunTests;
    }

    /*
     * WARNING - void declaration
     */
    private String endpointUrl$lzycompute() {
        KinesisTestUtils$ kinesisTestUtils$ = this;
        synchronized (kinesisTestUtils$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                void var2_2;
                String url = (String)package$.MODULE$.env().getOrElse((Object)this.endVarNameForEndpoint(), (Function0 & Serializable & scala.Serializable)() -> MODULE$.defaultEndpointUrl());
                Predef$.MODULE$.println((Object)new StringBuilder(59).append("Using endpoint URL ").append(url).append(" for creating Kinesis streams for tests.").toString());
                this.endpointUrl = var2_2;
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.endpointUrl;
    }

    public String endpointUrl() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.endpointUrl$lzycompute();
        }
        return this.endpointUrl;
    }

    public boolean isAWSCredentialsPresent() {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> new DefaultAWSCredentialsProviderChain().getCredentials()).isSuccess();
    }

    public AWSCredentials getAWSCredentials() {
        Predef$.MODULE$.assert(this.shouldRunTests(), (Function0 & Serializable & scala.Serializable)() -> "Kinesis test not enabled, should not attempt to get AWS credentials");
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> new DefaultAWSCredentialsProviderChain().getCredentials());
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            AWSCredentials cred = (AWSCredentials)success.value();
            return cred;
        }
        if (try_ instanceof Failure) {
            throw new Exception(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(315).append("\n             |Kinesis tests enabled using environment variable ").append(this.envVarNameForEnablingTests()).append("\n             |but could not find AWS credentials. Please follow instructions in AWS documentation\n             |to set the credentials in your system such that the DefaultAWSCredentialsProviderChain\n             |can find the credentials.\n           ").toString())).stripMargin());
        }
        throw new MatchError((Object)try_);
    }

    public static final /* synthetic */ boolean $anonfun$getRegionNameByEndpoint$1(URI uri$1, Region x$1) {
        return ((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(x$1.getAvailableEndpoints()).asScala()).toSeq().contains((Object)uri$1.getHost());
    }

    private KinesisTestUtils$() {
        MODULE$ = this;
        this.envVarNameForEnablingTests = "ENABLE_KINESIS_TESTS";
        this.endVarNameForEndpoint = "KINESIS_TEST_ENDPOINT_URL";
        this.defaultEndpointUrl = "https://kinesis.us-west-2.amazonaws.com";
    }
}

