/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.kinesis;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.services.kinesis.model.Record;
import java.io.Serializable;
import org.apache.spark.Partition;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkEnv$;
import org.apache.spark.TaskContext;
import org.apache.spark.rdd.BlockRDD;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockManager;
import org.apache.spark.streaming.kinesis.KinesisBackedBlockRDD$;
import org.apache.spark.streaming.kinesis.KinesisBackedBlockRDDPartition;
import org.apache.spark.streaming.kinesis.KinesisReadConfigurations;
import org.apache.spark.streaming.kinesis.KinesisSequenceRangeIterator;
import org.apache.spark.streaming.kinesis.SequenceNumberRange;
import org.apache.spark.streaming.kinesis.SequenceNumberRanges;
import org.apache.spark.streaming.kinesis.SparkAWSCredentials;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Iterator;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005mh!B\u0010!\u0001\u0001R\u0003\u0002C!\u0001\u0005\u0003\u0005\u000b\u0011\u0002\"\t\u0011\u0019\u0003!Q1A\u0005\u0002\u001dC\u0001b\u0015\u0001\u0003\u0002\u0003\u0006I\u0001\u0013\u0005\t)\u0002\u0011)\u0019!C\u0001\u000f\"AQ\u000b\u0001B\u0001B\u0003%\u0001\n\u0003\u0005W\u0001\t\u0015\r\u0011\"\u0003X\u0011%\t\u0007A!A!\u0002\u0013A&\r\u0003\u0005i\u0001\t\u0015\r\u0011\"\u0001j\u0011!y\u0007A!A!\u0002\u0013Q\u0007\u0002C9\u0001\u0005\u000b\u0007I\u0011\u0002:\t\u0011]\u0004!\u0011!Q\u0001\nMD\u0001\"\u001f\u0001\u0003\u0006\u0004%\tA\u001f\u0005\n\u0003/\u0001!\u0011!Q\u0001\nmD!\"!\u0007\u0001\u0005\u000b\u0007I\u0011AA\u000e\u0011)\t\u0019\u0003\u0001B\u0001B\u0003%\u0011Q\u0004\u0005\u000b\u0003K\u0001!Q1A\u0005\u0002\u0005\u001d\u0002BCA\u0018\u0001\t\u0005\t\u0015!\u0003\u0002*!Q\u0011\u0011\u0007\u0001\u0003\u0004\u0003\u0006Y!a\r\t\u000f\u0005}\u0002\u0001\"\u0001\u0002B!9\u00111\f\u0001\u0005B\u0005u\u0003bBA0\u0001\u0011\u0005\u0013\u0011\r\u0005\b\u0003W\u0002A\u0011IA7\u000f)\ty\tIA\u0001\u0012\u0003\u0001\u0013\u0011\u0013\u0004\n?\u0001\n\t\u0011#\u0001!\u0003'Cq!a\u0010\u0019\t\u0003\t\t\u000bC\u0005\u0002$b\t\n\u0011\"\u0001\u0002&\"I\u0011q\u0018\r\u0012\u0002\u0013\u0005\u0011\u0011\u0019\u0005\n\u0003'D\u0012\u0013!C\u0001\u0003+D\u0011\"!8\u0019#\u0003%\t!a8\t\u0013\u0005\u001d\b$!A\u0005\n\u0005%(!F&j]\u0016\u001c\u0018n\u001d\"bG.,GM\u00117pG.\u0014F\t\u0012\u0006\u0003C\t\nqa[5oKNL7O\u0003\u0002$I\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003K\u0019\nQa\u001d9be.T!a\n\u0015\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005I\u0013aA8sOV\u00111\u0006N\n\u0003\u00011\u00022!\f\u00193\u001b\u0005q#BA\u0018%\u0003\r\u0011H\rZ\u0005\u0003c9\u0012\u0001B\u00117pG.\u0014F\t\u0012\t\u0003gQb\u0001\u0001B\u00036\u0001\t\u0007qGA\u0001U\u0007\u0001\t\"\u0001\u000f \u0011\u0005ebT\"\u0001\u001e\u000b\u0003m\nQa]2bY\u0006L!!\u0010\u001e\u0003\u000f9{G\u000f[5oOB\u0011\u0011hP\u0005\u0003\u0001j\u00121!\u00118z\u0003\t\u00198\r\u0005\u0002D\t6\tA%\u0003\u0002FI\ta1\u000b]1sW\u000e{g\u000e^3yi\u0006Q!/Z4j_:t\u0015-\\3\u0016\u0003!\u0003\"!\u0013)\u000f\u0005)s\u0005CA&;\u001b\u0005a%BA'7\u0003\u0019a$o\\8u}%\u0011qJO\u0001\u0007!J,G-\u001a4\n\u0005E\u0013&AB*ue&twM\u0003\u0002Pu\u0005Y!/Z4j_:t\u0015-\\3!\u0003-)g\u000e\u001a9pS:$XK\u001d7\u0002\u0019\u0015tG\r]8j]R,&\u000f\u001c\u0011\u0002\u0013}\u0013Gn\\2l\u0013\u0012\u001cX#\u0001-\u0011\u0007eJ6,\u0003\u0002[u\t)\u0011I\u001d:bsB\u0011AlX\u0007\u0002;*\u0011a\fJ\u0001\bgR|'/Y4f\u0013\t\u0001WLA\u0004CY>\u001c7.\u00133\u0002\u0015}\u0013Gn\\2l\u0013\u0012\u001c\b%\u0003\u0002da\u0005A!\r\\8dW&#7\u000f\u000b\u0002\bKB\u0011\u0011HZ\u0005\u0003Oj\u0012\u0011\u0002\u001e:b]NLWM\u001c;\u0002-\u0005\u0014(/Y=PMN,\u0017OT;nE\u0016\u0014(+\u00198hKN,\u0012A\u001b\t\u0004se[\u0007C\u00017n\u001b\u0005\u0001\u0013B\u00018!\u0005Q\u0019V-];f]\u000e,g*^7cKJ\u0014\u0016M\\4fg\u00069\u0012M\u001d:bs>37/Z9Ok6\u0014WM\u001d*b]\u001e,7\u000f\t\u0015\u0003\u0013\u0015\fa\"[:CY>\u001c7.\u00133WC2LG-F\u0001t!\rI\u0014\f\u001e\t\u0003sUL!A\u001e\u001e\u0003\u000f\t{w\u000e\\3b]\u0006y\u0011n\u001d\"m_\u000e\\\u0017\n\u001a,bY&$\u0007\u0005\u000b\u0002\fK\u0006qQ.Z:tC\u001e,\u0007*\u00198eY\u0016\u0014X#A>\u0011\tebhPM\u0005\u0003{j\u0012\u0011BR;oGRLwN\\\u0019\u0011\u0007}\f\u0019\"\u0004\u0002\u0002\u0002)!\u00111AA\u0003\u0003\u0015iw\u000eZ3m\u0015\r\t\u0013q\u0001\u0006\u0005\u0003\u0013\tY!\u0001\u0005tKJ4\u0018nY3t\u0015\u0011\ti!a\u0004\u0002\u0013\u0005l\u0017M_8oC^\u001c(BAA\t\u0003\r\u0019w.\\\u0005\u0005\u0003+\t\tA\u0001\u0004SK\u000e|'\u000fZ\u0001\u0010[\u0016\u001c8/Y4f\u0011\u0006tG\r\\3sA\u0005a1.\u001b8fg&\u001c8I]3egV\u0011\u0011Q\u0004\t\u0004Y\u0006}\u0011bAA\u0011A\t\u00192\u000b]1sW\u0006;6k\u0011:fI\u0016tG/[1mg\u0006i1.\u001b8fg&\u001c8I]3eg\u0002\n!c[5oKNL7OU3bI\u000e{gNZ5hgV\u0011\u0011\u0011\u0006\t\u0004Y\u0006-\u0012bAA\u0017A\tI2*\u001b8fg&\u001c(+Z1e\u0007>tg-[4ve\u0006$\u0018n\u001c8t\u0003MY\u0017N\\3tSN\u0014V-\u00193D_:4\u0017nZ:!\u0003))g/\u001b3f]\u000e,G%\r\t\u0006\u0003k\tYDM\u0007\u0003\u0003oQ1!!\u000f;\u0003\u001d\u0011XM\u001a7fGRLA!!\u0010\u00028\tA1\t\\1tgR\u000bw-\u0001\u0004=S:LGO\u0010\u000b\u0015\u0003\u0007\nI%a\u0013\u0002N\u0005=\u0013\u0011KA*\u0003+\n9&!\u0017\u0015\t\u0005\u0015\u0013q\t\t\u0004Y\u0002\u0011\u0004bBA\u0019'\u0001\u000f\u00111\u0007\u0005\u0006\u0003N\u0001\rA\u0011\u0005\u0006\rN\u0001\r\u0001\u0013\u0005\u0006)N\u0001\r\u0001\u0013\u0005\u0006-N\u0001\r\u0001\u0017\u0005\u0006QN\u0001\rA\u001b\u0005\bcN\u0001\n\u00111\u0001t\u0011\u001dI8\u0003%AA\u0002mD\u0011\"!\u0007\u0014!\u0003\u0005\r!!\b\t\u0013\u0005\u00152\u0003%AA\u0002\u0005%\u0012aB5t-\u0006d\u0017\u000eZ\u000b\u0002i\u0006iq-\u001a;QCJ$\u0018\u000e^5p]N,\"!a\u0019\u0011\teJ\u0016Q\r\t\u0004\u0007\u0006\u001d\u0014bAA5I\tI\u0001+\u0019:uSRLwN\\\u0001\bG>l\u0007/\u001e;f)\u0019\ty'!!\u0002\u0006B)\u0011\u0011OA>e9!\u00111OA<\u001d\rY\u0015QO\u0005\u0002w%\u0019\u0011\u0011\u0010\u001e\u0002\u000fA\f7m[1hK&!\u0011QPA@\u0005!IE/\u001a:bi>\u0014(bAA=u!9\u00111\u0011\fA\u0002\u0005\u0015\u0014!B:qY&$\bbBAD-\u0001\u0007\u0011\u0011R\u0001\bG>tG/\u001a=u!\r\u0019\u00151R\u0005\u0004\u0003\u001b##a\u0003+bg.\u001cuN\u001c;fqR\fQcS5oKNL7OQ1dW\u0016$'\t\\8dWJ#E\t\u0005\u0002m1M)\u0001$!&\u0002\u001cB\u0019\u0011(a&\n\u0007\u0005e%H\u0001\u0004B]f\u0014VM\u001a\t\u0004s\u0005u\u0015bAAPu\ta1+\u001a:jC2L'0\u00192mKR\u0011\u0011\u0011S\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001c\u0016\t\u0005\u001d\u0016QX\u000b\u0003\u0003SS3a]AVW\t\ti\u000b\u0005\u0003\u00020\u0006eVBAAY\u0015\u0011\t\u0019,!.\u0002\u0013Ut7\r[3dW\u0016$'bAA\\u\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005m\u0016\u0011\u0017\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,G!B\u001b\u001b\u0005\u00049\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$s'\u0006\u0003\u0002D\u0006EWCAAcU\u0011\t9-a+\u0011\u000bebh0!3\u0011\teJ\u00161\u001a\t\u0004s\u00055\u0017bAAhu\t!!)\u001f;f\t\u0015)4D1\u00018\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%qU!\u0011q[An+\t\tIN\u000b\u0003\u0002\u001e\u0005-F!B\u001b\u001d\u0005\u00049\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0013(\u0006\u0003\u0002b\u0006\u0015XCAArU\u0011\tI#a+\u0005\u000bUj\"\u0019A\u001c\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003W\u0004B!!<\u0002x6\u0011\u0011q\u001e\u0006\u0005\u0003c\f\u00190\u0001\u0003mC:<'BAA{\u0003\u0011Q\u0017M^1\n\t\u0005e\u0018q\u001e\u0002\u0007\u001f\nTWm\u0019;")
public class KinesisBackedBlockRDD<T>
extends BlockRDD<T> {
    private final String regionName;
    private final String endpointUrl;
    private final transient SequenceNumberRanges[] arrayOfseqNumberRanges;
    private final transient boolean[] isBlockIdValid;
    private final Function1<Record, T> messageHandler;
    private final SparkAWSCredentials kinesisCreds;
    private final KinesisReadConfigurations kinesisReadConfigs;
    private final ClassTag<T> evidence$1;

    public static <T> KinesisReadConfigurations $lessinit$greater$default$9() {
        return KinesisBackedBlockRDD$.MODULE$.$lessinit$greater$default$9();
    }

    public static <T> SparkAWSCredentials $lessinit$greater$default$8() {
        return KinesisBackedBlockRDD$.MODULE$.$lessinit$greater$default$8();
    }

    public static <T> Function1<Record, byte[]> $lessinit$greater$default$7() {
        return KinesisBackedBlockRDD$.MODULE$.$lessinit$greater$default$7();
    }

    public static <T> boolean[] $lessinit$greater$default$6() {
        return KinesisBackedBlockRDD$.MODULE$.$lessinit$greater$default$6();
    }

    public String regionName() {
        return this.regionName;
    }

    public String endpointUrl() {
        return this.endpointUrl;
    }

    private BlockId[] _blockIds() {
        return super.blockIds();
    }

    public SequenceNumberRanges[] arrayOfseqNumberRanges() {
        return this.arrayOfseqNumberRanges;
    }

    private boolean[] isBlockIdValid() {
        return this.isBlockIdValid;
    }

    public Function1<Record, T> messageHandler() {
        return this.messageHandler;
    }

    public SparkAWSCredentials kinesisCreds() {
        return this.kinesisCreds;
    }

    public KinesisReadConfigurations kinesisReadConfigs() {
        return this.kinesisReadConfigs;
    }

    public boolean isValid() {
        return true;
    }

    public Partition[] getPartitions() {
        return (Partition[])Array$.MODULE$.tabulate(this._blockIds().length, (Function1 & Serializable & scala.Serializable)i -> KinesisBackedBlockRDD.$anonfun$getPartitions$1(this, BoxesRunTime.unboxToInt((Object)i)), ClassTag$.MODULE$.apply(Partition.class));
    }

    public Iterator<T> compute(Partition split, TaskContext context) {
        BlockManager blockManager = SparkEnv$.MODULE$.get().blockManager();
        KinesisBackedBlockRDDPartition partition = (KinesisBackedBlockRDDPartition)split;
        BlockId blockId = partition.blockId();
        if (partition.isBlockIdValid()) {
            return (Iterator)this.getBlockFromBlockManager$1(blockId, blockManager).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.getBlockFromKinesis$1(partition));
        }
        return this.getBlockFromKinesis$1(partition);
    }

    public static final /* synthetic */ KinesisBackedBlockRDDPartition $anonfun$getPartitions$1(KinesisBackedBlockRDD $this, int i) {
        boolean isValid = $this.isBlockIdValid().length == 0 ? true : $this.isBlockIdValid()[i];
        return new KinesisBackedBlockRDDPartition(i, $this._blockIds()[i], isValid, $this.arrayOfseqNumberRanges()[i]);
    }

    private final Option getBlockFromBlockManager$1(BlockId blockId$1, BlockManager blockManager$1) {
        this.logDebug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Read partition data of ").append((Object)this).append(" from block manager, block ").append(blockId$1).toString());
        return blockManager$1.get(blockId$1, this.evidence$1).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.data());
    }

    private final Iterator getBlockFromKinesis$1(KinesisBackedBlockRDDPartition partition$1) {
        AWSCredentials credentials = this.kinesisCreds().provider().getCredentials();
        return partition$1.seqNumberRanges().ranges().iterator().flatMap((Function1 & Serializable & scala.Serializable)range -> new KinesisSequenceRangeIterator(credentials, this.endpointUrl(), this.regionName(), (SequenceNumberRange)range, this.kinesisReadConfigs()).map(this.messageHandler()));
    }

    public KinesisBackedBlockRDD(SparkContext sc, String regionName, String endpointUrl, BlockId[] _blockIds, SequenceNumberRanges[] arrayOfseqNumberRanges, boolean[] isBlockIdValid, Function1<Record, T> messageHandler, SparkAWSCredentials kinesisCreds, KinesisReadConfigurations kinesisReadConfigs, ClassTag<T> evidence$1) {
        this.regionName = regionName;
        this.endpointUrl = endpointUrl;
        this.arrayOfseqNumberRanges = arrayOfseqNumberRanges;
        this.isBlockIdValid = isBlockIdValid;
        this.messageHandler = messageHandler;
        this.kinesisCreds = kinesisCreds;
        this.kinesisReadConfigs = kinesisReadConfigs;
        this.evidence$1 = evidence$1;
        super(sc, _blockIds, evidence$1);
        Predef$.MODULE$.require(_blockIds.length == arrayOfseqNumberRanges.length, (Function0 & Serializable & scala.Serializable)() -> "Number of blockIds is not equal to the number of sequence number ranges");
    }
}

