/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.streaming;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.services.kinesis.AmazonKinesisClient;
import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.examples.streaming.KinesisExampleUtils$;
import org.apache.spark.examples.streaming.StreamingExamples$;
import org.apache.spark.internal.Logging;
import org.apache.spark.storage.StorageLevel$;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.Milliseconds$;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.dstream.DStream;
import org.apache.spark.streaming.dstream.DStream$;
import org.apache.spark.streaming.kinesis.KinesisInitialPositions;
import org.apache.spark.streaming.kinesis.KinesisInputDStream;
import org.apache.spark.streaming.kinesis.KinesisInputDStream$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction2;

public final class KinesisWordCountASL$
implements Logging {
    public static KinesisWordCountASL$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new KinesisWordCountASL$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public void main(String[] args) {
        Duration batchInterval;
        int numShards;
        if (args.length != 3) {
            System.err.println(new StringOps(Predef$.MODULE$.augmentString("\n          |Usage: KinesisWordCountASL <app-name> <stream-name> <endpoint-url>\n          |\n          |    <app-name> is the name of the consumer app, used to track the read data in DynamoDB\n          |    <stream-name> is the name of the Kinesis stream\n          |    <endpoint-url> is the endpoint of the Kinesis service\n          |                   (e.g. https://kinesis.us-east-1.amazonaws.com)\n          |\n          |Generate input data for Kinesis stream using the example KinesisWordProducerASL.\n          |See https://spark.apache.org/docs/latest/streaming-kinesis-integration.html for more\n          |details.\n        ")).stripMargin());
            System.exit(1);
        }
        StreamingExamples$.MODULE$.setStreamingLogLevels();
        String[] stringArray = args;
        Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
        if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(3) != 0) {
            throw new MatchError((Object)stringArray);
        }
        String appName = (String)((SeqLike)option.get()).apply(0);
        String streamName = (String)((SeqLike)option.get()).apply(1);
        String endpointUrl = (String)((SeqLike)option.get()).apply(2);
        Tuple3 tuple3 = new Tuple3((Object)appName, (Object)streamName, (Object)endpointUrl);
        String appName2 = (String)tuple3._1();
        String streamName2 = (String)tuple3._2();
        String endpointUrl2 = (String)tuple3._3();
        AWSCredentials credentials = new DefaultAWSCredentialsProviderChain().getCredentials();
        Predef$.MODULE$.require(credentials != null, (Function0 & Serializable & scala.Serializable)() -> "No AWS credentials found. Please specify credentials using one of the methods specified in http://docs.aws.amazon.com/AWSSdkDocsJava/latest/DeveloperGuide/credentials.html");
        AmazonKinesisClient kinesisClient = new AmazonKinesisClient(credentials);
        kinesisClient.setEndpoint(endpointUrl2);
        int numStreams = numShards = kinesisClient.describeStream(streamName2).getStreamDescription().getShards().size();
        Duration kinesisCheckpointInterval = batchInterval = Milliseconds$.MODULE$.apply(2000L);
        String regionName = KinesisExampleUtils$.MODULE$.getRegionNameByEndpoint(endpointUrl2);
        SparkConf sparkConfig = new SparkConf().setAppName("KinesisWordCountASL");
        StreamingContext ssc = new StreamingContext(sparkConfig, batchInterval);
        IndexedSeq kinesisStreams = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numStreams).map((Function1 & Serializable & scala.Serializable)i -> KinesisWordCountASL$.$anonfun$main$2(ssc, streamName2, endpointUrl2, regionName, appName2, kinesisCheckpointInterval, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        DStream unionStreams = ssc.union((Seq)kinesisStreams, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
        DStream words = unionStreams.flatMap((Function1 & Serializable & scala.Serializable)byteArray -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String(byteArray).split(" "))), ClassTag$.MODULE$.apply(String.class));
        DStream wordCounts = DStream$.MODULE$.toPairDStreamFunctions(words.map((Function1 & Serializable & scala.Serializable)word -> new Tuple2(word, (Object)BoxesRunTime.boxToInteger((int)1)), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.Int(), (Ordering)Ordering.String$.MODULE$).reduceByKey((Function2)(JFunction2.mcIII.sp & Serializable & scala.Serializable)(x$2, x$3) -> x$2 + x$3);
        wordCounts.print();
        ssc.start();
        ssc.awaitTermination();
    }

    public static final /* synthetic */ KinesisInputDStream $anonfun$main$2(StreamingContext ssc$1, String streamName$1, String endpointUrl$1, String regionName$1, String appName$1, Duration kinesisCheckpointInterval$1, int i) {
        return KinesisInputDStream$.MODULE$.builder().streamingContext(ssc$1).streamName(streamName$1).endpointUrl(endpointUrl$1).regionName(regionName$1).initialPosition(new KinesisInitialPositions.Latest()).checkpointAppName(appName$1).checkpointInterval(kinesisCheckpointInterval$1).storageLevel(StorageLevel$.MODULE$.MEMORY_AND_DISK_2()).build();
    }

    private KinesisWordCountASL$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

