/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.kinesis;

import com.amazonaws.services.kinesis.clientlibrary.exceptions.InvalidStateException;
import com.amazonaws.services.kinesis.clientlibrary.exceptions.KinesisClientLibDependencyException;
import com.amazonaws.services.kinesis.clientlibrary.exceptions.ShutdownException;
import com.amazonaws.services.kinesis.clientlibrary.exceptions.ThrottlingException;
import org.apache.spark.internal.Logging;
import org.slf4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.Serializable;
import scala.util.Failure;
import scala.util.Random$;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class KinesisRecordProcessor$
implements Logging {
    public static KinesisRecordProcessor$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new KinesisRecordProcessor$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public <T> T retryRandom(Function0<T> expression, int numRetriesLeft, int maxBackOffMillis) {
        Try try_;
        block4: {
            Throwable throwable;
            Throwable e;
            while (true) {
                if ((try_ = Try$.MODULE$.apply(expression)) instanceof Success) {
                    Success success = (Success)try_;
                    Object x = success.value();
                    return (T)x;
                }
                if (!(try_ instanceof Failure)) break block4;
                Failure failure = (Failure)try_;
                e = failure.exception();
                throwable = e;
                if (!(throwable instanceof ThrottlingException ? true : throwable instanceof KinesisClientLibDependencyException) || numRetriesLeft <= 1) break;
                int backOffMillis = Random$.MODULE$.nextInt(maxBackOffMillis);
                Thread.sleep(backOffMillis);
                this.logError((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(43).append("Retryable Exception:  Random backOffMillis=").append(backOffMillis).toString(), e);
                --numRetriesLeft;
            }
            if (throwable instanceof ShutdownException) {
                this.logError((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> "ShutdownException:  Caught shutdown exception, skipping checkpoint.", e);
                throw e;
            }
            if (throwable instanceof InvalidStateException) {
                this.logError((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(140).append("InvalidStateException:  Cannot save checkpoint to the DynamoDB table used").append(" by the Amazon Kinesis Client Library.  Table likely doesn't exist.").toString(), e);
                throw e;
            }
            this.logError((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> "Unexpected, non-retryable exception.", e);
            throw e;
        }
        throw new MatchError((Object)try_);
    }

    private KinesisRecordProcessor$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

