/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.streaming;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.services.kinesis.AmazonKinesisClient;
import com.amazonaws.services.kinesis.model.PutRecordRequest;
import com.amazonaws.services.kinesis.model.PutRecordResult;
import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.spark.examples.streaming.StreamingExamples$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Random$;

public final class KinesisWordProducerASL$ {
    public static KinesisWordProducerASL$ MODULE$;

    static {
        new KinesisWordProducerASL$();
    }

    public void main(String[] args) {
        if (args.length != 4) {
            System.err.println(new StringOps(Predef$.MODULE$.augmentString("\n          |Usage: KinesisWordProducerASL <stream-name> <endpoint-url> <records-per-sec>\n          |                              <words-per-record>\n          |\n          |    <stream-name> is the name of the Kinesis stream\n          |    <endpoint-url> is the endpoint of the Kinesis service\n          |                   (e.g. https://kinesis.us-east-1.amazonaws.com)\n          |    <records-per-sec> is the rate of records per second to put onto the stream\n          |    <words-per-record> is the number of words per record\n          |\n        ")).stripMargin());
            System.exit(1);
        }
        StreamingExamples$.MODULE$.setStreamingLogLevels();
        String[] stringArray = args;
        Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
        if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(4) != 0) {
            throw new MatchError((Object)stringArray);
        }
        String stream = (String)((SeqLike)option.get()).apply(0);
        String endpoint = (String)((SeqLike)option.get()).apply(1);
        String recordsPerSecond = (String)((SeqLike)option.get()).apply(2);
        String wordsPerRecord = (String)((SeqLike)option.get()).apply(3);
        Tuple4 tuple4 = new Tuple4((Object)stream, (Object)endpoint, (Object)recordsPerSecond, (Object)wordsPerRecord);
        String stream2 = (String)tuple4._1();
        String endpoint2 = (String)tuple4._2();
        String recordsPerSecond2 = (String)tuple4._3();
        String wordsPerRecord2 = (String)tuple4._4();
        Seq<Tuple2<String, Object>> totals = this.generate(stream2, endpoint2, new StringOps(Predef$.MODULE$.augmentString(recordsPerSecond2)).toInt(), new StringOps(Predef$.MODULE$.augmentString(wordsPerRecord2)).toInt());
        Predef$.MODULE$.println((Object)"Totals for the words sent");
        totals.foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
            Predef$.MODULE$.println((Object)x$5);
            return BoxedUnit.UNIT;
        });
    }

    public Seq<Tuple2<String, Object>> generate(String stream, String endpoint, int recordsPerSecond, int wordsPerRecord) {
        .colon.colon randomWords = new .colon.colon((Object)"spark", (List)new .colon.colon((Object)"you", (List)new .colon.colon((Object)"are", (List)new .colon.colon((Object)"my", (List)new .colon.colon((Object)"father", (List)Nil$.MODULE$)))));
        Map totals = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        AmazonKinesisClient kinesisClient = new AmazonKinesisClient((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain());
        kinesisClient.setEndpoint(endpoint);
        Predef$.MODULE$.println((Object)new StringBuilder(97).append("Putting records onto stream ").append(stream).append(" and endpoint ").append(endpoint).append(" at a rate of").append(" ").append(recordsPerSecond).append(" records per second and ").append(wordsPerRecord).append(" words per record").toString());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10).foreach$mVc$sp((Function1)((JFunction1.mcVI.sp & Serializable & scala.Serializable)arg_0 -> KinesisWordProducerASL$.$anonfun$generate$1(recordsPerSecond, wordsPerRecord, (List)randomWords, totals, stream, kinesisClient, arg_0)));
        return (Seq)totals.toSeq().sortBy((Function1 & Serializable & scala.Serializable)x$6 -> (String)x$6._1(), (Ordering)Ordering.String$.MODULE$);
    }

    public static final /* synthetic */ String $anonfun$generate$3(List randomWords$1, Map totals$1, int x) {
        int randomWordIdx = Random$.MODULE$.nextInt(randomWords$1.size());
        String randomWord = (String)randomWords$1.apply(randomWordIdx);
        totals$1.update((Object)randomWord, (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)totals$1.getOrElse((Object)randomWord, (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0)) + 1)));
        return randomWord;
    }

    public static final /* synthetic */ void $anonfun$generate$1(int recordsPerSecond$1, int wordsPerRecord$1, List randomWords$1, Map totals$1, String stream$1, AmazonKinesisClient kinesisClient$1, int i) {
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), recordsPerSecond$1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)recordNum -> {
            String data = ((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), wordsPerRecord$1).map((Function1 & Serializable & scala.Serializable)x -> KinesisWordProducerASL$.$anonfun$generate$3(randomWords$1, totals$1, BoxesRunTime.unboxToInt((Object)x)), IndexedSeq$.MODULE$.canBuildFrom())).mkString(" ");
            String partitionKey = new StringBuilder(13).append("partitionKey-").append(recordNum).toString();
            PutRecordRequest putRecordRequest = new PutRecordRequest().withStreamName(stream$1).withPartitionKey(partitionKey).withData(ByteBuffer.wrap(data.getBytes()));
            PutRecordResult putRecordResult = kinesisClient$1.putRecord(putRecordRequest);
        });
        BoxedUnit records = BoxedUnit.UNIT;
        Thread.sleep(1000L);
        Predef$.MODULE$.println((Object)new StringBuilder(13).append("Sent ").append(recordsPerSecond$1).append(" records").toString());
    }

    private KinesisWordProducerASL$() {
        MODULE$ = this;
    }
}

