/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.kinesis;

import com.amazonaws.services.kinesis.clientlibrary.lib.worker.InitialPositionInStream;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.LocalJavaStreamingContext;
import org.apache.spark.streaming.Seconds;
import org.apache.spark.streaming.kinesis.KinesisInitialPosition;
import org.apache.spark.streaming.kinesis.KinesisInitialPositions;
import org.apache.spark.streaming.kinesis.KinesisInputDStream;
import org.junit.Assert;
import org.junit.Test;

public class JavaKinesisInputDStreamBuilderSuite
extends LocalJavaStreamingContext {
    @Test
    public void testJavaKinesisDStreamBuilder() {
        String streamName = "a-very-nice-stream-name";
        String endpointUrl = "https://kinesis.us-west-2.amazonaws.com";
        String region = "us-west-2";
        KinesisInitialPositions.TrimHorizon initialPosition = new KinesisInitialPositions.TrimHorizon();
        String appName = "a-very-nice-kinesis-app";
        Duration checkpointInterval = Seconds.apply((long)30L);
        StorageLevel storageLevel = StorageLevel.MEMORY_ONLY();
        KinesisInputDStream kinesisDStream = KinesisInputDStream.builder().streamingContext(this.ssc).streamName(streamName).endpointUrl(endpointUrl).regionName(region).initialPosition((KinesisInitialPosition)initialPosition).checkpointAppName(appName).checkpointInterval(checkpointInterval).storageLevel(storageLevel).build();
        Assert.assertEquals((Object)streamName, (Object)kinesisDStream.streamName());
        Assert.assertEquals((Object)endpointUrl, (Object)kinesisDStream.endpointUrl());
        Assert.assertEquals((Object)region, (Object)kinesisDStream.regionName());
        Assert.assertEquals((Object)initialPosition.getPosition(), (Object)kinesisDStream.initialPosition().getPosition());
        Assert.assertEquals((Object)appName, (Object)kinesisDStream.checkpointAppName());
        Assert.assertEquals((Object)checkpointInterval, (Object)kinesisDStream.checkpointInterval());
        Assert.assertEquals((Object)storageLevel, (Object)kinesisDStream._storageLevel());
        this.ssc.stop();
    }

    @Test
    public void testJavaKinesisDStreamBuilderOldApi() {
        String streamName = "a-very-nice-stream-name";
        String endpointUrl = "https://kinesis.us-west-2.amazonaws.com";
        String region = "us-west-2";
        String appName = "a-very-nice-kinesis-app";
        Duration checkpointInterval = Seconds.apply((long)30L);
        StorageLevel storageLevel = StorageLevel.MEMORY_ONLY();
        KinesisInputDStream kinesisDStream = KinesisInputDStream.builder().streamingContext(this.ssc).streamName(streamName).endpointUrl(endpointUrl).regionName(region).initialPositionInStream(InitialPositionInStream.LATEST).checkpointAppName(appName).checkpointInterval(checkpointInterval).storageLevel(storageLevel).build();
        Assert.assertEquals((Object)streamName, (Object)kinesisDStream.streamName());
        Assert.assertEquals((Object)endpointUrl, (Object)kinesisDStream.endpointUrl());
        Assert.assertEquals((Object)region, (Object)kinesisDStream.regionName());
        Assert.assertEquals((Object)InitialPositionInStream.LATEST, (Object)kinesisDStream.initialPosition().getPosition());
        Assert.assertEquals((Object)appName, (Object)kinesisDStream.checkpointAppName());
        Assert.assertEquals((Object)checkpointInterval, (Object)kinesisDStream.checkpointInterval());
        Assert.assertEquals((Object)storageLevel, (Object)kinesisDStream._storageLevel());
        this.ssc.stop();
    }
}

