/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.kinesis;

import com.amazonaws.services.kinesis.clientlibrary.interfaces.IRecordProcessorCheckpointer;
import java.io.Serializable;
import java.util.concurrent.TimeoutException;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.TestServer;
import org.apache.spark.streaming.TestSuiteBase;
import org.apache.spark.streaming.dstream.DStream;
import org.apache.spark.streaming.kinesis.KinesisCheckpointer;
import org.apache.spark.streaming.kinesis.KinesisReceiver;
import org.apache.spark.util.Clock;
import org.apache.spark.util.ManualClock;
import org.mockito.ArgumentMatchers;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.scalactic.source.Position;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.PrivateMethodTester;
import org.scalatest.PrivateMethodTester$PrivateMethod$;
import org.scalatest.Tag;
import org.scalatest.concurrent.AbstractPatienceConfiguration;
import org.scalatest.concurrent.AbstractPatienceConfiguration$PatienceConfig$;
import org.scalatest.concurrent.Eventually;
import org.scalatest.concurrent.PatienceConfiguration;
import org.scalatest.concurrent.ScaledTimeSpans;
import org.scalatest.enablers.Retrying;
import org.scalatest.enablers.Retrying$;
import org.scalatest.time.Span;
import org.scalatest.time.Span$;
import org.scalatestplus.mockito.MockitoSugar;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Some;
import scala.Symbol;
import scala.collection.Seq;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005=d\u0001B\u0010!\u0001-BQa\u0013\u0001\u0005\u00021Cqa\u0014\u0001C\u0002\u0013%\u0001\u000b\u0003\u0004Z\u0001\u0001\u0006I!\u0015\u0005\b5\u0002\u0011\r\u0011\"\u0003Q\u0011\u0019Y\u0006\u0001)A\u0005#\"9A\f\u0001b\u0001\n\u0013\u0001\u0006BB/\u0001A\u0003%\u0011\u000bC\u0004_\u0001\t\u0007I\u0011\u0002)\t\r}\u0003\u0001\u0015!\u0003R\u0011\u001d\u0001\u0007A1A\u0005\n\u0005Da!\u001a\u0001!\u0002\u0013\u0011\u0007b\u00024\u0001\u0005\u0004%Ia\u001a\u0005\u0007]\u0002\u0001\u000b\u0011\u00025\t\u000f=\u0004!\u0019!C\u0005O\"1\u0001\u000f\u0001Q\u0001\n!D\u0011\"\u001d\u0001A\u0002\u0003\u0007I\u0011\u0002:\t\u0013q\u0004\u0001\u0019!a\u0001\n\u0013i\bBCA\u0004\u0001\u0001\u0007\t\u0011)Q\u0005g\"Y\u0011\u0011\u0002\u0001A\u0002\u0003\u0007I\u0011BA\u0006\u0011-\tY\u0003\u0001a\u0001\u0002\u0004%I!!\f\t\u0017\u0005E\u0002\u00011A\u0001B\u0003&\u0011Q\u0002\u0005\f\u0003g\u0001\u0001\u0019!a\u0001\n\u0013\t)\u0004C\u0006\u0002>\u0001\u0001\r\u00111A\u0005\n\u0005}\u0002bCA\"\u0001\u0001\u0007\t\u0011)Q\u0005\u0003oA1\"!\u0012\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002H!Y\u0011Q\u000b\u0001A\u0002\u0003\u0007I\u0011BA,\u0011-\tY\u0006\u0001a\u0001\u0002\u0003\u0006K!!\u0013\t\u0013\u0005u\u0003A1A\u0005\n\u0005}\u0003\u0002CA5\u0001\u0001\u0006I!!\u0019\t\u000f\u0005-\u0004\u0001\"\u0011\u0002n\tA2*\u001b8fg&\u001c8\t[3dWB|\u0017N\u001c;feN+\u0018\u000e^3\u000b\u0005\u0005\u0012\u0013aB6j]\u0016\u001c\u0018n\u001d\u0006\u0003G\u0011\n\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u0005\u00152\u0013!B:qCJ\\'BA\u0014)\u0003\u0019\t\u0007/Y2iK*\t\u0011&A\u0002pe\u001e\u001c\u0001aE\u0004\u0001YA\"DHQ#\u0011\u00055rS\"\u0001\u0013\n\u0005=\"#!D*qCJ\\g)\u001e8Tk&$X\r\u0005\u00022e5\t!%\u0003\u00024E\tiA+Z:u'VLG/\u001a\"bg\u0016\u0004\"!\u000e\u001e\u000e\u0003YR!a\u000e\u001d\u0002\u000f5|7m[5u_*\u0011\u0011\bK\u0001\u000eg\u000e\fG.\u0019;fgR\u0004H.^:\n\u0005m2$\u0001D'pG.LGo\\*vO\u0006\u0014\bCA\u001fA\u001b\u0005q$BA )\u0003%\u00198-\u00197bi\u0016\u001cH/\u0003\u0002B}\t\u0011\")\u001a4pe\u0016\fe\u000eZ!gi\u0016\u0014X)Y2i!\ti4)\u0003\u0002E}\t\u0019\u0002K]5wCR,W*\u001a;i_\u0012$Vm\u001d;feB\u0011a)S\u0007\u0002\u000f*\u0011\u0001JP\u0001\u000bG>t7-\u001e:sK:$\u0018B\u0001&H\u0005))e/\u001a8uk\u0006dG._\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00035\u0003\"A\u0014\u0001\u000e\u0003\u0001\n\u0001b^8sW\u0016\u0014\u0018\nZ\u000b\u0002#B\u0011!kV\u0007\u0002'*\u0011A+V\u0001\u0005Y\u0006twMC\u0001W\u0003\u0011Q\u0017M^1\n\u0005a\u001b&AB*ue&tw-A\u0005x_J\\WM]%eA\u000591\u000f[1sI&#\u0017\u0001C:iCJ$\u0017\n\u001a\u0011\u0002\rM,\u0017OT;n\u0003\u001d\u0019X-\u001d(v[\u0002\n1b\u001c;iKJ\u001cV-\u001d(v[\u0006aq\u000e\u001e5feN+\u0017OT;nA\u0005\u00112\r[3dWB|\u0017N\u001c;J]R,'O^1m+\u0005\u0011\u0007CA\u0019d\u0013\t!'E\u0001\u0005EkJ\fG/[8o\u0003M\u0019\u0007.Z2la>Lg\u000e^%oi\u0016\u0014h/\u00197!\u0003)\u0019x.\\3TKFtU/\\\u000b\u0002QB\u0019\u0011\u000e\\)\u000e\u0003)T\u0011a[\u0001\u0006g\u000e\fG.Y\u0005\u0003[*\u0014AaU8nK\u0006Y1o\\7f'\u0016\fh*^7!\u0003=\u0019x.\\3Pi\",'oU3r\u001dVl\u0017\u0001E:p[\u0016|E\u000f[3s'\u0016\fh*^7!\u00031\u0011XmY3jm\u0016\u0014Xj\\2l+\u0005\u0019\bc\u0001(um&\u0011Q\u000f\t\u0002\u0010\u0017&tWm]5t%\u0016\u001cW-\u001b<feB\u0019\u0011n^=\n\u0005aT'!B!se\u0006L\bCA5{\u0013\tY(N\u0001\u0003CsR,\u0017\u0001\u0005:fG\u0016Lg/\u001a:N_\u000e\\w\fJ3r)\rq\u00181\u0001\t\u0003S~L1!!\u0001k\u0005\u0011)f.\u001b;\t\u0011\u0005\u0015\u0011#!AA\u0002M\f1\u0001\u001f\u00132\u00035\u0011XmY3jm\u0016\u0014Xj\\2lA\u0005\u00012\r[3dWB|\u0017N\u001c;fe6{7m[\u000b\u0003\u0003\u001b\u0001B!a\u0004\u0002(5\u0011\u0011\u0011\u0003\u0006\u0005\u0003'\t)\"\u0001\u0006j]R,'OZ1dKNTA!a\u0006\u0002\u001a\u0005i1\r\\5f]Rd\u0017N\u0019:befT1!IA\u000e\u0015\u0011\ti\"a\b\u0002\u0011M,'O^5dKNTA!!\t\u0002$\u0005I\u0011-\\1{_:\fwo\u001d\u0006\u0003\u0003K\t1aY8n\u0013\u0011\tI#!\u0005\u00039%\u0013VmY8sIB\u0013xnY3tg>\u00148\t[3dWB|\u0017N\u001c;fe\u0006!2\r[3dWB|\u0017N\u001c;fe6{7m[0%KF$2A`A\u0018\u0011%\t)\u0001FA\u0001\u0002\u0004\ti!A\tdQ\u0016\u001c7\u000e]8j]R,'/T8dW\u0002\n1c[5oKNL7o\u00115fG.\u0004x.\u001b8uKJ,\"!a\u000e\u0011\u00079\u000bI$C\u0002\u0002<\u0001\u00121cS5oKNL7o\u00115fG.\u0004x.\u001b8uKJ\fqc[5oKNL7o\u00115fG.\u0004x.\u001b8uKJ|F%Z9\u0015\u0007y\f\t\u0005C\u0005\u0002\u0006]\t\t\u00111\u0001\u00028\u0005!2.\u001b8fg&\u001c8\t[3dWB|\u0017N\u001c;fe\u0002\nQa\u00197pG.,\"!!\u0013\u0011\t\u0005-\u0013\u0011K\u0007\u0003\u0003\u001bR1!a\u0014%\u0003\u0011)H/\u001b7\n\t\u0005M\u0013Q\n\u0002\f\u001b\u0006tW/\u00197DY>\u001c7.A\u0005dY>\u001c7n\u0018\u0013fcR\u0019a0!\u0017\t\u0013\u0005\u0015!$!AA\u0002\u0005%\u0013AB2m_\u000e\\\u0007%\u0001\u0006dQ\u0016\u001c7\u000e]8j]R,\"!!\u0019\u0011\u000b\u0005\r\u0014Q\r@\u000e\u0003\u0001I1!a\u001aD\u00055\u0001&/\u001b<bi\u0016lU\r\u001e5pI\u0006Y1\r[3dWB|\u0017N\u001c;!\u0003)\u0011WMZ8sK\u0016\u000b7\r\u001b\u000b\u0002}\u0002")
public class KinesisCheckpointerSuite
extends SparkFunSuite
implements TestSuiteBase,
MockitoSugar,
PrivateMethodTester,
Eventually {
    private final String workerId;
    private final String shardId;
    private final String seqNum;
    private final String otherSeqNum;
    private final Duration checkpointInterval;
    private final Some<String> someSeqNum;
    private final Some<String> someOtherSeqNum;
    private KinesisReceiver<byte[]> receiverMock;
    private IRecordProcessorCheckpointer checkpointerMock;
    private KinesisCheckpointer kinesisCheckpointer;
    private ManualClock clock;
    private final PrivateMethodTester.PrivateMethod<BoxedUnit> checkpoint;
    private final AbstractPatienceConfiguration.PatienceConfig org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig;
    private volatile AbstractPatienceConfiguration$PatienceConfig$ PatienceConfig$module;
    private volatile PrivateMethodTester$PrivateMethod$ PrivateMethod$module;
    private String checkpointDir;
    private final SparkConf conf;
    private final PatienceConfiguration.Timeout eventuallyTimeout;
    private volatile boolean bitmap$0;

    public <T> T eventually(PatienceConfiguration.Timeout timeout, PatienceConfiguration.Interval interval, Function0<T> fun, Retrying<T> retrying, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, (PatienceConfiguration.Timeout)timeout, (PatienceConfiguration.Interval)interval, fun, retrying, (Position)pos);
    }

    public <T> T eventually(PatienceConfiguration.Timeout timeout, Function0<T> fun, AbstractPatienceConfiguration.PatienceConfig config, Retrying<T> retrying, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, (PatienceConfiguration.Timeout)timeout, fun, (AbstractPatienceConfiguration.PatienceConfig)config, retrying, (Position)pos);
    }

    public <T> T eventually(PatienceConfiguration.Interval interval, Function0<T> fun, AbstractPatienceConfiguration.PatienceConfig config, Retrying<T> retrying, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, (PatienceConfiguration.Interval)interval, fun, (AbstractPatienceConfiguration.PatienceConfig)config, retrying, (Position)pos);
    }

    public <T> T eventually(Function0<T> fun, AbstractPatienceConfiguration.PatienceConfig config, Retrying<T> retrying, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, fun, (AbstractPatienceConfiguration.PatienceConfig)config, retrying, (Position)pos);
    }

    public AbstractPatienceConfiguration.PatienceConfig patienceConfig() {
        return PatienceConfiguration.patienceConfig$((PatienceConfiguration)this);
    }

    public PatienceConfiguration.Timeout timeout(Span value) {
        return PatienceConfiguration.timeout$((PatienceConfiguration)this, (Span)value);
    }

    public PatienceConfiguration.Interval interval(Span value) {
        return PatienceConfiguration.interval$((PatienceConfiguration)this, (Span)value);
    }

    public final Span scaled(Span span) {
        return ScaledTimeSpans.scaled$((ScaledTimeSpans)this, (Span)span);
    }

    public double spanScaleFactor() {
        return ScaledTimeSpans.spanScaleFactor$((ScaledTimeSpans)this);
    }

    public PrivateMethodTester.Invoker anyRefToInvoker(Object target) {
        return PrivateMethodTester.anyRefToInvoker$((PrivateMethodTester)this, (Object)target);
    }

    public <T> T mock(ClassTag<T> classTag) {
        return (T)MockitoSugar.mock$((MockitoSugar)this, classTag);
    }

    public <T> T mock(Answer<?> defaultAnswer, ClassTag<T> classTag) {
        return (T)MockitoSugar.mock$((MockitoSugar)this, defaultAnswer, classTag);
    }

    public <T> T mock(MockSettings mockSettings, ClassTag<T> classTag) {
        return (T)MockitoSugar.mock$((MockitoSugar)this, (MockSettings)mockSettings, classTag);
    }

    public <T> T mock(String name, ClassTag<T> classTag) {
        return (T)MockitoSugar.mock$((MockitoSugar)this, (String)name, classTag);
    }

    public /* synthetic */ void org$apache$spark$streaming$TestSuiteBase$$super$beforeEach() {
        BeforeAndAfterEach.beforeEach$((BeforeAndAfterEach)this);
    }

    public /* synthetic */ void org$apache$spark$streaming$TestSuiteBase$$super$afterEach() {
        BeforeAndAfterEach.afterEach$((BeforeAndAfterEach)this);
    }

    public String framework() {
        return TestSuiteBase.framework$((TestSuiteBase)this);
    }

    public String master() {
        return TestSuiteBase.master$((TestSuiteBase)this);
    }

    public Duration batchDuration() {
        return TestSuiteBase.batchDuration$((TestSuiteBase)this);
    }

    public int numInputPartitions() {
        return TestSuiteBase.numInputPartitions$((TestSuiteBase)this);
    }

    public int maxWaitTimeMillis() {
        return TestSuiteBase.maxWaitTimeMillis$((TestSuiteBase)this);
    }

    public boolean useManualClock() {
        return TestSuiteBase.useManualClock$((TestSuiteBase)this);
    }

    public boolean actuallyWait() {
        return TestSuiteBase.actuallyWait$((TestSuiteBase)this);
    }

    public void beforeFunction() {
        TestSuiteBase.beforeFunction$((TestSuiteBase)this);
    }

    public void afterFunction() {
        TestSuiteBase.afterFunction$((TestSuiteBase)this);
    }

    public void afterEach() {
        TestSuiteBase.afterEach$((TestSuiteBase)this);
    }

    public <R> R withStreamingContext(StreamingContext ssc, Function1<StreamingContext, R> block) {
        return (R)TestSuiteBase.withStreamingContext$((TestSuiteBase)this, (StreamingContext)ssc, block);
    }

    public <R> R withTestServer(TestServer testServer, Function1<TestServer, R> block) {
        return (R)TestSuiteBase.withTestServer$((TestSuiteBase)this, (TestServer)testServer, block);
    }

    public <U, V> StreamingContext setupStreams(Seq<Seq<U>> input, Function1<DStream<U>, DStream<V>> operation, int numPartitions, ClassTag<U> evidence$4, ClassTag<V> evidence$5) {
        return TestSuiteBase.setupStreams$((TestSuiteBase)this, input, operation, (int)numPartitions, evidence$4, evidence$5);
    }

    public <U, V> int setupStreams$default$3() {
        return TestSuiteBase.setupStreams$default$3$((TestSuiteBase)this);
    }

    public <U, V, W> StreamingContext setupStreams(Seq<Seq<U>> input1, Seq<Seq<V>> input2, Function2<DStream<U>, DStream<V>, DStream<W>> operation, ClassTag<U> evidence$6, ClassTag<V> evidence$7, ClassTag<W> evidence$8) {
        return TestSuiteBase.setupStreams$((TestSuiteBase)this, input1, input2, operation, evidence$6, evidence$7, evidence$8);
    }

    public <V> Seq<Seq<V>> runStreams(StreamingContext ssc, int numBatches, int numExpectedOutput, Function0<BoxedUnit> preStop, ClassTag<V> evidence$9) {
        return TestSuiteBase.runStreams$((TestSuiteBase)this, (StreamingContext)ssc, (int)numBatches, (int)numExpectedOutput, preStop, evidence$9);
    }

    public <V> Function0<BoxedUnit> runStreams$default$4() {
        return TestSuiteBase.runStreams$default$4$((TestSuiteBase)this);
    }

    public <V> Seq<Seq<Seq<V>>> runStreamsWithPartitions(StreamingContext ssc, int numBatches, int numExpectedOutput, Function0<BoxedUnit> preStop, ClassTag<V> evidence$10) {
        return TestSuiteBase.runStreamsWithPartitions$((TestSuiteBase)this, (StreamingContext)ssc, (int)numBatches, (int)numExpectedOutput, preStop, evidence$10);
    }

    public <V> Function0<BoxedUnit> runStreamsWithPartitions$default$4() {
        return TestSuiteBase.runStreamsWithPartitions$default$4$((TestSuiteBase)this);
    }

    public <V> void verifyOutput(Seq<Seq<V>> output, Seq<Seq<V>> expectedOutput, boolean useSet, ClassTag<V> evidence$11) {
        TestSuiteBase.verifyOutput$((TestSuiteBase)this, output, expectedOutput, (boolean)useSet, evidence$11);
    }

    public <U, V> void testOperation(Seq<Seq<U>> input, Function1<DStream<U>, DStream<V>> operation, Seq<Seq<V>> expectedOutput, boolean useSet, ClassTag<U> evidence$12, ClassTag<V> evidence$13) {
        TestSuiteBase.testOperation$((TestSuiteBase)this, input, operation, expectedOutput, (boolean)useSet, evidence$12, evidence$13);
    }

    public <U, V> boolean testOperation$default$4() {
        return TestSuiteBase.testOperation$default$4$((TestSuiteBase)this);
    }

    public <U, V> void testOperation(Seq<Seq<U>> input, Function1<DStream<U>, DStream<V>> operation, Seq<Seq<V>> expectedOutput, int numBatches, boolean useSet, ClassTag<U> evidence$14, ClassTag<V> evidence$15) {
        TestSuiteBase.testOperation$((TestSuiteBase)this, input, operation, expectedOutput, (int)numBatches, (boolean)useSet, evidence$14, evidence$15);
    }

    public <U, V, W> void testOperation(Seq<Seq<U>> input1, Seq<Seq<V>> input2, Function2<DStream<U>, DStream<V>, DStream<W>> operation, Seq<Seq<W>> expectedOutput, boolean useSet, ClassTag<U> evidence$16, ClassTag<V> evidence$17, ClassTag<W> evidence$18) {
        TestSuiteBase.testOperation$((TestSuiteBase)this, input1, input2, operation, expectedOutput, (boolean)useSet, evidence$16, evidence$17, evidence$18);
    }

    public <U, V, W> void testOperation(Seq<Seq<U>> input1, Seq<Seq<V>> input2, Function2<DStream<U>, DStream<V>, DStream<W>> operation, Seq<Seq<W>> expectedOutput, int numBatches, boolean useSet, ClassTag<U> evidence$19, ClassTag<V> evidence$20, ClassTag<W> evidence$21) {
        TestSuiteBase.testOperation$((TestSuiteBase)this, input1, input2, operation, expectedOutput, (int)numBatches, (boolean)useSet, evidence$19, evidence$20, evidence$21);
    }

    public AbstractPatienceConfiguration.PatienceConfig org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig() {
        return this.org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig;
    }

    public final void org$scalatest$concurrent$PatienceConfiguration$_setter_$org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig_$eq(AbstractPatienceConfiguration.PatienceConfig x$1) {
        this.org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig = x$1;
    }

    public AbstractPatienceConfiguration$PatienceConfig$ PatienceConfig() {
        if (this.PatienceConfig$module == null) {
            this.PatienceConfig$lzycompute$1();
        }
        return this.PatienceConfig$module;
    }

    public PrivateMethodTester$PrivateMethod$ PrivateMethod() {
        if (this.PrivateMethod$module == null) {
            this.PrivateMethod$lzycompute$1();
        }
        return this.PrivateMethod$module;
    }

    private String checkpointDir$lzycompute() {
        KinesisCheckpointerSuite kinesisCheckpointerSuite = this;
        synchronized (kinesisCheckpointerSuite) {
            if (!this.bitmap$0) {
                this.checkpointDir = TestSuiteBase.checkpointDir$((TestSuiteBase)this);
                this.bitmap$0 = true;
            }
        }
        return this.checkpointDir;
    }

    public String checkpointDir() {
        return !this.bitmap$0 ? this.checkpointDir$lzycompute() : this.checkpointDir;
    }

    public SparkConf conf() {
        return this.conf;
    }

    public PatienceConfiguration.Timeout eventuallyTimeout() {
        return this.eventuallyTimeout;
    }

    public void org$apache$spark$streaming$TestSuiteBase$_setter_$conf_$eq(SparkConf x$1) {
        this.conf = x$1;
    }

    public void org$apache$spark$streaming$TestSuiteBase$_setter_$eventuallyTimeout_$eq(PatienceConfiguration.Timeout x$1) {
        this.eventuallyTimeout = x$1;
    }

    private String workerId() {
        return this.workerId;
    }

    private String shardId() {
        return this.shardId;
    }

    private String seqNum() {
        return this.seqNum;
    }

    private String otherSeqNum() {
        return this.otherSeqNum;
    }

    private Duration checkpointInterval() {
        return this.checkpointInterval;
    }

    private Some<String> someSeqNum() {
        return this.someSeqNum;
    }

    private Some<String> someOtherSeqNum() {
        return this.someOtherSeqNum;
    }

    private KinesisReceiver<byte[]> receiverMock() {
        return this.receiverMock;
    }

    private void receiverMock_$eq(KinesisReceiver<byte[]> x$1) {
        this.receiverMock = x$1;
    }

    private IRecordProcessorCheckpointer checkpointerMock() {
        return this.checkpointerMock;
    }

    private void checkpointerMock_$eq(IRecordProcessorCheckpointer x$1) {
        this.checkpointerMock = x$1;
    }

    private KinesisCheckpointer kinesisCheckpointer() {
        return this.kinesisCheckpointer;
    }

    private void kinesisCheckpointer_$eq(KinesisCheckpointer x$1) {
        this.kinesisCheckpointer = x$1;
    }

    private ManualClock clock() {
        return this.clock;
    }

    private void clock_$eq(ManualClock x$1) {
        this.clock = x$1;
    }

    private PrivateMethodTester.PrivateMethod<BoxedUnit> checkpoint() {
        return this.checkpoint;
    }

    public void beforeEach() {
        this.receiverMock_$eq((KinesisReceiver<byte[]>)((KinesisReceiver)this.mock(ClassTag$.MODULE$.apply(KinesisReceiver.class))));
        this.checkpointerMock_$eq((IRecordProcessorCheckpointer)this.mock(ClassTag$.MODULE$.apply(IRecordProcessorCheckpointer.class)));
        this.clock_$eq(new ManualClock());
        this.kinesisCheckpointer_$eq(new KinesisCheckpointer(this.receiverMock(), this.checkpointInterval(), this.workerId(), (Clock)this.clock()));
    }

    private final void PatienceConfig$lzycompute$1() {
        KinesisCheckpointerSuite kinesisCheckpointerSuite = this;
        synchronized (kinesisCheckpointerSuite) {
            if (this.PatienceConfig$module == null) {
                this.PatienceConfig$module = new AbstractPatienceConfiguration$PatienceConfig$((AbstractPatienceConfiguration)this);
            }
        }
    }

    private final void PrivateMethod$lzycompute$1() {
        KinesisCheckpointerSuite kinesisCheckpointerSuite = this;
        synchronized (kinesisCheckpointerSuite) {
            if (this.PrivateMethod$module == null) {
                this.PrivateMethod$module = new PrivateMethodTester$PrivateMethod$((PrivateMethodTester)this);
            }
        }
    }

    public static final /* synthetic */ long $anonfun$new$10(KinesisCheckpointerSuite $this, InvocationOnMock x$1) {
        return $this.clock().waitTillTime($this.clock().getTimeMillis() + $this.checkpointInterval().milliseconds() / 2L);
    }

    public KinesisCheckpointerSuite() {
        TestSuiteBase.$init$((TestSuiteBase)this);
        MockitoSugar.$init$((MockitoSugar)this);
        PrivateMethodTester.$init$((PrivateMethodTester)this);
        ScaledTimeSpans.$init$((ScaledTimeSpans)this);
        AbstractPatienceConfiguration.$init$((AbstractPatienceConfiguration)this);
        PatienceConfiguration.$init$((PatienceConfiguration)this);
        Eventually.$init$((Eventually)this);
        this.workerId = "dummyWorkerId";
        this.shardId = "dummyShardId";
        this.seqNum = "123";
        this.otherSeqNum = "245";
        this.checkpointInterval = new Duration(10L);
        this.someSeqNum = new Some((Object)this.seqNum());
        this.someOtherSeqNum = new Some((Object)this.otherSeqNum());
        this.checkpoint = this.PrivateMethod().apply((Symbol)SymbolLiteral.bootstrap("apply", "checkpoint"));
        this.test("checkpoint is not called twice for the same sequence number", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Mockito.when((Object)this.receiverMock().getLatestSeqNumToCheckpoint(this.shardId())).thenReturn(this.someSeqNum());
            this.anyRefToInvoker(this.kinesisCheckpointer()).invokePrivate(this.checkpoint().apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.shardId(), this.checkpointerMock()})));
            this.anyRefToInvoker(this.kinesisCheckpointer()).invokePrivate(this.checkpoint().apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.shardId(), this.checkpointerMock()})));
            ((IRecordProcessorCheckpointer)Mockito.verify((Object)this.checkpointerMock(), (VerificationMode)Mockito.times((int)1))).checkpoint(ArgumentMatchers.anyString());
        }, new Position("KinesisCheckpointerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64));
        this.test("checkpoint is called after sequence number increases", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Mockito.when((Object)this.receiverMock().getLatestSeqNumToCheckpoint(this.shardId())).thenReturn(this.someSeqNum()).thenReturn(this.someOtherSeqNum());
            this.anyRefToInvoker(this.kinesisCheckpointer()).invokePrivate(this.checkpoint().apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.shardId(), this.checkpointerMock()})));
            this.anyRefToInvoker(this.kinesisCheckpointer()).invokePrivate(this.checkpoint().apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.shardId(), this.checkpointerMock()})));
            ((IRecordProcessorCheckpointer)Mockito.verify((Object)this.checkpointerMock(), (VerificationMode)Mockito.times((int)1))).checkpoint(this.seqNum());
            ((IRecordProcessorCheckpointer)Mockito.verify((Object)this.checkpointerMock(), (VerificationMode)Mockito.times((int)1))).checkpoint(this.otherSeqNum());
        }, new Position("KinesisCheckpointerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 72));
        this.test("should checkpoint if we have exceeded the checkpoint interval", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Mockito.when((Object)this.receiverMock().getLatestSeqNumToCheckpoint(this.shardId())).thenReturn(this.someSeqNum()).thenReturn(this.someOtherSeqNum());
            this.kinesisCheckpointer().setCheckpointer(this.shardId(), this.checkpointerMock());
            this.clock().advance(5L * this.checkpointInterval().milliseconds());
            this.eventually(this.timeout(Span$.MODULE$.convertDurationToSpan((scala.concurrent.duration.Duration)new package.DurationInt(package$.MODULE$.DurationInt(1)).second())), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                ((IRecordProcessorCheckpointer)Mockito.verify((Object)this.checkpointerMock(), (VerificationMode)Mockito.times((int)1))).checkpoint(this.seqNum());
                ((IRecordProcessorCheckpointer)Mockito.verify((Object)this.checkpointerMock(), (VerificationMode)Mockito.times((int)1))).checkpoint(this.otherSeqNum());
            }, this.patienceConfig(), (Retrying)Retrying$.MODULE$.retryingNatureOfT(), new Position("KinesisCheckpointerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
        }, new Position("KinesisCheckpointerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 82));
        this.test("shouldn't checkpoint if we have not exceeded the checkpoint interval", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Mockito.when((Object)this.receiverMock().getLatestSeqNumToCheckpoint(this.shardId())).thenReturn(this.someSeqNum());
            this.kinesisCheckpointer().setCheckpointer(this.shardId(), this.checkpointerMock());
            this.clock().advance(this.checkpointInterval().milliseconds() / 2L);
            ((IRecordProcessorCheckpointer)Mockito.verify((Object)this.checkpointerMock(), (VerificationMode)Mockito.never())).checkpoint(ArgumentMatchers.anyString());
        }, new Position("KinesisCheckpointerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95));
        this.test("should not checkpoint for the same sequence number", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Mockito.when((Object)this.receiverMock().getLatestSeqNumToCheckpoint(this.shardId())).thenReturn(this.someSeqNum());
            this.kinesisCheckpointer().setCheckpointer(this.shardId(), this.checkpointerMock());
            this.clock().advance(this.checkpointInterval().milliseconds() * 5L);
            this.eventually(this.timeout(Span$.MODULE$.convertDurationToSpan((scala.concurrent.duration.Duration)new package.DurationInt(package$.MODULE$.DurationInt(1)).second())), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IRecordProcessorCheckpointer)Mockito.verify((Object)this.checkpointerMock(), (VerificationMode)Mockito.atMost((int)1))).checkpoint(ArgumentMatchers.anyString()), this.patienceConfig(), (Retrying)Retrying$.MODULE$.retryingNatureOfT(), new Position("KinesisCheckpointerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 110));
        }, new Position("KinesisCheckpointerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 104));
        this.test("removing checkpointer checkpoints one last time", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Mockito.when((Object)this.receiverMock().getLatestSeqNumToCheckpoint(this.shardId())).thenReturn(this.someSeqNum());
            this.kinesisCheckpointer().removeCheckpointer(this.shardId(), this.checkpointerMock());
            ((IRecordProcessorCheckpointer)Mockito.verify((Object)this.checkpointerMock(), (VerificationMode)Mockito.times((int)1))).checkpoint();
        }, new Position("KinesisCheckpointerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 115));
        this.test("if checkpointing is going on, wait until finished before removing and checkpointing", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Mockito.when((Object)this.receiverMock().getLatestSeqNumToCheckpoint(this.shardId())).thenReturn(this.someSeqNum()).thenReturn(this.someOtherSeqNum());
            this.checkpointerMock().checkpoint(ArgumentMatchers.anyString());
            Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$1 -> BoxesRunTime.boxToLong((long)KinesisCheckpointerSuite.$anonfun$new$10(this, x$1)));
            this.kinesisCheckpointer().setCheckpointer(this.shardId(), this.checkpointerMock());
            this.clock().advance(this.checkpointInterval().milliseconds());
            this.eventually(this.timeout(Span$.MODULE$.convertDurationToSpan((scala.concurrent.duration.Duration)new package.DurationInt(package$.MODULE$.DurationInt(1)).second())), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IRecordProcessorCheckpointer)Mockito.verify((Object)this.checkpointerMock(), (VerificationMode)Mockito.times((int)1))).checkpoint(ArgumentMatchers.anyString()), this.patienceConfig(), (Retrying)Retrying$.MODULE$.retryingNatureOfT(), new Position("KinesisCheckpointerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 131));
            Future f = Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.kinesisCheckpointer().removeCheckpointer(this.shardId(), this.checkpointerMock()), (ExecutionContext)ExecutionContext$.MODULE$.global());
            this.intercept((Function0 & Serializable & scala.Serializable)() -> (Future)Await$.MODULE$.ready((Awaitable)f, (scala.concurrent.duration.Duration)new package.DurationInt(package$.MODULE$.DurationInt(50)).milliseconds()), ClassTag$.MODULE$.apply(TimeoutException.class), new Position("KinesisCheckpointerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 138));
            this.clock().advance(this.checkpointInterval().milliseconds() / 2L);
            this.eventually(this.timeout(Span$.MODULE$.convertDurationToSpan((scala.concurrent.duration.Duration)new package.DurationInt(package$.MODULE$.DurationInt(1)).second())), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                ((IRecordProcessorCheckpointer)Mockito.verify((Object)this.checkpointerMock(), (VerificationMode)Mockito.times((int)1))).checkpoint(ArgumentMatchers.anyString());
                ((IRecordProcessorCheckpointer)Mockito.verify((Object)this.checkpointerMock(), (VerificationMode)Mockito.times((int)1))).checkpoint();
            }, this.patienceConfig(), (Retrying)Retrying$.MODULE$.retryingNatureOfT(), new Position("KinesisCheckpointerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 145));
        }, new Position("KinesisCheckpointerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 122));
    }
}

