/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.kinesis;

import com.amazonaws.regions.RegionUtils;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.InitialPositionInStream;
import com.amazonaws.services.kinesis.model.Record;
import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaSparkContext$;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.api.java.JavaReceiverInputDStream;
import org.apache.spark.streaming.api.java.JavaReceiverInputDStream$;
import org.apache.spark.streaming.api.java.JavaStreamingContext;
import org.apache.spark.streaming.dstream.ReceiverInputDStream;
import org.apache.spark.streaming.kinesis.BasicCredentials;
import org.apache.spark.streaming.kinesis.DefaultCredentials$;
import org.apache.spark.streaming.kinesis.KinesisInitialPositions;
import org.apache.spark.streaming.kinesis.KinesisInputDStream;
import org.apache.spark.streaming.kinesis.KinesisInputDStream$;
import org.apache.spark.streaming.kinesis.STSCredentials;
import org.apache.spark.streaming.kinesis.SparkAWSCredentials;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.ScalaRunTime$;

public final class KinesisUtils$ {
    public static KinesisUtils$ MODULE$;

    static {
        new KinesisUtils$();
    }

    public <T> ReceiverInputDStream<T> createStream(StreamingContext ssc, String kinesisAppName, String streamName, String endpointUrl, String regionName, InitialPositionInStream initialPositionInStream, Duration checkpointInterval, StorageLevel storageLevel, Function1<Record, T> messageHandler, ClassTag<T> evidence$1) {
        Function1 cleanedHandler = (Function1)ssc.sc().clean(messageHandler, ssc.sc().clean$default$2());
        return (ReceiverInputDStream)ssc.withNamedScope("kinesis stream", (Function0 & Serializable & scala.Serializable)() -> new KinesisInputDStream(ssc, streamName, endpointUrl, MODULE$.validateRegion(regionName), KinesisInitialPositions.fromKinesisInitialPosition(initialPositionInStream), kinesisAppName, checkpointInterval, storageLevel, cleanedHandler, DefaultCredentials$.MODULE$, (Option<SparkAWSCredentials>)None$.MODULE$, (Option<SparkAWSCredentials>)None$.MODULE$, evidence$1));
    }

    public <T> ReceiverInputDStream<T> createStream(StreamingContext ssc, String kinesisAppName, String streamName, String endpointUrl, String regionName, InitialPositionInStream initialPositionInStream, Duration checkpointInterval, StorageLevel storageLevel, Function1<Record, T> messageHandler, String awsAccessKeyId, String awsSecretKey, ClassTag<T> evidence$2) {
        Function1 cleanedHandler = (Function1)ssc.sc().clean(messageHandler, ssc.sc().clean$default$2());
        return (ReceiverInputDStream)ssc.withNamedScope("kinesis stream", (Function0 & Serializable & scala.Serializable)() -> {
            BasicCredentials kinesisCredsProvider = new BasicCredentials(awsAccessKeyId, awsSecretKey);
            return new KinesisInputDStream(ssc, streamName, endpointUrl, MODULE$.validateRegion(regionName), KinesisInitialPositions.fromKinesisInitialPosition(initialPositionInStream), kinesisAppName, checkpointInterval, storageLevel, cleanedHandler, kinesisCredsProvider, (Option<SparkAWSCredentials>)None$.MODULE$, (Option<SparkAWSCredentials>)None$.MODULE$, evidence$2);
        });
    }

    public <T> ReceiverInputDStream<T> createStream(StreamingContext ssc, String kinesisAppName, String streamName, String endpointUrl, String regionName, InitialPositionInStream initialPositionInStream, Duration checkpointInterval, StorageLevel storageLevel, Function1<Record, T> messageHandler, String awsAccessKeyId, String awsSecretKey, String stsAssumeRoleArn, String stsSessionName, String stsExternalId, ClassTag<T> evidence$3) {
        Function1 cleanedHandler = (Function1)ssc.sc().clean(messageHandler, ssc.sc().clean$default$2());
        return (ReceiverInputDStream)ssc.withNamedScope("kinesis stream", (Function0 & Serializable & scala.Serializable)() -> {
            STSCredentials kinesisCredsProvider = new STSCredentials(stsAssumeRoleArn, stsSessionName, (Option<String>)Option$.MODULE$.apply((Object)stsExternalId), new BasicCredentials(awsAccessKeyId, awsSecretKey));
            return new KinesisInputDStream(ssc, streamName, endpointUrl, MODULE$.validateRegion(regionName), KinesisInitialPositions.fromKinesisInitialPosition(initialPositionInStream), kinesisAppName, checkpointInterval, storageLevel, cleanedHandler, kinesisCredsProvider, (Option<SparkAWSCredentials>)None$.MODULE$, (Option<SparkAWSCredentials>)None$.MODULE$, evidence$3);
        });
    }

    public ReceiverInputDStream<byte[]> createStream(StreamingContext ssc, String kinesisAppName, String streamName, String endpointUrl, String regionName, InitialPositionInStream initialPositionInStream, Duration checkpointInterval, StorageLevel storageLevel) {
        return (ReceiverInputDStream)ssc.withNamedScope("kinesis stream", (Function0 & Serializable & scala.Serializable)() -> new KinesisInputDStream(ssc, streamName, endpointUrl, MODULE$.validateRegion(regionName), KinesisInitialPositions.fromKinesisInitialPosition(initialPositionInStream), kinesisAppName, checkpointInterval, storageLevel, (Function1 & Serializable & scala.Serializable)record -> KinesisInputDStream$.MODULE$.defaultMessageHandler((Record)record), DefaultCredentials$.MODULE$, (Option<SparkAWSCredentials>)None$.MODULE$, (Option<SparkAWSCredentials>)None$.MODULE$, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE))));
    }

    public ReceiverInputDStream<byte[]> createStream(StreamingContext ssc, String kinesisAppName, String streamName, String endpointUrl, String regionName, InitialPositionInStream initialPositionInStream, Duration checkpointInterval, StorageLevel storageLevel, String awsAccessKeyId, String awsSecretKey) {
        return (ReceiverInputDStream)ssc.withNamedScope("kinesis stream", (Function0 & Serializable & scala.Serializable)() -> {
            BasicCredentials kinesisCredsProvider = new BasicCredentials(awsAccessKeyId, awsSecretKey);
            return new KinesisInputDStream(ssc, streamName, endpointUrl, MODULE$.validateRegion(regionName), KinesisInitialPositions.fromKinesisInitialPosition(initialPositionInStream), kinesisAppName, checkpointInterval, storageLevel, (Function1 & Serializable & scala.Serializable)record -> KinesisInputDStream$.MODULE$.defaultMessageHandler((Record)record), kinesisCredsProvider, (Option<SparkAWSCredentials>)None$.MODULE$, (Option<SparkAWSCredentials>)None$.MODULE$, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
        });
    }

    public <T> JavaReceiverInputDStream<T> createStream(JavaStreamingContext jssc, String kinesisAppName, String streamName, String endpointUrl, String regionName, InitialPositionInStream initialPositionInStream, Duration checkpointInterval, StorageLevel storageLevel, Function<Record, T> messageHandler, Class<T> recordClass) {
        ClassTag recordCmt = ClassTag$.MODULE$.apply(recordClass);
        SparkContext qual$1 = JavaSparkContext$.MODULE$.toSparkContext(jssc.sparkContext());
        Function1 & Serializable & scala.Serializable x$12 = (Function1 & Serializable & scala.Serializable)x$1 -> messageHandler.call(x$1);
        boolean x$2 = qual$1.clean$default$2();
        Function1 cleanedHandler = (Function1)qual$1.clean((Object)x$12, x$2);
        return JavaReceiverInputDStream$.MODULE$.fromReceiverInputDStream(this.createStream(jssc.ssc(), kinesisAppName, streamName, endpointUrl, regionName, initialPositionInStream, checkpointInterval, storageLevel, cleanedHandler, recordCmt), recordCmt);
    }

    public <T> JavaReceiverInputDStream<T> createStream(JavaStreamingContext jssc, String kinesisAppName, String streamName, String endpointUrl, String regionName, InitialPositionInStream initialPositionInStream, Duration checkpointInterval, StorageLevel storageLevel, Function<Record, T> messageHandler, Class<T> recordClass, String awsAccessKeyId, String awsSecretKey) {
        ClassTag recordCmt = ClassTag$.MODULE$.apply(recordClass);
        SparkContext qual$1 = JavaSparkContext$.MODULE$.toSparkContext(jssc.sparkContext());
        Function1 & Serializable & scala.Serializable x$1 = (Function1 & Serializable & scala.Serializable)x$2 -> messageHandler.call(x$2);
        boolean x$22 = qual$1.clean$default$2();
        Function1 cleanedHandler = (Function1)qual$1.clean((Object)x$1, x$22);
        return JavaReceiverInputDStream$.MODULE$.fromReceiverInputDStream(this.createStream(jssc.ssc(), kinesisAppName, streamName, endpointUrl, regionName, initialPositionInStream, checkpointInterval, storageLevel, cleanedHandler, awsAccessKeyId, awsSecretKey, recordCmt), recordCmt);
    }

    public <T> JavaReceiverInputDStream<T> createStream(JavaStreamingContext jssc, String kinesisAppName, String streamName, String endpointUrl, String regionName, InitialPositionInStream initialPositionInStream, Duration checkpointInterval, StorageLevel storageLevel, Function<Record, T> messageHandler, Class<T> recordClass, String awsAccessKeyId, String awsSecretKey, String stsAssumeRoleArn, String stsSessionName, String stsExternalId) {
        ClassTag recordCmt = ClassTag$.MODULE$.apply(recordClass);
        SparkContext qual$1 = JavaSparkContext$.MODULE$.toSparkContext(jssc.sparkContext());
        Function1 & Serializable & scala.Serializable x$1 = (Function1 & Serializable & scala.Serializable)x$3 -> messageHandler.call(x$3);
        boolean x$2 = qual$1.clean$default$2();
        Function1 cleanedHandler = (Function1)qual$1.clean((Object)x$1, x$2);
        return JavaReceiverInputDStream$.MODULE$.fromReceiverInputDStream(this.createStream(jssc.ssc(), kinesisAppName, streamName, endpointUrl, regionName, initialPositionInStream, checkpointInterval, storageLevel, cleanedHandler, awsAccessKeyId, awsSecretKey, stsAssumeRoleArn, stsSessionName, stsExternalId, recordCmt), recordCmt);
    }

    public JavaReceiverInputDStream<byte[]> createStream(JavaStreamingContext jssc, String kinesisAppName, String streamName, String endpointUrl, String regionName, InitialPositionInStream initialPositionInStream, Duration checkpointInterval, StorageLevel storageLevel) {
        return JavaReceiverInputDStream$.MODULE$.fromReceiverInputDStream(this.createStream(jssc.ssc(), kinesisAppName, streamName, endpointUrl, regionName, initialPositionInStream, checkpointInterval, storageLevel, (Function1 & Serializable & scala.Serializable)x$4 -> KinesisInputDStream$.MODULE$.defaultMessageHandler((Record)x$4), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE))), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
    }

    public JavaReceiverInputDStream<byte[]> createStream(JavaStreamingContext jssc, String kinesisAppName, String streamName, String endpointUrl, String regionName, InitialPositionInStream initialPositionInStream, Duration checkpointInterval, StorageLevel storageLevel, String awsAccessKeyId, String awsSecretKey) {
        return JavaReceiverInputDStream$.MODULE$.fromReceiverInputDStream(this.createStream(jssc.ssc(), kinesisAppName, streamName, endpointUrl, regionName, initialPositionInStream, checkpointInterval, storageLevel, (Function1 & Serializable & scala.Serializable)x$5 -> KinesisInputDStream$.MODULE$.defaultMessageHandler((Record)x$5), awsAccessKeyId, awsSecretKey, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE))), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
    }

    private String validateRegion(String regionName) {
        return (String)Option$.MODULE$.apply((Object)RegionUtils.getRegion((String)regionName)).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.getName()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(27).append("Region name '").append(regionName).append("' is not valid").toString());
        });
    }

    private KinesisUtils$() {
        MODULE$ = this;
    }
}

