/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.kinesis;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.kinesis.clientlibrary.interfaces.IRecordProcessor;
import com.amazonaws.services.kinesis.clientlibrary.interfaces.IRecordProcessorCheckpointer;
import com.amazonaws.services.kinesis.clientlibrary.interfaces.IRecordProcessorFactory;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.KinesisClientLibConfiguration;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.Worker;
import com.amazonaws.services.kinesis.model.Record;
import java.io.Serializable;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.spark.internal.Logging;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StreamBlockId;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.kinesis.KinesisCheckpointer;
import org.apache.spark.streaming.kinesis.KinesisCheckpointer$;
import org.apache.spark.streaming.kinesis.KinesisInitialPosition;
import org.apache.spark.streaming.kinesis.KinesisInitialPositions;
import org.apache.spark.streaming.kinesis.KinesisRecordProcessor;
import org.apache.spark.streaming.kinesis.SequenceNumberRange;
import org.apache.spark.streaming.kinesis.SequenceNumberRanges;
import org.apache.spark.streaming.kinesis.SparkAWSCredentials;
import org.apache.spark.streaming.receiver.BlockGenerator;
import org.apache.spark.streaming.receiver.BlockGeneratorListener;
import org.apache.spark.streaming.receiver.Receiver;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\tEg!B\u001a5\u0001Qr\u0004\u0002C.\u0001\u0005\u000b\u0007I\u0011\u0001/\t\u0011!\u0004!\u0011!Q\u0001\nuC\u0001\"\u001b\u0001\u0003\u0002\u0003\u0006I!\u0018\u0005\tU\u0002\u0011\t\u0011)A\u0005;\"A1\u000e\u0001B\u0001B\u0003%A\u000e\u0003\u0005q\u0001\t\u0005\t\u0015!\u0003^\u0011!\t\bA!A!\u0002\u0013\u0011\b\"\u0003<\u0001\u0005\u0003\u0005\u000b\u0011B<~\u0011!q\bA!A!\u0002\u0013y\bBCA\u0010\u0001\t\u0005\t\u0015!\u0003\u0002\"!Q\u0011q\u0005\u0001\u0003\u0002\u0003\u0006I!!\u000b\t\u0015\u0005=\u0002A!A!\u0002\u0013\tI\u0003C\u0004\u00022\u0001!\t!a\r\t\u0011\u00055\u0003\u00011A\u0005\nqC\u0011\"a\u0014\u0001\u0001\u0004%I!!\u0015\t\u000f\u0005u\u0003\u0001)Q\u0005;\"I\u0011q\r\u0001A\u0002\u0013%\u0011\u0011\u000e\u0005\n\u0003{\u0002\u0001\u0019!C\u0005\u0003\u007fB\u0001\"a!\u0001A\u0003&\u00111\u000e\u0005\n\u0003\u000f\u0003\u0001\u0019!C\u0005\u0003\u0013C\u0011\"a'\u0001\u0001\u0004%I!!(\t\u0011\u0005\u0005\u0006\u0001)Q\u0005\u0003\u0017C\u0011\"!*\u0001\u0001\u0004%I!a*\t\u0013\u0005=\u0006\u00011A\u0005\n\u0005E\u0006\u0002CA[\u0001\u0001\u0006K!!+\t\u0013\u0005e\u0006A1A\u0005\n\u0005m\u0006\u0002CAj\u0001\u0001\u0006I!!0\t\u0013\u0005U\u0007A1A\u0005\n\u0005]\u0007\u0002CA{\u0001\u0001\u0006I!!7\t\u0013\u0005]\b\u00011A\u0005\n\u0005e\b\"\u0003B\u0001\u0001\u0001\u0007I\u0011\u0002B\u0002\u0011!\u00119\u0001\u0001Q!\n\u0005m\b\"\u0003B\u0006\u0001\t\u0007I\u0011\u0002B\u0007\u0011!\u0011\t\u0002\u0001Q\u0001\n\t=\u0001b\u0002B\n\u0001\u0011\u0005#Q\u0003\u0005\b\u0005/\u0001A\u0011\tB\u000b\u0011!\u0011I\u0002\u0001C\u0001i\tm\u0001\u0002\u0003B\u0017\u0001\u0011\u0005AGa\f\t\u0011\t]\u0002\u0001\"\u00015\u0005sAqAa\u0010\u0001\t\u0003\u0011\t\u0005C\u0004\u0003V\u0001!\tAa\u0016\t\u000f\tu\u0003\u0001\"\u0003\u0003`!9!Q\r\u0001\u0005\n\t\u001d\u0004b\u0002B7\u0001\u0011%!q\u000e\u0004\u0007\u0005s\u0002AAa\u001f\t\u000f\u0005ER\u0006\"\u0001\u0003\n\"9!qR\u0017\u0005\u0002\tE\u0005b\u0002BN[\u0011\u0005!Q\u0014\u0005\b\u0005CkC\u0011\u0001BR\u0011\u001d\u0011\u0019,\fC\u0001\u0005k\u0013qbS5oKNL7OU3dK&4XM\u001d\u0006\u0003kY\nqa[5oKNL7O\u0003\u00028q\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003si\nQa\u001d9be.T!a\u000f\u001f\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0014aA8sOV\u0011q\bS\n\u0004\u0001\u0001+\u0006cA!E\r6\t!I\u0003\u0002Dm\u0005A!/Z2fSZ,'/\u0003\u0002F\u0005\nA!+Z2fSZ,'\u000f\u0005\u0002H\u00112\u0001A!B%\u0001\u0005\u0004Y%!\u0001+\u0004\u0001E\u0011AJ\u0015\t\u0003\u001bBk\u0011A\u0014\u0006\u0002\u001f\u0006)1oY1mC&\u0011\u0011K\u0014\u0002\b\u001d>$\b.\u001b8h!\ti5+\u0003\u0002U\u001d\n\u0019\u0011I\\=\u0011\u0005YKV\"A,\u000b\u0005aC\u0014\u0001C5oi\u0016\u0014h.\u00197\n\u0005i;&a\u0002'pO\u001eLgnZ\u0001\u000bgR\u0014X-Y7OC6,W#A/\u0011\u0005y+gBA0d!\t\u0001g*D\u0001b\u0015\t\u0011'*\u0001\u0004=e>|GOP\u0005\u0003I:\u000ba\u0001\u0015:fI\u00164\u0017B\u00014h\u0005\u0019\u0019FO]5oO*\u0011AMT\u0001\fgR\u0014X-Y7OC6,\u0007%A\u0006f]\u0012\u0004x.\u001b8u+Jd\u0017A\u0003:fO&|gNT1nK\u0006y\u0011N\\5uS\u0006d\u0007k\\:ji&|g\u000e\u0005\u0002n]6\tA'\u0003\u0002pi\t12*\u001b8fg&\u001c\u0018J\\5uS\u0006d\u0007k\\:ji&|g.A\tdQ\u0016\u001c7\u000e]8j]R\f\u0005\u000f\u001d(b[\u0016\f!c\u00195fG.\u0004x.\u001b8u\u0013:$XM\u001d<bYB\u00111\u000f^\u0007\u0002m%\u0011QO\u000e\u0002\t\tV\u0014\u0018\r^5p]\u0006a1\u000f^8sC\u001e,G*\u001a<fYB\u0011\u0001p_\u0007\u0002s*\u0011!\u0010O\u0001\bgR|'/Y4f\u0013\ta\u0018P\u0001\u0007Ti>\u0014\u0018mZ3MKZ,G.\u0003\u0002w\t\u0006qQ.Z:tC\u001e,\u0007*\u00198eY\u0016\u0014\bCB'\u0002\u0002\u0005\u0015a)C\u0002\u0002\u00049\u0013\u0011BR;oGRLwN\\\u0019\u0011\t\u0005\u001d\u00111D\u0007\u0003\u0003\u0013QA!a\u0003\u0002\u000e\u0005)Qn\u001c3fY*\u0019Q'a\u0004\u000b\t\u0005E\u00111C\u0001\tg\u0016\u0014h/[2fg*!\u0011QCA\f\u0003%\tW.\u0019>p]\u0006<8O\u0003\u0002\u0002\u001a\u0005\u00191m\\7\n\t\u0005u\u0011\u0011\u0002\u0002\u0007%\u0016\u001cwN\u001d3\u0002\u0019-Lg.Z:jg\u000e\u0013X\rZ:\u0011\u00075\f\u0019#C\u0002\u0002&Q\u00121c\u00159be.\fukU\"sK\u0012,g\u000e^5bYN\fQ\u0002Z=oC6|GIQ\"sK\u0012\u001c\b#B'\u0002,\u0005\u0005\u0012bAA\u0017\u001d\n1q\n\u001d;j_:\fqb\u00197pk\u0012<\u0016\r^2i\u0007J,Gm]\u0001\u0007y%t\u0017\u000e\u001e \u00151\u0005U\u0012qGA\u001d\u0003w\ti$a\u0010\u0002B\u0005\r\u0013QIA$\u0003\u0013\nY\u0005E\u0002n\u0001\u0019CQaW\u0007A\u0002uCQ![\u0007A\u0002uCQA[\u0007A\u0002uCQa[\u0007A\u00021DQ\u0001]\u0007A\u0002uCQ!]\u0007A\u0002IDQA^\u0007A\u0002]DQA`\u0007A\u0002}Dq!a\b\u000e\u0001\u0004\t\t\u0003C\u0004\u0002(5\u0001\r!!\u000b\t\u000f\u0005=R\u00021\u0001\u0002*\u0005Aqo\u001c:lKJLE-\u0001\u0007x_J\\WM]%e?\u0012*\u0017\u000f\u0006\u0003\u0002T\u0005e\u0003cA'\u0002V%\u0019\u0011q\u000b(\u0003\tUs\u0017\u000e\u001e\u0005\t\u00037z\u0011\u0011!a\u0001;\u0006\u0019\u0001\u0010J\u0019\u0002\u0013]|'o[3s\u0013\u0012\u0004\u0003f\u0001\t\u0002bA\u0019Q*a\u0019\n\u0007\u0005\u0015dJ\u0001\u0005w_2\fG/\u001b7f\u0003\u00199xN]6feV\u0011\u00111\u000e\t\u0005\u0003[\nI(\u0004\u0002\u0002p)!\u0011qMA9\u0015\u0011\t\u0019(!\u001e\u0002\u00071L'M\u0003\u0003\u0002x\u00055\u0011!D2mS\u0016tG\u000f\\5ce\u0006\u0014\u00180\u0003\u0003\u0002|\u0005=$AB,pe.,'/\u0001\u0006x_J\\WM]0%KF$B!a\u0015\u0002\u0002\"I\u00111\f\n\u0002\u0002\u0003\u0007\u00111N\u0001\bo>\u00148.\u001a:!Q\r\u0019\u0012\u0011M\u0001\ro>\u00148.\u001a:UQJ,\u0017\rZ\u000b\u0003\u0003\u0017\u0003B!!$\u0002\u00186\u0011\u0011q\u0012\u0006\u0005\u0003#\u000b\u0019*\u0001\u0003mC:<'BAAK\u0003\u0011Q\u0017M^1\n\t\u0005e\u0015q\u0012\u0002\u0007)\"\u0014X-\u00193\u0002!]|'o[3s)\"\u0014X-\u00193`I\u0015\fH\u0003BA*\u0003?C\u0011\"a\u0017\u0016\u0003\u0003\u0005\r!a#\u0002\u001b]|'o[3s)\"\u0014X-\u00193!Q\r1\u0012\u0011M\u0001\u000fE2|7m[$f]\u0016\u0014\u0018\r^8s+\t\tI\u000bE\u0002B\u0003WK1!!,C\u00059\u0011En\\2l\u000f\u0016tWM]1u_J\f!C\u00197pG.<UM\\3sCR|'o\u0018\u0013fcR!\u00111KAZ\u0011%\tY\u0006GA\u0001\u0002\u0004\tI+A\bcY>\u001c7nR3oKJ\fGo\u001c:!Q\rI\u0012\u0011M\u0001\u001bg\u0016\fh*^7SC:<Wm]%o\u0007V\u0014(/\u001a8u\u00052|7m[\u000b\u0003\u0003{\u0003b!a0\u0002J\u00065WBAAa\u0015\u0011\t\u0019-!2\u0002\u000f5,H/\u00192mK*\u0019\u0011q\u0019(\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002L\u0006\u0005'aC!se\u0006L()\u001e4gKJ\u00042!\\Ah\u0013\r\t\t\u000e\u000e\u0002\u0014'\u0016\fX/\u001a8dK:+XNY3s%\u0006tw-Z\u0001\u001cg\u0016\fh*^7SC:<Wm]%o\u0007V\u0014(/\u001a8u\u00052|7m\u001b\u0011\u0002+\tdwnY6JIR{7+Z9Ok6\u0014\u0016M\\4fgV\u0011\u0011\u0011\u001c\t\t\u00037\f)/!;\u0002p6\u0011\u0011Q\u001c\u0006\u0005\u0003?\f\t/\u0001\u0006d_:\u001cWO\u001d:f]RTA!a9\u0002\u0014\u0006!Q\u000f^5m\u0013\u0011\t9/!8\u0003#\r{gnY;se\u0016tG\u000fS1tQ6\u000b\u0007\u000fE\u0002y\u0003WL1!!<z\u00055\u0019FO]3b[\ncwnY6JIB\u0019Q.!=\n\u0007\u0005MHG\u0001\u000bTKF,XM\\2f\u001dVl'-\u001a:SC:<Wm]\u0001\u0017E2|7m[%e)>\u001cV-\u001d(v[J\u000bgnZ3tA\u0005\u00192.\u001b8fg&\u001c8\t[3dWB|\u0017N\u001c;feV\u0011\u00111 \t\u0004[\u0006u\u0018bAA\u0000i\t\u00192*\u001b8fg&\u001c8\t[3dWB|\u0017N\u001c;fe\u000692.\u001b8fg&\u001c8\t[3dWB|\u0017N\u001c;fe~#S-\u001d\u000b\u0005\u0003'\u0012)\u0001C\u0005\u0002\\}\t\t\u00111\u0001\u0002|\u0006!2.\u001b8fg&\u001c8\t[3dWB|\u0017N\u001c;fe\u0002B3\u0001IA1\u0003m\u0019\b.\u0019:e\u0013\u0012$v\u000eT1uKN$8\u000b^8sK\u0012\u001cV-\u001d(v[V\u0011!q\u0002\t\u0007\u00037\f)/X/\u00029MD\u0017M\u001d3JIR{G*\u0019;fgR\u001cFo\u001c:fIN+\u0017OT;nA\u00059qN\\*uCJ$HCAA*\u0003\u0019ygn\u0015;pa\u0006Q\u0011\r\u001a3SK\u000e|'\u000fZ:\u0015\r\u0005M#Q\u0004B\u0011\u0011\u0019\u0011y\"\na\u0001;\u000691\u000f[1sI&#\u0007b\u0002B\u0012K\u0001\u0007!QE\u0001\be\u0016\u001cwN\u001d3t!\u0019\u00119C!\u000b\u0002\u00065\u0011\u0011\u0011]\u0005\u0005\u0005W\t\tO\u0001\u0003MSN$\u0018aD4fi\u000e+(O]3oi2KW.\u001b;\u0016\u0005\tE\u0002cA'\u00034%\u0019!Q\u0007(\u0003\u0007%sG/A\u000ehKRd\u0015\r^3tiN+\u0017OT;n)>\u001c\u0005.Z2la>Lg\u000e\u001e\u000b\u0005\u0005w\u0011i\u0004\u0005\u0003N\u0003Wi\u0006B\u0002B\u0010O\u0001\u0007Q,A\btKR\u001c\u0005.Z2la>Lg\u000e^3s)\u0019\t\u0019Fa\u0011\u0003F!1!q\u0004\u0015A\u0002uCqAa\u0012)\u0001\u0004\u0011I%\u0001\u0007dQ\u0016\u001c7\u000e]8j]R,'\u000f\u0005\u0003\u0003L\tESB\u0001B'\u0015\u0011\u0011y%!\u001e\u0002\u0015%tG/\u001a:gC\u000e,7/\u0003\u0003\u0003T\t5#\u0001H%SK\u000e|'\u000f\u001a)s_\u000e,7o]8s\u0007\",7m\u001b9pS:$XM]\u0001\u0013e\u0016lwN^3DQ\u0016\u001c7\u000e]8j]R,'\u000f\u0006\u0004\u0002T\te#1\f\u0005\u0007\u0005?I\u0003\u0019A/\t\u000f\t\u001d\u0013\u00061\u0001\u0003J\u0005\u0011\"/Z7f[\n,'/\u00113eK\u0012\u0014\u0016M\\4f)\u0011\t\u0019F!\u0019\t\u000f\t\r$\u00061\u0001\u0002N\u0006)!/\u00198hK\u0006ib-\u001b8bY&TXMU1oO\u0016\u001chi\u001c:DkJ\u0014XM\u001c;CY>\u001c7\u000e\u0006\u0003\u0002T\t%\u0004b\u0002B6W\u0001\u0007\u0011\u0011^\u0001\bE2|7m[%e\u0003Q\u0019Ho\u001c:f\u00052|7m[,ji\"\u0014\u0016M\\4fgR1\u00111\u000bB9\u0005gBqAa\u001b-\u0001\u0004\tI\u000fC\u0004\u0003v1\u0002\rAa\u001e\u0002\u0017\u0005\u0014(/Y=Ck\u001a4WM\u001d\t\u0006\u0003\u007f\u000bIM\u0012\u0002\u0016\u000f\u0016tWM]1uK\u0012\u0014En\\2l\u0011\u0006tG\r\\3s'\u0015i#Q\u0010BB!\ri%qP\u0005\u0004\u0005\u0003s%AB!osJ+g\rE\u0002B\u0005\u000bK1Aa\"C\u0005Y\u0011En\\2l\u000f\u0016tWM]1u_Jd\u0015n\u001d;f]\u0016\u0014HC\u0001BF!\r\u0011i)L\u0007\u0002\u0001\u0005IqN\\!eI\u0012\u000bG/\u0019\u000b\u0007\u0003'\u0012\u0019Ja&\t\r\tUu\u00061\u0001S\u0003\u0011!\u0017\r^1\t\r\teu\u00061\u0001S\u0003!iW\r^1eCR\f\u0017aD8o\u000f\u0016tWM]1uK\ncwnY6\u0015\t\u0005M#q\u0014\u0005\b\u0005W\u0002\u0004\u0019AAu\u0003-yg\u000eU;tQ\ncwnY6\u0015\r\u0005M#Q\u0015BT\u0011\u001d\u0011Y'\ra\u0001\u0003SDqA!\u001e2\u0001\u0004\u0011I\u000b\r\u0003\u0003,\n=\u0006CBA`\u0003\u0013\u0014i\u000bE\u0002H\u0005_#1B!-\u0003(\u0006\u0005\t\u0011!B\u0001\u0017\n\u0019q\fJ\u0019\u0002\u000f=tWI\u001d:peR1\u00111\u000bB\\\u0005wCaA!/3\u0001\u0004i\u0016aB7fgN\fw-\u001a\u0005\b\u0005{\u0013\u0004\u0019\u0001B`\u0003%!\bN]8xC\ndW\r\u0005\u0003\u0003B\n-g\u0002\u0002Bb\u0005\u000ft1\u0001\u0019Bc\u0013\u0005y\u0015b\u0001Be\u001d\u00069\u0001/Y2lC\u001e,\u0017\u0002\u0002Bg\u0005\u001f\u0014\u0011\u0002\u00165s_^\f'\r\\3\u000b\u0007\t%g\n")
public class KinesisReceiver<T>
extends Receiver<T>
implements Logging {
    private final String streamName;
    private final String endpointUrl;
    private final String regionName;
    private final KinesisInitialPosition initialPosition;
    private final String checkpointAppName;
    private final Duration checkpointInterval;
    private final Function1<Record, T> messageHandler;
    private final SparkAWSCredentials kinesisCreds;
    private final Option<SparkAWSCredentials> dynamoDBCreds;
    private final Option<SparkAWSCredentials> cloudWatchCreds;
    private volatile String org$apache$spark$streaming$kinesis$KinesisReceiver$$workerId;
    private volatile Worker org$apache$spark$streaming$kinesis$KinesisReceiver$$worker;
    private volatile Thread workerThread;
    private volatile BlockGenerator blockGenerator;
    private final ArrayBuffer<SequenceNumberRange> seqNumRangesInCurrentBlock;
    private final ConcurrentHashMap<StreamBlockId, SequenceNumberRanges> blockIdToSeqNumRanges;
    private volatile KinesisCheckpointer kinesisCheckpointer;
    private final ConcurrentHashMap<String, String> shardIdToLatestStoredSeqNum;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String streamName() {
        return this.streamName;
    }

    public String org$apache$spark$streaming$kinesis$KinesisReceiver$$workerId() {
        return this.org$apache$spark$streaming$kinesis$KinesisReceiver$$workerId;
    }

    private void org$apache$spark$streaming$kinesis$KinesisReceiver$$workerId_$eq(String x$1) {
        this.org$apache$spark$streaming$kinesis$KinesisReceiver$$workerId = x$1;
    }

    public Worker org$apache$spark$streaming$kinesis$KinesisReceiver$$worker() {
        return this.org$apache$spark$streaming$kinesis$KinesisReceiver$$worker;
    }

    private void org$apache$spark$streaming$kinesis$KinesisReceiver$$worker_$eq(Worker x$1) {
        this.org$apache$spark$streaming$kinesis$KinesisReceiver$$worker = x$1;
    }

    private Thread workerThread() {
        return this.workerThread;
    }

    private void workerThread_$eq(Thread x$1) {
        this.workerThread = x$1;
    }

    private BlockGenerator blockGenerator() {
        return this.blockGenerator;
    }

    private void blockGenerator_$eq(BlockGenerator x$1) {
        this.blockGenerator = x$1;
    }

    private ArrayBuffer<SequenceNumberRange> seqNumRangesInCurrentBlock() {
        return this.seqNumRangesInCurrentBlock;
    }

    private ConcurrentHashMap<StreamBlockId, SequenceNumberRanges> blockIdToSeqNumRanges() {
        return this.blockIdToSeqNumRanges;
    }

    private KinesisCheckpointer kinesisCheckpointer() {
        return this.kinesisCheckpointer;
    }

    private void kinesisCheckpointer_$eq(KinesisCheckpointer x$1) {
        this.kinesisCheckpointer = x$1;
    }

    private ConcurrentHashMap<String, String> shardIdToLatestStoredSeqNum() {
        return this.shardIdToLatestStoredSeqNum;
    }

    public void onStart() {
        KinesisClientLibConfiguration kinesisClientLibConfiguration;
        this.blockGenerator_$eq(this.supervisor().createBlockGenerator((BlockGeneratorListener)new GeneratedBlockHandler()));
        this.org$apache$spark$streaming$kinesis$KinesisReceiver$$workerId_$eq(new StringBuilder(1).append(Utils$.MODULE$.localHostName()).append(":").append(UUID.randomUUID()).toString());
        this.kinesisCheckpointer_$eq(new KinesisCheckpointer(this, this.checkpointInterval, this.org$apache$spark$streaming$kinesis$KinesisReceiver$$workerId(), KinesisCheckpointer$.MODULE$.$lessinit$greater$default$4()));
        AWSCredentialsProvider kinesisProvider = this.kinesisCreds.provider();
        KinesisClientLibConfiguration baseClientLibConfiguration = new KinesisClientLibConfiguration(this.checkpointAppName, this.streamName(), kinesisProvider, (AWSCredentialsProvider)this.dynamoDBCreds.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.provider()).getOrElse((Function0 & Serializable & scala.Serializable)() -> kinesisProvider), (AWSCredentialsProvider)this.cloudWatchCreds.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.provider()).getOrElse((Function0 & Serializable & scala.Serializable)() -> kinesisProvider), this.org$apache$spark$streaming$kinesis$KinesisReceiver$$workerId()).withKinesisEndpoint(this.endpointUrl).withTaskBackoffTimeMillis(500L).withRegionName(this.regionName);
        KinesisInitialPosition kinesisInitialPosition = this.initialPosition;
        if (kinesisInitialPosition instanceof KinesisInitialPositions.AtTimestamp) {
            KinesisInitialPositions.AtTimestamp atTimestamp = (KinesisInitialPositions.AtTimestamp)kinesisInitialPosition;
            kinesisClientLibConfiguration = baseClientLibConfiguration.withTimestampAtInitialPositionInStream(atTimestamp.getTimestamp());
        } else {
            kinesisClientLibConfiguration = baseClientLibConfiguration.withInitialPositionInStream(this.initialPosition.getPosition());
        }
        KinesisClientLibConfiguration kinesisClientLibConfiguration2 = kinesisClientLibConfiguration;
        IRecordProcessorFactory recordProcessorFactory = new IRecordProcessorFactory(this){
            private final /* synthetic */ KinesisReceiver $outer;

            public IRecordProcessor createProcessor() {
                return new KinesisRecordProcessor<T>(this.$outer, this.$outer.org$apache$spark$streaming$kinesis$KinesisReceiver$$workerId());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        this.org$apache$spark$streaming$kinesis$KinesisReceiver$$worker_$eq(new Worker(recordProcessorFactory, kinesisClientLibConfiguration2));
        this.workerThread_$eq(new Thread(this){
            private final /* synthetic */ KinesisReceiver $outer;

            public void run() {
                try {
                    this.$outer.org$apache$spark$streaming$kinesis$KinesisReceiver$$worker().run();
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (!option.isEmpty()) {
                        Throwable e = (Throwable)option.get();
                        this.$outer.restart("Error running the KCL worker in Receiver", e);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    throw throwable;
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.blockIdToSeqNumRanges().clear();
        this.blockGenerator().start();
        this.workerThread().setName(new StringBuilder(17).append("Kinesis Receiver ").append(this.streamId()).toString());
        this.workerThread().setDaemon(true);
        this.workerThread().start();
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Started receiver with workerId ").append(this.org$apache$spark$streaming$kinesis$KinesisReceiver$$workerId()).toString());
    }

    public void onStop() {
        block2: {
            if (this.workerThread() != null) {
                if (this.org$apache$spark$streaming$kinesis$KinesisReceiver$$worker() != null) {
                    this.org$apache$spark$streaming$kinesis$KinesisReceiver$$worker().shutdown();
                    this.org$apache$spark$streaming$kinesis$KinesisReceiver$$worker_$eq(null);
                }
                this.workerThread().join();
                this.workerThread_$eq(null);
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Stopped receiver for workerId ").append(this.org$apache$spark$streaming$kinesis$KinesisReceiver$$workerId()).toString());
            }
            this.org$apache$spark$streaming$kinesis$KinesisReceiver$$workerId_$eq(null);
            if (this.kinesisCheckpointer() == null) break block2;
            this.kinesisCheckpointer().shutdown();
            this.kinesisCheckpointer_$eq(null);
        }
    }

    public void addRecords(String shardId, List<Record> records) {
        block0: {
            if (records.size() <= 0) break block0;
            Iterator dataIterator = ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(records.iterator()).asScala()).map(this.messageHandler);
            SequenceNumberRange metadata = new SequenceNumberRange(this.streamName(), shardId, records.get(0).getSequenceNumber(), records.get(records.size() - 1).getSequenceNumber(), records.size());
            this.blockGenerator().addMultipleDataWithCallback(dataIterator, (Object)metadata);
        }
    }

    public int getCurrentLimit() {
        Predef$.MODULE$.assert(this.blockGenerator() != null);
        return (int)package$.MODULE$.min(this.blockGenerator().getCurrentLimit(), Integer.MAX_VALUE);
    }

    public Option<String> getLatestSeqNumToCheckpoint(String shardId) {
        return Option$.MODULE$.apply((Object)this.shardIdToLatestStoredSeqNum().get(shardId));
    }

    public void setCheckpointer(String shardId, IRecordProcessorCheckpointer checkpointer) {
        Predef$.MODULE$.assert(this.kinesisCheckpointer() != null, (Function0 & Serializable & scala.Serializable)() -> "Kinesis Checkpointer not initialized!");
        this.kinesisCheckpointer().setCheckpointer(shardId, checkpointer);
    }

    public void removeCheckpointer(String shardId, IRecordProcessorCheckpointer checkpointer) {
        Predef$.MODULE$.assert(this.kinesisCheckpointer() != null, (Function0 & Serializable & scala.Serializable)() -> "Kinesis Checkpointer not initialized!");
        this.kinesisCheckpointer().removeCheckpointer(shardId, checkpointer);
    }

    public void org$apache$spark$streaming$kinesis$KinesisReceiver$$rememberAddedRange(SequenceNumberRange range) {
        this.seqNumRangesInCurrentBlock().$plus$eq((Object)range);
    }

    public void org$apache$spark$streaming$kinesis$KinesisReceiver$$finalizeRangesForCurrentBlock(StreamBlockId blockId) {
        this.blockIdToSeqNumRanges().put(blockId, new SequenceNumberRanges((Seq<SequenceNumberRange>)Predef$.MODULE$.wrapRefArray((Object[])this.seqNumRangesInCurrentBlock().toArray(ClassTag$.MODULE$.apply(SequenceNumberRange.class)))));
        this.seqNumRangesInCurrentBlock().clear();
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Generated block ").append(blockId).append(" has ").append(this.blockIdToSeqNumRanges()).toString());
    }

    public void org$apache$spark$streaming$kinesis$KinesisReceiver$$storeBlockWithRanges(StreamBlockId blockId, ArrayBuffer<T> arrayBuffer) {
        Option rangesToReportOption = Option$.MODULE$.apply((Object)this.blockIdToSeqNumRanges().remove(blockId));
        if (rangesToReportOption.isEmpty()) {
            this.stop(new StringBuilder(86).append("Error while storing block into Spark, could not find sequence number ranges ").append("for block ").append(blockId).toString());
            return;
        }
        SequenceNumberRanges rangesToReport = (SequenceNumberRanges)rangesToReportOption.get();
        int attempt = 0;
        boolean stored = false;
        Throwable throwable = null;
        while (!stored && attempt <= 3) {
            try {
                this.store(arrayBuffer, rangesToReport);
                stored = true;
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                Option option = NonFatal$.MODULE$.unapply(throwable3);
                if (!option.isEmpty()) {
                    Throwable th = (Throwable)option.get();
                    ++attempt;
                    throwable = th;
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                throw throwable2;
            }
        }
        if (!stored) {
            this.stop("Error while storing block into Spark", throwable);
        }
        rangesToReport.ranges().foreach((Function1 & Serializable & scala.Serializable)range -> this.shardIdToLatestStoredSeqNum().put(range.shardId(), range.toSeqNumber()));
    }

    public KinesisReceiver(String streamName, String endpointUrl, String regionName, KinesisInitialPosition initialPosition, String checkpointAppName, Duration checkpointInterval, StorageLevel storageLevel, Function1<Record, T> messageHandler, SparkAWSCredentials kinesisCreds, Option<SparkAWSCredentials> dynamoDBCreds, Option<SparkAWSCredentials> cloudWatchCreds) {
        this.streamName = streamName;
        this.endpointUrl = endpointUrl;
        this.regionName = regionName;
        this.initialPosition = initialPosition;
        this.checkpointAppName = checkpointAppName;
        this.checkpointInterval = checkpointInterval;
        this.messageHandler = messageHandler;
        this.kinesisCreds = kinesisCreds;
        this.dynamoDBCreds = dynamoDBCreds;
        this.cloudWatchCreds = cloudWatchCreds;
        super(storageLevel);
        Logging.$init$((Logging)this);
        this.org$apache$spark$streaming$kinesis$KinesisReceiver$$workerId = null;
        this.org$apache$spark$streaming$kinesis$KinesisReceiver$$worker = null;
        this.workerThread = null;
        this.blockGenerator = null;
        this.seqNumRangesInCurrentBlock = new ArrayBuffer();
        this.blockIdToSeqNumRanges = new ConcurrentHashMap();
        this.kinesisCheckpointer = null;
        this.shardIdToLatestStoredSeqNum = new ConcurrentHashMap();
    }

    public class GeneratedBlockHandler
    implements BlockGeneratorListener {
        public void onAddData(Object data, Object metadata) {
            this.org$apache$spark$streaming$kinesis$KinesisReceiver$GeneratedBlockHandler$$$outer().org$apache$spark$streaming$kinesis$KinesisReceiver$$rememberAddedRange((SequenceNumberRange)metadata);
        }

        public void onGenerateBlock(StreamBlockId blockId) {
            this.org$apache$spark$streaming$kinesis$KinesisReceiver$GeneratedBlockHandler$$$outer().org$apache$spark$streaming$kinesis$KinesisReceiver$$finalizeRangesForCurrentBlock(blockId);
        }

        public void onPushBlock(StreamBlockId blockId, ArrayBuffer<?> arrayBuffer) {
            this.org$apache$spark$streaming$kinesis$KinesisReceiver$GeneratedBlockHandler$$$outer().org$apache$spark$streaming$kinesis$KinesisReceiver$$storeBlockWithRanges(blockId, arrayBuffer);
        }

        public void onError(String message, Throwable throwable) {
            this.org$apache$spark$streaming$kinesis$KinesisReceiver$GeneratedBlockHandler$$$outer().reportError(message, throwable);
        }

        public /* synthetic */ KinesisReceiver org$apache$spark$streaming$kinesis$KinesisReceiver$GeneratedBlockHandler$$$outer() {
            return KinesisReceiver.this;
        }

        public GeneratedBlockHandler() {
            if (KinesisReceiver.this == null) {
                throw null;
            }
        }
    }
}

