/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.kinesis;

import com.amazonaws.services.kinesis.clientlibrary.lib.worker.InitialPositionInStream;
import com.amazonaws.services.kinesis.model.Record;
import java.io.Serializable;
import org.apache.spark.annotation.InterfaceStability;
import org.apache.spark.rdd.RDD;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.api.java.JavaStreamingContext;
import org.apache.spark.streaming.dstream.ReceiverInputDStream;
import org.apache.spark.streaming.kinesis.DefaultCredentials$;
import org.apache.spark.streaming.kinesis.KinesisBackedBlockRDD;
import org.apache.spark.streaming.kinesis.KinesisInitialPosition;
import org.apache.spark.streaming.kinesis.KinesisInitialPositions;
import org.apache.spark.streaming.kinesis.KinesisInputDStream$;
import org.apache.spark.streaming.kinesis.KinesisReadConfigurations$;
import org.apache.spark.streaming.kinesis.KinesisReceiver;
import org.apache.spark.streaming.kinesis.SequenceNumberRanges;
import org.apache.spark.streaming.kinesis.SparkAWSCredentials;
import org.apache.spark.streaming.receiver.Receiver;
import org.apache.spark.streaming.scheduler.ReceivedBlockInfo;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\r=f!B/_\u0001yC\u0007\"C@\u0001\u0005\u0003\u0005\u000b\u0011BA\u0001\u0011)\tI\u0001\u0001BC\u0002\u0013\u0005\u00111\u0002\u0005\u000b\u0003G\u0001!\u0011!Q\u0001\n\u00055\u0001BCA\u0013\u0001\t\u0015\r\u0011\"\u0001\u0002\f!Q\u0011q\u0005\u0001\u0003\u0002\u0003\u0006I!!\u0004\t\u0015\u0005%\u0002A!b\u0001\n\u0003\tY\u0001\u0003\u0006\u0002,\u0001\u0011\t\u0011)A\u0005\u0003\u001bA!\"!\f\u0001\u0005\u000b\u0007I\u0011AA\u0018\u0011)\tI\u0004\u0001B\u0001B\u0003%\u0011\u0011\u0007\u0005\u000b\u0003w\u0001!Q1A\u0005\u0002\u0005-\u0001BCA\u001f\u0001\t\u0005\t\u0015!\u0003\u0002\u000e!Q\u0011q\b\u0001\u0003\u0006\u0004%\t!!\u0011\t\u0015\u0005%\u0003A!A!\u0002\u0013\t\u0019\u0005\u0003\u0006\u0002L\u0001\u0011)\u0019!C\u0001\u0003\u001bB!\"a\u0017\u0001\u0005\u0003\u0005\u000b\u0011BA(\u0011)\ti\u0006\u0001BC\u0002\u0013\u0005\u0011q\f\u0005\u000b\u0003\u0003\u0003!\u0011!Q\u0001\n\u0005\u0005\u0004BCAB\u0001\t\u0015\r\u0011\"\u0001\u0002\u0006\"Q\u0011Q\u0012\u0001\u0003\u0002\u0003\u0006I!a\"\t\u0015\u0005=\u0005A!b\u0001\n\u0003\t\t\n\u0003\u0006\u0002\u001a\u0002\u0011\t\u0011)A\u0005\u0003'C!\"a'\u0001\u0005\u000b\u0007I\u0011AAI\u0011)\ti\n\u0001B\u0001B\u0003%\u00111\u0013\u0005\u000b\u0003?\u0003!1!Q\u0001\f\u0005\u0005\u0006bBAW\u0001\u0011\u0005\u0011q\u0016\u0005\t\u0003\u001f\u0004A\u0011\t1\u0002R\"9!1\u0002\u0001\u0005B\t5qa\u0002B\u000e=\"\u0005!Q\u0004\u0004\u0007;zC\tAa\b\t\u000f\u00055V\u0004\"\u0001\u0003.\u00191!qF\u000f\u0001\u0005cAq!!, \t\u0003\u0011\u0019\u0004C\u0005\u0003:}\u0001\r\u0011\"\u0003\u0003<!I!qH\u0010A\u0002\u0013%!\u0011\t\u0005\t\u0005\u001bz\u0002\u0015)\u0003\u0003>!I\u0011\u0011B\u0010A\u0002\u0013%!q\n\u0005\n\u0005'z\u0002\u0019!C\u0005\u0005+B\u0001\"a\t A\u0003&!\u0011\u000b\u0005\n\u0003wy\u0002\u0019!C\u0005\u0005\u001fB\u0011B!\u0017 \u0001\u0004%IAa\u0017\t\u0011\u0005ur\u0004)Q\u0005\u0005#B\u0011\"!\n \u0001\u0004%IAa\u0014\t\u0013\t}s\u00041A\u0005\n\t\u0005\u0004\u0002CA\u0014?\u0001\u0006KA!\u0015\t\u0013\u0005%r\u00041A\u0005\n\t=\u0003\"\u0003B3?\u0001\u0007I\u0011\u0002B4\u0011!\tYc\bQ!\n\tE\u0003\"CA\u0017?\u0001\u0007I\u0011\u0002B6\u0011%\u0011yg\ba\u0001\n\u0013\u0011\t\b\u0003\u0005\u0002:}\u0001\u000b\u0015\u0002B7\u0011%\tyd\ba\u0001\n\u0013\u0011)\bC\u0005\u0003z}\u0001\r\u0011\"\u0003\u0003|!A\u0011\u0011J\u0010!B\u0013\u00119\bC\u0005\u0003\u0000}\u0001\r\u0011\"\u0003\u0003\u0002\"I!QQ\u0010A\u0002\u0013%!q\u0011\u0005\t\u0005\u0017{\u0002\u0015)\u0003\u0003\u0004\"I!QR\u0010A\u0002\u0013%\u0011\u0011\u0013\u0005\n\u0005\u001f{\u0002\u0019!C\u0005\u0005#C\u0001B!& A\u0003&\u00111\u0013\u0005\n\u0005/{\u0002\u0019!C\u0005\u0003#C\u0011B!' \u0001\u0004%IAa'\t\u0011\t}u\u0004)Q\u0005\u0003'C\u0011B!) \u0001\u0004%I!!%\t\u0013\t\rv\u00041A\u0005\n\t\u0015\u0006\u0002\u0003BU?\u0001\u0006K!a%\t\u000f\ter\u0004\"\u0001\u0003,\"9!\u0011H\u0010\u0005\u0002\tE\u0006bBA\u0005?\u0011\u0005!q\u0019\u0005\b\u0003wyB\u0011\u0001Bf\u0011\u001d\t)c\bC\u0001\u0005#Dq!!\u000b \t\u0003\u00119\u000eC\u0004\u0002.}!\tAa7\t\u000f\t}w\u0004\"\u0001\u0003b\"9\u0011qH\u0010\u0005\u0002\r%\u0001b\u0002B@?\u0011\u00051q\u0002\u0005\b\u0007'yB\u0011AB\u000b\u0011\u001d\u0019Yb\bC\u0001\u0007;Aqa!\t \t\u0003\u0019\u0019\u0003C\u0004\u0004(}!\ta!\u000b\t\u000f\r\u0005s\u0004\"\u0001\u0004D!911K\u0010\u0005\n\rU\u0003bBB?;\u0011\u00051q\u0010\u0005\t\u0007\u0003kB\u0011\u00010\u0004\u0004\"Q1\u0011R\u000fC\u0002\u0013\u0005a,a\u0003\t\u0011\r-U\u0004)A\u0005\u0003\u001bA!b!$\u001e\u0005\u0004%\tAXA\u0006\u0011!\u0019y)\bQ\u0001\n\u00055\u0001BCBI;\t\u0007I\u0011\u00010\u00020!A11S\u000f!\u0002\u0013\t\t\u0004\u0003\u0006\u0004\u0016v\u0011\r\u0011\"\u0001_\u0003\u001bB\u0001ba&\u001eA\u0003%\u0011q\n\u0005\n\u00073k\u0012\u0011!C\u0005\u00077\u00131cS5oKNL7/\u00138qkR$5\u000b\u001e:fC6T!a\u00181\u0002\u000f-Lg.Z:jg*\u0011\u0011MY\u0001\ngR\u0014X-Y7j]\u001eT!a\u00193\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u00154\u0017AB1qC\u000eDWMC\u0001h\u0003\ry'oZ\u000b\u0003SJ\u001c\"\u0001\u00016\u0011\u0007-t\u0007/D\u0001m\u0015\ti\u0007-A\u0004egR\u0014X-Y7\n\u0005=d'\u0001\u0006*fG\u0016Lg/\u001a:J]B,H\u000fR*ue\u0016\fW\u000e\u0005\u0002re2\u0001A!B:\u0001\u0005\u0004)(!\u0001+\u0004\u0001E\u0011a\u000f \t\u0003ojl\u0011\u0001\u001f\u0006\u0002s\u0006)1oY1mC&\u00111\u0010\u001f\u0002\b\u001d>$\b.\u001b8h!\t9X0\u0003\u0002\u007fq\n\u0019\u0011I\\=\u0002\t}\u001b8o\u0019\t\u0005\u0003\u0007\t)!D\u0001a\u0013\r\t9\u0001\u0019\u0002\u0011'R\u0014X-Y7j]\u001e\u001cuN\u001c;fqR\f!b\u001d;sK\u0006lg*Y7f+\t\ti\u0001\u0005\u0003\u0002\u0010\u0005ua\u0002BA\t\u00033\u00012!a\u0005y\u001b\t\t)BC\u0002\u0002\u0018Q\fa\u0001\u0010:p_Rt\u0014bAA\u000eq\u00061\u0001K]3eK\u001aLA!a\b\u0002\"\t11\u000b\u001e:j]\u001eT1!a\u0007y\u0003-\u0019HO]3b[:\u000bW.\u001a\u0011\u0002\u0017\u0015tG\r]8j]R,&\u000f\\\u0001\rK:$\u0007o\\5oiV\u0013H\u000eI\u0001\u000be\u0016<\u0017n\u001c8OC6,\u0017a\u0003:fO&|gNT1nK\u0002\nq\"\u001b8ji&\fG\u000eU8tSRLwN\\\u000b\u0003\u0003c\u0001B!a\r\u000265\ta,C\u0002\u00028y\u0013acS5oKNL7/\u00138ji&\fG\u000eU8tSRLwN\\\u0001\u0011S:LG/[1m!>\u001c\u0018\u000e^5p]\u0002\n\u0011c\u00195fG.\u0004x.\u001b8u\u0003B\u0004h*Y7f\u0003I\u0019\u0007.Z2la>Lg\u000e^!qa:\u000bW.\u001a\u0011\u0002%\rDWmY6q_&tG/\u00138uKJ4\u0018\r\\\u000b\u0003\u0003\u0007\u0002B!a\u0001\u0002F%\u0019\u0011q\t1\u0003\u0011\u0011+(/\u0019;j_:\f1c\u00195fG.\u0004x.\u001b8u\u0013:$XM\u001d<bY\u0002\nQbX:u_J\fw-\u001a'fm\u0016dWCAA(!\u0011\t\t&a\u0016\u000e\u0005\u0005M#bAA+E\u000691\u000f^8sC\u001e,\u0017\u0002BA-\u0003'\u0012Ab\u0015;pe\u0006<W\rT3wK2\fabX:u_J\fw-\u001a'fm\u0016d\u0007%\u0001\bnKN\u001c\u0018mZ3IC:$G.\u001a:\u0016\u0005\u0005\u0005\u0004CB<\u0002d\u0005\u001d\u0004/C\u0002\u0002fa\u0014\u0011BR;oGRLwN\\\u0019\u0011\t\u0005%\u0014QP\u0007\u0003\u0003WRA!!\u001c\u0002p\u0005)Qn\u001c3fY*\u0019q,!\u001d\u000b\t\u0005M\u0014QO\u0001\tg\u0016\u0014h/[2fg*!\u0011qOA=\u0003%\tW.\u0019>p]\u0006<8O\u0003\u0002\u0002|\u0005\u00191m\\7\n\t\u0005}\u00141\u000e\u0002\u0007%\u0016\u001cwN\u001d3\u0002\u001f5,7o]1hK\"\u000bg\u000e\u001a7fe\u0002\nAb[5oKNL7o\u0011:fIN,\"!a\"\u0011\t\u0005M\u0012\u0011R\u0005\u0004\u0003\u0017s&aE*qCJ\\\u0017iV*De\u0016$WM\u001c;jC2\u001c\u0018!D6j]\u0016\u001c\u0018n]\"sK\u0012\u001c\b%A\u0007es:\fWn\u001c#C\u0007J,Gm]\u000b\u0003\u0003'\u0003Ra^AK\u0003\u000fK1!a&y\u0005\u0019y\u0005\u000f^5p]\u0006qA-\u001f8b[>$%i\u0011:fIN\u0004\u0013aD2m_V$w+\u0019;dQ\u000e\u0013X\rZ:\u0002!\rdw.\u001e3XCR\u001c\u0007n\u0011:fIN\u0004\u0013AC3wS\u0012,gnY3%cA)\u00111UAUa6\u0011\u0011Q\u0015\u0006\u0004\u0003OC\u0018a\u0002:fM2,7\r^\u0005\u0005\u0003W\u000b)K\u0001\u0005DY\u0006\u001c8\u000fV1h\u0003\u0019a\u0014N\\5u}QQ\u0012\u0011WA\\\u0003s\u000bY,!0\u0002@\u0006\u0005\u00171YAc\u0003\u000f\fI-a3\u0002NR!\u00111WA[!\u0011\t\u0019\u0004\u00019\t\u000f\u0005}\u0015\u0004q\u0001\u0002\"\"1q0\u0007a\u0001\u0003\u0003Aq!!\u0003\u001a\u0001\u0004\ti\u0001C\u0004\u0002&e\u0001\r!!\u0004\t\u000f\u0005%\u0012\u00041\u0001\u0002\u000e!9\u0011QF\rA\u0002\u0005E\u0002bBA\u001e3\u0001\u0007\u0011Q\u0002\u0005\b\u0003\u007fI\u0002\u0019AA\"\u0011\u001d\tY%\u0007a\u0001\u0003\u001fBq!!\u0018\u001a\u0001\u0004\t\t\u0007C\u0004\u0002\u0004f\u0001\r!a\"\t\u000f\u0005=\u0015\u00041\u0001\u0002\u0014\"9\u00111T\rA\u0002\u0005M\u0015AD2sK\u0006$XM\u00117pG.\u0014F\t\u0012\u000b\u0007\u0003'\fy.!;\u0011\u000b\u0005U\u00171\u001c9\u000e\u0005\u0005]'bAAmE\u0006\u0019!\u000f\u001a3\n\t\u0005u\u0017q\u001b\u0002\u0004%\u0012#\u0005bBAq5\u0001\u0007\u00111]\u0001\u0005i&lW\r\u0005\u0003\u0002\u0004\u0005\u0015\u0018bAAtA\n!A+[7f\u0011\u001d\tYO\u0007a\u0001\u0003[\f!B\u00197pG.LeNZ8t!\u0019\ty/!?\u0002\u0000:!\u0011\u0011_A{\u001d\u0011\t\u0019\"a=\n\u0003eL1!a>y\u0003\u001d\u0001\u0018mY6bO\u0016LA!a?\u0002~\n\u00191+Z9\u000b\u0007\u0005]\b\u0010\u0005\u0003\u0003\u0002\t\u001dQB\u0001B\u0002\u0015\r\u0011)\u0001Y\u0001\ng\u000eDW\rZ;mKJLAA!\u0003\u0003\u0004\t\t\"+Z2fSZ,GM\u00117pG.LeNZ8\u0002\u0017\u001d,GOU3dK&4XM\u001d\u000b\u0003\u0005\u001f\u0001RA!\u0005\u0003\u0018Al!Aa\u0005\u000b\u0007\tU\u0001-\u0001\u0005sK\u000e,\u0017N^3s\u0013\u0011\u0011IBa\u0005\u0003\u0011I+7-Z5wKJ\f1cS5oKNL7/\u00138qkR$5\u000b\u001e:fC6\u00042!a\r\u001e'\u0015i\"\u0011\u0005B\u0014!\r9(1E\u0005\u0004\u0005KA(AB!osJ+g\rE\u0002x\u0005SI1Aa\u000by\u00051\u0019VM]5bY&T\u0018M\u00197f)\t\u0011iBA\u0004Ck&dG-\u001a:\u0014\u0007}\u0011\t\u0003\u0006\u0002\u00036A\u0019!qG\u0010\u000e\u0003u\t\u0001c\u001d;sK\u0006l\u0017N\\4D_:$X\r\u001f;\u0016\u0005\tu\u0002#B<\u0002\u0016\u0006\u0005\u0011\u0001F:ue\u0016\fW.\u001b8h\u0007>tG/\u001a=u?\u0012*\u0017\u000f\u0006\u0003\u0003D\t%\u0003cA<\u0003F%\u0019!q\t=\u0003\tUs\u0017\u000e\u001e\u0005\n\u0005\u0017\u0012\u0013\u0011!a\u0001\u0005{\t1\u0001\u001f\u00132\u0003E\u0019HO]3b[&twmQ8oi\u0016DH\u000fI\u000b\u0003\u0005#\u0002Ra^AK\u0003\u001b\tab\u001d;sK\u0006lg*Y7f?\u0012*\u0017\u000f\u0006\u0003\u0003D\t]\u0003\"\u0003B&K\u0005\u0005\t\u0019\u0001B)\u0003U\u0019\u0007.Z2la>Lg\u000e^!qa:\u000bW.Z0%KF$BAa\u0011\u0003^!I!1\n\u0015\u0002\u0002\u0003\u0007!\u0011K\u0001\u0010K:$\u0007o\\5oiV\u0013Hn\u0018\u0013fcR!!1\tB2\u0011%\u0011YeKA\u0001\u0002\u0004\u0011\t&\u0001\bsK\u001eLwN\u001c(b[\u0016|F%Z9\u0015\t\t\r#\u0011\u000e\u0005\n\u0005\u0017r\u0013\u0011!a\u0001\u0005#*\"A!\u001c\u0011\u000b]\f)*!\r\u0002'%t\u0017\u000e^5bYB{7/\u001b;j_:|F%Z9\u0015\t\t\r#1\u000f\u0005\n\u0005\u0017\n\u0014\u0011!a\u0001\u0005[*\"Aa\u001e\u0011\u000b]\f)*a\u0011\u0002-\rDWmY6q_&tG/\u00138uKJ4\u0018\r\\0%KF$BAa\u0011\u0003~!I!1\n\u001b\u0002\u0002\u0003\u0007!qO\u0001\rgR|'/Y4f\u0019\u00164X\r\\\u000b\u0003\u0005\u0007\u0003Ra^AK\u0003\u001f\n\u0001c\u001d;pe\u0006<W\rT3wK2|F%Z9\u0015\t\t\r#\u0011\u0012\u0005\n\u0005\u0017:\u0014\u0011!a\u0001\u0005\u0007\u000bQb\u001d;pe\u0006<W\rT3wK2\u0004\u0013\u0001F6j]\u0016\u001c\u0018n]\"sK\u0012\u001c\bK]8wS\u0012,'/\u0001\rlS:,7/[:De\u0016$7\u000f\u0015:pm&$WM]0%KF$BAa\u0011\u0003\u0014\"I!1\n\u001e\u0002\u0002\u0003\u0007\u00111S\u0001\u0016W&tWm]5t\u0007J,Gm\u001d)s_ZLG-\u001a:!\u0003U!\u0017P\\1n_\u0012\u00135I]3egB\u0013xN^5eKJ\f\u0011\u0004Z=oC6|GIQ\"sK\u0012\u001c\bK]8wS\u0012,'o\u0018\u0013fcR!!1\tBO\u0011%\u0011Y%PA\u0001\u0002\u0004\t\u0019*\u0001\fes:\fWn\u001c#C\u0007J,Gm\u001d)s_ZLG-\u001a:!\u0003]\u0019Gn\\;e/\u0006$8\r[\"sK\u0012\u001c\bK]8wS\u0012,'/A\u000edY>,HmV1uG\"\u001c%/\u001a3t!J|g/\u001b3fe~#S-\u001d\u000b\u0005\u0005\u0007\u00129\u000bC\u0005\u0003L\u0001\u000b\t\u00111\u0001\u0002\u0014\u0006A2\r\\8vI^\u000bGo\u00195De\u0016$7\u000f\u0015:pm&$WM\u001d\u0011\u0015\t\tU\"Q\u0016\u0005\b\u0005_\u0013\u0005\u0019AA\u0001\u0003\r\u00198o\u0019\u000b\u0005\u0005k\u0011\u0019\fC\u0004\u00036\u000e\u0003\rAa.\u0002\t)\u001c8o\u0019\t\u0005\u0005s\u0013\u0019-\u0004\u0002\u0003<*!!Q\u0018B`\u0003\u0011Q\u0017M^1\u000b\u0007\t\u0005\u0007-A\u0002ba&LAA!2\u0003<\n!\"*\u0019<b'R\u0014X-Y7j]\u001e\u001cuN\u001c;fqR$BA!\u000e\u0003J\"9\u0011\u0011\u0002#A\u0002\u00055A\u0003\u0002B\u001b\u0005\u001bDqAa4F\u0001\u0004\ti!A\u0004baBt\u0015-\\3\u0015\t\tU\"1\u001b\u0005\b\u0005+4\u0005\u0019AA\u0007\u0003\r)(\u000f\u001c\u000b\u0005\u0005k\u0011I\u000eC\u0004\u0002*\u001d\u0003\r!!\u0004\u0015\t\tU\"Q\u001c\u0005\b\u0003[A\u0005\u0019AA\u0019\u0003]Ig.\u001b;jC2\u0004vn]5uS>t\u0017J\\*ue\u0016\fW\u000e\u0006\u0003\u00036\t\r\bbBA\u0017\u0013\u0002\u0007!Q\u001d\t\u0005\u0005O\u0014)0\u0004\u0002\u0003j*!!1\u001eBw\u0003\u00199xN]6fe*!!q\u001eBy\u0003\ra\u0017N\u0019\u0006\u0005\u0005g\fy'A\u0007dY&,g\u000e\u001e7jEJ\f'/_\u0005\u0005\u0005o\u0014IOA\fJ]&$\u0018.\u00197Q_NLG/[8o\u0013:\u001cFO]3b[\":\u0011Ja?\u0004\u0002\r\u0015\u0001cA<\u0003~&\u0019!q =\u0003\u0015\u0011,\u0007O]3dCR,G-\t\u0002\u0004\u0004\u0005aTo]3!S:LG/[1m!>\u001c\u0018\u000e^5p]\"Jg.\u001b;jC2\u0004vn]5uS>t'\bI&j]\u0016\u001c\u0018n]%oSRL\u0017\r\u001c)pg&$\u0018n\u001c8*C\t\u00199!A\u00033]Mr\u0003\u0007\u0006\u0003\u00036\r-\u0001bBB\u0007\u0015\u0002\u0007\u00111I\u0001\tS:$XM\u001d<bYR!!QGB\t\u0011\u001d\u0011yh\u0013a\u0001\u0003\u001f\n!c[5oKNL7o\u0011:fI\u0016tG/[1mgR!!QGB\f\u0011\u001d\u0019I\u0002\u0014a\u0001\u0003\u000f\u000b1b\u0019:fI\u0016tG/[1mg\u0006\u0019B-\u001f8b[>$%i\u0011:fI\u0016tG/[1mgR!!QGB\u0010\u0011\u001d\u0019I\"\u0014a\u0001\u0003\u000f\u000bQc\u00197pk\u0012<\u0016\r^2i\u0007J,G-\u001a8uS\u0006d7\u000f\u0006\u0003\u00036\r\u0015\u0002bBB\r\u001d\u0002\u0007\u0011qQ\u0001\u0018EVLG\u000eZ,ji\"lUm]:bO\u0016D\u0015M\u001c3mKJ,Baa\u000b\u00044Q!1QFB\u001e)\u0011\u0019yc!\u000e\u0011\u000b\u0005M\u0002a!\r\u0011\u0007E\u001c\u0019\u0004B\u0003t\u001f\n\u0007Q\u000fC\u0005\u00048=\u000b\t\u0011q\u0001\u0004:\u0005QQM^5eK:\u001cW\r\n\u001a\u0011\r\u0005\r\u0016\u0011VB\u0019\u0011\u001d\u0019id\u0014a\u0001\u0007\u007f\tq\u0001[1oI2,'\u000fE\u0004x\u0003G\n9g!\r\u0002\u000b\t,\u0018\u000e\u001c3\u0015\u0005\r\u0015\u0003#BA\u001a\u0001\r\u001d\u0003#B<\u0004J\r5\u0013bAB&q\n)\u0011I\u001d:bsB\u0019qoa\u0014\n\u0007\rE\u0003P\u0001\u0003CsR,\u0017\u0001E4fiJ+\u0017/^5sK\u0012\u0004\u0016M]1n+\u0011\u00199fa\u0017\u0015\r\re3QLB2!\r\t81\f\u0003\u0006gF\u0013\r!\u001e\u0005\b\u0007?\n\u0006\u0019AB1\u0003\u0015\u0001\u0018M]1n!\u00159\u0018QSB-\u0011\u001d\u0019)'\u0015a\u0001\u0003\u001b\t\u0011\u0002]1sC6t\u0015-\\3)\u0007}\u0019I\u0007\u0005\u0003\u0004l\r]d\u0002BB7\u0007gj!aa\u001c\u000b\u0007\rE$-\u0001\u0006b]:|G/\u0019;j_:LAa!\u001e\u0004p\u0005\u0011\u0012J\u001c;fe\u001a\f7-Z*uC\nLG.\u001b;z\u0013\u0011\u0019Iha\u001f\u0003\u0011\u00153x\u000e\u001c<j]\u001eTAa!\u001e\u0004p\u00059!-^5mI\u0016\u0014XC\u0001B\u001b\u0003U!WMZ1vYRlUm]:bO\u0016D\u0015M\u001c3mKJ$Baa\u0012\u0004\u0006\"91qQ*A\u0002\u0005\u001d\u0014A\u0002:fG>\u0014H-\u0001\u000fE\u000b\u001a\u000bU\u000b\u0014+`\u0017&sUiU%T?\u0016sE\tU(J\u001dR{VK\u0015'\u0002;\u0011+e)Q+M)~[\u0015JT#T\u0013N{VI\u0014#Q\u001f&sEkX+S\u0019\u0002\n1\u0004R#G\u0003VcEkX&J\u001d\u0016\u001b\u0016jU0S\u000b\u001eKuJT0O\u00036+\u0015\u0001\b#F\r\u0006+F\nV0L\u0013:+5+S*`%\u0016;\u0015j\u0014(`\u001d\u0006kU\tI\u0001\u0019\t\u00163\u0015)\u0016'U?&s\u0015\nV%B\u0019~\u0003vjU%U\u0013>s\u0015!\u0007#F\r\u0006+F\nV0J\u001d&#\u0016*\u0011'`!>\u001b\u0016\nV%P\u001d\u0002\nQ\u0003R#G\u0003VcEkX*U\u001fJ\u000bu)R0M\u000bZ+E*\u0001\fE\u000b\u001a\u000bU\u000b\u0014+`'R{%+Q$F?2+e+\u0012'!\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\ru\u0005\u0003BBP\u0007Ok!a!)\u000b\t\r\r6QU\u0001\u0005Y\u0006twM\u0003\u0002\u0003>&!1\u0011VBQ\u0005\u0019y%M[3di\"\u001aQd!\u001b)\u0007q\u0019I\u0007")
public class KinesisInputDStream<T>
extends ReceiverInputDStream<T> {
    private final String streamName;
    private final String endpointUrl;
    private final String regionName;
    private final KinesisInitialPosition initialPosition;
    private final String checkpointAppName;
    private final Duration checkpointInterval;
    private final StorageLevel _storageLevel;
    private final Function1<Record, T> messageHandler;
    private final SparkAWSCredentials kinesisCreds;
    private final Option<SparkAWSCredentials> dynamoDBCreds;
    private final Option<SparkAWSCredentials> cloudWatchCreds;
    private final ClassTag<T> evidence$1;

    public static Builder builder() {
        return KinesisInputDStream$.MODULE$.builder();
    }

    public String streamName() {
        return this.streamName;
    }

    public String endpointUrl() {
        return this.endpointUrl;
    }

    public String regionName() {
        return this.regionName;
    }

    public KinesisInitialPosition initialPosition() {
        return this.initialPosition;
    }

    public String checkpointAppName() {
        return this.checkpointAppName;
    }

    public Duration checkpointInterval() {
        return this.checkpointInterval;
    }

    public StorageLevel _storageLevel() {
        return this._storageLevel;
    }

    public Function1<Record, T> messageHandler() {
        return this.messageHandler;
    }

    public SparkAWSCredentials kinesisCreds() {
        return this.kinesisCreds;
    }

    public Option<SparkAWSCredentials> dynamoDBCreds() {
        return this.dynamoDBCreds;
    }

    public Option<SparkAWSCredentials> cloudWatchCreds() {
        return this.cloudWatchCreds;
    }

    public RDD<T> createBlockRDD(Time time, Seq<ReceivedBlockInfo> blockInfos) {
        Object object;
        boolean allBlocksHaveRanges = ((IterableLike)blockInfos.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.metadataOption(), Seq$.MODULE$.canBuildFrom())).forall((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.nonEmpty()));
        if (allBlocksHaveRanges) {
            BlockId[] blockIds = (BlockId[])((TraversableOnce)blockInfos.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.blockId(), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(BlockId.class));
            SequenceNumberRanges[] seqNumRanges = (SequenceNumberRanges[])((TraversableOnce)blockInfos.map((Function1 & Serializable & scala.Serializable)x$4 -> (SequenceNumberRanges)x$4.metadataOption().get(), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(SequenceNumberRanges.class));
            boolean[] isBlockIdValid = (boolean[])((TraversableOnce)blockInfos.map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.isBlockIdValid()), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Boolean());
            this.logDebug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(62).append("Creating KinesisBackedBlockRDD for ").append(time).append(" with ").append(seqNumRanges.length).append(" ").append("seq number ranges: ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])seqNumRanges)).mkString(", ")).append(" ").toString());
            object = new KinesisBackedBlockRDD<T>(this.context().sc(), this.regionName(), this.endpointUrl(), blockIds, seqNumRanges, isBlockIdValid, this.messageHandler(), this.kinesisCreds(), KinesisReadConfigurations$.MODULE$.apply(this.ssc()), this.evidence$1);
        } else {
            this.logWarning((Function0 & Serializable & scala.Serializable)() -> "Kinesis sequence number information was not present with some block metadata, it may not be possible to recover from failures");
            object = super.createBlockRDD(time, blockInfos);
        }
        return object;
    }

    public Receiver<T> getReceiver() {
        return new KinesisReceiver<T>(this.streamName(), this.endpointUrl(), this.regionName(), this.initialPosition(), this.checkpointAppName(), this.checkpointInterval(), this._storageLevel(), this.messageHandler(), this.kinesisCreds(), this.dynamoDBCreds(), this.cloudWatchCreds());
    }

    public KinesisInputDStream(StreamingContext _ssc, String streamName, String endpointUrl, String regionName, KinesisInitialPosition initialPosition, String checkpointAppName, Duration checkpointInterval, StorageLevel _storageLevel, Function1<Record, T> messageHandler, SparkAWSCredentials kinesisCreds, Option<SparkAWSCredentials> dynamoDBCreds, Option<SparkAWSCredentials> cloudWatchCreds, ClassTag<T> evidence$1) {
        this.streamName = streamName;
        this.endpointUrl = endpointUrl;
        this.regionName = regionName;
        this.initialPosition = initialPosition;
        this.checkpointAppName = checkpointAppName;
        this.checkpointInterval = checkpointInterval;
        this._storageLevel = _storageLevel;
        this.messageHandler = messageHandler;
        this.kinesisCreds = kinesisCreds;
        this.dynamoDBCreds = dynamoDBCreds;
        this.cloudWatchCreds = cloudWatchCreds;
        this.evidence$1 = evidence$1;
        super(_ssc, evidence$1);
    }

    @InterfaceStability.Evolving
    public static class Builder {
        private Option<StreamingContext> streamingContext = None$.MODULE$;
        private Option<String> streamName = None$.MODULE$;
        private Option<String> checkpointAppName = None$.MODULE$;
        private Option<String> endpointUrl = None$.MODULE$;
        private Option<String> regionName = None$.MODULE$;
        private Option<KinesisInitialPosition> initialPosition = None$.MODULE$;
        private Option<Duration> checkpointInterval = None$.MODULE$;
        private Option<StorageLevel> storageLevel = None$.MODULE$;
        private Option<SparkAWSCredentials> kinesisCredsProvider = None$.MODULE$;
        private Option<SparkAWSCredentials> dynamoDBCredsProvider = None$.MODULE$;
        private Option<SparkAWSCredentials> cloudWatchCredsProvider = None$.MODULE$;

        private Option<StreamingContext> streamingContext() {
            return this.streamingContext;
        }

        private void streamingContext_$eq(Option<StreamingContext> x$1) {
            this.streamingContext = x$1;
        }

        private Option<String> streamName() {
            return this.streamName;
        }

        private void streamName_$eq(Option<String> x$1) {
            this.streamName = x$1;
        }

        private Option<String> checkpointAppName() {
            return this.checkpointAppName;
        }

        private void checkpointAppName_$eq(Option<String> x$1) {
            this.checkpointAppName = x$1;
        }

        private Option<String> endpointUrl() {
            return this.endpointUrl;
        }

        private void endpointUrl_$eq(Option<String> x$1) {
            this.endpointUrl = x$1;
        }

        private Option<String> regionName() {
            return this.regionName;
        }

        private void regionName_$eq(Option<String> x$1) {
            this.regionName = x$1;
        }

        private Option<KinesisInitialPosition> initialPosition() {
            return this.initialPosition;
        }

        private void initialPosition_$eq(Option<KinesisInitialPosition> x$1) {
            this.initialPosition = x$1;
        }

        private Option<Duration> checkpointInterval() {
            return this.checkpointInterval;
        }

        private void checkpointInterval_$eq(Option<Duration> x$1) {
            this.checkpointInterval = x$1;
        }

        private Option<StorageLevel> storageLevel() {
            return this.storageLevel;
        }

        private void storageLevel_$eq(Option<StorageLevel> x$1) {
            this.storageLevel = x$1;
        }

        private Option<SparkAWSCredentials> kinesisCredsProvider() {
            return this.kinesisCredsProvider;
        }

        private void kinesisCredsProvider_$eq(Option<SparkAWSCredentials> x$1) {
            this.kinesisCredsProvider = x$1;
        }

        private Option<SparkAWSCredentials> dynamoDBCredsProvider() {
            return this.dynamoDBCredsProvider;
        }

        private void dynamoDBCredsProvider_$eq(Option<SparkAWSCredentials> x$1) {
            this.dynamoDBCredsProvider = x$1;
        }

        private Option<SparkAWSCredentials> cloudWatchCredsProvider() {
            return this.cloudWatchCredsProvider;
        }

        private void cloudWatchCredsProvider_$eq(Option<SparkAWSCredentials> x$1) {
            this.cloudWatchCredsProvider = x$1;
        }

        public Builder streamingContext(StreamingContext ssc) {
            this.streamingContext_$eq((Option<StreamingContext>)Option$.MODULE$.apply((Object)ssc));
            return this;
        }

        public Builder streamingContext(JavaStreamingContext jssc) {
            this.streamingContext_$eq((Option<StreamingContext>)Option$.MODULE$.apply((Object)jssc.ssc()));
            return this;
        }

        public Builder streamName(String streamName) {
            this.streamName_$eq((Option<String>)Option$.MODULE$.apply((Object)streamName));
            return this;
        }

        public Builder checkpointAppName(String appName) {
            this.checkpointAppName_$eq((Option<String>)Option$.MODULE$.apply((Object)appName));
            return this;
        }

        public Builder endpointUrl(String url) {
            this.endpointUrl_$eq((Option<String>)Option$.MODULE$.apply((Object)url));
            return this;
        }

        public Builder regionName(String regionName) {
            this.regionName_$eq((Option<String>)Option$.MODULE$.apply((Object)regionName));
            return this;
        }

        public Builder initialPosition(KinesisInitialPosition initialPosition) {
            this.initialPosition_$eq((Option<KinesisInitialPosition>)Option$.MODULE$.apply((Object)initialPosition));
            return this;
        }

        public Builder initialPositionInStream(InitialPositionInStream initialPosition) {
            this.initialPosition_$eq((Option<KinesisInitialPosition>)Option$.MODULE$.apply((Object)KinesisInitialPositions.fromKinesisInitialPosition(initialPosition)));
            return this;
        }

        public Builder checkpointInterval(Duration interval) {
            this.checkpointInterval_$eq((Option<Duration>)Option$.MODULE$.apply((Object)interval));
            return this;
        }

        public Builder storageLevel(StorageLevel storageLevel) {
            this.storageLevel_$eq((Option<StorageLevel>)Option$.MODULE$.apply((Object)storageLevel));
            return this;
        }

        public Builder kinesisCredentials(SparkAWSCredentials credentials) {
            this.kinesisCredsProvider_$eq((Option<SparkAWSCredentials>)Option$.MODULE$.apply((Object)credentials));
            return this;
        }

        public Builder dynamoDBCredentials(SparkAWSCredentials credentials) {
            this.dynamoDBCredsProvider_$eq((Option<SparkAWSCredentials>)Option$.MODULE$.apply((Object)credentials));
            return this;
        }

        public Builder cloudWatchCredentials(SparkAWSCredentials credentials) {
            this.cloudWatchCredsProvider_$eq((Option<SparkAWSCredentials>)Option$.MODULE$.apply((Object)credentials));
            return this;
        }

        public <T> KinesisInputDStream<T> buildWithMessageHandler(Function1<Record, T> handler, ClassTag<T> evidence$2) {
            StreamingContext ssc = this.getRequiredParam(this.streamingContext(), "streamingContext");
            return new KinesisInputDStream<T>(ssc, this.getRequiredParam(this.streamName(), "streamName"), (String)this.endpointUrl().getOrElse((Function0 & Serializable & scala.Serializable)() -> KinesisInputDStream$.MODULE$.DEFAULT_KINESIS_ENDPOINT_URL()), (String)this.regionName().getOrElse((Function0 & Serializable & scala.Serializable)() -> KinesisInputDStream$.MODULE$.DEFAULT_KINESIS_REGION_NAME()), (KinesisInitialPosition)this.initialPosition().getOrElse((Function0 & Serializable & scala.Serializable)() -> KinesisInputDStream$.MODULE$.DEFAULT_INITIAL_POSITION()), this.getRequiredParam(this.checkpointAppName(), "checkpointAppName"), (Duration)this.checkpointInterval().getOrElse((Function0 & Serializable & scala.Serializable)() -> ssc.graph().batchDuration()), (StorageLevel)this.storageLevel().getOrElse((Function0 & Serializable & scala.Serializable)() -> KinesisInputDStream$.MODULE$.DEFAULT_STORAGE_LEVEL()), (Function1)ssc.sc().clean(handler, ssc.sc().clean$default$2()), (SparkAWSCredentials)this.kinesisCredsProvider().getOrElse((Function0 & Serializable & scala.Serializable)() -> DefaultCredentials$.MODULE$), this.dynamoDBCredsProvider(), this.cloudWatchCredsProvider(), evidence$2);
        }

        public KinesisInputDStream<byte[]> build() {
            return this.buildWithMessageHandler((Function1 & Serializable & scala.Serializable)record -> KinesisInputDStream$.MODULE$.defaultMessageHandler((Record)record), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
        }

        private <T> T getRequiredParam(Option<T> param, String paramName) {
            return (T)param.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new IllegalArgumentException(new StringBuilder(41).append("No value provided for required parameter ").append(paramName).toString());
            });
        }
    }
}

