/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.kinesis;

import com.amazonaws.services.kinesis.clientlibrary.interfaces.IRecordProcessorCheckpointer;
import java.io.Serializable;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.TestServer;
import org.apache.spark.streaming.TestSuiteBase;
import org.apache.spark.streaming.dstream.DStream;
import org.apache.spark.streaming.kinesis.KinesisCheckpointer;
import org.apache.spark.streaming.kinesis.KinesisReceiver;
import org.apache.spark.util.Clock;
import org.apache.spark.util.ManualClock;
import org.mockito.Matchers;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfter;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.PrivateMethodTester;
import org.scalatest.PrivateMethodTester$PrivateMethod$;
import org.scalatest.Status;
import org.scalatest.Tag;
import org.scalatest.concurrent.AbstractPatienceConfiguration;
import org.scalatest.concurrent.AbstractPatienceConfiguration$PatienceConfig$;
import org.scalatest.concurrent.Eventually;
import org.scalatest.concurrent.PatienceConfiguration;
import org.scalatest.concurrent.ScaledTimeSpans;
import org.scalatest.mockito.MockitoSugar;
import org.scalatest.time.Span;
import org.scalatest.time.Span$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Symbol;
import scala.collection.Seq;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005-d\u0001B\u0010!\u0001-BQ!\u0013\u0001\u0005\u0002)Cq!\u0014\u0001C\u0002\u0013%a\n\u0003\u0004X\u0001\u0001\u0006Ia\u0014\u0005\b1\u0002\u0011\r\u0011\"\u0003O\u0011\u0019I\u0006\u0001)A\u0005\u001f\"9!\f\u0001b\u0001\n\u0013q\u0005BB.\u0001A\u0003%q\nC\u0004]\u0001\t\u0007I\u0011\u0002(\t\ru\u0003\u0001\u0015!\u0003P\u0011\u001dq\u0006A1A\u0005\n}Caa\u0019\u0001!\u0002\u0013\u0001\u0007b\u00023\u0001\u0005\u0004%I!\u001a\u0005\u0007Y\u0002\u0001\u000b\u0011\u00024\t\u000f5\u0004!\u0019!C\u0005K\"1a\u000e\u0001Q\u0001\n\u0019D\u0011b\u001c\u0001A\u0002\u0003\u0007I\u0011\u00029\t\u0013i\u0004\u0001\u0019!a\u0001\n\u0013Y\bBCA\u0002\u0001\u0001\u0007\t\u0011)Q\u0005c\"Y\u0011Q\u0001\u0001A\u0002\u0003\u0007I\u0011BA\u0004\u0011-\t9\u0003\u0001a\u0001\u0002\u0004%I!!\u000b\t\u0017\u00055\u0002\u00011A\u0001B\u0003&\u0011\u0011\u0002\u0005\f\u0003_\u0001\u0001\u0019!a\u0001\n\u0013\t\t\u0004C\u0006\u0002:\u0001\u0001\r\u00111A\u0005\n\u0005m\u0002bCA \u0001\u0001\u0007\t\u0011)Q\u0005\u0003gA1\"!\u0011\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002D!Y\u0011\u0011\u000b\u0001A\u0002\u0003\u0007I\u0011BA*\u0011-\t9\u0006\u0001a\u0001\u0002\u0003\u0006K!!\u0012\t\u0013\u0005e\u0003A1A\u0005\n\u0005m\u0003\u0002CA3\u0001\u0001\u0006I!!\u0018\t\u000f\u0005\u001d\u0004\u0001\"\u0011\u0002j\tA2*\u001b8fg&\u001c8\t[3dWB|\u0017N\u001c;feN+\u0018\u000e^3\u000b\u0005\u0005\u0012\u0013aB6j]\u0016\u001c\u0018n\u001d\u0006\u0003G\u0011\n\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u0005\u00152\u0013!B:qCJ\\'BA\u0014)\u0003\u0019\t\u0007/Y2iK*\t\u0011&A\u0002pe\u001e\u001c\u0001aE\u0004\u0001YA\"D\bQ\"\u0011\u00055rS\"\u0001\u0013\n\u0005=\"#!D*qCJ\\g)\u001e8Tk&$X\r\u0005\u00022e5\t!%\u0003\u00024E\tiA+Z:u'VLG/\u001a\"bg\u0016\u0004\"!\u000e\u001e\u000e\u0003YR!a\u000e\u001d\u0002\u000f5|7m[5u_*\u0011\u0011\bK\u0001\ng\u000e\fG.\u0019;fgRL!a\u000f\u001c\u0003\u00195{7m[5u_N+x-\u0019:\u0011\u0005urT\"\u0001\u001d\n\u0005}B$A\u0005\"fM>\u0014X-\u00118e\u0003\u001a$XM]#bG\"\u0004\"!P!\n\u0005\tC$a\u0005)sSZ\fG/Z'fi\"|G\rV3ti\u0016\u0014\bC\u0001#H\u001b\u0005)%B\u0001$9\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0003\u0011\u0016\u0013!\"\u0012<f]R,\u0018\r\u001c7z\u0003\u0019a\u0014N\\5u}Q\t1\n\u0005\u0002M\u00015\t\u0001%\u0001\u0005x_J\\WM]%e+\u0005y\u0005C\u0001)V\u001b\u0005\t&B\u0001*T\u0003\u0011a\u0017M\\4\u000b\u0003Q\u000bAA[1wC&\u0011a+\u0015\u0002\u0007'R\u0014\u0018N\\4\u0002\u0013]|'o[3s\u0013\u0012\u0004\u0013aB:iCJ$\u0017\nZ\u0001\tg\"\f'\u000fZ%eA\u000511/Z9Ok6\fqa]3r\u001dVl\u0007%A\u0006pi\",'oU3r\u001dVl\u0017\u0001D8uQ\u0016\u00148+Z9Ok6\u0004\u0013AE2iK\u000e\\\u0007o\\5oi&sG/\u001a:wC2,\u0012\u0001\u0019\t\u0003c\u0005L!A\u0019\u0012\u0003\u0011\u0011+(/\u0019;j_:\f1c\u00195fG.\u0004x.\u001b8u\u0013:$XM\u001d<bY\u0002\n!b]8nKN+\u0017OT;n+\u00051\u0007cA4k\u001f6\t\u0001NC\u0001j\u0003\u0015\u00198-\u00197b\u0013\tY\u0007N\u0001\u0003T_6,\u0017aC:p[\u0016\u001cV-\u001d(v[\u0002\nqb]8nK>#\b.\u001a:TKFtU/\\\u0001\u0011g>lWm\u0014;iKJ\u001cV-\u001d(v[\u0002\nAB]3dK&4XM]'pG.,\u0012!\u001d\t\u0004\u0019J$\u0018BA:!\u0005=Y\u0015N\\3tSN\u0014VmY3jm\u0016\u0014\bcA4vo&\u0011a\u000f\u001b\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003ObL!!\u001f5\u0003\t\tKH/Z\u0001\u0011e\u0016\u001cW-\u001b<fe6{7m[0%KF$\"\u0001`@\u0011\u0005\u001dl\u0018B\u0001@i\u0005\u0011)f.\u001b;\t\u0011\u0005\u0005\u0011#!AA\u0002E\f1\u0001\u001f\u00132\u00035\u0011XmY3jm\u0016\u0014Xj\\2lA\u0005\u00012\r[3dWB|\u0017N\u001c;fe6{7m[\u000b\u0003\u0003\u0013\u0001B!a\u0003\u0002$5\u0011\u0011Q\u0002\u0006\u0005\u0003\u001f\t\t\"\u0001\u0006j]R,'OZ1dKNTA!a\u0005\u0002\u0016\u0005i1\r\\5f]Rd\u0017N\u0019:befT1!IA\f\u0015\u0011\tI\"a\u0007\u0002\u0011M,'O^5dKNTA!!\b\u0002 \u0005I\u0011-\\1{_:\fwo\u001d\u0006\u0003\u0003C\t1aY8n\u0013\u0011\t)#!\u0004\u00039%\u0013VmY8sIB\u0013xnY3tg>\u00148\t[3dWB|\u0017N\u001c;fe\u0006!2\r[3dWB|\u0017N\u001c;fe6{7m[0%KF$2\u0001`A\u0016\u0011%\t\t\u0001FA\u0001\u0002\u0004\tI!A\tdQ\u0016\u001c7\u000e]8j]R,'/T8dW\u0002\n1c[5oKNL7o\u00115fG.\u0004x.\u001b8uKJ,\"!a\r\u0011\u00071\u000b)$C\u0002\u00028\u0001\u00121cS5oKNL7o\u00115fG.\u0004x.\u001b8uKJ\fqc[5oKNL7o\u00115fG.\u0004x.\u001b8uKJ|F%Z9\u0015\u0007q\fi\u0004C\u0005\u0002\u0002]\t\t\u00111\u0001\u00024\u0005!2.\u001b8fg&\u001c8\t[3dWB|\u0017N\u001c;fe\u0002\nQa\u00197pG.,\"!!\u0012\u0011\t\u0005\u001d\u0013QJ\u0007\u0003\u0003\u0013R1!a\u0013%\u0003\u0011)H/\u001b7\n\t\u0005=\u0013\u0011\n\u0002\f\u001b\u0006tW/\u00197DY>\u001c7.A\u0005dY>\u001c7n\u0018\u0013fcR\u0019A0!\u0016\t\u0013\u0005\u0005!$!AA\u0002\u0005\u0015\u0013AB2m_\u000e\\\u0007%\u0001\u0006dQ\u0016\u001c7\u000e]8j]R,\"!!\u0018\u0011\u000b\u0005}\u0013\u0011\r?\u000e\u0003\u0001I1!a\u0019B\u00055\u0001&/\u001b<bi\u0016lU\r\u001e5pI\u0006Y1\r[3dWB|\u0017N\u001c;!\u0003)\u0011WMZ8sK\u0016\u000b7\r\u001b\u000b\u0002y\u0002")
public class KinesisCheckpointerSuite
extends SparkFunSuite
implements TestSuiteBase,
MockitoSugar,
PrivateMethodTester,
Eventually {
    private final String workerId;
    private final String shardId;
    private final String seqNum;
    private final String otherSeqNum;
    private final Duration org$apache$spark$streaming$kinesis$KinesisCheckpointerSuite$$checkpointInterval;
    private final Some<String> someSeqNum;
    private final Some<String> someOtherSeqNum;
    private KinesisReceiver<byte[]> receiverMock;
    private IRecordProcessorCheckpointer checkpointerMock;
    private KinesisCheckpointer kinesisCheckpointer;
    private ManualClock org$apache$spark$streaming$kinesis$KinesisCheckpointerSuite$$clock;
    private final PrivateMethodTester.PrivateMethod<BoxedUnit> checkpoint;
    private final AbstractPatienceConfiguration.PatienceConfig org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig;
    private volatile AbstractPatienceConfiguration$PatienceConfig$ PatienceConfig$module;
    private volatile PrivateMethodTester$PrivateMethod$ PrivateMethod$module;
    private String checkpointDir;
    private final SparkConf conf;
    private final PatienceConfiguration.Timeout eventuallyTimeout;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    private volatile boolean bitmap$0;

    public <T> T eventually(PatienceConfiguration.Timeout timeout, PatienceConfiguration.Interval interval, Function0<T> fun, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, (PatienceConfiguration.Timeout)timeout, (PatienceConfiguration.Interval)interval, fun, (Position)pos);
    }

    public <T> T eventually(PatienceConfiguration.Timeout timeout, Function0<T> fun, AbstractPatienceConfiguration.PatienceConfig config, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, (PatienceConfiguration.Timeout)timeout, fun, (AbstractPatienceConfiguration.PatienceConfig)config, (Position)pos);
    }

    public <T> T eventually(PatienceConfiguration.Interval interval, Function0<T> fun, AbstractPatienceConfiguration.PatienceConfig config, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, (PatienceConfiguration.Interval)interval, fun, (AbstractPatienceConfiguration.PatienceConfig)config, (Position)pos);
    }

    public <T> T eventually(Function0<T> fun, AbstractPatienceConfiguration.PatienceConfig config, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, fun, (AbstractPatienceConfiguration.PatienceConfig)config, (Position)pos);
    }

    public AbstractPatienceConfiguration.PatienceConfig patienceConfig() {
        return PatienceConfiguration.patienceConfig$((PatienceConfiguration)this);
    }

    public PatienceConfiguration.Timeout timeout(Span value) {
        return PatienceConfiguration.timeout$((PatienceConfiguration)this, (Span)value);
    }

    public PatienceConfiguration.Interval interval(Span value) {
        return PatienceConfiguration.interval$((PatienceConfiguration)this, (Span)value);
    }

    public final Span scaled(Span span) {
        return ScaledTimeSpans.scaled$((ScaledTimeSpans)this, (Span)span);
    }

    public double spanScaleFactor() {
        return ScaledTimeSpans.spanScaleFactor$((ScaledTimeSpans)this);
    }

    public PrivateMethodTester.Invoker anyRefToInvoker(Object target) {
        return PrivateMethodTester.anyRefToInvoker$((PrivateMethodTester)this, (Object)target);
    }

    public <T> T mock(ClassTag<T> classTag) {
        return (T)MockitoSugar.mock$((MockitoSugar)this, classTag);
    }

    public <T> T mock(Answer<?> defaultAnswer, ClassTag<T> classTag) {
        return (T)MockitoSugar.mock$((MockitoSugar)this, defaultAnswer, classTag);
    }

    public <T> T mock(MockSettings mockSettings, ClassTag<T> classTag) {
        return (T)MockitoSugar.mock$((MockitoSugar)this, (MockSettings)mockSettings, classTag);
    }

    public <T> T mock(String name, ClassTag<T> classTag) {
        return (T)MockitoSugar.mock$((MockitoSugar)this, (String)name, classTag);
    }

    public String framework() {
        return TestSuiteBase.framework$((TestSuiteBase)this);
    }

    public String master() {
        return TestSuiteBase.master$((TestSuiteBase)this);
    }

    public Duration batchDuration() {
        return TestSuiteBase.batchDuration$((TestSuiteBase)this);
    }

    public int numInputPartitions() {
        return TestSuiteBase.numInputPartitions$((TestSuiteBase)this);
    }

    public int maxWaitTimeMillis() {
        return TestSuiteBase.maxWaitTimeMillis$((TestSuiteBase)this);
    }

    public boolean useManualClock() {
        return TestSuiteBase.useManualClock$((TestSuiteBase)this);
    }

    public boolean actuallyWait() {
        return TestSuiteBase.actuallyWait$((TestSuiteBase)this);
    }

    public void beforeFunction() {
        TestSuiteBase.beforeFunction$((TestSuiteBase)this);
    }

    public void afterFunction() {
        TestSuiteBase.afterFunction$((TestSuiteBase)this);
    }

    public <R> R withStreamingContext(StreamingContext ssc, Function1<StreamingContext, R> block) {
        return (R)TestSuiteBase.withStreamingContext$((TestSuiteBase)this, (StreamingContext)ssc, block);
    }

    public <R> R withTestServer(TestServer testServer, Function1<TestServer, R> block) {
        return (R)TestSuiteBase.withTestServer$((TestSuiteBase)this, (TestServer)testServer, block);
    }

    public <U, V> StreamingContext setupStreams(Seq<Seq<U>> input, Function1<DStream<U>, DStream<V>> operation, int numPartitions, ClassTag<U> evidence$4, ClassTag<V> evidence$5) {
        return TestSuiteBase.setupStreams$((TestSuiteBase)this, input, operation, (int)numPartitions, evidence$4, evidence$5);
    }

    public <U, V> int setupStreams$default$3() {
        return TestSuiteBase.setupStreams$default$3$((TestSuiteBase)this);
    }

    public <U, V, W> StreamingContext setupStreams(Seq<Seq<U>> input1, Seq<Seq<V>> input2, Function2<DStream<U>, DStream<V>, DStream<W>> operation, ClassTag<U> evidence$6, ClassTag<V> evidence$7, ClassTag<W> evidence$8) {
        return TestSuiteBase.setupStreams$((TestSuiteBase)this, input1, input2, operation, evidence$6, evidence$7, evidence$8);
    }

    public <V> Seq<Seq<V>> runStreams(StreamingContext ssc, int numBatches, int numExpectedOutput, Function0<BoxedUnit> preStop, ClassTag<V> evidence$9) {
        return TestSuiteBase.runStreams$((TestSuiteBase)this, (StreamingContext)ssc, (int)numBatches, (int)numExpectedOutput, preStop, evidence$9);
    }

    public <V> Function0<BoxedUnit> runStreams$default$4() {
        return TestSuiteBase.runStreams$default$4$((TestSuiteBase)this);
    }

    public <V> Seq<Seq<Seq<V>>> runStreamsWithPartitions(StreamingContext ssc, int numBatches, int numExpectedOutput, Function0<BoxedUnit> preStop, ClassTag<V> evidence$10) {
        return TestSuiteBase.runStreamsWithPartitions$((TestSuiteBase)this, (StreamingContext)ssc, (int)numBatches, (int)numExpectedOutput, preStop, evidence$10);
    }

    public <V> Function0<BoxedUnit> runStreamsWithPartitions$default$4() {
        return TestSuiteBase.runStreamsWithPartitions$default$4$((TestSuiteBase)this);
    }

    public <V> void verifyOutput(Seq<Seq<V>> output, Seq<Seq<V>> expectedOutput, boolean useSet, ClassTag<V> evidence$11) {
        TestSuiteBase.verifyOutput$((TestSuiteBase)this, output, expectedOutput, (boolean)useSet, evidence$11);
    }

    public <U, V> void testOperation(Seq<Seq<U>> input, Function1<DStream<U>, DStream<V>> operation, Seq<Seq<V>> expectedOutput, boolean useSet, ClassTag<U> evidence$12, ClassTag<V> evidence$13) {
        TestSuiteBase.testOperation$((TestSuiteBase)this, input, operation, expectedOutput, (boolean)useSet, evidence$12, evidence$13);
    }

    public <U, V> boolean testOperation$default$4() {
        return TestSuiteBase.testOperation$default$4$((TestSuiteBase)this);
    }

    public <U, V> void testOperation(Seq<Seq<U>> input, Function1<DStream<U>, DStream<V>> operation, Seq<Seq<V>> expectedOutput, int numBatches, boolean useSet, ClassTag<U> evidence$14, ClassTag<V> evidence$15) {
        TestSuiteBase.testOperation$((TestSuiteBase)this, input, operation, expectedOutput, (int)numBatches, (boolean)useSet, evidence$14, evidence$15);
    }

    public <U, V, W> void testOperation(Seq<Seq<U>> input1, Seq<Seq<V>> input2, Function2<DStream<U>, DStream<V>, DStream<W>> operation, Seq<Seq<W>> expectedOutput, boolean useSet, ClassTag<U> evidence$16, ClassTag<V> evidence$17, ClassTag<W> evidence$18) {
        TestSuiteBase.testOperation$((TestSuiteBase)this, input1, input2, operation, expectedOutput, (boolean)useSet, evidence$16, evidence$17, evidence$18);
    }

    public <U, V, W> void testOperation(Seq<Seq<U>> input1, Seq<Seq<V>> input2, Function2<DStream<U>, DStream<V>, DStream<W>> operation, Seq<Seq<W>> expectedOutput, int numBatches, boolean useSet, ClassTag<U> evidence$19, ClassTag<V> evidence$20, ClassTag<W> evidence$21) {
        TestSuiteBase.testOperation$((TestSuiteBase)this, input1, input2, operation, expectedOutput, (int)numBatches, (boolean)useSet, evidence$19, evidence$20, evidence$21);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$runTest(String testName, Args args) {
        return BeforeAndAfterEach.runTest$((BeforeAndAfterEach)this, (String)testName, (Args)args);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$run(Option testName, Args args) {
        return BeforeAndAfterAll.run$((BeforeAndAfterAll)this, (Option)testName, (Args)args);
    }

    public void before(Function0<Object> fun, Position pos) {
        BeforeAndAfter.before$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public void after(Function0<Object> fun, Position pos) {
        BeforeAndAfter.after$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfter.runTest$((BeforeAndAfter)this, (String)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfter.run$((BeforeAndAfter)this, testName, (Args)args);
    }

    public AbstractPatienceConfiguration.PatienceConfig org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig() {
        return this.org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig;
    }

    public final void org$scalatest$concurrent$PatienceConfiguration$_setter_$org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig_$eq(AbstractPatienceConfiguration.PatienceConfig x$1) {
        this.org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig = x$1;
    }

    public AbstractPatienceConfiguration$PatienceConfig$ PatienceConfig() {
        if (this.PatienceConfig$module == null) {
            this.PatienceConfig$lzycompute$1();
        }
        return this.PatienceConfig$module;
    }

    public PrivateMethodTester$PrivateMethod$ PrivateMethod() {
        if (this.PrivateMethod$module == null) {
            this.PrivateMethod$lzycompute$1();
        }
        return this.PrivateMethod$module;
    }

    private String checkpointDir$lzycompute() {
        KinesisCheckpointerSuite kinesisCheckpointerSuite = this;
        synchronized (kinesisCheckpointerSuite) {
            if (!this.bitmap$0) {
                this.checkpointDir = TestSuiteBase.checkpointDir$((TestSuiteBase)this);
                this.bitmap$0 = true;
            }
        }
        return this.checkpointDir;
    }

    public String checkpointDir() {
        return !this.bitmap$0 ? this.checkpointDir$lzycompute() : this.checkpointDir;
    }

    public SparkConf conf() {
        return this.conf;
    }

    public PatienceConfiguration.Timeout eventuallyTimeout() {
        return this.eventuallyTimeout;
    }

    public void org$apache$spark$streaming$TestSuiteBase$_setter_$conf_$eq(SparkConf x$1) {
        this.conf = x$1;
    }

    public void org$apache$spark$streaming$TestSuiteBase$_setter_$eventuallyTimeout_$eq(PatienceConfiguration.Timeout x$1) {
        this.eventuallyTimeout = x$1;
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    private String workerId() {
        return this.workerId;
    }

    private String shardId() {
        return this.shardId;
    }

    private String seqNum() {
        return this.seqNum;
    }

    private String otherSeqNum() {
        return this.otherSeqNum;
    }

    public Duration org$apache$spark$streaming$kinesis$KinesisCheckpointerSuite$$checkpointInterval() {
        return this.org$apache$spark$streaming$kinesis$KinesisCheckpointerSuite$$checkpointInterval;
    }

    private Some<String> someSeqNum() {
        return this.someSeqNum;
    }

    private Some<String> someOtherSeqNum() {
        return this.someOtherSeqNum;
    }

    private KinesisReceiver<byte[]> receiverMock() {
        return this.receiverMock;
    }

    private void receiverMock_$eq(KinesisReceiver<byte[]> x$1) {
        this.receiverMock = x$1;
    }

    private IRecordProcessorCheckpointer checkpointerMock() {
        return this.checkpointerMock;
    }

    private void checkpointerMock_$eq(IRecordProcessorCheckpointer x$1) {
        this.checkpointerMock = x$1;
    }

    private KinesisCheckpointer kinesisCheckpointer() {
        return this.kinesisCheckpointer;
    }

    private void kinesisCheckpointer_$eq(KinesisCheckpointer x$1) {
        this.kinesisCheckpointer = x$1;
    }

    public ManualClock org$apache$spark$streaming$kinesis$KinesisCheckpointerSuite$$clock() {
        return this.org$apache$spark$streaming$kinesis$KinesisCheckpointerSuite$$clock;
    }

    private void org$apache$spark$streaming$kinesis$KinesisCheckpointerSuite$$clock_$eq(ManualClock x$1) {
        this.org$apache$spark$streaming$kinesis$KinesisCheckpointerSuite$$clock = x$1;
    }

    private PrivateMethodTester.PrivateMethod<BoxedUnit> checkpoint() {
        return this.checkpoint;
    }

    public void beforeEach() {
        this.receiverMock_$eq((KinesisReceiver<byte[]>)((KinesisReceiver)this.mock(ClassTag$.MODULE$.apply(KinesisReceiver.class))));
        this.checkpointerMock_$eq((IRecordProcessorCheckpointer)this.mock(ClassTag$.MODULE$.apply(IRecordProcessorCheckpointer.class)));
        this.org$apache$spark$streaming$kinesis$KinesisCheckpointerSuite$$clock_$eq(new ManualClock());
        this.kinesisCheckpointer_$eq(new KinesisCheckpointer(this.receiverMock(), this.org$apache$spark$streaming$kinesis$KinesisCheckpointerSuite$$checkpointInterval(), this.workerId(), (Clock)this.org$apache$spark$streaming$kinesis$KinesisCheckpointerSuite$$clock()));
    }

    private final void PatienceConfig$lzycompute$1() {
        KinesisCheckpointerSuite kinesisCheckpointerSuite = this;
        synchronized (kinesisCheckpointerSuite) {
            if (this.PatienceConfig$module == null) {
                this.PatienceConfig$module = new AbstractPatienceConfiguration$PatienceConfig$((AbstractPatienceConfiguration)this);
            }
        }
    }

    private final void PrivateMethod$lzycompute$1() {
        KinesisCheckpointerSuite kinesisCheckpointerSuite = this;
        synchronized (kinesisCheckpointerSuite) {
            if (this.PrivateMethod$module == null) {
                this.PrivateMethod$module = new PrivateMethodTester$PrivateMethod$((PrivateMethodTester)this);
            }
        }
    }

    public KinesisCheckpointerSuite() {
        BeforeAndAfter.$init$((BeforeAndAfter)this);
        TestSuiteBase.$init$((TestSuiteBase)this);
        MockitoSugar.$init$((MockitoSugar)this);
        PrivateMethodTester.$init$((PrivateMethodTester)this);
        ScaledTimeSpans.$init$((ScaledTimeSpans)this);
        AbstractPatienceConfiguration.$init$((AbstractPatienceConfiguration)this);
        PatienceConfiguration.$init$((PatienceConfiguration)this);
        Eventually.$init$((Eventually)this);
        this.workerId = "dummyWorkerId";
        this.shardId = "dummyShardId";
        this.seqNum = "123";
        this.otherSeqNum = "245";
        this.org$apache$spark$streaming$kinesis$KinesisCheckpointerSuite$$checkpointInterval = new Duration(10L);
        this.someSeqNum = new Some((Object)this.seqNum());
        this.someOtherSeqNum = new Some((Object)this.otherSeqNum());
        this.checkpoint = this.PrivateMethod().apply((Symbol)SymbolLiteral.bootstrap("apply", "checkpoint"));
        this.test("checkpoint is not called twice for the same sequence number", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Mockito.when((Object)this.receiverMock().getLatestSeqNumToCheckpoint(this.shardId())).thenReturn(this.someSeqNum());
            this.anyRefToInvoker(this.kinesisCheckpointer()).invokePrivate(this.checkpoint().apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.shardId(), this.checkpointerMock()})));
            this.anyRefToInvoker(this.kinesisCheckpointer()).invokePrivate(this.checkpoint().apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.shardId(), this.checkpointerMock()})));
            ((IRecordProcessorCheckpointer)Mockito.verify((Object)this.checkpointerMock(), (VerificationMode)Mockito.times((int)1))).checkpoint(Matchers.anyString());
        }, new Position("KinesisCheckpointerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66));
        this.test("checkpoint is called after sequence number increases", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Mockito.when((Object)this.receiverMock().getLatestSeqNumToCheckpoint(this.shardId())).thenReturn(this.someSeqNum()).thenReturn(this.someOtherSeqNum());
            this.anyRefToInvoker(this.kinesisCheckpointer()).invokePrivate(this.checkpoint().apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.shardId(), this.checkpointerMock()})));
            this.anyRefToInvoker(this.kinesisCheckpointer()).invokePrivate(this.checkpoint().apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.shardId(), this.checkpointerMock()})));
            ((IRecordProcessorCheckpointer)Mockito.verify((Object)this.checkpointerMock(), (VerificationMode)Mockito.times((int)1))).checkpoint(this.seqNum());
            ((IRecordProcessorCheckpointer)Mockito.verify((Object)this.checkpointerMock(), (VerificationMode)Mockito.times((int)1))).checkpoint(this.otherSeqNum());
        }, new Position("KinesisCheckpointerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
        this.test("should checkpoint if we have exceeded the checkpoint interval", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Mockito.when((Object)this.receiverMock().getLatestSeqNumToCheckpoint(this.shardId())).thenReturn(this.someSeqNum()).thenReturn(this.someOtherSeqNum());
            this.kinesisCheckpointer().setCheckpointer(this.shardId(), this.checkpointerMock());
            this.org$apache$spark$streaming$kinesis$KinesisCheckpointerSuite$$clock().advance(5L * this.org$apache$spark$streaming$kinesis$KinesisCheckpointerSuite$$checkpointInterval().milliseconds());
            this.eventually(this.timeout(Span$.MODULE$.convertDurationToSpan((scala.concurrent.duration.Duration)new package.DurationInt(package$.MODULE$.DurationInt(1)).second())), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                ((IRecordProcessorCheckpointer)Mockito.verify((Object)this.checkpointerMock(), (VerificationMode)Mockito.times((int)1))).checkpoint(this.seqNum());
                ((IRecordProcessorCheckpointer)Mockito.verify((Object)this.checkpointerMock(), (VerificationMode)Mockito.times((int)1))).checkpoint(this.otherSeqNum());
            }, this.patienceConfig(), new Position("KinesisCheckpointerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91));
        }, new Position("KinesisCheckpointerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
        this.test("shouldn't checkpoint if we have not exceeded the checkpoint interval", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Mockito.when((Object)this.receiverMock().getLatestSeqNumToCheckpoint(this.shardId())).thenReturn(this.someSeqNum());
            this.kinesisCheckpointer().setCheckpointer(this.shardId(), this.checkpointerMock());
            this.org$apache$spark$streaming$kinesis$KinesisCheckpointerSuite$$clock().advance(this.org$apache$spark$streaming$kinesis$KinesisCheckpointerSuite$$checkpointInterval().milliseconds() / 2L);
            ((IRecordProcessorCheckpointer)Mockito.verify((Object)this.checkpointerMock(), (VerificationMode)Mockito.never())).checkpoint(Matchers.anyString());
        }, new Position("KinesisCheckpointerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
        this.test("should not checkpoint for the same sequence number", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Mockito.when((Object)this.receiverMock().getLatestSeqNumToCheckpoint(this.shardId())).thenReturn(this.someSeqNum());
            this.kinesisCheckpointer().setCheckpointer(this.shardId(), this.checkpointerMock());
            this.org$apache$spark$streaming$kinesis$KinesisCheckpointerSuite$$clock().advance(this.org$apache$spark$streaming$kinesis$KinesisCheckpointerSuite$$checkpointInterval().milliseconds() * 5L);
            this.eventually(this.timeout(Span$.MODULE$.convertDurationToSpan((scala.concurrent.duration.Duration)new package.DurationInt(package$.MODULE$.DurationInt(1)).second())), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IRecordProcessorCheckpointer)Mockito.verify((Object)this.checkpointerMock(), (VerificationMode)Mockito.atMost((int)1))).checkpoint(Matchers.anyString()), this.patienceConfig(), new Position("KinesisCheckpointerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112));
        }, new Position("KinesisCheckpointerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 106));
        this.test("removing checkpointer checkpoints one last time", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Mockito.when((Object)this.receiverMock().getLatestSeqNumToCheckpoint(this.shardId())).thenReturn(this.someSeqNum());
            this.kinesisCheckpointer().removeCheckpointer(this.shardId(), this.checkpointerMock());
            ((IRecordProcessorCheckpointer)Mockito.verify((Object)this.checkpointerMock(), (VerificationMode)Mockito.times((int)1))).checkpoint();
        }, new Position("KinesisCheckpointerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 117));
        this.test("if checkpointing is going on, wait until finished before removing and checkpointing", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Mockito.when((Object)this.receiverMock().getLatestSeqNumToCheckpoint(this.shardId())).thenReturn(this.someSeqNum()).thenReturn(this.someOtherSeqNum());
            this.checkpointerMock().checkpoint(Matchers.anyString());
            Mockito.when((Object)BoxedUnit.UNIT).thenAnswer((Answer)new Answer<BoxedUnit>(this){
                private final /* synthetic */ KinesisCheckpointerSuite $outer;

                public void answer(InvocationOnMock invocations) {
                    this.$outer.org$apache$spark$streaming$kinesis$KinesisCheckpointerSuite$$clock().waitTillTime(this.$outer.org$apache$spark$streaming$kinesis$KinesisCheckpointerSuite$$clock().getTimeMillis() + this.$outer.org$apache$spark$streaming$kinesis$KinesisCheckpointerSuite$$checkpointInterval().milliseconds() / 2L);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            this.kinesisCheckpointer().setCheckpointer(this.shardId(), this.checkpointerMock());
            this.org$apache$spark$streaming$kinesis$KinesisCheckpointerSuite$$clock().advance(this.org$apache$spark$streaming$kinesis$KinesisCheckpointerSuite$$checkpointInterval().milliseconds());
            this.eventually(this.timeout(Span$.MODULE$.convertDurationToSpan((scala.concurrent.duration.Duration)new package.DurationInt(package$.MODULE$.DurationInt(1)).second())), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IRecordProcessorCheckpointer)Mockito.verify((Object)this.checkpointerMock(), (VerificationMode)Mockito.times((int)1))).checkpoint(Matchers.anyString()), this.patienceConfig(), new Position("KinesisCheckpointerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 135));
            Future f = Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.kinesisCheckpointer().removeCheckpointer(this.shardId(), this.checkpointerMock()), (ExecutionContext)ExecutionContext$.MODULE$.global());
            this.intercept((Function0 & Serializable & scala.Serializable)() -> (Future)Await$.MODULE$.ready((Awaitable)f, (scala.concurrent.duration.Duration)new package.DurationInt(package$.MODULE$.DurationInt(50)).millis()), ClassTag$.MODULE$.apply(TimeoutException.class), new Position("KinesisCheckpointerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 142));
            this.org$apache$spark$streaming$kinesis$KinesisCheckpointerSuite$$clock().advance(this.org$apache$spark$streaming$kinesis$KinesisCheckpointerSuite$$checkpointInterval().milliseconds() / 2L);
            this.eventually(this.timeout(Span$.MODULE$.convertDurationToSpan((scala.concurrent.duration.Duration)new package.DurationInt(package$.MODULE$.DurationInt(1)).second())), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                ((IRecordProcessorCheckpointer)Mockito.verify((Object)this.checkpointerMock(), (VerificationMode)Mockito.times((int)1))).checkpoint(Matchers.anyString());
                ((IRecordProcessorCheckpointer)Mockito.verify((Object)this.checkpointerMock(), (VerificationMode)Mockito.times((int)1))).checkpoint();
            }, this.patienceConfig(), new Position("KinesisCheckpointerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 149));
        }, new Position("KinesisCheckpointerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 124));
    }
}

