/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.kinesis;

import com.amazonaws.services.kinesis.clientlibrary.lib.worker.InitialPositionInStream;
import com.amazonaws.services.kinesis.model.Record;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.api.java.JavaReceiverInputDStream;
import org.apache.spark.streaming.api.java.JavaReceiverInputDStream$;
import org.apache.spark.streaming.api.java.JavaStreamingContext;
import org.apache.spark.streaming.kinesis.KinesisInputDStream$;
import org.apache.spark.streaming.kinesis.KinesisUtils$;
import scala.Function1;
import scala.Serializable;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001q4A!\u0001\u0002\u0005\u001b\tA2*\u001b8fg&\u001cX\u000b^5mgBKH\u000f[8o\u0011\u0016d\u0007/\u001a:\u000b\u0005\r!\u0011aB6j]\u0016\u001c\u0018n\u001d\u0006\u0003\u000b\u0019\t\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001\u001dA\u0011qBE\u0007\u0002!)\t\u0011#A\u0003tG\u0006d\u0017-\u0003\u0002\u0014!\t1\u0011I\\=SK\u001aDQ!\u0006\u0001\u0005\u0002Y\ta\u0001P5oSRtD#A\f\u0011\u0005a\u0001Q\"\u0001\u0002\t\u000bi\u0001A\u0011A\u000e\u00025\u001d,G/\u00138ji&\fG\u000eU8tSRLwN\\%o'R\u0014X-Y7\u0015\u0005qi\u0003CA\u000f,\u001b\u0005q\"BA\u0010!\u0003\u00199xN]6fe*\u0011\u0011EI\u0001\u0004Y&\u0014'BA\u0012%\u00035\u0019G.[3oi2L'M]1ss*\u00111!\n\u0006\u0003M\u001d\n\u0001b]3sm&\u001cWm\u001d\u0006\u0003Q%\n\u0011\"Y7bu>t\u0017m^:\u000b\u0003)\n1aY8n\u0013\tacDA\fJ]&$\u0018.\u00197Q_NLG/[8o\u0013:\u001cFO]3b[\")a&\u0007a\u0001_\u00059\u0012N\\5uS\u0006d\u0007k\\:ji&|g.\u00138TiJ,\u0017-\u001c\t\u0003\u001fAJ!!\r\t\u0003\u0007%sG\u000fC\u00034\u0001\u0011\u0005A'\u0001\u0007de\u0016\fG/Z*ue\u0016\fW\u000e\u0006\b6\u0007\"+v+W.]E*dg\u000e\u001d:\u0011\u0007YZT(D\u00018\u0015\tA\u0014(\u0001\u0003kCZ\f'B\u0001\u001e\u0005\u0003\r\t\u0007/[\u0005\u0003y]\u0012\u0001DS1wCJ+7-Z5wKJLe\u000e];u\tN#(/Z1n!\rya\bQ\u0005\u0003\u007fA\u0011Q!\u0011:sCf\u0004\"aD!\n\u0005\t\u0003\"\u0001\u0002\"zi\u0016DQ\u0001\u0012\u001aA\u0002\u0015\u000bAA[:tGB\u0011aGR\u0005\u0003\u000f^\u0012ACS1wCN#(/Z1nS:<7i\u001c8uKb$\b\"B%3\u0001\u0004Q\u0015AD6j]\u0016\u001c\u0018n]!qa:\u000bW.\u001a\t\u0003\u0017Js!\u0001\u0014)\u0011\u00055\u0003R\"\u0001(\u000b\u0005=c\u0011A\u0002\u001fs_>$h(\u0003\u0002R!\u00051\u0001K]3eK\u001aL!a\u0015+\u0003\rM#(/\u001b8h\u0015\t\t\u0006\u0003C\u0003We\u0001\u0007!*\u0001\u0006tiJ,\u0017-\u001c(b[\u0016DQ\u0001\u0017\u001aA\u0002)\u000b1\"\u001a8ea>Lg\u000e^+sY\")!L\ra\u0001\u0015\u0006Q!/Z4j_:t\u0015-\\3\t\u000b9\u0012\u0004\u0019A\u0018\t\u000bu\u0013\u0004\u0019\u00010\u0002%\rDWmY6q_&tG/\u00138uKJ4\u0018\r\u001c\t\u0003?\u0002l\u0011\u0001B\u0005\u0003C\u0012\u0011\u0001\u0002R;sCRLwN\u001c\u0005\u0006GJ\u0002\r\u0001Z\u0001\rgR|'/Y4f\u0019\u00164X\r\u001c\t\u0003K\"l\u0011A\u001a\u0006\u0003O\u001a\tqa\u001d;pe\u0006<W-\u0003\u0002jM\na1\u000b^8sC\u001e,G*\u001a<fY\")1N\ra\u0001\u0015\u0006q\u0011m^:BG\u000e,7o]&fs&#\u0007\"B73\u0001\u0004Q\u0015\u0001D1xgN+7M]3u\u0017\u0016L\b\"B83\u0001\u0004Q\u0015\u0001E:ug\u0006\u001b8/^7f%>dW-\u0011:o\u0011\u0015\t(\u00071\u0001K\u00039\u0019Ho]*fgNLwN\u001c(b[\u0016DQa\u001d\u001aA\u0002)\u000bQb\u001d;t\u000bb$XM\u001d8bY&#\u0007\"B;\u0001\t\u00131\u0018\u0001\u0005<bY&$\u0017\r^3BoN\u001c%/\u001a3t)\r9(p\u001f\t\u0003\u001faL!!\u001f\t\u0003\tUs\u0017\u000e\u001e\u0005\u0006WR\u0004\rA\u0013\u0005\u0006[R\u0004\rA\u0013")
public class KinesisUtilsPythonHelper {
    public InitialPositionInStream getInitialPositionInStream(int initialPositionInStream) {
        InitialPositionInStream initialPositionInStream2;
        int n = initialPositionInStream;
        switch (n) {
            case 0: {
                initialPositionInStream2 = InitialPositionInStream.LATEST;
                break;
            }
            case 1: {
                initialPositionInStream2 = InitialPositionInStream.TRIM_HORIZON;
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal InitialPositionInStream. Please use InitialPositionInStream.LATEST or InitialPositionInStream.TRIM_HORIZON");
            }
        }
        return initialPositionInStream2;
    }

    public JavaReceiverInputDStream<byte[]> createStream(JavaStreamingContext jssc, String kinesisAppName, String streamName, String endpointUrl, String regionName, int initialPositionInStream, Duration checkpointInterval, StorageLevel storageLevel, String awsAccessKeyId, String awsSecretKey, String stsAssumeRoleArn, String stsSessionName, String stsExternalId) {
        Object object;
        if (!(stsAssumeRoleArn != null && stsSessionName != null && stsExternalId != null || stsAssumeRoleArn == null && stsSessionName == null && stsExternalId == null)) {
            throw new IllegalArgumentException("stsAssumeRoleArn, stsSessionName, and stsExtenalId must all be defined or all be null");
        }
        if (stsAssumeRoleArn != null && stsSessionName != null && stsExternalId != null) {
            this.validateAwsCreds(awsAccessKeyId, awsSecretKey);
            object = JavaReceiverInputDStream$.MODULE$.fromReceiverInputDStream(KinesisUtils$.MODULE$.createStream(jssc.ssc(), kinesisAppName, streamName, endpointUrl, regionName, this.getInitialPositionInStream(initialPositionInStream), checkpointInterval, storageLevel, (Function1 & java.io.Serializable & Serializable)x$7 -> KinesisInputDStream$.MODULE$.defaultMessageHandler((Record)x$7), awsAccessKeyId, awsSecretKey, stsAssumeRoleArn, stsSessionName, stsExternalId, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE))), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
        } else {
            this.validateAwsCreds(awsAccessKeyId, awsSecretKey);
            object = awsAccessKeyId == null && awsSecretKey == null ? KinesisUtils$.MODULE$.createStream(jssc, kinesisAppName, streamName, endpointUrl, regionName, this.getInitialPositionInStream(initialPositionInStream), checkpointInterval, storageLevel) : KinesisUtils$.MODULE$.createStream(jssc, kinesisAppName, streamName, endpointUrl, regionName, this.getInitialPositionInStream(initialPositionInStream), checkpointInterval, storageLevel, awsAccessKeyId, awsSecretKey);
        }
        return object;
    }

    private void validateAwsCreds(String awsAccessKeyId, String awsSecretKey) {
        if (awsAccessKeyId == null && awsSecretKey != null) {
            throw new IllegalArgumentException("awsSecretKey is set but awsAccessKeyId is null");
        }
        if (awsAccessKeyId != null && awsSecretKey == null) {
            throw new IllegalArgumentException("awsAccessKeyId is set but awsSecretKey is null");
        }
    }
}

