/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.kinesis;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.regions.RegionUtils;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBClient;
import com.amazonaws.services.dynamodbv2.document.DynamoDB;
import com.amazonaws.services.dynamodbv2.document.Table;
import com.amazonaws.services.kinesis.AmazonKinesisClient;
import com.amazonaws.services.kinesis.model.CreateStreamRequest;
import com.amazonaws.services.kinesis.model.DescribeStreamRequest;
import com.amazonaws.services.kinesis.model.MergeShardsRequest;
import com.amazonaws.services.kinesis.model.ResourceNotFoundException;
import com.amazonaws.services.kinesis.model.Shard;
import com.amazonaws.services.kinesis.model.SplitShardRequest;
import com.amazonaws.services.kinesis.model.StreamDescription;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.spark.internal.Logging;
import org.apache.spark.streaming.kinesis.KinesisDataGenerator;
import org.apache.spark.streaming.kinesis.KinesisTestUtils$;
import org.apache.spark.streaming.kinesis.SimpleDataGenerator;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.NonLocalReturnControl;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\t}a!B\u0001\u0003\u0001\ta!\u0001E&j]\u0016\u001c\u0018n\u001d+fgR,F/\u001b7t\u0015\t\u0019A!A\u0004lS:,7/[:\u000b\u0005\u00151\u0011!C:ue\u0016\fW.\u001b8h\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7c\u0001\u0001\u000e'A\u0011a\"E\u0007\u0002\u001f)\t\u0001#A\u0003tG\u0006d\u0017-\u0003\u0002\u0013\u001f\t1\u0011I\\=SK\u001a\u0004\"\u0001F\f\u000e\u0003UQ!A\u0006\u0004\u0002\u0011%tG/\u001a:oC2L!\u0001G\u000b\u0003\u000f1{wmZ5oO\"A!\u0004\u0001B\u0001B\u0003%A$\u0001\ttiJ,\u0017-\\*iCJ$7i\\;oi\u000e\u0001\u0001C\u0001\b\u001e\u0013\tqrBA\u0002J]RDQ\u0001\t\u0001\u0005\u0002\u0005\na\u0001P5oSRtDC\u0001\u0012%!\t\u0019\u0003!D\u0001\u0003\u0011\u001dQr\u0004%AA\u0002qAqA\n\u0001C\u0002\u0013\u0005q%A\u0006f]\u0012\u0004x.\u001b8u+JdW#\u0001\u0015\u0011\u0005%\u0002dB\u0001\u0016/!\tYs\"D\u0001-\u0015\ti3$\u0001\u0004=e>|GOP\u0005\u0003_=\ta\u0001\u0015:fI\u00164\u0017BA\u00193\u0005\u0019\u0019FO]5oO*\u0011qf\u0004\u0005\u0007i\u0001\u0001\u000b\u0011\u0002\u0015\u0002\u0019\u0015tG\r]8j]R,&\u000f\u001c\u0011\t\u000fY\u0002!\u0019!C\u0001O\u0005Q!/Z4j_:t\u0015-\\3\t\ra\u0002\u0001\u0015!\u0003)\u0003-\u0011XmZ5p]:\u000bW.\u001a\u0011\t\u000fi\u0002!\u0019!C\u0005w\u0005Q2M]3bi\u0016\u001cFO]3b[RKW.Z8viN+7m\u001c8egV\tA\u0004\u0003\u0004>\u0001\u0001\u0006I\u0001H\u0001\u001cGJ,\u0017\r^3TiJ,\u0017-\u001c+j[\u0016|W\u000f^*fG>tGm\u001d\u0011\t\u000f}\u0002!\u0019!C\u0005w\u0005iB-Z:de&\u0014Wm\u0015;sK\u0006l\u0007k\u001c7m)&lWmU3d_:$7\u000f\u0003\u0004B\u0001\u0001\u0006I\u0001H\u0001\u001fI\u0016\u001c8M]5cKN#(/Z1n!>dG\u000eV5nKN+7m\u001c8eg\u0002Bqa\u0011\u0001A\u0002\u0013%A)A\u0007tiJ,\u0017-\\\"sK\u0006$X\rZ\u000b\u0002\u000bB\u0011aBR\u0005\u0003\u000f>\u0011qAQ8pY\u0016\fg\u000eC\u0004J\u0001\u0001\u0007I\u0011\u0002&\u0002#M$(/Z1n\u0007J,\u0017\r^3e?\u0012*\u0017\u000f\u0006\u0002L\u001dB\u0011a\u0002T\u0005\u0003\u001b>\u0011A!\u00168ji\"9q\nSA\u0001\u0002\u0004)\u0015a\u0001=%c!1\u0011\u000b\u0001Q!\n\u0015\u000bab\u001d;sK\u0006l7I]3bi\u0016$\u0007\u0005\u000b\u0002Q'B\u0011a\u0002V\u0005\u0003+>\u0011\u0001B^8mCRLG.\u001a\u0005\n/\u0002\u0001\r\u00111A\u0005\n\u001d\n1bX:ue\u0016\fWNT1nK\"I\u0011\f\u0001a\u0001\u0002\u0004%IAW\u0001\u0010?N$(/Z1n\u001d\u0006lWm\u0018\u0013fcR\u00111j\u0017\u0005\b\u001fb\u000b\t\u00111\u0001)\u0011%i\u0006\u00011A\u0001B\u0003&\u0001&\u0001\u0007`gR\u0014X-Y7OC6,\u0007\u0005\u000b\u0002]'\"A\u0001\r\u0001EC\u0002\u0013E\u0011-A\u0007lS:,7/[:DY&,g\u000e^\u000b\u0002EB\u00111m[\u0007\u0002I*\u00111!\u001a\u0006\u0003M\u001e\f\u0001b]3sm&\u001cWm\u001d\u0006\u0003Q&\f\u0011\"Y7bu>t\u0017m^:\u000b\u0003)\f1aY8n\u0013\taGMA\nB[\u0006TxN\\&j]\u0016\u001c\u0018n]\"mS\u0016tG\u000f\u0003\u0005o\u0001!\u0015\r\u0011\"\u0003p\u0003!!\u0017P\\1n_\u0012\u0013U#\u00019\u0011\u0005E4X\"\u0001:\u000b\u0005M$\u0018\u0001\u00033pGVlWM\u001c;\u000b\u0005U,\u0017A\u00033z]\u0006lw\u000e\u001a2we%\u0011qO\u001d\u0002\t\tft\u0017-\\8E\u0005\")\u0011\u0010\u0001C\tu\u0006Yq-\u001a;Qe>$WoY3s)\tYh\u0010\u0005\u0002$y&\u0011QP\u0001\u0002\u0015\u0017&tWm]5t\t\u0006$\u0018mR3oKJ\fGo\u001c:\t\u000b}D\b\u0019A#\u0002\u0013\u0005<wM]3hCR,\u0007BBA\u0002\u0001\u0011\u0005q%\u0001\u0006tiJ,\u0017-\u001c(b[\u0016Dq!a\u0002\u0001\t\u0003\tI!\u0001\u0007de\u0016\fG/Z*ue\u0016\fW\u000eF\u0001L\u0011\u001d\ti\u0001\u0001C\u0001\u0003\u001f\t\u0011bZ3u'\"\f'\u000fZ:\u0015\u0005\u0005E\u0001CBA\n\u0003;\t\u0019C\u0004\u0003\u0002\u0016\u0005eabA\u0016\u0002\u0018%\t\u0001#C\u0002\u0002\u001c=\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002 \u0005\u0005\"aA*fc*\u0019\u00111D\b\u0011\t\u0005\u0015\u00121F\u0007\u0003\u0003OQ1!!\u000be\u0003\u0015iw\u000eZ3m\u0013\u0011\ti#a\n\u0003\u000bMC\u0017M\u001d3\t\u000f\u0005E\u0002\u0001\"\u0001\u00024\u0005Q1\u000f\u001d7jiNC\u0017M\u001d3\u0015\u0007-\u000b)\u0004C\u0004\u00028\u0005=\u0002\u0019\u0001\u0015\u0002\u000fMD\u0017M\u001d3JI\"9\u00111\b\u0001\u0005\u0002\u0005u\u0012AC7fe\u001e,7\u000b[1sIR)1*a\u0010\u0002D!9\u0011\u0011IA\u001d\u0001\u0004A\u0013\u0001D:iCJ$Gk\\'fe\u001e,\u0007bBA#\u0003s\u0001\r\u0001K\u0001\u0015C\u0012T\u0017mY3oiNC\u0017M\u001d3U_6+'oZ3\t\u000f\u0005%\u0003\u0001\"\u0001\u0002L\u0005A\u0001/^:i\t\u0006$\u0018\r\u0006\u0004\u0002N\u0005m\u0013\u0011\r\t\u0007S\u0005=\u0003&a\u0015\n\u0007\u0005E#GA\u0002NCB\u0004b!a\u0005\u0002\u001e\u0005U\u0003#\u0002\b\u0002XqA\u0013bAA-\u001f\t1A+\u001e9mKJB\u0001\"!\u0018\u0002H\u0001\u0007\u0011qL\u0001\ti\u0016\u001cH\u000fR1uCB)\u00111CA\u000f9!1q0a\u0012A\u0002\u0015Cq!!\u0013\u0001\t\u0003\t)\u0007F\u0002L\u0003OB\u0001\"!\u0018\u0002d\u0001\u0007\u0011\u0011\u000e\t\u0006\u0003W\n)\bH\u0007\u0003\u0003[RA!a\u001c\u0002r\u0005!Q\u000f^5m\u0015\t\t\u0019(\u0001\u0003kCZ\f\u0017\u0002BA<\u0003[\u0012A\u0001T5ti\"9\u00111\u0010\u0001\u0005\u0002\u0005%\u0011\u0001\u00043fY\u0016$Xm\u0015;sK\u0006l\u0007bBA@\u0001\u0011\u0005\u0011\u0011Q\u0001\u0014I\u0016dW\r^3Es:\fWn\u001c#C)\u0006\u0014G.\u001a\u000b\u0004\u0017\u0006\r\u0005bBAC\u0003{\u0002\r\u0001K\u0001\ni\u0006\u0014G.\u001a(b[\u0016Dq!!#\u0001\t\u0013\tY)\u0001\beKN\u001c'/\u001b2f'R\u0014X-Y7\u0015\t\u00055\u0015\u0011\u0014\t\u0006\u001d\u0005=\u00151S\u0005\u0004\u0003#{!AB(qi&|g\u000e\u0005\u0003\u0002&\u0005U\u0015\u0002BAL\u0003O\u0011\u0011c\u0015;sK\u0006lG)Z:de&\u0004H/[8o\u0011\u001d\tY*a\"A\u0002!\nAc\u001d;sK\u0006lg*Y7f)>$Um]2sS\n,\u0007bBAP\u0001\u0011%\u0011\u0011U\u0001\u001aM&tGMT8o\u000bbL7\u000f^3oiN#(/Z1n\u001d\u0006lW\rF\u0001)\u0011\u001d\t)\u000b\u0001C\u0005\u0003O\u000bqc^1ji\u001a{'o\u0015;sK\u0006lGk\u001c\"f\u0003\u000e$\u0018N^3\u0015\u0007-\u000bI\u000bC\u0004\u0002,\u0006\r\u0006\u0019\u0001\u0015\u0002'M$(/Z1n\u001d\u0006lW\rV8XC&$hi\u001c:\b\u0011\u0005=&\u0001#\u0001\u0003\u0003c\u000b\u0001cS5oKNL7\u000fV3tiV#\u0018\u000e\\:\u0011\u0007\r\n\u0019LB\u0004\u0002\u0005!\u0005!!!.\u0014\u0007\u0005MV\u0002C\u0004!\u0003g#\t!!/\u0015\u0005\u0005E\u0006BCA_\u0003g\u0013\r\u0011\"\u0001\u0002@\u0006QRM\u001c<WCJt\u0015-\\3G_J,e.\u00192mS:<G+Z:ugV\u0011\u0011\u0011\u0019\t\u0005\u0003\u0007\fI-\u0004\u0002\u0002F*!\u0011qYA9\u0003\u0011a\u0017M\\4\n\u0007E\n)\rC\u0005\u0002N\u0006M\u0006\u0015!\u0003\u0002B\u0006YRM\u001c<WCJt\u0015-\\3G_J,e.\u00192mS:<G+Z:ug\u0002B!\"!5\u00024\n\u0007I\u0011AA`\u0003U)g\u000e\u001a,be:\u000bW.\u001a$pe\u0016sG\r]8j]RD\u0011\"!6\u00024\u0002\u0006I!!1\u0002-\u0015tGMV1s\u001d\u0006lWMR8s\u000b:$\u0007o\\5oi\u0002B!\"!7\u00024\n\u0007I\u0011AA`\u0003I!WMZ1vYR,e\u000e\u001a9pS:$XK\u001d7\t\u0013\u0005u\u00171\u0017Q\u0001\n\u0005\u0005\u0017a\u00053fM\u0006,H\u000e^#oIB|\u0017N\u001c;Ve2\u0004\u0003\u0002CAq\u0003g#\t!a9\u0002/\u001d,GOU3hS>tg*Y7f\u0005f,e\u000e\u001a9pS:$Hc\u0001\u0015\u0002f\"9\u0011q]Ap\u0001\u0004A\u0013\u0001C3oIB|\u0017N\u001c;\t\u0015\u0005-\u00181\u0017EC\u0002\u0013\u0005A)\u0001\btQ>,H\u000e\u001a*v]R+7\u000f^:\t\u0013\u0019\n\u0019\f#b\u0001\n\u00039\u0003bBAy\u0003g#\t\u0001R\u0001\u0018SN\fukU\"sK\u0012,g\u000e^5bYN\u0004&/Z:f]RD\u0001\"!>\u00024\u0012\u0005\u0011q_\u0001\u0012O\u0016$\u0018iV*De\u0016$WM\u001c;jC2\u001cHCAA}!\u0011\tYP!\u0001\u000e\u0005\u0005u(bAA\u0000O\u0006!\u0011-\u001e;i\u0013\u0011\u0011\u0019!!@\u0003\u001d\u0005;6k\u0011:fI\u0016tG/[1mg\"Q!qAAZ#\u0003%\tA!\u0003\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00132+\t\u0011YAK\u0002\u001d\u0005\u001bY#Aa\u0004\u0011\t\tE!1D\u0007\u0003\u0005'QAA!\u0006\u0003\u0018\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u00053y\u0011AC1o]>$\u0018\r^5p]&!!Q\u0004B\n\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class KinesisTestUtils
implements Logging {
    private AmazonKinesisClient kinesisClient;
    private DynamoDB dynamoDB;
    private final int streamShardCount;
    private final String endpointUrl;
    private final String regionName;
    private final int createStreamTimeoutSeconds;
    private final int describeStreamPollTimeSeconds;
    private volatile boolean streamCreated;
    private volatile String _streamName;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;

    public static int $lessinit$greater$default$1() {
        return KinesisTestUtils$.MODULE$.$lessinit$greater$default$1();
    }

    public static AWSCredentials getAWSCredentials() {
        return KinesisTestUtils$.MODULE$.getAWSCredentials();
    }

    public static boolean isAWSCredentialsPresent() {
        return KinesisTestUtils$.MODULE$.isAWSCredentialsPresent();
    }

    public static boolean shouldRunTests() {
        return KinesisTestUtils$.MODULE$.shouldRunTests();
    }

    public static String getRegionNameByEndpoint(String string) {
        return KinesisTestUtils$.MODULE$.getRegionNameByEndpoint(string);
    }

    public static String defaultEndpointUrl() {
        return KinesisTestUtils$.MODULE$.defaultEndpointUrl();
    }

    public static String endVarNameForEndpoint() {
        return KinesisTestUtils$.MODULE$.endVarNameForEndpoint();
    }

    public static String envVarNameForEnablingTests() {
        return KinesisTestUtils$.MODULE$.envVarNameForEnablingTests();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String endpointUrl() {
        return this.endpointUrl;
    }

    public String regionName() {
        return this.regionName;
    }

    private int createStreamTimeoutSeconds() {
        return this.createStreamTimeoutSeconds;
    }

    private int describeStreamPollTimeSeconds() {
        return this.describeStreamPollTimeSeconds;
    }

    private boolean streamCreated() {
        return this.streamCreated;
    }

    private void streamCreated_$eq(boolean x$1) {
        this.streamCreated = x$1;
    }

    private String _streamName() {
        return this._streamName;
    }

    private void _streamName_$eq(String x$1) {
        this._streamName = x$1;
    }

    /*
     * WARNING - void declaration
     */
    private AmazonKinesisClient kinesisClient$lzycompute() {
        KinesisTestUtils kinesisTestUtils = this;
        synchronized (kinesisTestUtils) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                void var2_2;
                AmazonKinesisClient client = new AmazonKinesisClient(KinesisTestUtils$.MODULE$.getAWSCredentials());
                client.setEndpoint(this.endpointUrl());
                this.kinesisClient = var2_2;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.kinesisClient;
    }

    public AmazonKinesisClient kinesisClient() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.kinesisClient$lzycompute() : this.kinesisClient;
    }

    private DynamoDB dynamoDB$lzycompute() {
        KinesisTestUtils kinesisTestUtils = this;
        synchronized (kinesisTestUtils) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                AmazonDynamoDBClient dynamoDBClient = new AmazonDynamoDBClient((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain());
                dynamoDBClient.setRegion(RegionUtils.getRegion((String)this.regionName()));
                this.dynamoDB = new DynamoDB((AmazonDynamoDB)dynamoDBClient);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.dynamoDB;
    }

    private DynamoDB dynamoDB() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.dynamoDB$lzycompute() : this.dynamoDB;
    }

    public KinesisDataGenerator getProducer(boolean aggregate) {
        if (aggregate) {
            throw new UnsupportedOperationException("Aggregation is not supported through this code path");
        }
        return new SimpleDataGenerator(this.kinesisClient());
    }

    public String streamName() {
        Predef$.MODULE$.require(this.streamCreated(), (Function0 & Serializable & scala.Serializable)() -> "Stream not yet created, call createStream() to create one");
        return this._streamName();
    }

    public void createStream() {
        Predef$.MODULE$.require(!this.streamCreated(), (Function0 & Serializable & scala.Serializable)() -> "Stream already created");
        this._streamName_$eq(this.findNonExistentStreamName());
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append("Creating stream ").append(this._streamName()).toString());
        CreateStreamRequest createStreamRequest = new CreateStreamRequest();
        createStreamRequest.setStreamName(this._streamName());
        createStreamRequest.setShardCount(Predef$.MODULE$.int2Integer(this.streamShardCount));
        this.kinesisClient().createStream(createStreamRequest);
        this.waitForStreamToBeActive(this._streamName());
        this.streamCreated_$eq(true);
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(15).append("Created stream ").append(this._streamName()).toString());
    }

    public Seq<Shard> getShards() {
        return (Seq)JavaConverters$.MODULE$.asScalaBufferConverter(this.kinesisClient().describeStream(this._streamName()).getStreamDescription().getShards()).asScala();
    }

    public void splitShard(String shardId) {
        SplitShardRequest splitShardRequest = new SplitShardRequest();
        splitShardRequest.withStreamName(this._streamName());
        splitShardRequest.withShardToSplit(shardId);
        splitShardRequest.withNewStartingHashKey("170141183460469231731687303715884105728");
        this.kinesisClient().splitShard(splitShardRequest);
        this.waitForStreamToBeActive(this._streamName());
    }

    public void mergeShard(String shardToMerge, String adjacentShardToMerge) {
        MergeShardsRequest mergeShardRequest = new MergeShardsRequest();
        mergeShardRequest.withStreamName(this._streamName());
        mergeShardRequest.withShardToMerge(shardToMerge);
        mergeShardRequest.withAdjacentShardToMerge(adjacentShardToMerge);
        this.kinesisClient().mergeShards(mergeShardRequest);
        this.waitForStreamToBeActive(this._streamName());
    }

    public Map<String, Seq<Tuple2<Object, String>>> pushData(Seq<Object> testData, boolean aggregate) {
        Predef$.MODULE$.require(this.streamCreated(), (Function0 & Serializable & scala.Serializable)() -> "Stream not yet created, call createStream() to create one");
        KinesisDataGenerator producer = this.getProducer(aggregate);
        Map<String, Seq<Tuple2<Object, String>>> shardIdToSeqNumbers = producer.sendData(this.streamName(), testData);
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(11).append("Pushed ").append(testData).append(":\n\t ").append(shardIdToSeqNumbers.mkString("\n\t")).toString());
        return shardIdToSeqNumbers.toMap(Predef$.MODULE$.$conforms());
    }

    public void pushData(List<Object> testData) {
        this.pushData((Seq<Object>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(testData).asScala()), false);
    }

    public void deleteStream() {
        try {
            if (this.streamCreated()) {
                this.kinesisClient().deleteStream(this.streamName());
            }
        }
        catch (Exception e) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("Could not delete stream ").append(this.streamName()).toString());
        }
    }

    public void deleteDynamoDBTable(String tableName) {
        try {
            Table table = this.dynamoDB().getTable(tableName);
            table.delete();
            table.waitForDelete();
        }
        catch (Exception e) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Could not delete DynamoDB table ").append(tableName).toString());
        }
    }

    private Option<StreamDescription> describeStream(String streamNameToDescribe) {
        None$ none$;
        try {
            DescribeStreamRequest describeStreamRequest = new DescribeStreamRequest().withStreamName(streamNameToDescribe);
            StreamDescription desc = this.kinesisClient().describeStream(describeStreamRequest).getStreamDescription();
            none$ = new Some((Object)desc);
        }
        catch (ResourceNotFoundException rnfe) {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    /*
     * WARNING - void declaration
     */
    private String findNonExistentStreamName() {
        void var1_1;
        String testStreamName = null;
        do {
            Thread.sleep(TimeUnit.SECONDS.toMillis(this.describeStreamPollTimeSeconds()));
            testStreamName = new StringBuilder(17).append("KinesisTestUtils-").append(package$.MODULE$.abs(Random$.MODULE$.nextLong())).toString();
        } while (this.describeStream(testStreamName).nonEmpty());
        return var1_1;
    }

    private void waitForStreamToBeActive(String streamNameToWaitFor) {
        Object object = new Object();
        try {
            long startTime = System.currentTimeMillis();
            long endTime = startTime + TimeUnit.SECONDS.toMillis(this.createStreamTimeoutSeconds());
            while (System.currentTimeMillis() < endTime) {
                Thread.sleep(TimeUnit.SECONDS.toMillis(this.describeStreamPollTimeSeconds()));
                this.describeStream(streamNameToWaitFor).foreach((Function1 & Serializable & scala.Serializable)description -> {
                    KinesisTestUtils.$anonfun$waitForStreamToBeActive$1(this, object, description);
                    return BoxedUnit.UNIT;
                });
            }
            Predef$.MODULE$.require(false, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Stream ").append(this.streamName()).append(" never became active").toString());
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    public static final /* synthetic */ void $anonfun$waitForStreamToBeActive$1(KinesisTestUtils $this, Object nonLocalReturnKey1$1, StreamDescription description) {
        String streamStatus = description.getStreamStatus();
        $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("\t- current state: ").append(streamStatus).append("\n").toString());
        if ("ACTIVE".equals(streamStatus)) {
            throw new NonLocalReturnControl.mcV.sp(nonLocalReturnKey1$1, BoxedUnit.UNIT);
        }
    }

    public KinesisTestUtils(int streamShardCount) {
        this.streamShardCount = streamShardCount;
        Logging.$init$((Logging)this);
        this.endpointUrl = KinesisTestUtils$.MODULE$.endpointUrl();
        this.regionName = KinesisTestUtils$.MODULE$.getRegionNameByEndpoint(this.endpointUrl());
        this.createStreamTimeoutSeconds = 300;
        this.describeStreamPollTimeSeconds = 1;
        this.streamCreated = false;
    }
}

