/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.kinesis;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.services.kinesis.AmazonKinesisClient;
import com.amazonaws.services.kinesis.clientlibrary.types.UserRecord;
import com.amazonaws.services.kinesis.model.GetRecordsRequest;
import com.amazonaws.services.kinesis.model.GetRecordsResult;
import com.amazonaws.services.kinesis.model.GetShardIteratorRequest;
import com.amazonaws.services.kinesis.model.GetShardIteratorResult;
import com.amazonaws.services.kinesis.model.ProvisionedThroughputExceededException;
import com.amazonaws.services.kinesis.model.Record;
import com.amazonaws.services.kinesis.model.ShardIteratorType;
import java.io.Serializable;
import java.util.List;
import org.apache.spark.SparkException;
import org.apache.spark.internal.Logging;
import org.apache.spark.streaming.kinesis.KinesisReadConfigurations;
import org.apache.spark.streaming.kinesis.SequenceNumberRange;
import org.apache.spark.util.NextIterator;
import org.slf4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005\rf!B\u0001\u0003\u0001\ta!\u0001H&j]\u0016\u001c\u0018n]*fcV,gnY3SC:<W-\u0013;fe\u0006$xN\u001d\u0006\u0003\u0007\u0011\tqa[5oKNL7O\u0003\u0002\u0006\r\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sON\u0019\u0001!\u0004\u0011\u0011\u00079\t2#D\u0001\u0010\u0015\t\u0001b!\u0001\u0003vi&d\u0017B\u0001\n\u0010\u00051qU\r\u001f;Ji\u0016\u0014\u0018\r^8s!\t!b$D\u0001\u0016\u0015\t1r#A\u0003n_\u0012,GN\u0003\u0002\u00041)\u0011\u0011DG\u0001\tg\u0016\u0014h/[2fg*\u00111\u0004H\u0001\nC6\f'p\u001c8boNT\u0011!H\u0001\u0004G>l\u0017BA\u0010\u0016\u0005\u0019\u0011VmY8sIB\u0011\u0011\u0005J\u0007\u0002E)\u00111EB\u0001\tS:$XM\u001d8bY&\u0011QE\t\u0002\b\u0019><w-\u001b8h\u0011!9\u0003A!A!\u0002\u0013I\u0013aC2sK\u0012,g\u000e^5bYN\u001c\u0001\u0001\u0005\u0002+[5\t1F\u0003\u0002-5\u0005!\u0011-\u001e;i\u0013\tq3F\u0001\bB/N\u001b%/\u001a3f]RL\u0017\r\\:\t\u0011A\u0002!\u0011!Q\u0001\nE\n1\"\u001a8ea>Lg\u000e^+sYB\u0011!g\u000f\b\u0003ge\u0002\"\u0001N\u001c\u000e\u0003UR!A\u000e\u0015\u0002\rq\u0012xn\u001c;?\u0015\u0005A\u0014!B:dC2\f\u0017B\u0001\u001e8\u0003\u0019\u0001&/\u001a3fM&\u0011A(\u0010\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005i:\u0004\u0002C \u0001\u0005\u0003\u0005\u000b\u0011B\u0019\u0002\u0011I,w-[8o\u0013\u0012D\u0001\"\u0011\u0001\u0003\u0002\u0003\u0006IAQ\u0001\u0006e\u0006tw-\u001a\t\u0003\u0007\u0012k\u0011AA\u0005\u0003\u000b\n\u00111cU3rk\u0016t7-\u001a(v[\n,'OU1oO\u0016D\u0001b\u0012\u0001\u0003\u0002\u0003\u0006I\u0001S\u0001\u0013W&tWm]5t%\u0016\fGmQ8oM&<7\u000f\u0005\u0002D\u0013&\u0011!J\u0001\u0002\u001a\u0017&tWm]5t%\u0016\fGmQ8oM&<WO]1uS>t7\u000fC\u0003M\u0001\u0011\u0005Q*\u0001\u0004=S:LGO\u0010\u000b\u0007\u001d>\u0003\u0016KU*\u0011\u0005\r\u0003\u0001\"B\u0014L\u0001\u0004I\u0003\"\u0002\u0019L\u0001\u0004\t\u0004\"B L\u0001\u0004\t\u0004\"B!L\u0001\u0004\u0011\u0005\"B$L\u0001\u0004A\u0005bB+\u0001\u0005\u0004%IAV\u0001\u0007G2LWM\u001c;\u0016\u0003]\u0003\"\u0001W-\u000e\u0003]I!AW\f\u0003'\u0005k\u0017M_8o\u0017&tWm]5t\u00072LWM\u001c;\t\rq\u0003\u0001\u0015!\u0003X\u0003\u001d\u0019G.[3oi\u0002BqA\u0018\u0001C\u0002\u0013%q,\u0001\u0006tiJ,\u0017-\u001c(b[\u0016,\u0012!\r\u0005\u0007C\u0002\u0001\u000b\u0011B\u0019\u0002\u0017M$(/Z1n\u001d\u0006lW\r\t\u0005\bG\u0002\u0011\r\u0011\"\u0003`\u0003\u001d\u0019\b.\u0019:e\u0013\u0012Da!\u001a\u0001!\u0002\u0013\t\u0014\u0001C:iCJ$\u0017\n\u001a\u0011\t\u000f\u001d\u0004!\u0019!C\u0005Q\u0006\u0011R.\u0019=HKR\u0014VmY8sINd\u0015.\\5u+\u0005I\u0007C\u00016l\u001b\u00059\u0014B\u000178\u0005\rIe\u000e\u001e\u0005\u0007]\u0002\u0001\u000b\u0011B5\u0002'5\f\u0007pR3u%\u0016\u001cwN\u001d3t\u0019&l\u0017\u000e\u001e\u0011\t\u000fA\u0004\u0001\u0019!C\u0005c\u0006\u0019Bo\\*fc:+XNY3s%\u0016\u001cW-\u001b<fIV\t!\u000f\u0005\u0002kg&\u0011Ao\u000e\u0002\b\u0005>|G.Z1o\u0011\u001d1\b\u00011A\u0005\n]\fq\u0003^8TKFtU/\u001c2feJ+7-Z5wK\u0012|F%Z9\u0015\u0005a\\\bC\u00016z\u0013\tQxG\u0001\u0003V]&$\bb\u0002?v\u0003\u0003\u0005\rA]\u0001\u0004q\u0012\n\u0004B\u0002@\u0001A\u0003&!/\u0001\u000bu_N+\u0017OT;nE\u0016\u0014(+Z2fSZ,G\r\t\u0005\t\u0003\u0003\u0001\u0001\u0019!C\u0005?\u0006iA.Y:u'\u0016\fh*^7cKJD\u0011\"!\u0002\u0001\u0001\u0004%I!a\u0002\u0002#1\f7\u000f^*fc:+XNY3s?\u0012*\u0017\u000fF\u0002y\u0003\u0013A\u0001\u0002`A\u0002\u0003\u0003\u0005\r!\r\u0005\b\u0003\u001b\u0001\u0001\u0015)\u00032\u00039a\u0017m\u001d;TKFtU/\u001c2fe\u0002B\u0011\"!\u0005\u0001\u0001\u0004%I!a\u0005\u0002!%tG/\u001a:oC2LE/\u001a:bi>\u0014XCAA\u000b!\u0015\t9\"!\t\u0014\u001d\u0011\tI\"!\b\u000f\u0007Q\nY\"C\u00019\u0013\r\tybN\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\u0019#!\n\u0003\u0011%#XM]1u_JT1!a\b8\u0011%\tI\u0003\u0001a\u0001\n\u0013\tY#\u0001\u000bj]R,'O\\1m\u0013R,'/\u0019;pe~#S-\u001d\u000b\u0004q\u00065\u0002\"\u0003?\u0002(\u0005\u0005\t\u0019AA\u000b\u0011!\t\t\u0004\u0001Q!\n\u0005U\u0011!E5oi\u0016\u0014h.\u00197Ji\u0016\u0014\u0018\r^8sA!9\u0011Q\u0007\u0001\u0005R\u0005]\u0012aB4fi:+\u0007\u0010\u001e\u000b\u0002'!9\u00111\b\u0001\u0005R\u0005u\u0012!B2m_N,G#\u0001=\t\u000f\u0005\u0005\u0003\u0001\"\u0003\u0002D\u0005Qq-\u001a;SK\u000e|'\u000fZ:\u0015\u0011\u0005U\u0011QIA(\u0003'B\u0001\"a\u0012\u0002@\u0001\u0007\u0011\u0011J\u0001\rSR,'/\u0019;peRK\b/\u001a\t\u0004)\u0005-\u0013bAA'+\t\t2\u000b[1sI&#XM]1u_J$\u0016\u0010]3\t\u000f\u0005E\u0013q\ba\u0001c\u000511/Z9Ok6Dq!!\u0016\u0002@\u0001\u0007\u0011.A\u0006sK\u000e|'\u000fZ\"pk:$\bbBA-\u0001\u0011%\u00111L\u0001!O\u0016$(+Z2pe\u0012\u001c\u0018I\u001c3OKb$8*\u001b8fg&\u001c\u0018\n^3sCR|'\u000f\u0006\u0004\u0002^\u0005\r\u0014q\r\t\u0007U\u0006}\u0013QC\u0019\n\u0007\u0005\u0005tG\u0001\u0004UkBdWM\r\u0005\b\u0003K\n9\u00061\u00012\u00035\u0019\b.\u0019:e\u0013R,'/\u0019;pe\"9\u0011QKA,\u0001\u0004I\u0007bBA6\u0001\u0011%\u0011QN\u0001\u0013O\u0016$8*\u001b8fg&\u001c\u0018\n^3sCR|'\u000fF\u00032\u0003_\n\t\b\u0003\u0005\u0002H\u0005%\u0004\u0019AA%\u0011\u001d\t\u0019(!\u001bA\u0002E\nab]3rk\u0016t7-\u001a(v[\n,'\u000fC\u0004\u0002x\u0001!I!!\u001f\u0002\u001dI,GO]=PeRKW.Z8viV!\u00111PAB)\u0011\ti(a(\u0015\t\u0005}\u0014Q\u0013\t\u0005\u0003\u0003\u000b\u0019\t\u0004\u0001\u0005\u0011\u0005\u0015\u0015Q\u000fb\u0001\u0003\u000f\u0013\u0011\u0001V\t\u0005\u0003\u0013\u000by\tE\u0002k\u0003\u0017K1!!$8\u0005\u001dqu\u000e\u001e5j]\u001e\u00042A[AI\u0013\r\t\u0019j\u000e\u0002\u0004\u0003:L\b\"CAL\u0003k\"\t\u0019AAM\u0003\u0011\u0011w\u000eZ=\u0011\u000b)\fY*a \n\u0007\u0005uuG\u0001\u0005=Eft\u0017-\\3?\u0011\u001d\t\t+!\u001eA\u0002E\nq!\\3tg\u0006<W\r")
public class KinesisSequenceRangeIterator
extends NextIterator<Record>
implements Logging {
    private final AWSCredentials credentials;
    private final SequenceNumberRange range;
    private final KinesisReadConfigurations kinesisReadConfigs;
    private final AmazonKinesisClient client;
    private final String streamName;
    private final String shardId;
    private final int maxGetRecordsLimit;
    private boolean toSeqNumberReceived;
    private String lastSeqNumber;
    private Iterator<Record> internalIterator;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private AmazonKinesisClient client() {
        return this.client;
    }

    private String streamName() {
        return this.streamName;
    }

    private String shardId() {
        return this.shardId;
    }

    private int maxGetRecordsLimit() {
        return this.maxGetRecordsLimit;
    }

    private boolean toSeqNumberReceived() {
        return this.toSeqNumberReceived;
    }

    private void toSeqNumberReceived_$eq(boolean x$1) {
        this.toSeqNumberReceived = x$1;
    }

    private String lastSeqNumber() {
        return this.lastSeqNumber;
    }

    private void lastSeqNumber_$eq(String x$1) {
        this.lastSeqNumber = x$1;
    }

    private Iterator<Record> internalIterator() {
        return this.internalIterator;
    }

    private void internalIterator_$eq(Iterator<Record> x$1) {
        this.internalIterator = x$1;
    }

    /*
     * WARNING - void declaration
     */
    public Record getNext() {
        void var1_1;
        block5: {
            Record nextRecord;
            block4: {
                nextRecord = null;
                if (!this.toSeqNumberReceived()) break block4;
                this.finished_$eq(true);
                break block5;
            }
            if (this.internalIterator() == null) {
                this.internalIterator_$eq(this.getRecords(ShardIteratorType.AT_SEQUENCE_NUMBER, this.range.fromSeqNumber(), this.range.recordCount()));
            } else if (!this.internalIterator().hasNext()) {
                this.internalIterator_$eq(this.getRecords(ShardIteratorType.AFTER_SEQUENCE_NUMBER, this.lastSeqNumber(), this.range.recordCount()));
            }
            if (!this.internalIterator().hasNext()) {
                this.finished_$eq(true);
                throw new SparkException(new StringBuilder(59).append("Could not read until the end sequence number of the range: ").append(this.range).toString());
            }
            nextRecord = (Record)this.internalIterator().next();
            this.lastSeqNumber_$eq(nextRecord.getSequenceNumber());
            String string = nextRecord.getSequenceNumber();
            String string2 = this.range.toSeqNumber();
            if (string != null ? !string.equals(string2) : string2 != null) break block5;
            this.toSeqNumberReceived_$eq(true);
        }
        return var1_1;
    }

    public void close() {
        this.client().shutdown();
    }

    private Iterator<Record> getRecords(ShardIteratorType iteratorType, String seqNum, int recordCount) {
        String shardIterator = this.getKinesisIterator(iteratorType, seqNum);
        Tuple2<Iterator<Record>, String> result = this.getRecordsAndNextKinesisIterator(shardIterator, recordCount);
        return (Iterator)result._1();
    }

    private Tuple2<Iterator<Record>, String> getRecordsAndNextKinesisIterator(String shardIterator, int recordCount) {
        GetRecordsRequest getRecordsRequest = new GetRecordsRequest();
        getRecordsRequest.setRequestCredentials(this.credentials);
        getRecordsRequest.setShardIterator(shardIterator);
        getRecordsRequest.setLimit(Predef$.MODULE$.int2Integer(Math.min(recordCount, this.maxGetRecordsLimit())));
        GetRecordsResult getRecordsResult = (GetRecordsResult)this.retryOrTimeout("getting records using shard iterator", (Function0 & Serializable & scala.Serializable)() -> this.client().getRecords(getRecordsRequest));
        List recordIterator = UserRecord.deaggregate((List)getRecordsResult.getRecords());
        return new Tuple2(JavaConverters$.MODULE$.asScalaIteratorConverter(recordIterator.iterator()).asScala(), (Object)getRecordsResult.getNextShardIterator());
    }

    private String getKinesisIterator(ShardIteratorType iteratorType, String sequenceNumber) {
        GetShardIteratorRequest getShardIteratorRequest = new GetShardIteratorRequest();
        getShardIteratorRequest.setRequestCredentials(this.credentials);
        getShardIteratorRequest.setStreamName(this.streamName());
        getShardIteratorRequest.setShardId(this.shardId());
        getShardIteratorRequest.setShardIteratorType(iteratorType.toString());
        getShardIteratorRequest.setStartingSequenceNumber(sequenceNumber);
        GetShardIteratorResult getShardIteratorResult = (GetShardIteratorResult)this.retryOrTimeout(new StringBuilder(44).append("getting shard iterator from sequence number ").append(sequenceNumber).toString(), (Function0 & Serializable & scala.Serializable)() -> this.client().getShardIterator(getShardIteratorRequest));
        return getShardIteratorResult.getShardIterator();
    }

    private <T> T retryOrTimeout(String message, Function0<T> body) {
        long startTimeMs = System.currentTimeMillis();
        IntRef retryCount = IntRef.create((int)0);
        None$ result = None$.MODULE$;
        ObjectRef lastError = ObjectRef.create(null);
        long waitTimeInterval = this.kinesisReadConfigs.retryWaitTimeMs();
        while (result.isEmpty() && !this.isTimedOut$1(startTimeMs) && !this.isMaxRetryDone$1(retryCount)) {
            if (retryCount.elem > 0) {
                Thread.sleep(waitTimeInterval);
                waitTimeInterval *= 2L;
            }
            try {
                result = new Some(body.apply());
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable t = (Throwable)option.get();
                    lastError.elem = t;
                    Throwable throwable3 = t;
                    if (!(throwable3 instanceof ProvisionedThroughputExceededException)) {
                        if (throwable3 != null) {
                            Throwable throwable4 = throwable3;
                            throw new SparkException(new StringBuilder(12).append("Error while ").append(message).toString(), throwable4);
                        }
                        throw new MatchError((Object)throwable3);
                    }
                    ProvisionedThroughputExceededException provisionedThroughputExceededException = (ProvisionedThroughputExceededException)throwable3;
                    this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("Error while ").append(message).append(" [attempt = ").append(retryCount$1.elem + 1).append("]").toString(), (Throwable)provisionedThroughputExceededException);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                }
                throw throwable;
            }
            ++retryCount.elem;
        }
        return (T)result.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            if (this.isTimedOut$1(startTimeMs)) {
                throw new SparkException(new StringBuilder(26).append("Timed out after ").append($this.kinesisReadConfigs.retryTimeoutMs()).append(" ms while ").append(new StringBuilder(18).append(message).append(", last exception: ").toString()).toString(), (Throwable)lastError$1.elem);
            }
            throw new SparkException(new StringBuilder(47).append("Gave up after ").append(retryCount$1.elem).append(" retries while ").append(message).append(", last exception: ").toString(), (Throwable)lastError$1.elem);
        });
    }

    private final boolean isTimedOut$1(long startTimeMs$1) {
        return System.currentTimeMillis() - startTimeMs$1 >= this.kinesisReadConfigs.retryTimeoutMs();
    }

    private final boolean isMaxRetryDone$1(IntRef retryCount$1) {
        return retryCount$1.elem >= this.kinesisReadConfigs.maxRetries();
    }

    public KinesisSequenceRangeIterator(AWSCredentials credentials, String endpointUrl, String regionId, SequenceNumberRange range, KinesisReadConfigurations kinesisReadConfigs) {
        this.credentials = credentials;
        this.range = range;
        this.kinesisReadConfigs = kinesisReadConfigs;
        Logging.$init$((Logging)this);
        this.client = new AmazonKinesisClient(credentials);
        this.streamName = range.streamName();
        this.shardId = range.shardId();
        this.maxGetRecordsLimit = 10000;
        this.toSeqNumberReceived = false;
        this.lastSeqNumber = null;
        this.internalIterator = null;
        this.client().setEndpoint(endpointUrl);
    }
}

