/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.kinesis;

import com.amazonaws.services.kinesis.clientlibrary.interfaces.IRecordProcessor;
import com.amazonaws.services.kinesis.clientlibrary.interfaces.IRecordProcessorCheckpointer;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.ShutdownReason;
import com.amazonaws.services.kinesis.model.Record;
import java.io.Serializable;
import java.util.List;
import org.apache.spark.internal.Logging;
import org.apache.spark.streaming.kinesis.KinesisReceiver;
import org.apache.spark.streaming.kinesis.KinesisRecordProcessor$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005}c!B\u0001\u0003\u0001\ta!AF&j]\u0016\u001c\u0018n\u001d*fG>\u0014H\r\u0015:pG\u0016\u001c8o\u001c:\u000b\u0005\r!\u0011aB6j]\u0016\u001c\u0018n\u001d\u0006\u0003\u000b\u0019\t\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e,\"!\u0004\u001b\u0014\t\u0001qa#\n\t\u0003\u001fQi\u0011\u0001\u0005\u0006\u0003#I\tA\u0001\\1oO*\t1#\u0001\u0003kCZ\f\u0017BA\u000b\u0011\u0005\u0019y%M[3diB\u0011qcI\u0007\u00021)\u0011\u0011DG\u0001\u000bS:$XM\u001d4bG\u0016\u001c(BA\u000e\u001d\u00035\u0019G.[3oi2L'M]1ss*\u00111!\b\u0006\u0003=}\t\u0001b]3sm&\u001cWm\u001d\u0006\u0003A\u0005\n\u0011\"Y7bu>t\u0017m^:\u000b\u0003\t\n1aY8n\u0013\t!\u0003D\u0001\tJ%\u0016\u001cwN\u001d3Qe>\u001cWm]:peB\u0011a%K\u0007\u0002O)\u0011\u0001FB\u0001\tS:$XM\u001d8bY&\u0011!f\n\u0002\b\u0019><w-\u001b8h\u0011!a\u0003A!A!\u0002\u0013q\u0013\u0001\u0003:fG\u0016Lg/\u001a:\u0004\u0001A\u0019q\u0006\r\u001a\u000e\u0003\tI!!\r\u0002\u0003\u001f-Kg.Z:jgJ+7-Z5wKJ\u0004\"a\r\u001b\r\u0001\u0011)Q\u0007\u0001b\u0001m\t\tA+\u0005\u00028{A\u0011\u0001hO\u0007\u0002s)\t!(A\u0003tG\u0006d\u0017-\u0003\u0002=s\t9aj\u001c;iS:<\u0007C\u0001\u001d?\u0013\ty\u0014HA\u0002B]fD\u0001\"\u0011\u0001\u0003\u0002\u0003\u0006IAQ\u0001\to>\u00148.\u001a:JIB\u00111I\u0013\b\u0003\t\"\u0003\"!R\u001d\u000e\u0003\u0019S!aR\u0017\u0002\rq\u0012xn\u001c;?\u0013\tI\u0015(\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u00172\u0013aa\u0015;sS:<'BA%:\u0011\u0015q\u0005\u0001\"\u0001P\u0003\u0019a\u0014N\\5u}Q\u0019\u0001+\u0015*\u0011\u0007=\u0002!\u0007C\u0003-\u001b\u0002\u0007a\u0006C\u0003B\u001b\u0002\u0007!\tC\u0005U\u0001\u0001\u0007\t\u0019!C\u0005+\u000691\u000f[1sI&#W#\u0001\"\t\u0013]\u0003\u0001\u0019!a\u0001\n\u0013A\u0016aC:iCJ$\u0017\nZ0%KF$\"!\u0017/\u0011\u0005aR\u0016BA.:\u0005\u0011)f.\u001b;\t\u000fu3\u0016\u0011!a\u0001\u0005\u0006\u0019\u0001\u0010J\u0019\t\u0013}\u0003\u0001\u0019!A!B\u0013\u0011\u0015\u0001C:iCJ$\u0017\n\u001a\u0011)\u0005y\u000b\u0007C\u0001\u001dc\u0013\t\u0019\u0017H\u0001\u0005w_2\fG/\u001b7f\u0011\u0015)\u0007\u0001\"\u0011g\u0003)Ig.\u001b;jC2L'0\u001a\u000b\u00033\u001eDQ\u0001\u00163A\u0002\tCQ!\u001b\u0001\u0005B)\fa\u0002\u001d:pG\u0016\u001c8OU3d_J$7\u000fF\u0002ZWfDQ\u0001\u001c5A\u00025\fQAY1uG\"\u00042A\\9t\u001b\u0005y'B\u00019\u0013\u0003\u0011)H/\u001b7\n\u0005I|'\u0001\u0002'jgR\u0004\"\u0001^<\u000e\u0003UT!A\u001e\u000f\u0002\u000b5|G-\u001a7\n\u0005a,(A\u0002*fG>\u0014H\rC\u0003{Q\u0002\u000710\u0001\u0007dQ\u0016\u001c7\u000e]8j]R,'\u000f\u0005\u0002\u0018y&\u0011Q\u0010\u0007\u0002\u001d\u0013J+7m\u001c:e!J|7-Z:t_J\u001c\u0005.Z2la>Lg\u000e^3s\u0011\u0019y\b\u0001\"\u0011\u0002\u0002\u0005A1\u000f[;uI><h\u000eF\u0003Z\u0003\u0007\t)\u0001C\u0003{}\u0002\u00071\u0010C\u0004\u0002\by\u0004\r!!\u0003\u0002\rI,\u0017m]8o!\u0011\tY!!\u0006\u000e\u0005\u00055!\u0002BA\b\u0003#\taa^8sW\u0016\u0014(bAA\n5\u0005\u0019A.\u001b2\n\t\u0005]\u0011Q\u0002\u0002\u000f'\",H\u000fZ8x]J+\u0017m]8o\u000f!\tYB\u0001E\u0001\u0005\u0005u\u0011AF&j]\u0016\u001c\u0018n\u001d*fG>\u0014H\r\u0015:pG\u0016\u001c8o\u001c:\u0011\u0007=\nyBB\u0004\u0002\u0005!\u0005!!!\t\u0014\u000b\u0005}\u00111E\u0013\u0011\u0007a\n)#C\u0002\u0002(e\u0012a!\u00118z%\u00164\u0007b\u0002(\u0002 \u0011\u0005\u00111\u0006\u000b\u0003\u0003;A\u0001\"a\f\u0002 \u0011\u0005\u0011\u0011G\u0001\fe\u0016$(/\u001f*b]\u0012|W.\u0006\u0003\u00024\u0005]B\u0003CA\u001b\u0003s\t\u0019%!\u0014\u0011\u0007M\n9\u0004\u0002\u00046\u0003[\u0011\rA\u000e\u0005\n\u0003w\ti\u0003\"a\u0001\u0003{\t!\"\u001a=qe\u0016\u001c8/[8o!\u0015A\u0014qHA\u001b\u0013\r\t\t%\u000f\u0002\ty\tLh.Y7f}!A\u0011QIA\u0017\u0001\u0004\t9%\u0001\bok6\u0014V\r\u001e:jKNdUM\u001a;\u0011\u0007a\nI%C\u0002\u0002Le\u00121!\u00138u\u0011!\ty%!\fA\u0002\u0005\u001d\u0013\u0001E7bq\n\u000b7m[(gM6KG\u000e\\5tQ\u0011\ti#a\u0015\u0011\t\u0005U\u00131L\u0007\u0003\u0003/R1!!\u0017:\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003;\n9FA\u0004uC&d'/Z2")
public class KinesisRecordProcessor<T>
implements IRecordProcessor,
Logging {
    private final KinesisReceiver<T> receiver;
    private final String workerId;
    private volatile String shardId;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static <T> T retryRandom(Function0<T> function0, int n, int n2) {
        return KinesisRecordProcessor$.MODULE$.retryRandom(function0, n, n2);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private String shardId() {
        return this.shardId;
    }

    private void shardId_$eq(String x$1) {
        this.shardId = x$1;
    }

    public void initialize(String shardId) {
        this.shardId_$eq(shardId);
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Initialized workerId ").append($this.workerId).append(" with shardId ").append(shardId).toString());
    }

    public void processRecords(List<Record> batch, IRecordProcessorCheckpointer checkpointer) {
        if (!this.receiver.isStopped()) {
            try {
                int maxRecords = this.receiver.getCurrentLimit();
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), batch.size()).by(maxRecords).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)start -> {
                    List<Record> miniBatch = batch.subList(start, package$.MODULE$.min(start + maxRecords, batch.size()));
                    $this.receiver.addRecords(this.shardId(), miniBatch);
                    this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Stored: Worker ").append($this.workerId).append(" stored ").append(miniBatch.size()).append(" records ").append(new StringBuilder(12).append("for shardId ").append(this.shardId()).toString()).toString());
                });
                this.receiver.setCheckpointer(this.shardId(), checkpointer);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(62).append("Exception:  WorkerId ").append($this.workerId).append(" encountered and exception while storing ").append(new StringBuilder(53).append(" or checkpointing a batch for workerId ").append($this.workerId).append(" and shardId ").append(this.shardId()).append(".").toString()).toString(), e);
                    throw e;
                }
                throw throwable;
            }
        } else {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Stopped:  KinesisReceiver has stopped for workerId ").append($this.workerId).append(new StringBuilder(50).append(" and shardId ").append(this.shardId()).append(".  No more records will be processed.").toString()).toString());
        }
    }

    public void shutdown(IRecordProcessorCheckpointer checkpointer, ShutdownReason reason) {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Shutdown:  Shutting down workerId ").append($this.workerId).append(" with reason ").append(reason).toString());
        if (this.shardId() == null) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("No shardId for workerId ").append($this.workerId).append("?").toString());
        } else {
            ShutdownReason shutdownReason = reason;
            if (ShutdownReason.TERMINATE.equals(shutdownReason)) {
                this.receiver.removeCheckpointer(this.shardId(), checkpointer);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                this.receiver.removeCheckpointer(this.shardId(), null);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    public KinesisRecordProcessor(KinesisReceiver<T> receiver, String workerId) {
        this.receiver = receiver;
        this.workerId = workerId;
        Logging.$init$((Logging)this);
    }
}

