/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.kinesis;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.kinesis.clientlibrary.interfaces.IRecordProcessor;
import com.amazonaws.services.kinesis.clientlibrary.interfaces.IRecordProcessorCheckpointer;
import com.amazonaws.services.kinesis.clientlibrary.interfaces.IRecordProcessorFactory;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.KinesisClientLibConfiguration;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.Worker;
import com.amazonaws.services.kinesis.model.Record;
import java.io.Serializable;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.spark.internal.Logging;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StreamBlockId;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.kinesis.KinesisCheckpointer;
import org.apache.spark.streaming.kinesis.KinesisCheckpointer$;
import org.apache.spark.streaming.kinesis.KinesisInitialPosition;
import org.apache.spark.streaming.kinesis.KinesisInitialPositions;
import org.apache.spark.streaming.kinesis.KinesisRecordProcessor;
import org.apache.spark.streaming.kinesis.SequenceNumberRange;
import org.apache.spark.streaming.kinesis.SequenceNumberRanges;
import org.apache.spark.streaming.kinesis.SparkAWSCredentials;
import org.apache.spark.streaming.receiver.BlockGenerator;
import org.apache.spark.streaming.receiver.BlockGeneratorListener;
import org.apache.spark.streaming.receiver.Receiver;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\tEg!B\u0001\u0003\u0001\ta!aD&j]\u0016\u001c\u0018n\u001d*fG\u0016Lg/\u001a:\u000b\u0005\r!\u0011aB6j]\u0016\u001c\u0018n\u001d\u0006\u0003\u000b\u0019\t\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e,\"!\u0004\f\u0014\u0007\u0001q1\u0005E\u0002\u0010%Qi\u0011\u0001\u0005\u0006\u0003#\u0011\t\u0001B]3dK&4XM]\u0005\u0003'A\u0011\u0001BU3dK&4XM\u001d\t\u0003+Ya\u0001\u0001B\u0003\u0018\u0001\t\u0007\u0011DA\u0001U\u0007\u0001\t\"A\u0007\u0011\u0011\u0005mqR\"\u0001\u000f\u000b\u0003u\tQa]2bY\u0006L!a\b\u000f\u0003\u000f9{G\u000f[5oOB\u00111$I\u0005\u0003Eq\u00111!\u00118z!\t!s%D\u0001&\u0015\t1c!\u0001\u0005j]R,'O\\1m\u0013\tASEA\u0004M_\u001e<\u0017N\\4\t\u0011)\u0002!Q1A\u0005\u0002-\n!b\u001d;sK\u0006lg*Y7f+\u0005a\u0003CA\u00175\u001d\tq#\u0007\u0005\u0002095\t\u0001G\u0003\u000221\u00051AH]8pizJ!a\r\u000f\u0002\rA\u0013X\rZ3g\u0013\t)dG\u0001\u0004TiJLgn\u001a\u0006\u0003gqA\u0001\u0002\u000f\u0001\u0003\u0002\u0003\u0006I\u0001L\u0001\fgR\u0014X-Y7OC6,\u0007\u0005\u0003\u0005;\u0001\t\u0005\t\u0015!\u0003-\u0003-)g\u000e\u001a9pS:$XK\u001d7\t\u0011q\u0002!\u0011!Q\u0001\n1\n!B]3hS>tg*Y7f\u0011!q\u0004A!A!\u0002\u0013y\u0014aD5oSRL\u0017\r\u001c)pg&$\u0018n\u001c8\u0011\u0005\u0001\u000bU\"\u0001\u0002\n\u0005\t\u0013!AF&j]\u0016\u001c\u0018n]%oSRL\u0017\r\u001c)pg&$\u0018n\u001c8\t\u0011\u0011\u0003!\u0011!Q\u0001\n1\n\u0011c\u00195fG.\u0004x.\u001b8u\u0003B\u0004h*Y7f\u0011!1\u0005A!A!\u0002\u00139\u0015AE2iK\u000e\\\u0007o\\5oi&sG/\u001a:wC2\u0004\"\u0001S%\u000e\u0003\u0011I!A\u0013\u0003\u0003\u0011\u0011+(/\u0019;j_:D\u0011\u0002\u0014\u0001\u0003\u0002\u0003\u0006I!T*\u0002\u0019M$xN]1hK2+g/\u001a7\u0011\u00059\u000bV\"A(\u000b\u0005A3\u0011aB:u_J\fw-Z\u0005\u0003%>\u0013Ab\u0015;pe\u0006<W\rT3wK2L!\u0001\u0014\n\t\u0011U\u0003!\u0011!Q\u0001\nY\u000ba\"\\3tg\u0006<W\rS1oI2,'\u000f\u0005\u0003\u001c/f#\u0012B\u0001-\u001d\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0002[I6\t1L\u0003\u0002];\u0006)Qn\u001c3fY*\u00111A\u0018\u0006\u0003?\u0002\f\u0001b]3sm&\u001cWm\u001d\u0006\u0003C\n\f\u0011\"Y7bu>t\u0017m^:\u000b\u0003\r\f1aY8n\u0013\t)7L\u0001\u0004SK\u000e|'\u000f\u001a\u0005\tO\u0002\u0011\t\u0011)A\u0005Q\u0006a1.\u001b8fg&\u001c8I]3egB\u0011\u0001)[\u0005\u0003U\n\u00111c\u00159be.\fukU\"sK\u0012,g\u000e^5bYND\u0001\u0002\u001c\u0001\u0003\u0002\u0003\u0006I!\\\u0001\u000eIft\u0017-\\8E\u0005\u000e\u0013X\rZ:\u0011\u0007mq\u0007.\u0003\u0002p9\t1q\n\u001d;j_:D\u0001\"\u001d\u0001\u0003\u0002\u0003\u0006I!\\\u0001\u0010G2|W\u000fZ,bi\u000eD7I]3eg\")1\u000f\u0001C\u0001i\u00061A(\u001b8jiz\"R\"\u001e<xqfT8\u0010`?\u007f\u007f\u0006\u0005\u0001c\u0001!\u0001)!)!F\u001da\u0001Y!)!H\u001da\u0001Y!)AH\u001da\u0001Y!)aH\u001da\u0001\u007f!)AI\u001da\u0001Y!)aI\u001da\u0001\u000f\")AJ\u001da\u0001\u001b\")QK\u001da\u0001-\")qM\u001da\u0001Q\")AN\u001da\u0001[\")\u0011O\u001da\u0001[\"A\u0011Q\u0001\u0001A\u0002\u0013%1&\u0001\u0005x_J\\WM]%e\u0011%\tI\u0001\u0001a\u0001\n\u0013\tY!\u0001\u0007x_J\\WM]%e?\u0012*\u0017\u000f\u0006\u0003\u0002\u000e\u0005M\u0001cA\u000e\u0002\u0010%\u0019\u0011\u0011\u0003\u000f\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003+\t9!!AA\u00021\n1\u0001\u001f\u00132\u0011\u001d\tI\u0002\u0001Q!\n1\n\u0011b^8sW\u0016\u0014\u0018\n\u001a\u0011)\t\u0005]\u0011Q\u0004\t\u00047\u0005}\u0011bAA\u00119\tAao\u001c7bi&dW\rC\u0005\u0002&\u0001\u0001\r\u0011\"\u0003\u0002(\u00051qo\u001c:lKJ,\"!!\u000b\u0011\t\u0005-\u0012qG\u0007\u0003\u0003[QA!!\n\u00020)!\u0011\u0011GA\u001a\u0003\ra\u0017N\u0019\u0006\u0004\u0003ki\u0016!D2mS\u0016tG\u000f\\5ce\u0006\u0014\u00180\u0003\u0003\u0002:\u00055\"AB,pe.,'\u000fC\u0005\u0002>\u0001\u0001\r\u0011\"\u0003\u0002@\u0005Qqo\u001c:lKJ|F%Z9\u0015\t\u00055\u0011\u0011\t\u0005\u000b\u0003+\tY$!AA\u0002\u0005%\u0002\u0002CA#\u0001\u0001\u0006K!!\u000b\u0002\u000f]|'o[3sA!\"\u00111IA\u000f\u0011%\tY\u0005\u0001a\u0001\n\u0013\ti%\u0001\u0007x_J\\WM\u001d+ie\u0016\fG-\u0006\u0002\u0002PA!\u0011\u0011KA.\u001b\t\t\u0019F\u0003\u0003\u0002V\u0005]\u0013\u0001\u00027b]\u001eT!!!\u0017\u0002\t)\fg/Y\u0005\u0005\u0003;\n\u0019F\u0001\u0004UQJ,\u0017\r\u001a\u0005\n\u0003C\u0002\u0001\u0019!C\u0005\u0003G\n\u0001c^8sW\u0016\u0014H\u000b\u001b:fC\u0012|F%Z9\u0015\t\u00055\u0011Q\r\u0005\u000b\u0003+\ty&!AA\u0002\u0005=\u0003\u0002CA5\u0001\u0001\u0006K!a\u0014\u0002\u001b]|'o[3s)\"\u0014X-\u00193!Q\u0011\t9'!\b\t\u0013\u0005=\u0004\u00011A\u0005\n\u0005E\u0014A\u00042m_\u000e\\w)\u001a8fe\u0006$xN]\u000b\u0003\u0003g\u00022aDA;\u0013\r\t9\b\u0005\u0002\u000f\u00052|7m[$f]\u0016\u0014\u0018\r^8s\u0011%\tY\b\u0001a\u0001\n\u0013\ti(\u0001\ncY>\u001c7nR3oKJ\fGo\u001c:`I\u0015\fH\u0003BA\u0007\u0003\u007fB!\"!\u0006\u0002z\u0005\u0005\t\u0019AA:\u0011!\t\u0019\t\u0001Q!\n\u0005M\u0014a\u00042m_\u000e\\w)\u001a8fe\u0006$xN\u001d\u0011)\t\u0005\u0005\u0015Q\u0004\u0005\n\u0003\u0013\u0003!\u0019!C\u0005\u0003\u0017\u000b!d]3r\u001dVl'+\u00198hKNLenQ;se\u0016tGO\u00117pG.,\"!!$\u0011\r\u0005=\u0015\u0011TAO\u001b\t\t\tJ\u0003\u0003\u0002\u0014\u0006U\u0015aB7vi\u0006\u0014G.\u001a\u0006\u0004\u0003/c\u0012AC2pY2,7\r^5p]&!\u00111TAI\u0005-\t%O]1z\u0005V4g-\u001a:\u0011\u0007\u0001\u000by*C\u0002\u0002\"\n\u00111cU3rk\u0016t7-\u001a(v[\n,'OU1oO\u0016D\u0001\"!*\u0001A\u0003%\u0011QR\u0001\u001cg\u0016\fh*^7SC:<Wm]%o\u0007V\u0014(/\u001a8u\u00052|7m\u001b\u0011\t\u0013\u0005%\u0006A1A\u0005\n\u0005-\u0016!\u00062m_\u000e\\\u0017\n\u001a+p'\u0016\fh*^7SC:<Wm]\u000b\u0003\u0003[\u0003\u0002\"a,\u0002:\u0006u\u00161Y\u0007\u0003\u0003cSA!a-\u00026\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\t\u0005]\u0016qK\u0001\u0005kRLG.\u0003\u0003\u0002<\u0006E&!E\"p]\u000e,(O]3oi\"\u000b7\u000f['baB\u0019a*a0\n\u0007\u0005\u0005wJA\u0007TiJ,\u0017-\u001c\"m_\u000e\\\u0017\n\u001a\t\u0004\u0001\u0006\u0015\u0017bAAd\u0005\t!2+Z9vK:\u001cWMT;nE\u0016\u0014(+\u00198hKND\u0001\"a3\u0001A\u0003%\u0011QV\u0001\u0017E2|7m[%e)>\u001cV-\u001d(v[J\u000bgnZ3tA!I\u0011q\u001a\u0001A\u0002\u0013%\u0011\u0011[\u0001\u0014W&tWm]5t\u0007\",7m\u001b9pS:$XM]\u000b\u0003\u0003'\u00042\u0001QAk\u0013\r\t9N\u0001\u0002\u0014\u0017&tWm]5t\u0007\",7m\u001b9pS:$XM\u001d\u0005\n\u00037\u0004\u0001\u0019!C\u0005\u0003;\fqc[5oKNL7o\u00115fG.\u0004x.\u001b8uKJ|F%Z9\u0015\t\u00055\u0011q\u001c\u0005\u000b\u0003+\tI.!AA\u0002\u0005M\u0007\u0002CAr\u0001\u0001\u0006K!a5\u0002)-Lg.Z:jg\u000eCWmY6q_&tG/\u001a:!Q\u0011\t\t/!\b\t\u0013\u0005%\bA1A\u0005\n\u0005-\u0018aG:iCJ$\u0017\n\u001a+p\u0019\u0006$Xm\u001d;Ti>\u0014X\rZ*fc:+X.\u0006\u0002\u0002nB1\u0011qVA]Y1B\u0001\"!=\u0001A\u0003%\u0011Q^\u0001\u001dg\"\f'\u000fZ%e)>d\u0015\r^3tiN#xN]3e'\u0016\fh*^7!\u0011\u001d\t)\u0010\u0001C!\u0003o\fqa\u001c8Ti\u0006\u0014H\u000f\u0006\u0002\u0002\u000e!9\u00111 \u0001\u0005B\u0005]\u0018AB8o'R|\u0007\u000f\u0003\u0005\u0002\u0000\u0002!\tA\u0001B\u0001\u0003)\tG\r\u001a*fG>\u0014Hm\u001d\u000b\u0007\u0003\u001b\u0011\u0019Aa\u0002\t\u000f\t\u0015\u0011Q a\u0001Y\u000591\u000f[1sI&#\u0007\u0002\u0003B\u0005\u0003{\u0004\rAa\u0003\u0002\u000fI,7m\u001c:egB)!Q\u0002B\b36\u0011\u0011QW\u0005\u0005\u0005#\t)L\u0001\u0003MSN$\b\u0002\u0003B\u000b\u0001\u0011\u0005!Aa\u0006\u0002\u001f\u001d,GoQ;se\u0016tG\u000fT5nSR,\"A!\u0007\u0011\u0007m\u0011Y\"C\u0002\u0003\u001eq\u00111!\u00138u\u0011!\u0011\t\u0003\u0001C\u0001\u0005\t\r\u0012aG4fi2\u000bG/Z:u'\u0016\fh*^7U_\u000eCWmY6q_&tG\u000f\u0006\u0003\u0003&\t\u001d\u0002cA\u000eoY!9!Q\u0001B\u0010\u0001\u0004a\u0003b\u0002B\u0016\u0001\u0011\u0005!QF\u0001\u0010g\u0016$8\t[3dWB|\u0017N\u001c;feR1\u0011Q\u0002B\u0018\u0005cAqA!\u0002\u0003*\u0001\u0007A\u0006\u0003\u0005\u00034\t%\u0002\u0019\u0001B\u001b\u00031\u0019\u0007.Z2la>Lg\u000e^3s!\u0011\u00119D!\u0010\u000e\u0005\te\"\u0002\u0002B\u001e\u0003g\t!\"\u001b8uKJ4\u0017mY3t\u0013\u0011\u0011yD!\u000f\u00039%\u0013VmY8sIB\u0013xnY3tg>\u00148\t[3dWB|\u0017N\u001c;fe\"9!1\t\u0001\u0005\u0002\t\u0015\u0013A\u0005:f[>4Xm\u00115fG.\u0004x.\u001b8uKJ$b!!\u0004\u0003H\t%\u0003b\u0002B\u0003\u0005\u0003\u0002\r\u0001\f\u0005\t\u0005g\u0011\t\u00051\u0001\u00036!9!Q\n\u0001\u0005\n\t=\u0013A\u0005:f[\u0016l'-\u001a:BI\u0012,GMU1oO\u0016$B!!\u0004\u0003R!A!1\u000bB&\u0001\u0004\ti*A\u0003sC:<W\rC\u0004\u0003X\u0001!IA!\u0017\u0002;\u0019Lg.\u00197ju\u0016\u0014\u0016M\\4fg\u001a{'oQ;se\u0016tGO\u00117pG.$B!!\u0004\u0003\\!A!Q\fB+\u0001\u0004\ti,A\u0004cY>\u001c7.\u00133\t\u000f\t\u0005\u0004\u0001\"\u0003\u0003d\u0005!2\u000f^8sK\ncwnY6XSRD'+\u00198hKN$b!!\u0004\u0003f\t\u001d\u0004\u0002\u0003B/\u0005?\u0002\r!!0\t\u0011\t%$q\fa\u0001\u0005W\n1\"\u0019:sCf\u0014UO\u001a4feB)\u0011qRAM)\u00191!q\u000e\u0001\u0005\u0005c\u0012QcR3oKJ\fG/\u001a3CY>\u001c7\u000eS1oI2,'o\u0005\u0004\u0003n\tM$\u0011\u0010\t\u00047\tU\u0014b\u0001B<9\t1\u0011I\\=SK\u001a\u00042a\u0004B>\u0013\r\u0011i\b\u0005\u0002\u0017\u00052|7m[$f]\u0016\u0014\u0018\r^8s\u0019&\u001cH/\u001a8fe\"91O!\u001c\u0005\u0002\t\u0005EC\u0001BB!\u0011\u0011)I!\u001c\u000e\u0003\u0001A\u0001B!#\u0003n\u0011\u0005!1R\u0001\n_:\fE\r\u001a#bi\u0006$b!!\u0004\u0003\u000e\nE\u0005b\u0002BH\u0005\u000f\u0003\r\u0001I\u0001\u0005I\u0006$\u0018\rC\u0004\u0003\u0014\n\u001d\u0005\u0019\u0001\u0011\u0002\u00115,G/\u00193bi\u0006D\u0001Ba&\u0003n\u0011\u0005!\u0011T\u0001\u0010_:<UM\\3sCR,'\t\\8dWR!\u0011Q\u0002BN\u0011!\u0011iF!&A\u0002\u0005u\u0006\u0002\u0003BP\u0005[\"\tA!)\u0002\u0017=t\u0007+^:i\u00052|7m\u001b\u000b\u0007\u0003\u001b\u0011\u0019K!*\t\u0011\tu#Q\u0014a\u0001\u0003{C\u0001B!\u001b\u0003\u001e\u0002\u0007!q\u0015\u0019\u0005\u0005S\u0013i\u000b\u0005\u0004\u0002\u0010\u0006e%1\u0016\t\u0004+\t5Fa\u0003BX\u0005K\u000b\t\u0011!A\u0003\u0002e\u00111a\u0018\u00132\u0011!\u0011\u0019L!\u001c\u0005\u0002\tU\u0016aB8o\u000bJ\u0014xN\u001d\u000b\u0007\u0003\u001b\u00119La/\t\u000f\te&\u0011\u0017a\u0001Y\u00059Q.Z:tC\u001e,\u0007\u0002\u0003B_\u0005c\u0003\rAa0\u0002\u0013QD'o\\<bE2,\u0007\u0003\u0002Ba\u0005\u0017tAAa1\u0003H:\u0019qF!2\n\u0003uI1A!3\u001d\u0003\u001d\u0001\u0018mY6bO\u0016LAA!4\u0003P\nIA\u000b\u001b:po\u0006\u0014G.\u001a\u0006\u0004\u0005\u0013d\u0002")
public class KinesisReceiver<T>
extends Receiver<T>
implements Logging {
    private final String streamName;
    private final String endpointUrl;
    private final String regionName;
    private final KinesisInitialPosition initialPosition;
    private final String checkpointAppName;
    private final Duration checkpointInterval;
    private final Function1<Record, T> messageHandler;
    private final SparkAWSCredentials kinesisCreds;
    private final Option<SparkAWSCredentials> dynamoDBCreds;
    private final Option<SparkAWSCredentials> cloudWatchCreds;
    private volatile String org$apache$spark$streaming$kinesis$KinesisReceiver$$workerId;
    private volatile Worker org$apache$spark$streaming$kinesis$KinesisReceiver$$worker;
    private volatile Thread workerThread;
    private volatile BlockGenerator blockGenerator;
    private final ArrayBuffer<SequenceNumberRange> seqNumRangesInCurrentBlock;
    private final ConcurrentHashMap<StreamBlockId, SequenceNumberRanges> blockIdToSeqNumRanges;
    private volatile KinesisCheckpointer kinesisCheckpointer;
    private final ConcurrentHashMap<String, String> shardIdToLatestStoredSeqNum;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String streamName() {
        return this.streamName;
    }

    public String org$apache$spark$streaming$kinesis$KinesisReceiver$$workerId() {
        return this.org$apache$spark$streaming$kinesis$KinesisReceiver$$workerId;
    }

    private void org$apache$spark$streaming$kinesis$KinesisReceiver$$workerId_$eq(String x$1) {
        this.org$apache$spark$streaming$kinesis$KinesisReceiver$$workerId = x$1;
    }

    public Worker org$apache$spark$streaming$kinesis$KinesisReceiver$$worker() {
        return this.org$apache$spark$streaming$kinesis$KinesisReceiver$$worker;
    }

    private void org$apache$spark$streaming$kinesis$KinesisReceiver$$worker_$eq(Worker x$1) {
        this.org$apache$spark$streaming$kinesis$KinesisReceiver$$worker = x$1;
    }

    private Thread workerThread() {
        return this.workerThread;
    }

    private void workerThread_$eq(Thread x$1) {
        this.workerThread = x$1;
    }

    private BlockGenerator blockGenerator() {
        return this.blockGenerator;
    }

    private void blockGenerator_$eq(BlockGenerator x$1) {
        this.blockGenerator = x$1;
    }

    private ArrayBuffer<SequenceNumberRange> seqNumRangesInCurrentBlock() {
        return this.seqNumRangesInCurrentBlock;
    }

    private ConcurrentHashMap<StreamBlockId, SequenceNumberRanges> blockIdToSeqNumRanges() {
        return this.blockIdToSeqNumRanges;
    }

    private KinesisCheckpointer kinesisCheckpointer() {
        return this.kinesisCheckpointer;
    }

    private void kinesisCheckpointer_$eq(KinesisCheckpointer x$1) {
        this.kinesisCheckpointer = x$1;
    }

    private ConcurrentHashMap<String, String> shardIdToLatestStoredSeqNum() {
        return this.shardIdToLatestStoredSeqNum;
    }

    public void onStart() {
        KinesisClientLibConfiguration kinesisClientLibConfiguration;
        this.blockGenerator_$eq(this.supervisor().createBlockGenerator((BlockGeneratorListener)new GeneratedBlockHandler()));
        this.org$apache$spark$streaming$kinesis$KinesisReceiver$$workerId_$eq(new StringBuilder(1).append(Utils$.MODULE$.localHostName()).append(":").append(UUID.randomUUID()).toString());
        this.kinesisCheckpointer_$eq(new KinesisCheckpointer(this, this.checkpointInterval, this.org$apache$spark$streaming$kinesis$KinesisReceiver$$workerId(), KinesisCheckpointer$.MODULE$.$lessinit$greater$default$4()));
        AWSCredentialsProvider kinesisProvider = this.kinesisCreds.provider();
        KinesisClientLibConfiguration baseClientLibConfiguration = new KinesisClientLibConfiguration(this.checkpointAppName, this.streamName(), kinesisProvider, (AWSCredentialsProvider)this.dynamoDBCreds.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.provider()).getOrElse((Function0 & Serializable & scala.Serializable)() -> kinesisProvider), (AWSCredentialsProvider)this.cloudWatchCreds.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.provider()).getOrElse((Function0 & Serializable & scala.Serializable)() -> kinesisProvider), this.org$apache$spark$streaming$kinesis$KinesisReceiver$$workerId()).withKinesisEndpoint(this.endpointUrl).withTaskBackoffTimeMillis(500L).withRegionName(this.regionName);
        KinesisInitialPosition kinesisInitialPosition = this.initialPosition;
        if (kinesisInitialPosition instanceof KinesisInitialPositions.AtTimestamp) {
            KinesisInitialPositions.AtTimestamp atTimestamp = (KinesisInitialPositions.AtTimestamp)kinesisInitialPosition;
            kinesisClientLibConfiguration = baseClientLibConfiguration.withTimestampAtInitialPositionInStream(atTimestamp.getTimestamp());
        } else {
            kinesisClientLibConfiguration = baseClientLibConfiguration.withInitialPositionInStream(this.initialPosition.getPosition());
        }
        KinesisClientLibConfiguration kinesisClientLibConfiguration2 = kinesisClientLibConfiguration;
        IRecordProcessorFactory recordProcessorFactory = new IRecordProcessorFactory(this){
            private final /* synthetic */ KinesisReceiver $outer;

            public IRecordProcessor createProcessor() {
                return new KinesisRecordProcessor<T>(this.$outer, this.$outer.org$apache$spark$streaming$kinesis$KinesisReceiver$$workerId());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        this.org$apache$spark$streaming$kinesis$KinesisReceiver$$worker_$eq(new Worker(recordProcessorFactory, kinesisClientLibConfiguration2));
        this.workerThread_$eq(new Thread(this){
            private final /* synthetic */ KinesisReceiver $outer;

            public void run() {
                try {
                    this.$outer.org$apache$spark$streaming$kinesis$KinesisReceiver$$worker().run();
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (!option.isEmpty()) {
                        Throwable e = (Throwable)option.get();
                        this.$outer.restart("Error running the KCL worker in Receiver", e);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    throw throwable;
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.blockIdToSeqNumRanges().clear();
        this.blockGenerator().start();
        this.workerThread().setName(new StringBuilder(17).append("Kinesis Receiver ").append(this.streamId()).toString());
        this.workerThread().setDaemon(true);
        this.workerThread().start();
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Started receiver with workerId ").append(this.org$apache$spark$streaming$kinesis$KinesisReceiver$$workerId()).toString());
    }

    public void onStop() {
        block2: {
            if (this.workerThread() != null) {
                if (this.org$apache$spark$streaming$kinesis$KinesisReceiver$$worker() != null) {
                    this.org$apache$spark$streaming$kinesis$KinesisReceiver$$worker().shutdown();
                    this.org$apache$spark$streaming$kinesis$KinesisReceiver$$worker_$eq(null);
                }
                this.workerThread().join();
                this.workerThread_$eq(null);
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Stopped receiver for workerId ").append(this.org$apache$spark$streaming$kinesis$KinesisReceiver$$workerId()).toString());
            }
            this.org$apache$spark$streaming$kinesis$KinesisReceiver$$workerId_$eq(null);
            if (this.kinesisCheckpointer() == null) break block2;
            this.kinesisCheckpointer().shutdown();
            this.kinesisCheckpointer_$eq(null);
        }
    }

    public void addRecords(String shardId, List<Record> records) {
        block0: {
            if (records.size() <= 0) break block0;
            Iterator dataIterator = ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(records.iterator()).asScala()).map(this.messageHandler);
            SequenceNumberRange metadata = new SequenceNumberRange(this.streamName(), shardId, records.get(0).getSequenceNumber(), records.get(records.size() - 1).getSequenceNumber(), records.size());
            this.blockGenerator().addMultipleDataWithCallback(dataIterator, (Object)metadata);
        }
    }

    public int getCurrentLimit() {
        Predef$.MODULE$.assert(this.blockGenerator() != null);
        return (int)package$.MODULE$.min(this.blockGenerator().getCurrentLimit(), Integer.MAX_VALUE);
    }

    public Option<String> getLatestSeqNumToCheckpoint(String shardId) {
        return Option$.MODULE$.apply((Object)this.shardIdToLatestStoredSeqNum().get(shardId));
    }

    public void setCheckpointer(String shardId, IRecordProcessorCheckpointer checkpointer) {
        Predef$.MODULE$.assert(this.kinesisCheckpointer() != null, (Function0 & Serializable & scala.Serializable)() -> "Kinesis Checkpointer not initialized!");
        this.kinesisCheckpointer().setCheckpointer(shardId, checkpointer);
    }

    public void removeCheckpointer(String shardId, IRecordProcessorCheckpointer checkpointer) {
        Predef$.MODULE$.assert(this.kinesisCheckpointer() != null, (Function0 & Serializable & scala.Serializable)() -> "Kinesis Checkpointer not initialized!");
        this.kinesisCheckpointer().removeCheckpointer(shardId, checkpointer);
    }

    public void org$apache$spark$streaming$kinesis$KinesisReceiver$$rememberAddedRange(SequenceNumberRange range) {
        this.seqNumRangesInCurrentBlock().$plus$eq((Object)range);
    }

    public void org$apache$spark$streaming$kinesis$KinesisReceiver$$finalizeRangesForCurrentBlock(StreamBlockId blockId) {
        this.blockIdToSeqNumRanges().put(blockId, new SequenceNumberRanges((Seq<SequenceNumberRange>)Predef$.MODULE$.wrapRefArray((Object[])this.seqNumRangesInCurrentBlock().toArray(ClassTag$.MODULE$.apply(SequenceNumberRange.class)))));
        this.seqNumRangesInCurrentBlock().clear();
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Generated block ").append(blockId).append(" has ").append(this.blockIdToSeqNumRanges()).toString());
    }

    public void org$apache$spark$streaming$kinesis$KinesisReceiver$$storeBlockWithRanges(StreamBlockId blockId, ArrayBuffer<T> arrayBuffer) {
        Option rangesToReportOption = Option$.MODULE$.apply((Object)this.blockIdToSeqNumRanges().remove(blockId));
        if (rangesToReportOption.isEmpty()) {
            this.stop(new StringBuilder(76).append("Error while storing block into Spark, could not find sequence number ranges ").append(new StringBuilder(10).append("for block ").append(blockId).toString()).toString());
            return;
        }
        SequenceNumberRanges rangesToReport = (SequenceNumberRanges)rangesToReportOption.get();
        int attempt = 0;
        boolean stored = false;
        Throwable throwable = null;
        while (!stored && attempt <= 3) {
            try {
                this.store(arrayBuffer, rangesToReport);
                stored = true;
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                Option option = NonFatal$.MODULE$.unapply(throwable3);
                if (!option.isEmpty()) {
                    Throwable th = (Throwable)option.get();
                    ++attempt;
                    throwable = th;
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                throw throwable2;
            }
        }
        if (!stored) {
            this.stop("Error while storing block into Spark", throwable);
        }
        rangesToReport.ranges().foreach((Function1 & Serializable & scala.Serializable)range -> this.shardIdToLatestStoredSeqNum().put(range.shardId(), range.toSeqNumber()));
    }

    public KinesisReceiver(String streamName, String endpointUrl, String regionName, KinesisInitialPosition initialPosition, String checkpointAppName, Duration checkpointInterval, StorageLevel storageLevel, Function1<Record, T> messageHandler, SparkAWSCredentials kinesisCreds, Option<SparkAWSCredentials> dynamoDBCreds, Option<SparkAWSCredentials> cloudWatchCreds) {
        this.streamName = streamName;
        this.endpointUrl = endpointUrl;
        this.regionName = regionName;
        this.initialPosition = initialPosition;
        this.checkpointAppName = checkpointAppName;
        this.checkpointInterval = checkpointInterval;
        this.messageHandler = messageHandler;
        this.kinesisCreds = kinesisCreds;
        this.dynamoDBCreds = dynamoDBCreds;
        this.cloudWatchCreds = cloudWatchCreds;
        super(storageLevel);
        Logging.$init$((Logging)this);
        this.org$apache$spark$streaming$kinesis$KinesisReceiver$$workerId = null;
        this.org$apache$spark$streaming$kinesis$KinesisReceiver$$worker = null;
        this.workerThread = null;
        this.blockGenerator = null;
        this.seqNumRangesInCurrentBlock = new ArrayBuffer();
        this.blockIdToSeqNumRanges = new ConcurrentHashMap();
        this.kinesisCheckpointer = null;
        this.shardIdToLatestStoredSeqNum = new ConcurrentHashMap();
    }

    public class GeneratedBlockHandler
    implements BlockGeneratorListener {
        public void onAddData(Object data, Object metadata) {
            this.org$apache$spark$streaming$kinesis$KinesisReceiver$GeneratedBlockHandler$$$outer().org$apache$spark$streaming$kinesis$KinesisReceiver$$rememberAddedRange((SequenceNumberRange)metadata);
        }

        public void onGenerateBlock(StreamBlockId blockId) {
            this.org$apache$spark$streaming$kinesis$KinesisReceiver$GeneratedBlockHandler$$$outer().org$apache$spark$streaming$kinesis$KinesisReceiver$$finalizeRangesForCurrentBlock(blockId);
        }

        public void onPushBlock(StreamBlockId blockId, ArrayBuffer<?> arrayBuffer) {
            this.org$apache$spark$streaming$kinesis$KinesisReceiver$GeneratedBlockHandler$$$outer().org$apache$spark$streaming$kinesis$KinesisReceiver$$storeBlockWithRanges(blockId, arrayBuffer);
        }

        public void onError(String message, Throwable throwable) {
            this.org$apache$spark$streaming$kinesis$KinesisReceiver$GeneratedBlockHandler$$$outer().reportError(message, throwable);
        }

        public /* synthetic */ KinesisReceiver org$apache$spark$streaming$kinesis$KinesisReceiver$GeneratedBlockHandler$$$outer() {
            return KinesisReceiver.this;
        }

        public GeneratedBlockHandler() {
            if (KinesisReceiver.this == null) {
                throw null;
            }
        }
    }
}

