/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.kinesis;

import com.amazonaws.services.kinesis.clientlibrary.lib.worker.InitialPositionInStream;
import com.amazonaws.services.kinesis.model.Record;
import java.io.Serializable;
import org.apache.spark.annotation.InterfaceStability;
import org.apache.spark.rdd.RDD;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.api.java.JavaStreamingContext;
import org.apache.spark.streaming.dstream.ReceiverInputDStream;
import org.apache.spark.streaming.kinesis.DefaultCredentials$;
import org.apache.spark.streaming.kinesis.KinesisBackedBlockRDD;
import org.apache.spark.streaming.kinesis.KinesisInitialPosition;
import org.apache.spark.streaming.kinesis.KinesisInitialPositions;
import org.apache.spark.streaming.kinesis.KinesisInputDStream$;
import org.apache.spark.streaming.kinesis.KinesisReadConfigurations$;
import org.apache.spark.streaming.kinesis.KinesisReceiver;
import org.apache.spark.streaming.kinesis.SequenceNumberRanges;
import org.apache.spark.streaming.kinesis.SparkAWSCredentials;
import org.apache.spark.streaming.receiver.Receiver;
import org.apache.spark.streaming.scheduler.ReceivedBlockInfo;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\r=f!B\u0001\u0003\u0001\ta!aE&j]\u0016\u001c\u0018n]%oaV$Hi\u0015;sK\u0006l'BA\u0002\u0005\u0003\u001dY\u0017N\\3tSNT!!\u0002\u0004\u0002\u0013M$(/Z1nS:<'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0016\u0005512C\u0001\u0001\u000f!\ry!\u0003F\u0007\u0002!)\u0011\u0011\u0003B\u0001\bIN$(/Z1n\u0013\t\u0019\u0002C\u0001\u000bSK\u000e,\u0017N^3s\u0013:\u0004X\u000f\u001e#TiJ,\u0017-\u001c\t\u0003+Ya\u0001\u0001B\u0003\u0018\u0001\t\u0007\u0011DA\u0001U\u0007\u0001\t\"A\u0007\u0011\u0011\u0005mqR\"\u0001\u000f\u000b\u0003u\tQa]2bY\u0006L!a\b\u000f\u0003\u000f9{G\u000f[5oOB\u00111$I\u0005\u0003Eq\u00111!\u00118z\u0011!!\u0003A!A!\u0002\u0013)\u0013\u0001B0tg\u000e\u0004\"AJ\u0014\u000e\u0003\u0011I!\u0001\u000b\u0003\u0003!M#(/Z1nS:<7i\u001c8uKb$\b\u0002\u0003\u0016\u0001\u0005\u000b\u0007I\u0011A\u0016\u0002\u0015M$(/Z1n\u001d\u0006lW-F\u0001-!\tiCG\u0004\u0002/eA\u0011q\u0006H\u0007\u0002a)\u0011\u0011\u0007G\u0001\u0007yI|w\u000e\u001e \n\u0005Mb\u0012A\u0002)sK\u0012,g-\u0003\u00026m\t11\u000b\u001e:j]\u001eT!a\r\u000f\t\u0011a\u0002!\u0011!Q\u0001\n1\n1b\u001d;sK\u0006lg*Y7fA!A!\b\u0001BC\u0002\u0013\u00051&A\u0006f]\u0012\u0004x.\u001b8u+Jd\u0007\u0002\u0003\u001f\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0017\u0002\u0019\u0015tG\r]8j]R,&\u000f\u001c\u0011\t\u0011y\u0002!Q1A\u0005\u0002-\n!B]3hS>tg*Y7f\u0011!\u0001\u0005A!A!\u0002\u0013a\u0013a\u0003:fO&|gNT1nK\u0002B\u0001B\u0011\u0001\u0003\u0006\u0004%\taQ\u0001\u0010S:LG/[1m!>\u001c\u0018\u000e^5p]V\tA\t\u0005\u0002F\r6\t!!\u0003\u0002H\u0005\t12*\u001b8fg&\u001c\u0018J\\5uS\u0006d\u0007k\\:ji&|g\u000e\u0003\u0005J\u0001\t\u0005\t\u0015!\u0003E\u0003AIg.\u001b;jC2\u0004vn]5uS>t\u0007\u0005\u0003\u0005L\u0001\t\u0015\r\u0011\"\u0001,\u0003E\u0019\u0007.Z2la>Lg\u000e^!qa:\u000bW.\u001a\u0005\t\u001b\u0002\u0011\t\u0011)A\u0005Y\u0005\u00112\r[3dWB|\u0017N\u001c;BaBt\u0015-\\3!\u0011!y\u0005A!b\u0001\n\u0003\u0001\u0016AE2iK\u000e\\\u0007o\\5oi&sG/\u001a:wC2,\u0012!\u0015\t\u0003MIK!a\u0015\u0003\u0003\u0011\u0011+(/\u0019;j_:D\u0001\"\u0016\u0001\u0003\u0002\u0003\u0006I!U\u0001\u0014G\",7m\u001b9pS:$\u0018J\u001c;feZ\fG\u000e\t\u0005\t/\u0002\u0011)\u0019!C\u00011\u0006iql\u001d;pe\u0006<W\rT3wK2,\u0012!\u0017\t\u00035vk\u0011a\u0017\u0006\u00039\u001a\tqa\u001d;pe\u0006<W-\u0003\u0002_7\na1\u000b^8sC\u001e,G*\u001a<fY\"A\u0001\r\u0001B\u0001B\u0003%\u0011,\u0001\b`gR|'/Y4f\u0019\u00164X\r\u001c\u0011\t\u0011\t\u0004!Q1A\u0005\u0002\r\fa\"\\3tg\u0006<W\rS1oI2,'/F\u0001e!\u0011YRm\u001a\u000b\n\u0005\u0019d\"!\u0003$v]\u000e$\u0018n\u001c82!\tA'/D\u0001j\u0015\tQ7.A\u0003n_\u0012,GN\u0003\u0002\u0004Y*\u0011QN\\\u0001\tg\u0016\u0014h/[2fg*\u0011q\u000e]\u0001\nC6\f'p\u001c8boNT\u0011!]\u0001\u0004G>l\u0017BA:j\u0005\u0019\u0011VmY8sI\"AQ\u000f\u0001B\u0001B\u0003%A-A\bnKN\u001c\u0018mZ3IC:$G.\u001a:!\u0011!9\bA!b\u0001\n\u0003A\u0018\u0001D6j]\u0016\u001c\u0018n]\"sK\u0012\u001cX#A=\u0011\u0005\u0015S\u0018BA>\u0003\u0005M\u0019\u0006/\u0019:l\u0003^\u001b6I]3eK:$\u0018.\u00197t\u0011!i\bA!A!\u0002\u0013I\u0018!D6j]\u0016\u001c\u0018n]\"sK\u0012\u001c\b\u0005C\u0005\u0000\u0001\t\u0015\r\u0011\"\u0001\u0002\u0002\u0005iA-\u001f8b[>$%i\u0011:fIN,\"!a\u0001\u0011\tm\t)!_\u0005\u0004\u0003\u000fa\"AB(qi&|g\u000e\u0003\u0006\u0002\f\u0001\u0011\t\u0011)A\u0005\u0003\u0007\ta\u0002Z=oC6|GIQ\"sK\u0012\u001c\b\u0005\u0003\u0006\u0002\u0010\u0001\u0011)\u0019!C\u0001\u0003\u0003\tqb\u00197pk\u0012<\u0016\r^2i\u0007J,Gm\u001d\u0005\u000b\u0003'\u0001!\u0011!Q\u0001\n\u0005\r\u0011\u0001E2m_V$w+\u0019;dQ\u000e\u0013X\rZ:!\u0011)\t9\u0002\u0001B\u0002B\u0003-\u0011\u0011D\u0001\u000bKZLG-\u001a8dK\u0012\n\u0004#BA\u000e\u0003C!RBAA\u000f\u0015\r\ty\u0002H\u0001\be\u00164G.Z2u\u0013\u0011\t\u0019#!\b\u0003\u0011\rc\u0017m]:UC\u001eDq!a\n\u0001\t\u0003\tI#\u0001\u0004=S:LGO\u0010\u000b\u001b\u0003W\t\t$a\r\u00026\u0005]\u0012\u0011HA\u001e\u0003{\ty$!\u0011\u0002D\u0005\u0015\u0013q\t\u000b\u0005\u0003[\ty\u0003E\u0002F\u0001QA\u0001\"a\u0006\u0002&\u0001\u000f\u0011\u0011\u0004\u0005\u0007I\u0005\u0015\u0002\u0019A\u0013\t\r)\n)\u00031\u0001-\u0011\u0019Q\u0014Q\u0005a\u0001Y!1a(!\nA\u00021BaAQA\u0013\u0001\u0004!\u0005BB&\u0002&\u0001\u0007A\u0006\u0003\u0004P\u0003K\u0001\r!\u0015\u0005\u0007/\u0006\u0015\u0002\u0019A-\t\r\t\f)\u00031\u0001e\u0011\u00199\u0018Q\u0005a\u0001s\"9q0!\nA\u0002\u0005\r\u0001\u0002CA\b\u0003K\u0001\r!a\u0001\t\u0011\u0005-\u0003\u0001\"\u0011\u0005\u0003\u001b\nab\u0019:fCR,'\t\\8dWJ#E\t\u0006\u0004\u0002P\u0005m\u0013Q\r\t\u0006\u0003#\n9\u0006F\u0007\u0003\u0003'R1!!\u0016\u0007\u0003\r\u0011H\rZ\u0005\u0005\u00033\n\u0019FA\u0002S\t\u0012C\u0001\"!\u0018\u0002J\u0001\u0007\u0011qL\u0001\u0005i&lW\rE\u0002'\u0003CJ1!a\u0019\u0005\u0005\u0011!\u0016.\\3\t\u0011\u0005\u001d\u0014\u0011\na\u0001\u0003S\n!B\u00197pG.LeNZ8t!\u0019\tY'!\u001e\u0002|9!\u0011QNA9\u001d\ry\u0013qN\u0005\u0002;%\u0019\u00111\u000f\u000f\u0002\u000fA\f7m[1hK&!\u0011qOA=\u0005\r\u0019V-\u001d\u0006\u0004\u0003gb\u0002\u0003BA?\u0003\u0007k!!a \u000b\u0007\u0005\u0005E!A\u0005tG\",G-\u001e7fe&!\u0011QQA@\u0005E\u0011VmY3jm\u0016$'\t\\8dW&sgm\u001c\u0005\b\u0003\u0013\u0003A\u0011IAF\u0003-9W\r\u001e*fG\u0016Lg/\u001a:\u0015\u0005\u00055\u0005#BAH\u0003+#RBAAI\u0015\r\t\u0019\nB\u0001\te\u0016\u001cW-\u001b<fe&!\u0011qSAI\u0005!\u0011VmY3jm\u0016\u0014xaBAN\u0005!\u0005\u0011QT\u0001\u0014\u0017&tWm]5t\u0013:\u0004X\u000f\u001e#TiJ,\u0017-\u001c\t\u0004\u000b\u0006}eAB\u0001\u0003\u0011\u0003\t\tk\u0005\u0004\u0002 \u0006\r\u0016\u0011\u0016\t\u00047\u0005\u0015\u0016bAAT9\t1\u0011I\\=SK\u001a\u00042aGAV\u0013\r\ti\u000b\b\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\t\u0003O\ty\n\"\u0001\u00022R\u0011\u0011Q\u0014\u0004\b\u0003k\u000by\nAA\\\u0005\u001d\u0011U/\u001b7eKJ\u001cB!a-\u0002$\"A\u0011qEAZ\t\u0003\tY\f\u0006\u0002\u0002>B!\u0011qXAZ\u001b\t\ty\n\u0003\u0006\u0002D\u0006M\u0006\u0019!C\u0005\u0003\u000b\f\u0001c\u001d;sK\u0006l\u0017N\\4D_:$X\r\u001f;\u0016\u0005\u0005\u001d\u0007\u0003B\u000e\u0002\u0006\u0015B!\"a3\u00024\u0002\u0007I\u0011BAg\u0003Q\u0019HO]3b[&twmQ8oi\u0016DHo\u0018\u0013fcR!\u0011qZAk!\rY\u0012\u0011[\u0005\u0004\u0003'd\"\u0001B+oSRD!\"a6\u0002J\u0006\u0005\t\u0019AAd\u0003\rAH%\r\u0005\n\u00037\f\u0019\f)Q\u0005\u0003\u000f\f\u0011c\u001d;sK\u0006l\u0017N\\4D_:$X\r\u001f;!\u0011%Q\u00131\u0017a\u0001\n\u0013\ty.\u0006\u0002\u0002bB!1$!\u0002-\u0011)\t)/a-A\u0002\u0013%\u0011q]\u0001\u000fgR\u0014X-Y7OC6,w\fJ3r)\u0011\ty-!;\t\u0015\u0005]\u00171]A\u0001\u0002\u0004\t\t\u000f\u0003\u00059\u0003g\u0003\u000b\u0015BAq\u0011%Y\u00151\u0017a\u0001\n\u0013\ty\u000e\u0003\u0006\u0002r\u0006M\u0006\u0019!C\u0005\u0003g\fQc\u00195fG.\u0004x.\u001b8u\u0003B\u0004h*Y7f?\u0012*\u0017\u000f\u0006\u0003\u0002P\u0006U\bBCAl\u0003_\f\t\u00111\u0001\u0002b\"AQ*a-!B\u0013\t\t\u000fC\u0005;\u0003g\u0003\r\u0011\"\u0003\u0002`\"Q\u0011Q`AZ\u0001\u0004%I!a@\u0002\u001f\u0015tG\r]8j]R,&\u000f\\0%KF$B!a4\u0003\u0002!Q\u0011q[A~\u0003\u0003\u0005\r!!9\t\u0011q\n\u0019\f)Q\u0005\u0003CD\u0011BPAZ\u0001\u0004%I!a8\t\u0015\t%\u00111\u0017a\u0001\n\u0013\u0011Y!\u0001\bsK\u001eLwN\u001c(b[\u0016|F%Z9\u0015\t\u0005='Q\u0002\u0005\u000b\u0003/\u00149!!AA\u0002\u0005\u0005\b\u0002\u0003!\u00024\u0002\u0006K!!9\t\u0013\t\u000b\u0019\f1A\u0005\n\tMQC\u0001B\u000b!\u0011Y\u0012Q\u0001#\t\u0015\te\u00111\u0017a\u0001\n\u0013\u0011Y\"A\nj]&$\u0018.\u00197Q_NLG/[8o?\u0012*\u0017\u000f\u0006\u0003\u0002P\nu\u0001BCAl\u0005/\t\t\u00111\u0001\u0003\u0016!A\u0011*a-!B\u0013\u0011)\u0002C\u0005P\u0003g\u0003\r\u0011\"\u0003\u0003$U\u0011!Q\u0005\t\u00057\u0005\u0015\u0011\u000b\u0003\u0006\u0003*\u0005M\u0006\u0019!C\u0005\u0005W\tac\u00195fG.\u0004x.\u001b8u\u0013:$XM\u001d<bY~#S-\u001d\u000b\u0005\u0003\u001f\u0014i\u0003\u0003\u0006\u0002X\n\u001d\u0012\u0011!a\u0001\u0005KA\u0001\"VAZA\u0003&!Q\u0005\u0005\u000b\u0005g\t\u0019\f1A\u0005\n\tU\u0012\u0001D:u_J\fw-\u001a'fm\u0016dWC\u0001B\u001c!\u0011Y\u0012QA-\t\u0015\tm\u00121\u0017a\u0001\n\u0013\u0011i$\u0001\tti>\u0014\u0018mZ3MKZ,Gn\u0018\u0013fcR!\u0011q\u001aB \u0011)\t9N!\u000f\u0002\u0002\u0003\u0007!q\u0007\u0005\n\u0005\u0007\n\u0019\f)Q\u0005\u0005o\tQb\u001d;pe\u0006<W\rT3wK2\u0004\u0003B\u0003B$\u0003g\u0003\r\u0011\"\u0003\u0002\u0002\u0005!2.\u001b8fg&\u001c8I]3egB\u0013xN^5eKJD!Ba\u0013\u00024\u0002\u0007I\u0011\u0002B'\u0003aY\u0017N\\3tSN\u001c%/\u001a3t!J|g/\u001b3fe~#S-\u001d\u000b\u0005\u0003\u001f\u0014y\u0005\u0003\u0006\u0002X\n%\u0013\u0011!a\u0001\u0003\u0007A\u0011Ba\u0015\u00024\u0002\u0006K!a\u0001\u0002+-Lg.Z:jg\u000e\u0013X\rZ:Qe>4\u0018\u000eZ3sA!Q!qKAZ\u0001\u0004%I!!\u0001\u0002+\u0011Lh.Y7p\t\n\u001b%/\u001a3t!J|g/\u001b3fe\"Q!1LAZ\u0001\u0004%IA!\u0018\u00023\u0011Lh.Y7p\t\n\u001b%/\u001a3t!J|g/\u001b3fe~#S-\u001d\u000b\u0005\u0003\u001f\u0014y\u0006\u0003\u0006\u0002X\ne\u0013\u0011!a\u0001\u0003\u0007A\u0011Ba\u0019\u00024\u0002\u0006K!a\u0001\u0002-\u0011Lh.Y7p\t\n\u001b%/\u001a3t!J|g/\u001b3fe\u0002B!Ba\u001a\u00024\u0002\u0007I\u0011BA\u0001\u0003]\u0019Gn\\;e/\u0006$8\r[\"sK\u0012\u001c\bK]8wS\u0012,'\u000f\u0003\u0006\u0003l\u0005M\u0006\u0019!C\u0005\u0005[\n1d\u00197pk\u0012<\u0016\r^2i\u0007J,Gm\u001d)s_ZLG-\u001a:`I\u0015\fH\u0003BAh\u0005_B!\"a6\u0003j\u0005\u0005\t\u0019AA\u0002\u0011%\u0011\u0019(a-!B\u0013\t\u0019!\u0001\rdY>,HmV1uG\"\u001c%/\u001a3t!J|g/\u001b3fe\u0002B\u0001\"a1\u00024\u0012\u0005!q\u000f\u000b\u0005\u0003{\u0013I\bC\u0004\u0003|\tU\u0004\u0019A\u0013\u0002\u0007M\u001c8\r\u0003\u0005\u0002D\u0006MF\u0011\u0001B@)\u0011\tiL!!\t\u0011\t\r%Q\u0010a\u0001\u0005\u000b\u000bAA[:tGB!!q\u0011BI\u001b\t\u0011II\u0003\u0003\u0003\f\n5\u0015\u0001\u00026bm\u0006T1Aa$\u0005\u0003\r\t\u0007/[\u0005\u0005\u0005'\u0013II\u0001\u000bKCZ\f7\u000b\u001e:fC6LgnZ\"p]R,\u0007\u0010\u001e\u0005\bU\u0005MF\u0011\u0001BL)\u0011\tiL!'\t\r)\u0012)\n1\u0001-\u0011\u001dY\u00151\u0017C\u0001\u0005;#B!!0\u0003 \"9!\u0011\u0015BN\u0001\u0004a\u0013aB1qa:\u000bW.\u001a\u0005\bu\u0005MF\u0011\u0001BS)\u0011\tiLa*\t\u000f\t%&1\u0015a\u0001Y\u0005\u0019QO\u001d7\t\u000fy\n\u0019\f\"\u0001\u0003.R!\u0011Q\u0018BX\u0011\u0019q$1\u0016a\u0001Y!9!)a-\u0005\u0002\tMF\u0003BA_\u0005kCaA\u0011BY\u0001\u0004!\u0005\u0002\u0003B]\u0003g#\tAa/\u0002/%t\u0017\u000e^5bYB{7/\u001b;j_:Len\u0015;sK\u0006lG\u0003BA_\u0005{CqA\u0011B\\\u0001\u0004\u0011y\f\u0005\u0003\u0003B\n=WB\u0001Bb\u0015\u0011\u0011)Ma2\u0002\r]|'o[3s\u0015\u0011\u0011IMa3\u0002\u00071L'MC\u0002\u0003N.\fQb\u00197jK:$H.\u001b2sCJL\u0018\u0002\u0002Bi\u0005\u0007\u0014q#\u00138ji&\fG\u000eU8tSRLwN\\%o'R\u0014X-Y7)\u0011\t]&Q\u001bBn\u0005?\u00042a\u0007Bl\u0013\r\u0011I\u000e\b\u0002\u000bI\u0016\u0004(/Z2bi\u0016$\u0017E\u0001Bo\u0003q*8/\u001a\u0011j]&$\u0018.\u00197Q_NLG/[8oQ%t\u0017\u000e^5bYB{7/\u001b;j_:T\u0004eS5oKNL7/\u00138ji&\fG\u000eU8tSRLwN\\\u0015\"\u0005\t\u0005\u0018!\u0002\u001a/g9\u0002\u0004bB(\u00024\u0012\u0005!Q\u001d\u000b\u0005\u0003{\u00139\u000fC\u0004\u0003j\n\r\b\u0019A)\u0002\u0011%tG/\u001a:wC2D\u0001Ba\r\u00024\u0012\u0005!Q\u001e\u000b\u0005\u0003{\u0013y\u000fC\u0004\u00034\t-\b\u0019A-\t\u0011\tM\u00181\u0017C\u0001\u0005k\f!c[5oKNL7o\u0011:fI\u0016tG/[1mgR!\u0011Q\u0018B|\u0011\u001d\u0011IP!=A\u0002e\f1b\u0019:fI\u0016tG/[1mg\"A!Q`AZ\t\u0003\u0011y0A\nes:\fWn\u001c#C\u0007J,G-\u001a8uS\u0006d7\u000f\u0006\u0003\u0002>\u000e\u0005\u0001b\u0002B}\u0005w\u0004\r!\u001f\u0005\t\u0007\u000b\t\u0019\f\"\u0001\u0004\b\u0005)2\r\\8vI^\u000bGo\u00195De\u0016$WM\u001c;jC2\u001cH\u0003BA_\u0007\u0013AqA!?\u0004\u0004\u0001\u0007\u0011\u0010\u0003\u0005\u0004\u000e\u0005MF\u0011AB\b\u0003]\u0011W/\u001b7e/&$\b.T3tg\u0006<W\rS1oI2,'/\u0006\u0003\u0004\u0012\reA\u0003BB\n\u0007C!Ba!\u0006\u0004\u001cA!Q\tAB\f!\r)2\u0011\u0004\u0003\u0007/\r-!\u0019A\r\t\u0015\ru11BA\u0001\u0002\b\u0019y\"\u0001\u0006fm&$WM\\2fII\u0002b!a\u0007\u0002\"\r]\u0001\u0002CB\u0012\u0007\u0017\u0001\ra!\n\u0002\u000f!\fg\u000e\u001a7feB)1$Z4\u0004\u0018!A1\u0011FAZ\t\u0003\u0019Y#A\u0003ck&dG\r\u0006\u0002\u0004.A!Q\tAB\u0018!\u0015Y2\u0011GB\u001b\u0013\r\u0019\u0019\u0004\b\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u00047\r]\u0012bAB\u001d9\t!!)\u001f;f\u0011!\u0019i$a-\u0005\n\r}\u0012\u0001E4fiJ+\u0017/^5sK\u0012\u0004\u0016M]1n+\u0011\u0019\te!\u0012\u0015\r\r\r3qIB'!\r)2Q\t\u0003\u0007/\rm\"\u0019A\r\t\u0011\r%31\ba\u0001\u0007\u0017\nQ\u0001]1sC6\u0004RaGA\u0003\u0007\u0007Bqaa\u0014\u0004<\u0001\u0007A&A\u0005qCJ\fWNT1nK\"\"\u00111WB*!\u0011\u0019)f!\u0019\u000f\t\r]3QL\u0007\u0003\u00073R1aa\u0017\u0007\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0007?\u001aI&\u0001\nJ]R,'OZ1dKN#\u0018MY5mSRL\u0018\u0002BB2\u0007K\u0012\u0001\"\u0012<pYZLgn\u001a\u0006\u0005\u0007?\u001aI\u0006\u0003\u0005\u0004j\u0005}E\u0011AB6\u0003\u001d\u0011W/\u001b7eKJ,\"!!0\t\u0013\r=\u0014q\u0014C\u0001\u0005\rE\u0014!\u00063fM\u0006,H\u000e^'fgN\fw-\u001a%b]\u0012dWM\u001d\u000b\u0005\u0007_\u0019\u0019\bC\u0004\u0004v\r5\u0004\u0019A4\u0002\rI,7m\u001c:e\u0011)\u0019I(a(C\u0002\u0013\u0005!aK\u0001\u001d\t\u00163\u0015)\u0016'U?.Ke*R*J'~+e\n\u0012)P\u0013:#v,\u0016*M\u0011!\u0019i(a(!\u0002\u0013a\u0013!\b#F\r\u0006+F\nV0L\u0013:+5+S*`\u000b:#\u0005kT%O)~+&\u000b\u0014\u0011\t\u0015\r\u0005\u0015q\u0014b\u0001\n\u0003\u00111&A\u000eE\u000b\u001a\u000bU\u000b\u0014+`\u0017&sUiU%T?J+u)S(O?:\u000bU*\u0012\u0005\t\u0007\u000b\u000by\n)A\u0005Y\u0005aB)\u0012$B+2#vlS%O\u000bNK5k\u0018*F\u000f&{ej\u0018(B\u001b\u0016\u0003\u0003BCBE\u0003?\u0013\r\u0011\"\u0001\u0003\u0007\u0006AB)\u0012$B+2#v,\u0013(J)&\u000bEj\u0018)P'&#\u0016j\u0014(\t\u0011\r5\u0015q\u0014Q\u0001\n\u0011\u000b\u0011\u0004R#G\u0003VcEkX%O\u0013RK\u0015\tT0Q\u001fNKE+S(OA!Q1\u0011SAP\u0005\u0004%\tA\u0001-\u0002+\u0011+e)Q+M)~\u001bFk\u0014*B\u000f\u0016{F*\u0012,F\u0019\"A1QSAPA\u0003%\u0011,\u0001\fE\u000b\u001a\u000bU\u000b\u0014+`'R{%+Q$F?2+e+\u0012'!\u0011)\u0019I*a(\u0002\u0002\u0013%11T\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0004\u001eB!1qTBT\u001b\t\u0019\tK\u0003\u0003\u0004$\u000e\u0015\u0016\u0001\u00027b]\u001eT!Aa#\n\t\r%6\u0011\u0015\u0002\u0007\u001f\nTWm\u0019;)\t\u0005}51\u000b\u0015\u0005\u00033\u001b\u0019\u0006")
public class KinesisInputDStream<T>
extends ReceiverInputDStream<T> {
    private final String streamName;
    private final String endpointUrl;
    private final String regionName;
    private final KinesisInitialPosition initialPosition;
    private final String checkpointAppName;
    private final Duration checkpointInterval;
    private final StorageLevel _storageLevel;
    private final Function1<Record, T> messageHandler;
    private final SparkAWSCredentials kinesisCreds;
    private final Option<SparkAWSCredentials> dynamoDBCreds;
    private final Option<SparkAWSCredentials> cloudWatchCreds;
    private final ClassTag<T> evidence$1;

    public static Builder builder() {
        return KinesisInputDStream$.MODULE$.builder();
    }

    public String streamName() {
        return this.streamName;
    }

    public String endpointUrl() {
        return this.endpointUrl;
    }

    public String regionName() {
        return this.regionName;
    }

    public KinesisInitialPosition initialPosition() {
        return this.initialPosition;
    }

    public String checkpointAppName() {
        return this.checkpointAppName;
    }

    public Duration checkpointInterval() {
        return this.checkpointInterval;
    }

    public StorageLevel _storageLevel() {
        return this._storageLevel;
    }

    public Function1<Record, T> messageHandler() {
        return this.messageHandler;
    }

    public SparkAWSCredentials kinesisCreds() {
        return this.kinesisCreds;
    }

    public Option<SparkAWSCredentials> dynamoDBCreds() {
        return this.dynamoDBCreds;
    }

    public Option<SparkAWSCredentials> cloudWatchCreds() {
        return this.cloudWatchCreds;
    }

    public RDD<T> createBlockRDD(Time time, Seq<ReceivedBlockInfo> blockInfos) {
        Object object;
        boolean allBlocksHaveRanges = ((IterableLike)blockInfos.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.metadataOption(), Seq$.MODULE$.canBuildFrom())).forall((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.nonEmpty()));
        if (allBlocksHaveRanges) {
            BlockId[] blockIds = (BlockId[])((TraversableOnce)blockInfos.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.blockId(), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(BlockId.class));
            SequenceNumberRanges[] seqNumRanges = (SequenceNumberRanges[])((TraversableOnce)blockInfos.map((Function1 & Serializable & scala.Serializable)x$4 -> (SequenceNumberRanges)x$4.metadataOption().get(), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(SequenceNumberRanges.class));
            boolean[] isBlockIdValid = (boolean[])((TraversableOnce)blockInfos.map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.isBlockIdValid()), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Boolean());
            this.logDebug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Creating KinesisBackedBlockRDD for ").append(time).append(" with ").append(seqNumRanges.length).append(" ").append(new StringBuilder(20).append("seq number ranges: ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])seqNumRanges)).mkString(", ")).append(" ").toString()).toString());
            object = new KinesisBackedBlockRDD<T>(this.context().sc(), this.regionName(), this.endpointUrl(), blockIds, seqNumRanges, isBlockIdValid, this.messageHandler(), this.kinesisCreds(), KinesisReadConfigurations$.MODULE$.apply(this.ssc()), this.evidence$1);
        } else {
            this.logWarning((Function0 & Serializable & scala.Serializable)() -> "Kinesis sequence number information was not present with some block metadata, it may not be possible to recover from failures");
            object = super.createBlockRDD(time, blockInfos);
        }
        return object;
    }

    public Receiver<T> getReceiver() {
        return new KinesisReceiver<T>(this.streamName(), this.endpointUrl(), this.regionName(), this.initialPosition(), this.checkpointAppName(), this.checkpointInterval(), this._storageLevel(), this.messageHandler(), this.kinesisCreds(), this.dynamoDBCreds(), this.cloudWatchCreds());
    }

    public KinesisInputDStream(StreamingContext _ssc, String streamName, String endpointUrl, String regionName, KinesisInitialPosition initialPosition, String checkpointAppName, Duration checkpointInterval, StorageLevel _storageLevel, Function1<Record, T> messageHandler, SparkAWSCredentials kinesisCreds, Option<SparkAWSCredentials> dynamoDBCreds, Option<SparkAWSCredentials> cloudWatchCreds, ClassTag<T> evidence$1) {
        this.streamName = streamName;
        this.endpointUrl = endpointUrl;
        this.regionName = regionName;
        this.initialPosition = initialPosition;
        this.checkpointAppName = checkpointAppName;
        this.checkpointInterval = checkpointInterval;
        this._storageLevel = _storageLevel;
        this.messageHandler = messageHandler;
        this.kinesisCreds = kinesisCreds;
        this.dynamoDBCreds = dynamoDBCreds;
        this.cloudWatchCreds = cloudWatchCreds;
        this.evidence$1 = evidence$1;
        super(_ssc, evidence$1);
    }

    @InterfaceStability.Evolving
    public static class Builder {
        private Option<StreamingContext> streamingContext = None$.MODULE$;
        private Option<String> streamName = None$.MODULE$;
        private Option<String> checkpointAppName = None$.MODULE$;
        private Option<String> endpointUrl = None$.MODULE$;
        private Option<String> regionName = None$.MODULE$;
        private Option<KinesisInitialPosition> initialPosition = None$.MODULE$;
        private Option<Duration> checkpointInterval = None$.MODULE$;
        private Option<StorageLevel> storageLevel = None$.MODULE$;
        private Option<SparkAWSCredentials> kinesisCredsProvider = None$.MODULE$;
        private Option<SparkAWSCredentials> dynamoDBCredsProvider = None$.MODULE$;
        private Option<SparkAWSCredentials> cloudWatchCredsProvider = None$.MODULE$;

        private Option<StreamingContext> streamingContext() {
            return this.streamingContext;
        }

        private void streamingContext_$eq(Option<StreamingContext> x$1) {
            this.streamingContext = x$1;
        }

        private Option<String> streamName() {
            return this.streamName;
        }

        private void streamName_$eq(Option<String> x$1) {
            this.streamName = x$1;
        }

        private Option<String> checkpointAppName() {
            return this.checkpointAppName;
        }

        private void checkpointAppName_$eq(Option<String> x$1) {
            this.checkpointAppName = x$1;
        }

        private Option<String> endpointUrl() {
            return this.endpointUrl;
        }

        private void endpointUrl_$eq(Option<String> x$1) {
            this.endpointUrl = x$1;
        }

        private Option<String> regionName() {
            return this.regionName;
        }

        private void regionName_$eq(Option<String> x$1) {
            this.regionName = x$1;
        }

        private Option<KinesisInitialPosition> initialPosition() {
            return this.initialPosition;
        }

        private void initialPosition_$eq(Option<KinesisInitialPosition> x$1) {
            this.initialPosition = x$1;
        }

        private Option<Duration> checkpointInterval() {
            return this.checkpointInterval;
        }

        private void checkpointInterval_$eq(Option<Duration> x$1) {
            this.checkpointInterval = x$1;
        }

        private Option<StorageLevel> storageLevel() {
            return this.storageLevel;
        }

        private void storageLevel_$eq(Option<StorageLevel> x$1) {
            this.storageLevel = x$1;
        }

        private Option<SparkAWSCredentials> kinesisCredsProvider() {
            return this.kinesisCredsProvider;
        }

        private void kinesisCredsProvider_$eq(Option<SparkAWSCredentials> x$1) {
            this.kinesisCredsProvider = x$1;
        }

        private Option<SparkAWSCredentials> dynamoDBCredsProvider() {
            return this.dynamoDBCredsProvider;
        }

        private void dynamoDBCredsProvider_$eq(Option<SparkAWSCredentials> x$1) {
            this.dynamoDBCredsProvider = x$1;
        }

        private Option<SparkAWSCredentials> cloudWatchCredsProvider() {
            return this.cloudWatchCredsProvider;
        }

        private void cloudWatchCredsProvider_$eq(Option<SparkAWSCredentials> x$1) {
            this.cloudWatchCredsProvider = x$1;
        }

        public Builder streamingContext(StreamingContext ssc) {
            this.streamingContext_$eq((Option<StreamingContext>)Option$.MODULE$.apply((Object)ssc));
            return this;
        }

        public Builder streamingContext(JavaStreamingContext jssc) {
            this.streamingContext_$eq((Option<StreamingContext>)Option$.MODULE$.apply((Object)jssc.ssc()));
            return this;
        }

        public Builder streamName(String streamName) {
            this.streamName_$eq((Option<String>)Option$.MODULE$.apply((Object)streamName));
            return this;
        }

        public Builder checkpointAppName(String appName) {
            this.checkpointAppName_$eq((Option<String>)Option$.MODULE$.apply((Object)appName));
            return this;
        }

        public Builder endpointUrl(String url) {
            this.endpointUrl_$eq((Option<String>)Option$.MODULE$.apply((Object)url));
            return this;
        }

        public Builder regionName(String regionName) {
            this.regionName_$eq((Option<String>)Option$.MODULE$.apply((Object)regionName));
            return this;
        }

        public Builder initialPosition(KinesisInitialPosition initialPosition) {
            this.initialPosition_$eq((Option<KinesisInitialPosition>)Option$.MODULE$.apply((Object)initialPosition));
            return this;
        }

        public Builder initialPositionInStream(InitialPositionInStream initialPosition) {
            this.initialPosition_$eq((Option<KinesisInitialPosition>)Option$.MODULE$.apply((Object)KinesisInitialPositions.fromKinesisInitialPosition(initialPosition)));
            return this;
        }

        public Builder checkpointInterval(Duration interval) {
            this.checkpointInterval_$eq((Option<Duration>)Option$.MODULE$.apply((Object)interval));
            return this;
        }

        public Builder storageLevel(StorageLevel storageLevel) {
            this.storageLevel_$eq((Option<StorageLevel>)Option$.MODULE$.apply((Object)storageLevel));
            return this;
        }

        public Builder kinesisCredentials(SparkAWSCredentials credentials) {
            this.kinesisCredsProvider_$eq((Option<SparkAWSCredentials>)Option$.MODULE$.apply((Object)credentials));
            return this;
        }

        public Builder dynamoDBCredentials(SparkAWSCredentials credentials) {
            this.dynamoDBCredsProvider_$eq((Option<SparkAWSCredentials>)Option$.MODULE$.apply((Object)credentials));
            return this;
        }

        public Builder cloudWatchCredentials(SparkAWSCredentials credentials) {
            this.cloudWatchCredsProvider_$eq((Option<SparkAWSCredentials>)Option$.MODULE$.apply((Object)credentials));
            return this;
        }

        public <T> KinesisInputDStream<T> buildWithMessageHandler(Function1<Record, T> handler, ClassTag<T> evidence$2) {
            StreamingContext ssc = this.getRequiredParam(this.streamingContext(), "streamingContext");
            return new KinesisInputDStream<T>(ssc, this.getRequiredParam(this.streamName(), "streamName"), (String)this.endpointUrl().getOrElse((Function0 & Serializable & scala.Serializable)() -> KinesisInputDStream$.MODULE$.DEFAULT_KINESIS_ENDPOINT_URL()), (String)this.regionName().getOrElse((Function0 & Serializable & scala.Serializable)() -> KinesisInputDStream$.MODULE$.DEFAULT_KINESIS_REGION_NAME()), (KinesisInitialPosition)this.initialPosition().getOrElse((Function0 & Serializable & scala.Serializable)() -> KinesisInputDStream$.MODULE$.DEFAULT_INITIAL_POSITION()), this.getRequiredParam(this.checkpointAppName(), "checkpointAppName"), (Duration)this.checkpointInterval().getOrElse((Function0 & Serializable & scala.Serializable)() -> ssc.graph().batchDuration()), (StorageLevel)this.storageLevel().getOrElse((Function0 & Serializable & scala.Serializable)() -> KinesisInputDStream$.MODULE$.DEFAULT_STORAGE_LEVEL()), (Function1)ssc.sc().clean(handler, ssc.sc().clean$default$2()), (SparkAWSCredentials)this.kinesisCredsProvider().getOrElse((Function0 & Serializable & scala.Serializable)() -> DefaultCredentials$.MODULE$), this.dynamoDBCredsProvider(), this.cloudWatchCredsProvider(), evidence$2);
        }

        public KinesisInputDStream<byte[]> build() {
            return this.buildWithMessageHandler((Function1 & Serializable & scala.Serializable)record -> KinesisInputDStream$.MODULE$.defaultMessageHandler((Record)record), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
        }

        private <T> T getRequiredParam(Option<T> param, String paramName) {
            return (T)param.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new IllegalArgumentException(new StringBuilder(41).append("No value provided for required parameter ").append(paramName).toString());
            });
        }
    }
}

