/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.kinesis;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.services.kinesis.model.Record;
import java.io.Serializable;
import org.apache.spark.Partition;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkEnv$;
import org.apache.spark.TaskContext;
import org.apache.spark.rdd.BlockRDD;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockManager;
import org.apache.spark.streaming.kinesis.KinesisBackedBlockRDD$;
import org.apache.spark.streaming.kinesis.KinesisBackedBlockRDDPartition;
import org.apache.spark.streaming.kinesis.KinesisReadConfigurations;
import org.apache.spark.streaming.kinesis.KinesisSequenceRangeIterator;
import org.apache.spark.streaming.kinesis.SequenceNumberRange;
import org.apache.spark.streaming.kinesis.SequenceNumberRanges;
import org.apache.spark.streaming.kinesis.SparkAWSCredentials;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Iterator;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005mh!B\u0001\u0003\u0001\ta!!F&j]\u0016\u001c\u0018n\u001d\"bG.,GM\u00117pG.\u0014F\t\u0012\u0006\u0003\u0007\u0011\tqa[5oKNL7O\u0003\u0002\u0006\r\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sOV\u0011QBF\n\u0003\u00019\u00012a\u0004\n\u0015\u001b\u0005\u0001\"BA\t\u0007\u0003\r\u0011H\rZ\u0005\u0003'A\u0011\u0001B\u00117pG.\u0014F\t\u0012\t\u0003+Ya\u0001\u0001B\u0003\u0018\u0001\t\u0007\u0011DA\u0001U\u0007\u0001\t\"A\u0007\u0011\u0011\u0005mqR\"\u0001\u000f\u000b\u0003u\tQa]2bY\u0006L!a\b\u000f\u0003\u000f9{G\u000f[5oOB\u00111$I\u0005\u0003Eq\u00111!\u00118z\u0011!!\u0003A!A!\u0002\u0013)\u0013AA:d!\t1s%D\u0001\u0007\u0013\tAcA\u0001\u0007Ta\u0006\u00148nQ8oi\u0016DH\u000f\u0003\u0005+\u0001\t\u0015\r\u0011\"\u0001,\u0003)\u0011XmZ5p]:\u000bW.Z\u000b\u0002YA\u0011Q\u0006\u000e\b\u0003]I\u0002\"a\f\u000f\u000e\u0003AR!!\r\r\u0002\rq\u0012xn\u001c;?\u0013\t\u0019D$\u0001\u0004Qe\u0016$WMZ\u0005\u0003kY\u0012aa\u0015;sS:<'BA\u001a\u001d\u0011!A\u0004A!A!\u0002\u0013a\u0013a\u0003:fO&|gNT1nK\u0002B\u0001B\u000f\u0001\u0003\u0006\u0004%\taK\u0001\fK:$\u0007o\\5oiV\u0013H\u000e\u0003\u0005=\u0001\t\u0005\t\u0015!\u0003-\u00031)g\u000e\u001a9pS:$XK\u001d7!\u0011!q\u0004A!b\u0001\n\u0013y\u0014!C0cY>\u001c7.\u00133t+\u0005\u0001\u0005cA\u000eB\u0007&\u0011!\t\b\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003\t\u001ek\u0011!\u0012\u0006\u0003\r\u001a\tqa\u001d;pe\u0006<W-\u0003\u0002I\u000b\n9!\t\\8dW&#\u0007\"\u0003&\u0001\u0005\u0003\u0005\u000b\u0011\u0002!L\u0003)y&\r\\8dW&#7\u000fI\u0005\u0003\u0019J\t\u0001B\u00197pG.LEm\u001d\u0015\u0003\u0013:\u0003\"aG(\n\u0005Ac\"!\u0003;sC:\u001c\u0018.\u001a8u\u0011!\u0011\u0006A!b\u0001\n\u0003\u0019\u0016AF1se\u0006LxJZ:fc:+XNY3s%\u0006tw-Z:\u0016\u0003Q\u00032aG!V!\t1v+D\u0001\u0003\u0013\tA&A\u0001\u000bTKF,XM\\2f\u001dVl'-\u001a:SC:<Wm\u001d\u0005\t5\u0002\u0011\t\u0011)A\u0005)\u00069\u0012M\u001d:bs>37/Z9Ok6\u0014WM\u001d*b]\u001e,7\u000f\t\u0015\u00033:C\u0001\"\u0018\u0001\u0003\u0006\u0004%IAX\u0001\u000fSN\u0014En\\2l\u0013\u00124\u0016\r\\5e+\u0005y\u0006cA\u000eBAB\u00111$Y\u0005\u0003Er\u0011qAQ8pY\u0016\fg\u000e\u0003\u0005e\u0001\t\u0005\t\u0015!\u0003`\u0003=I7O\u00117pG.LEMV1mS\u0012\u0004\u0003FA2O\u0011!9\u0007A!b\u0001\n\u0003A\u0017AD7fgN\fw-\u001a%b]\u0012dWM]\u000b\u0002SB!1D\u001b7\u0015\u0013\tYGDA\u0005Gk:\u001cG/[8ocA\u0011Qn^\u0007\u0002]*\u0011q\u000e]\u0001\u0006[>$W\r\u001c\u0006\u0003\u0007ET!A]:\u0002\u0011M,'O^5dKNT!\u0001^;\u0002\u0013\u0005l\u0017M_8oC^\u001c(\"\u0001<\u0002\u0007\r|W.\u0003\u0002y]\n1!+Z2pe\u0012D\u0001B\u001f\u0001\u0003\u0002\u0003\u0006I![\u0001\u0010[\u0016\u001c8/Y4f\u0011\u0006tG\r\\3sA!AA\u0010\u0001BC\u0002\u0013\u0005Q0\u0001\u0007lS:,7/[:De\u0016$7/F\u0001\u007f!\t1v0C\u0002\u0002\u0002\t\u00111c\u00159be.\fukU\"sK\u0012,g\u000e^5bYND\u0011\"!\u0002\u0001\u0005\u0003\u0005\u000b\u0011\u0002@\u0002\u001b-Lg.Z:jg\u000e\u0013X\rZ:!\u0011)\tI\u0001\u0001BC\u0002\u0013\u0005\u00111B\u0001\u0013W&tWm]5t%\u0016\fGmQ8oM&<7/\u0006\u0002\u0002\u000eA\u0019a+a\u0004\n\u0007\u0005E!AA\rLS:,7/[:SK\u0006$7i\u001c8gS\u001e,(/\u0019;j_:\u001c\bBCA\u000b\u0001\t\u0005\t\u0015!\u0003\u0002\u000e\u0005\u00192.\u001b8fg&\u001c(+Z1e\u0007>tg-[4tA!Q\u0011\u0011\u0004\u0001\u0003\u0004\u0003\u0006Y!a\u0007\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$\u0013\u0007E\u0003\u0002\u001e\u0005\rB#\u0004\u0002\u0002 )\u0019\u0011\u0011\u0005\u000f\u0002\u000fI,g\r\\3di&!\u0011QEA\u0010\u0005!\u0019E.Y:t)\u0006<\u0007bBA\u0015\u0001\u0011\u0005\u00111F\u0001\u0007y%t\u0017\u000e\u001e \u0015)\u00055\u00121GA\u001b\u0003o\tI$a\u000f\u0002>\u0005}\u0012\u0011IA\")\u0011\ty#!\r\u0011\u0007Y\u0003A\u0003\u0003\u0005\u0002\u001a\u0005\u001d\u00029AA\u000e\u0011\u0019!\u0013q\u0005a\u0001K!1!&a\nA\u00021BaAOA\u0014\u0001\u0004a\u0003B\u0002 \u0002(\u0001\u0007\u0001\t\u0003\u0004S\u0003O\u0001\r\u0001\u0016\u0005\t;\u0006\u001d\u0002\u0013!a\u0001?\"Aq-a\n\u0011\u0002\u0003\u0007\u0011\u000e\u0003\u0005}\u0003O\u0001\n\u00111\u0001\u007f\u0011)\tI!a\n\u0011\u0002\u0003\u0007\u0011Q\u0002\u0005\b\u0003\u000f\u0002A\u0011IA%\u0003\u001dI7OV1mS\u0012$\u0012\u0001\u0019\u0005\b\u0003\u001b\u0002A\u0011IA(\u000359W\r\u001e)beRLG/[8ogV\u0011\u0011\u0011\u000b\t\u00057\u0005\u000b\u0019\u0006E\u0002'\u0003+J1!a\u0016\u0007\u0005%\u0001\u0016M\u001d;ji&|g\u000eC\u0004\u0002\\\u0001!\t%!\u0018\u0002\u000f\r|W\u000e];uKR1\u0011qLA9\u0003k\u0002R!!\u0019\u0002lQqA!a\u0019\u0002h9\u0019q&!\u001a\n\u0003uI1!!\u001b\u001d\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u001c\u0002p\tA\u0011\n^3sCR|'OC\u0002\u0002jqA\u0001\"a\u001d\u0002Z\u0001\u0007\u00111K\u0001\u0006gBd\u0017\u000e\u001e\u0005\t\u0003o\nI\u00061\u0001\u0002z\u000591m\u001c8uKb$\bc\u0001\u0014\u0002|%\u0019\u0011Q\u0010\u0004\u0003\u0017Q\u000b7o[\"p]R,\u0007\u0010^\u0004\u000b\u0003\u0003\u0013\u0011\u0011!E\u0001\u0005\u0005\r\u0015!F&j]\u0016\u001c\u0018n\u001d\"bG.,GM\u00117pG.\u0014F\t\u0012\t\u0004-\u0006\u0015e!C\u0001\u0003\u0003\u0003E\tAAAD'\u0019\t))!#\u0002\u0010B\u00191$a#\n\u0007\u00055ED\u0001\u0004B]f\u0014VM\u001a\t\u00047\u0005E\u0015bAAJ9\ta1+\u001a:jC2L'0\u00192mK\"A\u0011\u0011FAC\t\u0003\t9\n\u0006\u0002\u0002\u0004\"Q\u00111TAC#\u0003%\t!!(\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00137+\u0011\ty*!.\u0016\u0005\u0005\u0005&fA0\u0002$.\u0012\u0011Q\u0015\t\u0005\u0003O\u000b\t,\u0004\u0002\u0002**!\u00111VAW\u0003%)hn\u00195fG.,GMC\u0002\u00020r\t!\"\u00198o_R\fG/[8o\u0013\u0011\t\u0019,!+\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r\u0002\u0004\u0018\u00033\u0013\r!\u0007\u0005\u000b\u0003s\u000b))%A\u0005\u0002\u0005m\u0016a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$s'\u0006\u0003\u0002>\u0006-WCAA`U\u0011\t\t-a)\u0011\u000bmQG.a1\u0011\tm\t\u0015Q\u0019\t\u00047\u0005\u001d\u0017bAAe9\t!!)\u001f;f\t\u00199\u0012q\u0017b\u00013!Q\u0011qZAC#\u0003%\t!!5\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00139+\u0011\t\u0019.a6\u0016\u0005\u0005U'f\u0001@\u0002$\u00121q#!4C\u0002eA!\"a7\u0002\u0006F\u0005I\u0011AAo\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%sU!\u0011q\\Ar+\t\t\tO\u000b\u0003\u0002\u000e\u0005\rFAB\f\u0002Z\n\u0007\u0011\u0004\u0003\u0006\u0002h\u0006\u0015\u0015\u0011!C\u0005\u0003S\f1B]3bIJ+7o\u001c7wKR\u0011\u00111\u001e\t\u0005\u0003[\f90\u0004\u0002\u0002p*!\u0011\u0011_Az\u0003\u0011a\u0017M\\4\u000b\u0005\u0005U\u0018\u0001\u00026bm\u0006LA!!?\u0002p\n1qJ\u00196fGR\u0004")
public class KinesisBackedBlockRDD<T>
extends BlockRDD<T> {
    private final String regionName;
    private final String endpointUrl;
    private final transient SequenceNumberRanges[] arrayOfseqNumberRanges;
    private final transient boolean[] isBlockIdValid;
    private final Function1<Record, T> messageHandler;
    private final SparkAWSCredentials kinesisCreds;
    private final KinesisReadConfigurations kinesisReadConfigs;
    private final ClassTag<T> evidence$1;

    public static <T> KinesisReadConfigurations $lessinit$greater$default$9() {
        return KinesisBackedBlockRDD$.MODULE$.$lessinit$greater$default$9();
    }

    public static <T> SparkAWSCredentials $lessinit$greater$default$8() {
        return KinesisBackedBlockRDD$.MODULE$.$lessinit$greater$default$8();
    }

    public static <T> Function1<Record, byte[]> $lessinit$greater$default$7() {
        return KinesisBackedBlockRDD$.MODULE$.$lessinit$greater$default$7();
    }

    public static <T> boolean[] $lessinit$greater$default$6() {
        return KinesisBackedBlockRDD$.MODULE$.$lessinit$greater$default$6();
    }

    public String regionName() {
        return this.regionName;
    }

    public String endpointUrl() {
        return this.endpointUrl;
    }

    private BlockId[] _blockIds() {
        return super.blockIds();
    }

    public SequenceNumberRanges[] arrayOfseqNumberRanges() {
        return this.arrayOfseqNumberRanges;
    }

    private boolean[] isBlockIdValid() {
        return this.isBlockIdValid;
    }

    public Function1<Record, T> messageHandler() {
        return this.messageHandler;
    }

    public SparkAWSCredentials kinesisCreds() {
        return this.kinesisCreds;
    }

    public KinesisReadConfigurations kinesisReadConfigs() {
        return this.kinesisReadConfigs;
    }

    public boolean isValid() {
        return true;
    }

    public Partition[] getPartitions() {
        return (Partition[])Array$.MODULE$.tabulate(this._blockIds().length, (Function1 & Serializable & scala.Serializable)i -> KinesisBackedBlockRDD.$anonfun$getPartitions$1(this, BoxesRunTime.unboxToInt((Object)i)), ClassTag$.MODULE$.apply(Partition.class));
    }

    public Iterator<T> compute(Partition split, TaskContext context) {
        BlockManager blockManager = SparkEnv$.MODULE$.get().blockManager();
        KinesisBackedBlockRDDPartition partition = (KinesisBackedBlockRDDPartition)split;
        BlockId blockId = partition.blockId();
        return partition.isBlockIdValid() ? (Iterator)this.getBlockFromBlockManager$1(blockManager, blockId).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.getBlockFromKinesis$1(partition)) : this.getBlockFromKinesis$1(partition);
    }

    public static final /* synthetic */ KinesisBackedBlockRDDPartition $anonfun$getPartitions$1(KinesisBackedBlockRDD $this, int i) {
        boolean isValid = $this.isBlockIdValid().length == 0 ? true : $this.isBlockIdValid()[i];
        return new KinesisBackedBlockRDDPartition(i, $this._blockIds()[i], isValid, $this.arrayOfseqNumberRanges()[i]);
    }

    private final Option getBlockFromBlockManager$1(BlockManager blockManager$1, BlockId blockId$1) {
        this.logDebug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Read partition data of ").append((Object)this).append(" from block manager, block ").append(blockId$1).toString());
        return blockManager$1.get(blockId$1, this.evidence$1).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.data());
    }

    private final Iterator getBlockFromKinesis$1(KinesisBackedBlockRDDPartition partition$1) {
        AWSCredentials credentials = this.kinesisCreds().provider().getCredentials();
        return partition$1.seqNumberRanges().ranges().iterator().flatMap((Function1 & Serializable & scala.Serializable)range -> new KinesisSequenceRangeIterator(credentials, this.endpointUrl(), this.regionName(), (SequenceNumberRange)range, this.kinesisReadConfigs()).map(this.messageHandler()));
    }

    public KinesisBackedBlockRDD(SparkContext sc, String regionName, String endpointUrl, BlockId[] _blockIds, SequenceNumberRanges[] arrayOfseqNumberRanges, boolean[] isBlockIdValid, Function1<Record, T> messageHandler, SparkAWSCredentials kinesisCreds, KinesisReadConfigurations kinesisReadConfigs, ClassTag<T> evidence$1) {
        this.regionName = regionName;
        this.endpointUrl = endpointUrl;
        this.arrayOfseqNumberRanges = arrayOfseqNumberRanges;
        this.isBlockIdValid = isBlockIdValid;
        this.messageHandler = messageHandler;
        this.kinesisCreds = kinesisCreds;
        this.kinesisReadConfigs = kinesisReadConfigs;
        this.evidence$1 = evidence$1;
        super(sc, _blockIds, evidence$1);
        Predef$.MODULE$.require(_blockIds.length == arrayOfseqNumberRanges.length, (Function0 & Serializable & scala.Serializable)() -> "Number of blockIds is not equal to the number of sequence number ranges");
    }
}

