/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.kinesis;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.TestServer;
import org.apache.spark.streaming.TestSuiteBase;
import org.apache.spark.streaming.dstream.DStream;
import org.apache.spark.streaming.kinesis.BasicCredentials;
import org.apache.spark.streaming.kinesis.DefaultCredentials$;
import org.apache.spark.streaming.kinesis.STSCredentials;
import org.apache.spark.streaming.kinesis.SparkAWSCredentials;
import org.apache.spark.streaming.kinesis.SparkAWSCredentials$;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfter;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import org.scalatest.concurrent.PatienceConfiguration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.Seq;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001U2A!\u0001\u0002\u0001\u001b\ty2\u000b]1sW\u0006;6k\u0011:fI\u0016tG/[1mg\n+\u0018\u000e\u001c3feN+\u0018\u000e^3\u000b\u0005\r!\u0011aB6j]\u0016\u001c\u0018n\u001d\u0006\u0003\u000b\u0019\t\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001\u001dI\u0001\"a\u0004\t\u000e\u0003\u0019I!!\u0005\u0004\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f!\t\u0019B#D\u0001\u0005\u0013\t)BAA\u0007UKN$8+^5uK\n\u000b7/\u001a\u0005\u0006/\u0001!\t\u0001G\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003e\u0001\"A\u0007\u0001\u000e\u0003\tAQ\u0001\b\u0001\u0005\nu\tqAY;jY\u0012,'/F\u0001\u001f!\ty\"E\u0004\u0002\u001bA%\u0011\u0011EA\u0001\u0014'B\f'o[!X'\u000e\u0013X\rZ3oi&\fGn]\u0005\u0003G\u0011\u0012qAQ;jY\u0012,'O\u0003\u0002\"\u0005!9a\u0005\u0001b\u0001\n\u00139\u0013A\u00032bg&\u001c7I]3egV\t\u0001\u0006\u0005\u0002\u001bS%\u0011!F\u0001\u0002\u0011\u0005\u0006\u001c\u0018nY\"sK\u0012,g\u000e^5bYNDa\u0001\f\u0001!\u0002\u0013A\u0013a\u00032bg&\u001c7I]3eg\u0002BqA\f\u0001C\u0002\u0013%q&\u0001\u0005tiN\u001c%/\u001a3t+\u0005\u0001\u0004C\u0001\u000e2\u0013\t\u0011$A\u0001\bT)N\u001b%/\u001a3f]RL\u0017\r\\:\t\rQ\u0002\u0001\u0015!\u00031\u0003%\u0019Ho]\"sK\u0012\u001c\b\u0005")
public class SparkAWSCredentialsBuilderSuite
extends SparkFunSuite
implements TestSuiteBase {
    private final BasicCredentials basicCreds;
    private final STSCredentials stsCreds;
    private String checkpointDir;
    private final SparkConf conf;
    private final PatienceConfiguration.Timeout eventuallyTimeout;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    private volatile boolean bitmap$0;

    public String framework() {
        return TestSuiteBase.framework$((TestSuiteBase)this);
    }

    public String master() {
        return TestSuiteBase.master$((TestSuiteBase)this);
    }

    public Duration batchDuration() {
        return TestSuiteBase.batchDuration$((TestSuiteBase)this);
    }

    public int numInputPartitions() {
        return TestSuiteBase.numInputPartitions$((TestSuiteBase)this);
    }

    public int maxWaitTimeMillis() {
        return TestSuiteBase.maxWaitTimeMillis$((TestSuiteBase)this);
    }

    public boolean useManualClock() {
        return TestSuiteBase.useManualClock$((TestSuiteBase)this);
    }

    public boolean actuallyWait() {
        return TestSuiteBase.actuallyWait$((TestSuiteBase)this);
    }

    public void beforeFunction() {
        TestSuiteBase.beforeFunction$((TestSuiteBase)this);
    }

    public void afterFunction() {
        TestSuiteBase.afterFunction$((TestSuiteBase)this);
    }

    public <R> R withStreamingContext(StreamingContext ssc, Function1<StreamingContext, R> block) {
        return (R)TestSuiteBase.withStreamingContext$((TestSuiteBase)this, (StreamingContext)ssc, block);
    }

    public <R> R withTestServer(TestServer testServer, Function1<TestServer, R> block) {
        return (R)TestSuiteBase.withTestServer$((TestSuiteBase)this, (TestServer)testServer, block);
    }

    public <U, V> StreamingContext setupStreams(Seq<Seq<U>> input, Function1<DStream<U>, DStream<V>> operation, int numPartitions, ClassTag<U> evidence$4, ClassTag<V> evidence$5) {
        return TestSuiteBase.setupStreams$((TestSuiteBase)this, input, operation, (int)numPartitions, evidence$4, evidence$5);
    }

    public <U, V, W> StreamingContext setupStreams(Seq<Seq<U>> input1, Seq<Seq<V>> input2, Function2<DStream<U>, DStream<V>, DStream<W>> operation, ClassTag<U> evidence$6, ClassTag<V> evidence$7, ClassTag<W> evidence$8) {
        return TestSuiteBase.setupStreams$((TestSuiteBase)this, input1, input2, operation, evidence$6, evidence$7, evidence$8);
    }

    public <V> Seq<Seq<V>> runStreams(StreamingContext ssc, int numBatches, int numExpectedOutput, Function0<BoxedUnit> preStop, ClassTag<V> evidence$9) {
        return TestSuiteBase.runStreams$((TestSuiteBase)this, (StreamingContext)ssc, (int)numBatches, (int)numExpectedOutput, preStop, evidence$9);
    }

    public <V> Seq<Seq<Seq<V>>> runStreamsWithPartitions(StreamingContext ssc, int numBatches, int numExpectedOutput, Function0<BoxedUnit> preStop, ClassTag<V> evidence$10) {
        return TestSuiteBase.runStreamsWithPartitions$((TestSuiteBase)this, (StreamingContext)ssc, (int)numBatches, (int)numExpectedOutput, preStop, evidence$10);
    }

    public <V> void verifyOutput(Seq<Seq<V>> output, Seq<Seq<V>> expectedOutput, boolean useSet, ClassTag<V> evidence$11) {
        TestSuiteBase.verifyOutput$((TestSuiteBase)this, output, expectedOutput, (boolean)useSet, evidence$11);
    }

    public <U, V> void testOperation(Seq<Seq<U>> input, Function1<DStream<U>, DStream<V>> operation, Seq<Seq<V>> expectedOutput, boolean useSet, ClassTag<U> evidence$12, ClassTag<V> evidence$13) {
        TestSuiteBase.testOperation$((TestSuiteBase)this, input, operation, expectedOutput, (boolean)useSet, evidence$12, evidence$13);
    }

    public <U, V> void testOperation(Seq<Seq<U>> input, Function1<DStream<U>, DStream<V>> operation, Seq<Seq<V>> expectedOutput, int numBatches, boolean useSet, ClassTag<U> evidence$14, ClassTag<V> evidence$15) {
        TestSuiteBase.testOperation$((TestSuiteBase)this, input, operation, expectedOutput, (int)numBatches, (boolean)useSet, evidence$14, evidence$15);
    }

    public <U, V, W> void testOperation(Seq<Seq<U>> input1, Seq<Seq<V>> input2, Function2<DStream<U>, DStream<V>, DStream<W>> operation, Seq<Seq<W>> expectedOutput, boolean useSet, ClassTag<U> evidence$16, ClassTag<V> evidence$17, ClassTag<W> evidence$18) {
        TestSuiteBase.testOperation$((TestSuiteBase)this, input1, input2, operation, expectedOutput, (boolean)useSet, evidence$16, evidence$17, evidence$18);
    }

    public <U, V, W> void testOperation(Seq<Seq<U>> input1, Seq<Seq<V>> input2, Function2<DStream<U>, DStream<V>, DStream<W>> operation, Seq<Seq<W>> expectedOutput, int numBatches, boolean useSet, ClassTag<U> evidence$19, ClassTag<V> evidence$20, ClassTag<W> evidence$21) {
        TestSuiteBase.testOperation$((TestSuiteBase)this, input1, input2, operation, expectedOutput, (int)numBatches, (boolean)useSet, evidence$19, evidence$20, evidence$21);
    }

    public <U, V> boolean testOperation$default$4() {
        return TestSuiteBase.testOperation$default$4$((TestSuiteBase)this);
    }

    public <U, V> int setupStreams$default$3() {
        return TestSuiteBase.setupStreams$default$3$((TestSuiteBase)this);
    }

    public <V> Function0<BoxedUnit> runStreamsWithPartitions$default$4() {
        return TestSuiteBase.runStreamsWithPartitions$default$4$((TestSuiteBase)this);
    }

    public <V> Function0<BoxedUnit> runStreams$default$4() {
        return TestSuiteBase.runStreams$default$4$((TestSuiteBase)this);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$runTest(String testName, Args args) {
        return FunSuiteLike.runTest$((FunSuiteLike)this, (String)testName, (Args)args);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$run(Option testName, Args args) {
        return BeforeAndAfterAll.run$((BeforeAndAfterAll)this, (Option)testName, (Args)args);
    }

    public void before(Function0<Object> fun, Position pos) {
        BeforeAndAfter.before$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public void after(Function0<Object> fun, Position pos) {
        BeforeAndAfter.after$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfter.runTest$((BeforeAndAfter)this, (String)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfter.run$((BeforeAndAfter)this, testName, (Args)args);
    }

    private String checkpointDir$lzycompute() {
        SparkAWSCredentialsBuilderSuite sparkAWSCredentialsBuilderSuite = this;
        synchronized (sparkAWSCredentialsBuilderSuite) {
            if (!this.bitmap$0) {
                this.checkpointDir = TestSuiteBase.checkpointDir$((TestSuiteBase)this);
                this.bitmap$0 = true;
            }
        }
        return this.checkpointDir;
    }

    public String checkpointDir() {
        return !this.bitmap$0 ? this.checkpointDir$lzycompute() : this.checkpointDir;
    }

    public SparkConf conf() {
        return this.conf;
    }

    public PatienceConfiguration.Timeout eventuallyTimeout() {
        return this.eventuallyTimeout;
    }

    public void org$apache$spark$streaming$TestSuiteBase$_setter_$conf_$eq(SparkConf x$1) {
        this.conf = x$1;
    }

    public void org$apache$spark$streaming$TestSuiteBase$_setter_$eventuallyTimeout_$eq(PatienceConfiguration.Timeout x$1) {
        this.eventuallyTimeout = x$1;
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    private SparkAWSCredentials.Builder builder() {
        return SparkAWSCredentials$.MODULE$.builder();
    }

    private BasicCredentials basicCreds() {
        return this.basicCreds;
    }

    private STSCredentials stsCreds() {
        return this.stsCreds;
    }

    public SparkAWSCredentialsBuilderSuite() {
        BeforeAndAfter.$init$((BeforeAndAfter)this);
        TestSuiteBase.$init$((TestSuiteBase)this);
        this.basicCreds = new BasicCredentials("a-very-nice-access-key", "a-very-nice-secret-key");
        this.stsCreds = new STSCredentials("a-very-nice-role-arn", "a-very-nice-secret-key", Option$.MODULE$.apply((Object)"a-very-nice-external-id"), (SparkAWSCredentials)this.basicCreds());
        this.test("should build DefaultCredentials when given no params", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SparkAWSCredentials $org_scalatest_assert_macro_left = this.builder().build();
            DefaultCredentials$ $org_scalatest_assert_macro_right = DefaultCredentials$.MODULE$;
            SparkAWSCredentials sparkAWSCredentials = $org_scalatest_assert_macro_left;
            DefaultCredentials$ defaultCredentials$ = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(sparkAWSCredentials != null ? !sparkAWSCredentials.equals(defaultCredentials$) : defaultCredentials$ != null), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkAWSCredentialsBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 37));
        }, new Position("SparkAWSCredentialsBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 36));
        this.test("should build BasicCredentials", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> this.assertResult(this.basicCreds(), this.builder().basicCredentials(this.basicCreds().awsAccessKeyId(), this.basicCreds().awsSecretKey()).build(), Prettifier$.MODULE$.default(), new Position("SparkAWSCredentialsBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 41)), new Position("SparkAWSCredentialsBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 40));
        this.test("should build STSCredentials", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            None$ x$1 = None$.MODULE$;
            DefaultCredentials$ x$2 = DefaultCredentials$.MODULE$;
            String x$3 = this.stsCreds().copy$default$1();
            String x$4 = this.stsCreds().copy$default$2();
            this.assertResult(this.stsCreds().copy(x$3, x$4, (Option)x$1, (SparkAWSCredentials)x$2), this.builder().stsCredentials(this.stsCreds().stsRoleArn(), this.stsCreds().stsSessionName()).build(), Prettifier$.MODULE$.default(), new Position("SparkAWSCredentialsBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 49));
            DefaultCredentials$ x$5 = DefaultCredentials$.MODULE$;
            String x$6 = this.stsCreds().copy$default$1();
            String x$7 = this.stsCreds().copy$default$2();
            Option x$8 = this.stsCreds().copy$default$3();
            this.assertResult(this.stsCreds().copy(x$6, x$7, x$8, (SparkAWSCredentials)x$5), this.builder().stsCredentials(this.stsCreds().stsRoleArn(), this.stsCreds().stsSessionName(), (String)this.stsCreds().stsExternalId().get()).build(), Prettifier$.MODULE$.default(), new Position("SparkAWSCredentialsBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 54));
            None$ x$9 = None$.MODULE$;
            String x$10 = this.stsCreds().copy$default$1();
            String x$11 = this.stsCreds().copy$default$2();
            SparkAWSCredentials x$12 = this.stsCreds().copy$default$4();
            this.assertResult(this.stsCreds().copy(x$10, x$11, (Option)x$9, x$12), this.builder().stsCredentials(this.stsCreds().stsRoleArn(), this.stsCreds().stsSessionName()).basicCredentials(this.basicCreds().awsAccessKeyId(), this.basicCreds().awsSecretKey()).build(), Prettifier$.MODULE$.default(), new Position("SparkAWSCredentialsBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
            this.assertResult(this.stsCreds(), this.builder().stsCredentials(this.stsCreds().stsRoleArn(), this.stsCreds().stsSessionName(), (String)this.stsCreds().stsExternalId().get()).basicCredentials(this.basicCreds().awsAccessKeyId(), this.basicCreds().awsSecretKey()).build(), Prettifier$.MODULE$.default(), new Position("SparkAWSCredentialsBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
            return this.assertResult(this.stsCreds(), this.builder().basicCredentials(this.basicCreds().awsAccessKeyId(), this.basicCreds().awsSecretKey()).stsCredentials(this.stsCreds().stsRoleArn(), this.stsCreds().stsSessionName(), (String)this.stsCreds().stsExternalId().get()).build(), Prettifier$.MODULE$.default(), new Position("SparkAWSCredentialsBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 77));
        }, new Position("SparkAWSCredentialsBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 47));
        this.test("SparkAWSCredentials classes should be serializable", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            this.assertResult(this.basicCreds(), Utils$.MODULE$.deserialize(Utils$.MODULE$.serialize((Object)this.basicCreds())), Prettifier$.MODULE$.default(), new Position("SparkAWSCredentialsBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 88));
            this.assertResult(this.stsCreds(), Utils$.MODULE$.deserialize(Utils$.MODULE$.serialize((Object)this.stsCreds())), Prettifier$.MODULE$.default(), new Position("SparkAWSCredentialsBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91));
            DefaultCredentials$ x$13 = DefaultCredentials$.MODULE$;
            String x$14 = this.stsCreds().copy$default$1();
            String x$15 = this.stsCreds().copy$default$2();
            Option x$16 = this.stsCreds().copy$default$3();
            STSCredentials stsDefaultCreds = this.stsCreds().copy(x$14, x$15, x$16, (SparkAWSCredentials)x$13);
            return this.assertResult(stsDefaultCreds, Utils$.MODULE$.deserialize(Utils$.MODULE$.serialize((Object)stsDefaultCreds)), Prettifier$.MODULE$.default(), new Position("SparkAWSCredentialsBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 96));
        }, new Position("SparkAWSCredentialsBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 87));
    }
}

