/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.kinesis;

import com.amazonaws.services.kinesis.clientlibrary.interfaces.IRecordProcessorCheckpointer;
import java.io.Serializable;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.TestServer;
import org.apache.spark.streaming.TestSuiteBase;
import org.apache.spark.streaming.dstream.DStream;
import org.apache.spark.streaming.kinesis.KinesisCheckpointer;
import org.apache.spark.streaming.kinesis.KinesisReceiver;
import org.apache.spark.util.Clock;
import org.apache.spark.util.ManualClock;
import org.mockito.Matchers;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfter;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.FunSuiteLike;
import org.scalatest.PrivateMethodTester;
import org.scalatest.PrivateMethodTester$PrivateMethod$;
import org.scalatest.Status;
import org.scalatest.Tag;
import org.scalatest.concurrent.AbstractPatienceConfiguration;
import org.scalatest.concurrent.AbstractPatienceConfiguration$PatienceConfig$;
import org.scalatest.concurrent.Eventually;
import org.scalatest.concurrent.PatienceConfiguration;
import org.scalatest.concurrent.ScaledTimeSpans;
import org.scalatest.mockito.MockitoSugar;
import org.scalatest.time.Span;
import org.scalatest.time.Span$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Symbol;
import scala.collection.Seq;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005-d\u0001B\u0001\u0003\u00015\u0011\u0001dS5oKNL7o\u00115fG.\u0004x.\u001b8uKJ\u001cV/\u001b;f\u0015\t\u0019A!A\u0004lS:,7/[:\u000b\u0005\u00151\u0011!C:ue\u0016\fW.\u001b8h\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\b\u00019\u0011bC\b\u0012&!\ty\u0001#D\u0001\u0007\u0013\t\tbAA\u0007Ta\u0006\u00148NR;o'VLG/\u001a\t\u0003'Qi\u0011\u0001B\u0005\u0003+\u0011\u0011Q\u0002V3tiN+\u0018\u000e^3CCN,\u0007CA\f\u001d\u001b\u0005A\"BA\r\u001b\u0003\u001diwnY6ji>T!a\u0007\u0006\u0002\u0013M\u001c\u0017\r\\1uKN$\u0018BA\u000f\u0019\u00051iunY6ji>\u001cVoZ1s!\ty\u0002%D\u0001\u001b\u0013\t\t#D\u0001\nCK\u001a|'/Z!oI\u00063G/\u001a:FC\u000eD\u0007CA\u0010$\u0013\t!#DA\nQe&4\u0018\r^3NKRDw\u000e\u001a+fgR,'\u000f\u0005\u0002'S5\tqE\u0003\u0002)5\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\u0005):#AC#wK:$X/\u00197ms\")A\u0006\u0001C\u0001[\u00051A(\u001b8jiz\"\u0012A\f\t\u0003_\u0001i\u0011A\u0001\u0005\bc\u0001\u0011\r\u0011\"\u00033\u0003!9xN]6fe&#W#A\u001a\u0011\u0005QJT\"A\u001b\u000b\u0005Y:\u0014\u0001\u00027b]\u001eT\u0011\u0001O\u0001\u0005U\u00064\u0018-\u0003\u0002;k\t11\u000b\u001e:j]\u001eDa\u0001\u0010\u0001!\u0002\u0013\u0019\u0014!C<pe.,'/\u00133!\u0011\u001dq\u0004A1A\u0005\nI\nqa\u001d5be\u0012LE\r\u0003\u0004A\u0001\u0001\u0006IaM\u0001\tg\"\f'\u000fZ%eA!9!\t\u0001b\u0001\n\u0013\u0011\u0014AB:fc:+X\u000e\u0003\u0004E\u0001\u0001\u0006IaM\u0001\bg\u0016\fh*^7!\u0011\u001d1\u0005A1A\u0005\nI\n1b\u001c;iKJ\u001cV-\u001d(v[\"1\u0001\n\u0001Q\u0001\nM\nAb\u001c;iKJ\u001cV-\u001d(v[\u0002BqA\u0013\u0001C\u0002\u0013%1*\u0001\ndQ\u0016\u001c7\u000e]8j]RLe\u000e^3sm\u0006dW#\u0001'\u0011\u0005Mi\u0015B\u0001(\u0005\u0005!!UO]1uS>t\u0007B\u0002)\u0001A\u0003%A*A\ndQ\u0016\u001c7\u000e]8j]RLe\u000e^3sm\u0006d\u0007\u0005C\u0004S\u0001\t\u0007I\u0011B*\u0002\u0015M|W.Z*fc:+X.F\u0001U!\r)\u0006lM\u0007\u0002-*\tq+A\u0003tG\u0006d\u0017-\u0003\u0002Z-\n!1k\\7f\u0011\u0019Y\u0006\u0001)A\u0005)\u0006Y1o\\7f'\u0016\fh*^7!\u0011\u001di\u0006A1A\u0005\nM\u000bqb]8nK>#\b.\u001a:TKFtU/\u001c\u0005\u0007?\u0002\u0001\u000b\u0011\u0002+\u0002!M|W.Z(uQ\u0016\u00148+Z9Ok6\u0004\u0003\"C1\u0001\u0001\u0004\u0005\r\u0011\"\u0003c\u00031\u0011XmY3jm\u0016\u0014Xj\\2l+\u0005\u0019\u0007cA\u0018eM&\u0011QM\u0001\u0002\u0010\u0017&tWm]5t%\u0016\u001cW-\u001b<feB\u0019QkZ5\n\u0005!4&!B!se\u0006L\bCA+k\u0013\tYgK\u0001\u0003CsR,\u0007\"C7\u0001\u0001\u0004\u0005\r\u0011\"\u0003o\u0003A\u0011XmY3jm\u0016\u0014Xj\\2l?\u0012*\u0017\u000f\u0006\u0002peB\u0011Q\u000b]\u0005\u0003cZ\u0013A!\u00168ji\"91\u000f\\A\u0001\u0002\u0004\u0019\u0017a\u0001=%c!IQ\u000f\u0001a\u0001\u0002\u0003\u0006KaY\u0001\u000ee\u0016\u001cW-\u001b<fe6{7m\u001b\u0011\t\u0013]\u0004\u0001\u0019!a\u0001\n\u0013A\u0018\u0001E2iK\u000e\\\u0007o\\5oi\u0016\u0014Xj\\2l+\u0005I\bc\u0001>\u0002\u000e5\t1P\u0003\u0002}{\u0006Q\u0011N\u001c;fe\u001a\f7-Z:\u000b\u0005y|\u0018!D2mS\u0016tG\u000f\\5ce\u0006\u0014\u0018PC\u0002\u0004\u0003\u0003QA!a\u0001\u0002\u0006\u0005A1/\u001a:wS\u000e,7O\u0003\u0003\u0002\b\u0005%\u0011!C1nCj|g.Y<t\u0015\t\tY!A\u0002d_6L1!a\u0004|\u0005qI%+Z2pe\u0012\u0004&o\\2fgN|'o\u00115fG.\u0004x.\u001b8uKJD1\"a\u0005\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\u0016\u0005!2\r[3dWB|\u0017N\u001c;fe6{7m[0%KF$2a\\A\f\u0011!\u0019\u0018\u0011CA\u0001\u0002\u0004I\bBCA\u000e\u0001\u0001\u0007\t\u0011)Q\u0005s\u0006\t2\r[3dWB|\u0017N\u001c;fe6{7m\u001b\u0011\t\u0017\u0005}\u0001\u00011AA\u0002\u0013%\u0011\u0011E\u0001\u0014W&tWm]5t\u0007\",7m\u001b9pS:$XM]\u000b\u0003\u0003G\u00012aLA\u0013\u0013\r\t9C\u0001\u0002\u0014\u0017&tWm]5t\u0007\",7m\u001b9pS:$XM\u001d\u0005\f\u0003W\u0001\u0001\u0019!a\u0001\n\u0013\ti#A\flS:,7/[:DQ\u0016\u001c7\u000e]8j]R,'o\u0018\u0013fcR\u0019q.a\f\t\u0013M\fI#!AA\u0002\u0005\r\u0002bCA\u001a\u0001\u0001\u0007\t\u0011)Q\u0005\u0003G\tAc[5oKNL7o\u00115fG.\u0004x.\u001b8uKJ\u0004\u0003bCA\u001c\u0001\u0001\u0007\t\u0019!C\u0005\u0003s\tQa\u00197pG.,\"!a\u000f\u0011\t\u0005u\u00121I\u0007\u0003\u0003\u007fQ1!!\u0011\u0007\u0003\u0011)H/\u001b7\n\t\u0005\u0015\u0013q\b\u0002\f\u001b\u0006tW/\u00197DY>\u001c7\u000eC\u0006\u0002J\u0001\u0001\r\u00111A\u0005\n\u0005-\u0013!C2m_\u000e\\w\fJ3r)\ry\u0017Q\n\u0005\ng\u0006\u001d\u0013\u0011!a\u0001\u0003wA1\"!\u0015\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002<\u000511\r\\8dW\u0002B\u0011\"!\u0016\u0001\u0005\u0004%I!a\u0016\u0002\u0015\rDWmY6q_&tG/\u0006\u0002\u0002ZA)\u00111LA/_6\t\u0001!C\u0002\u0002`\r\u0012Q\u0002\u0015:jm\u0006$X-T3uQ>$\u0007\u0002CA2\u0001\u0001\u0006I!!\u0017\u0002\u0017\rDWmY6q_&tG\u000f\t\u0005\b\u0003O\u0002A\u0011IA5\u0003)\u0011WMZ8sK\u0016\u000b7\r\u001b\u000b\u0002_\u0002")
public class KinesisCheckpointerSuite
extends SparkFunSuite
implements TestSuiteBase,
MockitoSugar,
BeforeAndAfterEach,
PrivateMethodTester,
Eventually {
    private final String workerId;
    private final String shardId;
    private final String seqNum;
    private final String otherSeqNum;
    private final Duration org$apache$spark$streaming$kinesis$KinesisCheckpointerSuite$$checkpointInterval;
    private final Some<String> someSeqNum;
    private final Some<String> someOtherSeqNum;
    private KinesisReceiver<byte[]> receiverMock;
    private IRecordProcessorCheckpointer checkpointerMock;
    private KinesisCheckpointer kinesisCheckpointer;
    private ManualClock org$apache$spark$streaming$kinesis$KinesisCheckpointerSuite$$clock;
    private final PrivateMethodTester.PrivateMethod<BoxedUnit> checkpoint;
    private final AbstractPatienceConfiguration.PatienceConfig org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig;
    private volatile AbstractPatienceConfiguration$PatienceConfig$ PatienceConfig$module;
    private volatile PrivateMethodTester$PrivateMethod$ PrivateMethod$module;
    private String checkpointDir;
    private final SparkConf conf;
    private final PatienceConfiguration.Timeout eventuallyTimeout;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    private volatile boolean bitmap$0;

    public <T> T eventually(PatienceConfiguration.Timeout timeout, PatienceConfiguration.Interval interval, Function0<T> fun, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, (PatienceConfiguration.Timeout)timeout, (PatienceConfiguration.Interval)interval, fun, (Position)pos);
    }

    public <T> T eventually(PatienceConfiguration.Timeout timeout, Function0<T> fun, AbstractPatienceConfiguration.PatienceConfig config, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, (PatienceConfiguration.Timeout)timeout, fun, (AbstractPatienceConfiguration.PatienceConfig)config, (Position)pos);
    }

    public <T> T eventually(PatienceConfiguration.Interval interval, Function0<T> fun, AbstractPatienceConfiguration.PatienceConfig config, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, (PatienceConfiguration.Interval)interval, fun, (AbstractPatienceConfiguration.PatienceConfig)config, (Position)pos);
    }

    public <T> T eventually(Function0<T> fun, AbstractPatienceConfiguration.PatienceConfig config, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, fun, (AbstractPatienceConfiguration.PatienceConfig)config, (Position)pos);
    }

    public AbstractPatienceConfiguration.PatienceConfig patienceConfig() {
        return PatienceConfiguration.patienceConfig$((PatienceConfiguration)this);
    }

    public PatienceConfiguration.Timeout timeout(Span value) {
        return PatienceConfiguration.timeout$((PatienceConfiguration)this, (Span)value);
    }

    public PatienceConfiguration.Interval interval(Span value) {
        return PatienceConfiguration.interval$((PatienceConfiguration)this, (Span)value);
    }

    public final Span scaled(Span span) {
        return ScaledTimeSpans.scaled$((ScaledTimeSpans)this, (Span)span);
    }

    public double spanScaleFactor() {
        return ScaledTimeSpans.spanScaleFactor$((ScaledTimeSpans)this);
    }

    public PrivateMethodTester.Invoker anyRefToInvoker(Object target) {
        return PrivateMethodTester.anyRefToInvoker$((PrivateMethodTester)this, (Object)target);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfterEach$$super$runTest(String testName, Args args) {
        return BeforeAndAfter.runTest$((BeforeAndAfter)this, (String)testName, (Args)args);
    }

    public void afterEach() {
        BeforeAndAfterEach.afterEach$((BeforeAndAfterEach)this);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfterEach.runTest$((BeforeAndAfterEach)this, (String)testName, (Args)args);
    }

    public <T> T mock(ClassTag<T> classTag) {
        return (T)MockitoSugar.mock$((MockitoSugar)this, classTag);
    }

    public <T> T mock(Answer<?> defaultAnswer, ClassTag<T> classTag) {
        return (T)MockitoSugar.mock$((MockitoSugar)this, defaultAnswer, classTag);
    }

    public <T> T mock(MockSettings mockSettings, ClassTag<T> classTag) {
        return (T)MockitoSugar.mock$((MockitoSugar)this, (MockSettings)mockSettings, classTag);
    }

    public <T> T mock(String name, ClassTag<T> classTag) {
        return (T)MockitoSugar.mock$((MockitoSugar)this, (String)name, classTag);
    }

    public String framework() {
        return TestSuiteBase.framework$((TestSuiteBase)this);
    }

    public String master() {
        return TestSuiteBase.master$((TestSuiteBase)this);
    }

    public Duration batchDuration() {
        return TestSuiteBase.batchDuration$((TestSuiteBase)this);
    }

    public int numInputPartitions() {
        return TestSuiteBase.numInputPartitions$((TestSuiteBase)this);
    }

    public int maxWaitTimeMillis() {
        return TestSuiteBase.maxWaitTimeMillis$((TestSuiteBase)this);
    }

    public boolean useManualClock() {
        return TestSuiteBase.useManualClock$((TestSuiteBase)this);
    }

    public boolean actuallyWait() {
        return TestSuiteBase.actuallyWait$((TestSuiteBase)this);
    }

    public void beforeFunction() {
        TestSuiteBase.beforeFunction$((TestSuiteBase)this);
    }

    public void afterFunction() {
        TestSuiteBase.afterFunction$((TestSuiteBase)this);
    }

    public <R> R withStreamingContext(StreamingContext ssc, Function1<StreamingContext, R> block) {
        return (R)TestSuiteBase.withStreamingContext$((TestSuiteBase)this, (StreamingContext)ssc, block);
    }

    public <R> R withTestServer(TestServer testServer, Function1<TestServer, R> block) {
        return (R)TestSuiteBase.withTestServer$((TestSuiteBase)this, (TestServer)testServer, block);
    }

    public <U, V> StreamingContext setupStreams(Seq<Seq<U>> input, Function1<DStream<U>, DStream<V>> operation, int numPartitions, ClassTag<U> evidence$4, ClassTag<V> evidence$5) {
        return TestSuiteBase.setupStreams$((TestSuiteBase)this, input, operation, (int)numPartitions, evidence$4, evidence$5);
    }

    public <U, V, W> StreamingContext setupStreams(Seq<Seq<U>> input1, Seq<Seq<V>> input2, Function2<DStream<U>, DStream<V>, DStream<W>> operation, ClassTag<U> evidence$6, ClassTag<V> evidence$7, ClassTag<W> evidence$8) {
        return TestSuiteBase.setupStreams$((TestSuiteBase)this, input1, input2, operation, evidence$6, evidence$7, evidence$8);
    }

    public <V> Seq<Seq<V>> runStreams(StreamingContext ssc, int numBatches, int numExpectedOutput, Function0<BoxedUnit> preStop, ClassTag<V> evidence$9) {
        return TestSuiteBase.runStreams$((TestSuiteBase)this, (StreamingContext)ssc, (int)numBatches, (int)numExpectedOutput, preStop, evidence$9);
    }

    public <V> Seq<Seq<Seq<V>>> runStreamsWithPartitions(StreamingContext ssc, int numBatches, int numExpectedOutput, Function0<BoxedUnit> preStop, ClassTag<V> evidence$10) {
        return TestSuiteBase.runStreamsWithPartitions$((TestSuiteBase)this, (StreamingContext)ssc, (int)numBatches, (int)numExpectedOutput, preStop, evidence$10);
    }

    public <V> void verifyOutput(Seq<Seq<V>> output, Seq<Seq<V>> expectedOutput, boolean useSet, ClassTag<V> evidence$11) {
        TestSuiteBase.verifyOutput$((TestSuiteBase)this, output, expectedOutput, (boolean)useSet, evidence$11);
    }

    public <U, V> void testOperation(Seq<Seq<U>> input, Function1<DStream<U>, DStream<V>> operation, Seq<Seq<V>> expectedOutput, boolean useSet, ClassTag<U> evidence$12, ClassTag<V> evidence$13) {
        TestSuiteBase.testOperation$((TestSuiteBase)this, input, operation, expectedOutput, (boolean)useSet, evidence$12, evidence$13);
    }

    public <U, V> void testOperation(Seq<Seq<U>> input, Function1<DStream<U>, DStream<V>> operation, Seq<Seq<V>> expectedOutput, int numBatches, boolean useSet, ClassTag<U> evidence$14, ClassTag<V> evidence$15) {
        TestSuiteBase.testOperation$((TestSuiteBase)this, input, operation, expectedOutput, (int)numBatches, (boolean)useSet, evidence$14, evidence$15);
    }

    public <U, V, W> void testOperation(Seq<Seq<U>> input1, Seq<Seq<V>> input2, Function2<DStream<U>, DStream<V>, DStream<W>> operation, Seq<Seq<W>> expectedOutput, boolean useSet, ClassTag<U> evidence$16, ClassTag<V> evidence$17, ClassTag<W> evidence$18) {
        TestSuiteBase.testOperation$((TestSuiteBase)this, input1, input2, operation, expectedOutput, (boolean)useSet, evidence$16, evidence$17, evidence$18);
    }

    public <U, V, W> void testOperation(Seq<Seq<U>> input1, Seq<Seq<V>> input2, Function2<DStream<U>, DStream<V>, DStream<W>> operation, Seq<Seq<W>> expectedOutput, int numBatches, boolean useSet, ClassTag<U> evidence$19, ClassTag<V> evidence$20, ClassTag<W> evidence$21) {
        TestSuiteBase.testOperation$((TestSuiteBase)this, input1, input2, operation, expectedOutput, (int)numBatches, (boolean)useSet, evidence$19, evidence$20, evidence$21);
    }

    public <U, V> boolean testOperation$default$4() {
        return TestSuiteBase.testOperation$default$4$((TestSuiteBase)this);
    }

    public <U, V> int setupStreams$default$3() {
        return TestSuiteBase.setupStreams$default$3$((TestSuiteBase)this);
    }

    public <V> Function0<BoxedUnit> runStreamsWithPartitions$default$4() {
        return TestSuiteBase.runStreamsWithPartitions$default$4$((TestSuiteBase)this);
    }

    public <V> Function0<BoxedUnit> runStreams$default$4() {
        return TestSuiteBase.runStreams$default$4$((TestSuiteBase)this);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$runTest(String testName, Args args) {
        return FunSuiteLike.runTest$((FunSuiteLike)this, (String)testName, (Args)args);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$run(Option testName, Args args) {
        return BeforeAndAfterAll.run$((BeforeAndAfterAll)this, (Option)testName, (Args)args);
    }

    public void before(Function0<Object> fun, Position pos) {
        BeforeAndAfter.before$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public void after(Function0<Object> fun, Position pos) {
        BeforeAndAfter.after$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfter.run$((BeforeAndAfter)this, testName, (Args)args);
    }

    public AbstractPatienceConfiguration.PatienceConfig org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig() {
        return this.org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig;
    }

    public final void org$scalatest$concurrent$PatienceConfiguration$_setter_$org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig_$eq(AbstractPatienceConfiguration.PatienceConfig x$1) {
        this.org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig = x$1;
    }

    public AbstractPatienceConfiguration$PatienceConfig$ PatienceConfig() {
        if (this.PatienceConfig$module == null) {
            this.PatienceConfig$lzycompute$1();
        }
        return this.PatienceConfig$module;
    }

    public PrivateMethodTester$PrivateMethod$ PrivateMethod() {
        if (this.PrivateMethod$module == null) {
            this.PrivateMethod$lzycompute$1();
        }
        return this.PrivateMethod$module;
    }

    private String checkpointDir$lzycompute() {
        KinesisCheckpointerSuite kinesisCheckpointerSuite = this;
        synchronized (kinesisCheckpointerSuite) {
            if (!this.bitmap$0) {
                this.checkpointDir = TestSuiteBase.checkpointDir$((TestSuiteBase)this);
                this.bitmap$0 = true;
            }
        }
        return this.checkpointDir;
    }

    public String checkpointDir() {
        return !this.bitmap$0 ? this.checkpointDir$lzycompute() : this.checkpointDir;
    }

    public SparkConf conf() {
        return this.conf;
    }

    public PatienceConfiguration.Timeout eventuallyTimeout() {
        return this.eventuallyTimeout;
    }

    public void org$apache$spark$streaming$TestSuiteBase$_setter_$conf_$eq(SparkConf x$1) {
        this.conf = x$1;
    }

    public void org$apache$spark$streaming$TestSuiteBase$_setter_$eventuallyTimeout_$eq(PatienceConfiguration.Timeout x$1) {
        this.eventuallyTimeout = x$1;
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    private String workerId() {
        return this.workerId;
    }

    private String shardId() {
        return this.shardId;
    }

    private String seqNum() {
        return this.seqNum;
    }

    private String otherSeqNum() {
        return this.otherSeqNum;
    }

    public Duration org$apache$spark$streaming$kinesis$KinesisCheckpointerSuite$$checkpointInterval() {
        return this.org$apache$spark$streaming$kinesis$KinesisCheckpointerSuite$$checkpointInterval;
    }

    private Some<String> someSeqNum() {
        return this.someSeqNum;
    }

    private Some<String> someOtherSeqNum() {
        return this.someOtherSeqNum;
    }

    private KinesisReceiver<byte[]> receiverMock() {
        return this.receiverMock;
    }

    private void receiverMock_$eq(KinesisReceiver<byte[]> x$1) {
        this.receiverMock = x$1;
    }

    private IRecordProcessorCheckpointer checkpointerMock() {
        return this.checkpointerMock;
    }

    private void checkpointerMock_$eq(IRecordProcessorCheckpointer x$1) {
        this.checkpointerMock = x$1;
    }

    private KinesisCheckpointer kinesisCheckpointer() {
        return this.kinesisCheckpointer;
    }

    private void kinesisCheckpointer_$eq(KinesisCheckpointer x$1) {
        this.kinesisCheckpointer = x$1;
    }

    public ManualClock org$apache$spark$streaming$kinesis$KinesisCheckpointerSuite$$clock() {
        return this.org$apache$spark$streaming$kinesis$KinesisCheckpointerSuite$$clock;
    }

    private void org$apache$spark$streaming$kinesis$KinesisCheckpointerSuite$$clock_$eq(ManualClock x$1) {
        this.org$apache$spark$streaming$kinesis$KinesisCheckpointerSuite$$clock = x$1;
    }

    private PrivateMethodTester.PrivateMethod<BoxedUnit> checkpoint() {
        return this.checkpoint;
    }

    public void beforeEach() {
        this.receiverMock_$eq((KinesisReceiver<byte[]>)((KinesisReceiver)this.mock(ClassTag$.MODULE$.apply(KinesisReceiver.class))));
        this.checkpointerMock_$eq((IRecordProcessorCheckpointer)this.mock(ClassTag$.MODULE$.apply(IRecordProcessorCheckpointer.class)));
        this.org$apache$spark$streaming$kinesis$KinesisCheckpointerSuite$$clock_$eq(new ManualClock());
        this.kinesisCheckpointer_$eq(new KinesisCheckpointer(this.receiverMock(), this.org$apache$spark$streaming$kinesis$KinesisCheckpointerSuite$$checkpointInterval(), this.workerId(), (Clock)this.org$apache$spark$streaming$kinesis$KinesisCheckpointerSuite$$clock()));
    }

    private final void PatienceConfig$lzycompute$1() {
        KinesisCheckpointerSuite kinesisCheckpointerSuite = this;
        synchronized (kinesisCheckpointerSuite) {
            if (this.PatienceConfig$module == null) {
                this.PatienceConfig$module = new AbstractPatienceConfiguration$PatienceConfig$((AbstractPatienceConfiguration)this);
            }
        }
    }

    private final void PrivateMethod$lzycompute$1() {
        KinesisCheckpointerSuite kinesisCheckpointerSuite = this;
        synchronized (kinesisCheckpointerSuite) {
            if (this.PrivateMethod$module == null) {
                this.PrivateMethod$module = new PrivateMethodTester$PrivateMethod$((PrivateMethodTester)this);
            }
        }
    }

    public KinesisCheckpointerSuite() {
        BeforeAndAfter.$init$((BeforeAndAfter)this);
        TestSuiteBase.$init$((TestSuiteBase)this);
        MockitoSugar.$init$((MockitoSugar)this);
        BeforeAndAfterEach.$init$((BeforeAndAfterEach)this);
        PrivateMethodTester.$init$((PrivateMethodTester)this);
        ScaledTimeSpans.$init$((ScaledTimeSpans)this);
        AbstractPatienceConfiguration.$init$((AbstractPatienceConfiguration)this);
        PatienceConfiguration.$init$((PatienceConfiguration)this);
        Eventually.$init$((Eventually)this);
        this.workerId = "dummyWorkerId";
        this.shardId = "dummyShardId";
        this.seqNum = "123";
        this.otherSeqNum = "245";
        this.org$apache$spark$streaming$kinesis$KinesisCheckpointerSuite$$checkpointInterval = new Duration(10L);
        this.someSeqNum = new Some((Object)this.seqNum());
        this.someOtherSeqNum = new Some((Object)this.otherSeqNum());
        this.checkpoint = this.PrivateMethod().apply((Symbol)SymbolLiteral.bootstrap("apply", "checkpoint"));
        this.test("checkpoint is not called twice for the same sequence number", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Mockito.when((Object)this.receiverMock().getLatestSeqNumToCheckpoint(this.shardId())).thenReturn(this.someSeqNum());
            this.anyRefToInvoker(this.kinesisCheckpointer()).invokePrivate(this.checkpoint().apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.shardId(), this.checkpointerMock()})));
            this.anyRefToInvoker(this.kinesisCheckpointer()).invokePrivate(this.checkpoint().apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.shardId(), this.checkpointerMock()})));
            ((IRecordProcessorCheckpointer)Mockito.verify((Object)this.checkpointerMock(), (VerificationMode)Mockito.times((int)1))).checkpoint(Matchers.anyString());
        }, new Position("KinesisCheckpointerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66));
        this.test("checkpoint is called after sequence number increases", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Mockito.when((Object)this.receiverMock().getLatestSeqNumToCheckpoint(this.shardId())).thenReturn(this.someSeqNum()).thenReturn(this.someOtherSeqNum());
            this.anyRefToInvoker(this.kinesisCheckpointer()).invokePrivate(this.checkpoint().apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.shardId(), this.checkpointerMock()})));
            this.anyRefToInvoker(this.kinesisCheckpointer()).invokePrivate(this.checkpoint().apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.shardId(), this.checkpointerMock()})));
            ((IRecordProcessorCheckpointer)Mockito.verify((Object)this.checkpointerMock(), (VerificationMode)Mockito.times((int)1))).checkpoint(this.seqNum());
            ((IRecordProcessorCheckpointer)Mockito.verify((Object)this.checkpointerMock(), (VerificationMode)Mockito.times((int)1))).checkpoint(this.otherSeqNum());
        }, new Position("KinesisCheckpointerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
        this.test("should checkpoint if we have exceeded the checkpoint interval", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Mockito.when((Object)this.receiverMock().getLatestSeqNumToCheckpoint(this.shardId())).thenReturn(this.someSeqNum()).thenReturn(this.someOtherSeqNum());
            this.kinesisCheckpointer().setCheckpointer(this.shardId(), this.checkpointerMock());
            this.org$apache$spark$streaming$kinesis$KinesisCheckpointerSuite$$clock().advance(5L * this.org$apache$spark$streaming$kinesis$KinesisCheckpointerSuite$$checkpointInterval().milliseconds());
            this.eventually(this.timeout(Span$.MODULE$.convertDurationToSpan((scala.concurrent.duration.Duration)new package.DurationInt(package$.MODULE$.DurationInt(1)).second())), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                ((IRecordProcessorCheckpointer)Mockito.verify((Object)this.checkpointerMock(), (VerificationMode)Mockito.times((int)1))).checkpoint(this.seqNum());
                ((IRecordProcessorCheckpointer)Mockito.verify((Object)this.checkpointerMock(), (VerificationMode)Mockito.times((int)1))).checkpoint(this.otherSeqNum());
            }, this.patienceConfig(), new Position("KinesisCheckpointerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91));
        }, new Position("KinesisCheckpointerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
        this.test("shouldn't checkpoint if we have not exceeded the checkpoint interval", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Mockito.when((Object)this.receiverMock().getLatestSeqNumToCheckpoint(this.shardId())).thenReturn(this.someSeqNum());
            this.kinesisCheckpointer().setCheckpointer(this.shardId(), this.checkpointerMock());
            this.org$apache$spark$streaming$kinesis$KinesisCheckpointerSuite$$clock().advance(this.org$apache$spark$streaming$kinesis$KinesisCheckpointerSuite$$checkpointInterval().milliseconds() / 2L);
            ((IRecordProcessorCheckpointer)Mockito.verify((Object)this.checkpointerMock(), (VerificationMode)Mockito.never())).checkpoint(Matchers.anyString());
        }, new Position("KinesisCheckpointerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
        this.test("should not checkpoint for the same sequence number", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Mockito.when((Object)this.receiverMock().getLatestSeqNumToCheckpoint(this.shardId())).thenReturn(this.someSeqNum());
            this.kinesisCheckpointer().setCheckpointer(this.shardId(), this.checkpointerMock());
            this.org$apache$spark$streaming$kinesis$KinesisCheckpointerSuite$$clock().advance(this.org$apache$spark$streaming$kinesis$KinesisCheckpointerSuite$$checkpointInterval().milliseconds() * 5L);
            this.eventually(this.timeout(Span$.MODULE$.convertDurationToSpan((scala.concurrent.duration.Duration)new package.DurationInt(package$.MODULE$.DurationInt(1)).second())), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IRecordProcessorCheckpointer)Mockito.verify((Object)this.checkpointerMock(), (VerificationMode)Mockito.atMost((int)1))).checkpoint(Matchers.anyString()), this.patienceConfig(), new Position("KinesisCheckpointerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112));
        }, new Position("KinesisCheckpointerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 106));
        this.test("removing checkpointer checkpoints one last time", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Mockito.when((Object)this.receiverMock().getLatestSeqNumToCheckpoint(this.shardId())).thenReturn(this.someSeqNum());
            this.kinesisCheckpointer().removeCheckpointer(this.shardId(), this.checkpointerMock());
            ((IRecordProcessorCheckpointer)Mockito.verify((Object)this.checkpointerMock(), (VerificationMode)Mockito.times((int)1))).checkpoint();
        }, new Position("KinesisCheckpointerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 117));
        this.test("if checkpointing is going on, wait until finished before removing and checkpointing", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Mockito.when((Object)this.receiverMock().getLatestSeqNumToCheckpoint(this.shardId())).thenReturn(this.someSeqNum()).thenReturn(this.someOtherSeqNum());
            this.checkpointerMock().checkpoint(Matchers.anyString());
            Mockito.when((Object)BoxedUnit.UNIT).thenAnswer((Answer)new Answer<BoxedUnit>(this){
                private final /* synthetic */ KinesisCheckpointerSuite $outer;

                public void answer(InvocationOnMock invocations) {
                    this.$outer.org$apache$spark$streaming$kinesis$KinesisCheckpointerSuite$$clock().waitTillTime(this.$outer.org$apache$spark$streaming$kinesis$KinesisCheckpointerSuite$$clock().getTimeMillis() + this.$outer.org$apache$spark$streaming$kinesis$KinesisCheckpointerSuite$$checkpointInterval().milliseconds() / 2L);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            this.kinesisCheckpointer().setCheckpointer(this.shardId(), this.checkpointerMock());
            this.org$apache$spark$streaming$kinesis$KinesisCheckpointerSuite$$clock().advance(this.org$apache$spark$streaming$kinesis$KinesisCheckpointerSuite$$checkpointInterval().milliseconds());
            this.eventually(this.timeout(Span$.MODULE$.convertDurationToSpan((scala.concurrent.duration.Duration)new package.DurationInt(package$.MODULE$.DurationInt(1)).second())), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IRecordProcessorCheckpointer)Mockito.verify((Object)this.checkpointerMock(), (VerificationMode)Mockito.times((int)1))).checkpoint(Matchers.anyString()), this.patienceConfig(), new Position("KinesisCheckpointerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 135));
            Future f = Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.kinesisCheckpointer().removeCheckpointer(this.shardId(), this.checkpointerMock()), (ExecutionContext)ExecutionContext$.MODULE$.global());
            this.intercept((Function0 & Serializable & scala.Serializable)() -> (Future)Await$.MODULE$.ready((Awaitable)f, (scala.concurrent.duration.Duration)new package.DurationInt(package$.MODULE$.DurationInt(50)).millis()), ClassTag$.MODULE$.apply(TimeoutException.class), new Position("KinesisCheckpointerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 142));
            this.org$apache$spark$streaming$kinesis$KinesisCheckpointerSuite$$clock().advance(this.org$apache$spark$streaming$kinesis$KinesisCheckpointerSuite$$checkpointInterval().milliseconds() / 2L);
            this.eventually(this.timeout(Span$.MODULE$.convertDurationToSpan((scala.concurrent.duration.Duration)new package.DurationInt(package$.MODULE$.DurationInt(1)).second())), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                ((IRecordProcessorCheckpointer)Mockito.verify((Object)this.checkpointerMock(), (VerificationMode)Mockito.times((int)1))).checkpoint(Matchers.anyString());
                ((IRecordProcessorCheckpointer)Mockito.verify((Object)this.checkpointerMock(), (VerificationMode)Mockito.times((int)1))).checkpoint();
            }, this.patienceConfig(), new Position("KinesisCheckpointerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 149));
        }, new Position("KinesisCheckpointerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 124));
    }
}

