/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.kinesis;

import java.io.Serializable;
import org.apache.spark.LocalSparkContext;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkException;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockManager;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.apache.spark.storage.StreamBlockId;
import org.apache.spark.streaming.kinesis.KPLBasedKinesisTestUtils;
import org.apache.spark.streaming.kinesis.KPLBasedKinesisTestUtils$;
import org.apache.spark.streaming.kinesis.KinesisBackedBlockRDD;
import org.apache.spark.streaming.kinesis.KinesisBackedBlockRDD$;
import org.apache.spark.streaming.kinesis.KinesisFunSuite;
import org.apache.spark.streaming.kinesis.KinesisTestUtils;
import org.apache.spark.streaming.kinesis.SequenceNumberRange;
import org.apache.spark.streaming.kinesis.SequenceNumberRanges;
import org.apache.spark.streaming.kinesis.SequenceNumberRanges$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.compatible.Assertion;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u00055g!B\u0001\u0003\u0003\u0003i!AG&j]\u0016\u001c\u0018n\u001d\"bG.,GM\u00117pG.\u0014F\t\u0012+fgR\u001c(BA\u0002\u0005\u0003\u001dY\u0017N\\3tSNT!!\u0002\u0004\u0002\u0013M$(/Z1nS:<'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M)\u0001A\u0004\n\u00179A\u0011q\u0002E\u0007\u0002\r%\u0011\u0011C\u0002\u0002\u000e'B\f'o\u001b$v]N+\u0018\u000e^3\u0011\u0005M!R\"\u0001\u0002\n\u0005U\u0011!aD&j]\u0016\u001c\u0018n\u001d$v]N+\u0018\u000e^3\u0011\u0005]QR\"\u0001\r\u000b\u0005eQ\u0011!C:dC2\fG/Z:u\u0013\tY\u0002D\u0001\nCK\u001a|'/Z!oI\u00063G/\u001a:FC\u000eD\u0007CA\b\u001e\u0013\tqbAA\tM_\u000e\fGn\u00159be.\u001cuN\u001c;fqRD\u0001\u0002\t\u0001\u0003\u0002\u0003\u0006I!I\u0001\u0012C\u001e<'/Z4bi\u0016$Vm\u001d;ECR\f\u0007C\u0001\u0012&\u001b\u0005\u0019#\"\u0001\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0019\u001a#a\u0002\"p_2,\u0017M\u001c\u0005\u0006Q\u0001!\t!K\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005)Z\u0003CA\n\u0001\u0011\u0015\u0001s\u00051\u0001\"\u0011\u001di\u0003A1A\u0005\n9\n\u0001\u0002^3ti\u0012\u000bG/Y\u000b\u0002_A\u0011\u0001\u0007\u000f\b\u0003cYj\u0011A\r\u0006\u0003gQ\n\u0011\"[7nkR\f'\r\\3\u000b\u0005U\u001a\u0013AC2pY2,7\r^5p]&\u0011qGM\u0001\u0006%\u0006tw-Z\u0005\u0003si\u0012\u0011\"\u00138dYV\u001c\u0018N^3\u000b\u0005]\u0012\u0004B\u0002\u001f\u0001A\u0003%q&A\u0005uKN$H)\u0019;bA!9a\b\u0001a\u0001\n\u0013y\u0014!\u0003;fgR,F/\u001b7t+\u0005\u0001\u0005CA\nB\u0013\t\u0011%A\u0001\tLS:,7/[:UKN$X\u000b^5mg\"9A\t\u0001a\u0001\n\u0013)\u0015!\u0004;fgR,F/\u001b7t?\u0012*\u0017\u000f\u0006\u0002G\u0013B\u0011!eR\u0005\u0003\u0011\u000e\u0012A!\u00168ji\"9!jQA\u0001\u0002\u0004\u0001\u0015a\u0001=%c!1A\n\u0001Q!\n\u0001\u000b!\u0002^3tiV#\u0018\u000e\\:!\u0011\u001dq\u0005\u00011A\u0005\n=\u000b\u0001b\u001d5be\u0012LEm]\u000b\u0002!B\u0019\u0011+\u0017/\u000f\u0005I;fBA*W\u001b\u0005!&BA+\r\u0003\u0019a$o\\8u}%\tA%\u0003\u0002YG\u00059\u0001/Y2lC\u001e,\u0017B\u0001.\\\u0005\r\u0019V-\u001d\u0006\u00031\u000e\u0002\"!X1\u000f\u0005y{\u0006CA*$\u0013\t\u00017%\u0001\u0004Qe\u0016$WMZ\u0005\u0003E\u000e\u0014aa\u0015;sS:<'B\u00011$\u0011\u001d)\u0007\u00011A\u0005\n\u0019\fAb\u001d5be\u0012LEm]0%KF$\"AR4\t\u000f)#\u0017\u0011!a\u0001!\"1\u0011\u000e\u0001Q!\nA\u000b\u0011b\u001d5be\u0012LEm\u001d\u0011\t\u000f-\u0004\u0001\u0019!C\u0005Y\u0006i1\u000f[1sI&#Gk\u001c#bi\u0006,\u0012!\u001c\t\u0005;:d\u0006/\u0003\u0002pG\n\u0019Q*\u00199\u0011\u0007EK\u0016\u000f\u0005\u0002#e&\u00111o\t\u0002\u0004\u0013:$\bbB;\u0001\u0001\u0004%IA^\u0001\u0012g\"\f'\u000fZ%e)>$\u0015\r^1`I\u0015\fHC\u0001$x\u0011\u001dQE/!AA\u00025Da!\u001f\u0001!B\u0013i\u0017AD:iCJ$\u0017\n\u001a+p\t\u0006$\u0018\r\t\u0005\bw\u0002\u0001\r\u0011\"\u0003}\u0003M\u0019\b.\u0019:e\u0013\u0012$vnU3r\u001dVl'-\u001a:t+\u0005i\b\u0003B/o9BC\u0001b \u0001A\u0002\u0013%\u0011\u0011A\u0001\u0018g\"\f'\u000fZ%e)>\u001cV-\u001d(v[\n,'o]0%KF$2ARA\u0002\u0011\u001dQe0!AA\u0002uDq!a\u0002\u0001A\u0003&Q0\u0001\u000btQ\u0006\u0014H-\u00133U_N+\u0017OT;nE\u0016\u00148\u000f\t\u0005\n\u0003\u0017\u0001\u0001\u0019!C\u0005\u0003\u001b\t!d\u001d5be\u0012LE\rV8ECR\f\u0017I\u001c3TKFtU/\u001c2feN,\"!a\u0004\u0011\u000busG,!\u0005\u0011\tEK\u00161\u0003\t\u0006E\u0005U\u0011\u000fX\u0005\u0004\u0003/\u0019#A\u0002+va2,'\u0007C\u0005\u0002\u001c\u0001\u0001\r\u0011\"\u0003\u0002\u001e\u0005q2\u000f[1sI&#Gk\u001c#bi\u0006\fe\u000eZ*fc:+XNY3sg~#S-\u001d\u000b\u0004\r\u0006}\u0001\"\u0003&\u0002\u001a\u0005\u0005\t\u0019AA\b\u0011!\t\u0019\u0003\u0001Q!\n\u0005=\u0011aG:iCJ$\u0017\n\u001a+p\t\u0006$\u0018-\u00118e'\u0016\fh*^7cKJ\u001c\b\u0005C\u0005\u0002(\u0001\u0001\r\u0011\"\u0003\u0002*\u0005q1\u000f[1sI&#Gk\u001c*b]\u001e,WCAA\u0016!\u0015if\u000eXA\u0017!\r\u0019\u0012qF\u0005\u0004\u0003c\u0011!aE*fcV,gnY3Ok6\u0014WM\u001d*b]\u001e,\u0007\"CA\u001b\u0001\u0001\u0007I\u0011BA\u001c\u0003I\u0019\b.\u0019:e\u0013\u0012$vNU1oO\u0016|F%Z9\u0015\u0007\u0019\u000bI\u0004C\u0005K\u0003g\t\t\u00111\u0001\u0002,!A\u0011Q\b\u0001!B\u0013\tY#A\btQ\u0006\u0014H-\u00133U_J\u000bgnZ3!\u0011%\t\t\u0005\u0001a\u0001\n\u0013\t\u0019%A\u0005bY2\u0014\u0016M\\4fgV\u0011\u0011Q\t\t\u0005#f\u000bi\u0003C\u0005\u0002J\u0001\u0001\r\u0011\"\u0003\u0002L\u0005i\u0011\r\u001c7SC:<Wm]0%KF$2ARA'\u0011%Q\u0015qIA\u0001\u0002\u0004\t)\u0005\u0003\u0005\u0002R\u0001\u0001\u000b\u0015BA#\u0003)\tG\u000e\u001c*b]\u001e,7\u000f\t\u0005\n\u0003+\u0002\u0001\u0019!C\u0005\u0003/\nAB\u00197pG.l\u0015M\\1hKJ,\"!!\u0017\u0011\t\u0005m\u0013\u0011M\u0007\u0003\u0003;R1!a\u0018\u0007\u0003\u001d\u0019Ho\u001c:bO\u0016LA!a\u0019\u0002^\ta!\t\\8dW6\u000bg.Y4fe\"I\u0011q\r\u0001A\u0002\u0013%\u0011\u0011N\u0001\u0011E2|7m['b]\u0006<WM]0%KF$2ARA6\u0011%Q\u0015QMA\u0001\u0002\u0004\tI\u0006\u0003\u0005\u0002p\u0001\u0001\u000b\u0015BA-\u00035\u0011Gn\\2l\u001b\u0006t\u0017mZ3sA!9\u00111\u000f\u0001\u0005B\u0005U\u0014!\u00032fM>\u0014X-\u00117m)\u00051\u0005bBA=\u0001\u0011\u0005\u0013QO\u0001\u000bE\u00164wN]3FC\u000eD\u0007bBA?\u0001\u0011\u0005\u0013QO\u0001\tC\u001a$XM]!mY\"9\u0011\u0011\u0011\u0001\u0005\n\u0005\r\u0015a\u0002;fgR\u0014F\t\u0012\u000b\f\r\u0006\u0015\u0015\u0011RAG\u0003#\u000b)\nC\u0004\u0002\b\u0006}\u0004\u0019A9\u0002\u001b9,X\u000eU1si&$\u0018n\u001c8t\u0011\u001d\tY)a A\u0002E\f\u0011C\\;n!\u0006\u0014H/\u001b;j_:\u001c\u0018J\u001c\"N\u0011\u001d\ty)a A\u0002E\faC\\;n!\u0006\u0014H/\u001b;j_:\u001c\u0018J\\&j]\u0016\u001c\u0018n\u001d\u0005\n\u0003'\u000by\b%AA\u0002\u0005\n\u0001\u0003^3ti&\u001b(\t\\8dWZ\u000bG.\u001b3\t\u0013\u0005]\u0015q\u0010I\u0001\u0002\u0004\t\u0013a\u0004;fgR\u0014En\\2l%\u0016lwN^3\t\u000f\u0005m\u0005\u0001\"\u0003\u0002\u001e\u0006aa-Y6f\u00052|7m[%egR!\u0011qTAV!\u0015\u0011\u0013\u0011UAS\u0013\r\t\u0019k\t\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0005\u00037\n9+\u0003\u0003\u0002*\u0006u#a\u0002\"m_\u000e\\\u0017\n\u001a\u0005\b\u0003[\u000bI\n1\u0001r\u0003\rqW/\u001c\u0005\n\u0003c\u0003\u0011\u0013!C\u0005\u0003g\u000b\u0011\u0003^3tiJ#E\t\n3fM\u0006,H\u000e\u001e\u00135+\t\t)LK\u0002\"\u0003o[#!!/\u0011\t\u0005m\u0016QY\u0007\u0003\u0003{SA!a0\u0002B\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u0007\u001c\u0013AC1o]>$\u0018\r^5p]&!\u0011qYA_\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\n\u0003\u0017\u0004\u0011\u0013!C\u0005\u0003g\u000b\u0011\u0003^3tiJ#E\t\n3fM\u0006,H\u000e\u001e\u00136\u0001")
public abstract class KinesisBackedBlockRDDTests
extends SparkFunSuite
implements KinesisFunSuite,
LocalSparkContext {
    private final boolean aggregateTestData;
    private final Range.Inclusive testData;
    private KinesisTestUtils testUtils;
    private Seq<String> shardIds;
    private Map<String, Seq<Object>> shardIdToData;
    private Map<String, Seq<String>> shardIdToSeqNumbers;
    private Map<String, Seq<Tuple2<Object, String>>> shardIdToDataAndSeqNumbers;
    private Map<String, SequenceNumberRange> shardIdToRange;
    private Seq<SequenceNumberRange> allRanges;
    private BlockManager blockManager;
    private transient SparkContext sc;

    public /* synthetic */ void org$apache$spark$LocalSparkContext$$super$beforeAll() {
        super.beforeAll();
    }

    public /* synthetic */ void org$apache$spark$LocalSparkContext$$super$afterEach() {
        BeforeAndAfterEach.afterEach$((BeforeAndAfterEach)this);
    }

    public void afterEach() {
        LocalSparkContext.afterEach$((LocalSparkContext)this);
    }

    public void resetSparkContext() {
        LocalSparkContext.resetSparkContext$((LocalSparkContext)this);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfterEach$$super$runTest(String testName, Args args) {
        return FunSuiteLike.runTest$((FunSuiteLike)this, (String)testName, (Args)args);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfterEach.runTest$((BeforeAndAfterEach)this, (String)testName, (Args)args);
    }

    @Override
    public void testIfEnabled(String testName, Function0<BoxedUnit> testBody) {
        KinesisFunSuite.testIfEnabled$(this, testName, testBody);
    }

    @Override
    public void runIfTestsEnabled(String message, Function0<BoxedUnit> body) {
        KinesisFunSuite.runIfTestsEnabled$(this, message, body);
    }

    public SparkContext sc() {
        return this.sc;
    }

    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    private Range.Inclusive testData() {
        return this.testData;
    }

    private KinesisTestUtils testUtils() {
        return this.testUtils;
    }

    private void testUtils_$eq(KinesisTestUtils x$1) {
        this.testUtils = x$1;
    }

    private Seq<String> shardIds() {
        return this.shardIds;
    }

    private void shardIds_$eq(Seq<String> x$1) {
        this.shardIds = x$1;
    }

    private Map<String, Seq<Object>> shardIdToData() {
        return this.shardIdToData;
    }

    private void shardIdToData_$eq(Map<String, Seq<Object>> x$1) {
        this.shardIdToData = x$1;
    }

    private Map<String, Seq<String>> shardIdToSeqNumbers() {
        return this.shardIdToSeqNumbers;
    }

    private void shardIdToSeqNumbers_$eq(Map<String, Seq<String>> x$1) {
        this.shardIdToSeqNumbers = x$1;
    }

    private Map<String, Seq<Tuple2<Object, String>>> shardIdToDataAndSeqNumbers() {
        return this.shardIdToDataAndSeqNumbers;
    }

    private void shardIdToDataAndSeqNumbers_$eq(Map<String, Seq<Tuple2<Object, String>>> x$1) {
        this.shardIdToDataAndSeqNumbers = x$1;
    }

    private Map<String, SequenceNumberRange> shardIdToRange() {
        return this.shardIdToRange;
    }

    private void shardIdToRange_$eq(Map<String, SequenceNumberRange> x$1) {
        this.shardIdToRange = x$1;
    }

    private Seq<SequenceNumberRange> allRanges() {
        return this.allRanges;
    }

    private void allRanges_$eq(Seq<SequenceNumberRange> x$1) {
        this.allRanges = x$1;
    }

    private BlockManager blockManager() {
        return this.blockManager;
    }

    private void blockManager_$eq(BlockManager x$1) {
        this.blockManager = x$1;
    }

    public void beforeAll() {
        LocalSparkContext.beforeAll$((LocalSparkContext)this);
        this.runIfTestsEnabled("Prepare KinesisTestUtils", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.testUtils_$eq(new KPLBasedKinesisTestUtils(KPLBasedKinesisTestUtils$.MODULE$.$lessinit$greater$default$1()));
            this.testUtils().createStream();
            this.shardIdToDataAndSeqNumbers_$eq((Map<String, Seq<Tuple2<Object, String>>>)this.testUtils().pushData((Seq)this.testData(), $this.aggregateTestData));
            Predef$.MODULE$.require(this.shardIdToDataAndSeqNumbers().size() > 1, (Function0 & Serializable & scala.Serializable)() -> "Need data to be sent to multiple shards");
            this.shardIds_$eq((Seq<String>)this.shardIdToDataAndSeqNumbers().keySet().toSeq());
            this.shardIdToData_$eq((Map<String, Seq<Object>>)this.shardIdToDataAndSeqNumbers().mapValues((Function1 & Serializable & scala.Serializable)x$1 -> (Seq)x$1.map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2._1$mcI$sp()), Seq$.MODULE$.canBuildFrom())));
            this.shardIdToSeqNumbers_$eq((Map<String, Seq<String>>)this.shardIdToDataAndSeqNumbers().mapValues((Function1 & Serializable & scala.Serializable)x$3 -> (Seq)x$3.map((Function1 & Serializable & scala.Serializable)x$4 -> (String)x$4._2(), Seq$.MODULE$.canBuildFrom())));
            this.shardIdToRange_$eq((Map<String, SequenceNumberRange>)((Map)this.shardIdToSeqNumbers().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String shardId = (String)tuple2._1();
                Seq seqNumbers = (Seq)tuple2._2();
                SequenceNumberRange seqNumRange = new SequenceNumberRange(this.testUtils().streamName(), shardId, (String)seqNumbers.head(), (String)seqNumbers.last(), seqNumbers.size());
                Tuple2 tuple22 = new Tuple2((Object)shardId, (Object)seqNumRange);
                return tuple22;
            }, Map$.MODULE$.canBuildFrom())));
            this.allRanges_$eq((Seq<SequenceNumberRange>)this.shardIdToRange().values().toSeq());
        });
    }

    public void beforeEach() {
        BeforeAndAfterEach.beforeEach$((BeforeAndAfterEach)this);
        SparkConf conf = new SparkConf().setMaster("local[4]").setAppName("KinesisBackedBlockRDDSuite");
        this.sc_$eq(new SparkContext(conf));
        this.blockManager_$eq(this.sc().env().blockManager());
    }

    public void afterAll() {
        try {
            if (this.testUtils() != null) {
                this.testUtils().deleteStream();
            }
        }
        finally {
            super.afterAll();
        }
    }

    private void testRDD(int numPartitions, int numPartitionsInBM, int numPartitionsInKinesis, boolean testIsBlockValid, boolean testBlockRemove) {
        block2: {
            Object object;
            Predef$.MODULE$.require(this.shardIds().size() > 1, (Function0 & Serializable & scala.Serializable)() -> "Need at least 2 shards to test");
            Predef$.MODULE$.require(numPartitionsInBM <= this.shardIds().size(), (Function0 & Serializable & scala.Serializable)() -> "Number of partitions in BlockManager cannot be more than the Kinesis test shards available");
            Predef$.MODULE$.require(numPartitionsInKinesis <= this.shardIds().size(), (Function0 & Serializable & scala.Serializable)() -> "Number of partitions in Kinesis cannot be more than the Kinesis test shards available");
            Predef$.MODULE$.require(numPartitionsInBM <= numPartitions, (Function0 & Serializable & scala.Serializable)() -> "Number of partitions in BlockManager cannot be more than that in RDD");
            Predef$.MODULE$.require(numPartitionsInKinesis <= numPartitions, (Function0 & Serializable & scala.Serializable)() -> "Number of partitions in Kinesis cannot be more than that in RDD");
            BlockId[] blockIds = this.fakeBlockIds(numPartitions);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])blockIds)).foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
                KinesisBackedBlockRDDTests.$anonfun$testRDD$6(this, x$5);
                return BoxedUnit.UNIT;
            });
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numPartitionsInBM).foreach((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)i -> {
                Iterator blockData = ((IterableLike)this.shardIdToData().apply(this.shardIds().apply(i))).iterator().map((Function1 & Serializable & scala.Serializable)x$6 -> KinesisBackedBlockRDDTests.$anonfun$testRDD$8(BoxesRunTime.unboxToInt((Object)x$6)));
                BlockManager qual$2 = this.blockManager();
                BlockId x$20 = blockIds[i];
                Iterator x$21 = blockData;
                StorageLevel x$22 = StorageLevel$.MODULE$.MEMORY_ONLY();
                boolean x$23 = qual$2.putIterator$default$4();
                return qual$2.putIterator(x$20, x$21, x$22, x$23, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
            });
            SequenceNumberRanges[] fakeRanges = (SequenceNumberRanges[])Array$.MODULE$.fill(numPartitions - numPartitionsInKinesis, (Function0 & Serializable & scala.Serializable)() -> SequenceNumberRanges$.MODULE$.apply(new SequenceNumberRange("fakeStream", "fakeShardId", "xxx", "yyy", 1)), ClassTag$.MODULE$.apply(SequenceNumberRanges.class));
            SequenceNumberRanges[] realRanges = (SequenceNumberRanges[])Array$.MODULE$.tabulate(numPartitionsInKinesis, (Function1 & Serializable & scala.Serializable)i -> KinesisBackedBlockRDDTests.$anonfun$testRDD$10(this, numPartitions, numPartitionsInKinesis, BoxesRunTime.unboxToInt((Object)i)), ClassTag$.MODULE$.apply(SequenceNumberRanges.class));
            SequenceNumberRanges[] ranges = (SequenceNumberRanges[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fakeRanges)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])realRanges)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(SequenceNumberRanges.class)));
            Predef$.MODULE$.require(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])blockIds)).take(numPartitionsInBM))).forall((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)KinesisBackedBlockRDDTests.$anonfun$testRDD$12(this, x$7))), (Function0 & Serializable & scala.Serializable)() -> "Expected blocks not in BlockManager");
            Predef$.MODULE$.require(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])blockIds)).drop(numPartitionsInBM))).forall((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)KinesisBackedBlockRDDTests.$anonfun$testRDD$14(this, x$8))), (Function0 & Serializable & scala.Serializable)() -> "Unexpected blocks in BlockManager");
            Predef$.MODULE$.require(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ranges)).takeRight(numPartitionsInKinesis))).forall((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)KinesisBackedBlockRDDTests.$anonfun$testRDD$16(this, x$9))), (Function0 & Serializable & scala.Serializable)() -> "Incorrect configuration of RDD, expected ranges not set: ");
            Predef$.MODULE$.require(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ranges)).dropRight(numPartitionsInKinesis))).forall((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)KinesisBackedBlockRDDTests.$anonfun$testRDD$19(this, x$11))), (Function0 & Serializable & scala.Serializable)() -> "Incorrect configuration of RDD, unexpected ranges set");
            KinesisBackedBlockRDD rdd = new KinesisBackedBlockRDD(this.sc(), this.testUtils().regionName(), this.testUtils().endpointUrl(), blockIds, ranges, KinesisBackedBlockRDD$.MODULE$.$lessinit$greater$default$6(), KinesisBackedBlockRDD$.MODULE$.$lessinit$greater$default$7(), KinesisBackedBlockRDD$.MODULE$.$lessinit$greater$default$8(), KinesisBackedBlockRDD$.MODULE$.$lessinit$greater$default$9(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
            int[] collectedData = (int[])rdd.map((Function1 & Serializable & scala.Serializable)bytes -> BoxesRunTime.boxToInteger((int)KinesisBackedBlockRDDTests.$anonfun$testRDD$21(bytes)), ClassTag$.MODULE$.Int()).collect();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(collectedData)).toSet());
            Set $org_scalatest_assert_macro_right = this.testData().toSet();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KinesisBackedBlockRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 221));
            if (testIsBlockValid) {
                Predef$.MODULE$.require(this.convertToEqualizer(BoxesRunTime.boxToInteger((int)numPartitionsInBM)).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)numPartitions), Equality$.MODULE$.default()), (Function0 & Serializable & scala.Serializable)() -> "All partitions must be in BlockManager");
                Predef$.MODULE$.require(this.convertToEqualizer(BoxesRunTime.boxToInteger((int)numPartitionsInKinesis)).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)0), Equality$.MODULE$.default()), (Function0 & Serializable & scala.Serializable)() -> "No partitions must be in Kinesis");
                KinesisBackedBlockRDD rdd2 = new KinesisBackedBlockRDD(this.sc(), this.testUtils().regionName(), this.testUtils().endpointUrl(), (BlockId[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])blockIds)).toArray(ClassTag$.MODULE$.apply(BlockId.class)), ranges, (boolean[])Array$.MODULE$.fill(blockIds.length, (Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false, ClassTag$.MODULE$.Boolean()), KinesisBackedBlockRDD$.MODULE$.$lessinit$greater$default$7(), KinesisBackedBlockRDD$.MODULE$.$lessinit$greater$default$8(), KinesisBackedBlockRDD$.MODULE$.$lessinit$greater$default$9(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
                object = this.intercept((Function0 & Serializable & scala.Serializable)() -> (byte[][])rdd2.collect(), ClassTag$.MODULE$.apply(SparkException.class), new Position("KinesisBackedBlockRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 233));
            } else {
                object = BoxedUnit.UNIT;
            }
            if (!testBlockRemove) break block2;
            Predef$.MODULE$.require(this.convertToEqualizer(BoxesRunTime.boxToInteger((int)numPartitions)).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)numPartitionsInKinesis), Equality$.MODULE$.default()), (Function0 & Serializable & scala.Serializable)() -> "All partitions must be in WAL for this test");
            Predef$.MODULE$.require(numPartitionsInBM > 0, (Function0 & Serializable & scala.Serializable)() -> "Some partitions must be in BlockManager for this test");
            rdd.removeBlocks();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])rdd.map((Function1 & Serializable & scala.Serializable)bytes -> BoxesRunTime.boxToInteger((int)KinesisBackedBlockRDDTests.$anonfun$testRDD$28(bytes)), ClassTag$.MODULE$.Int()).collect())).toSet());
            Set $org_scalatest_assert_macro_right2 = this.testData().toSet();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("KinesisBackedBlockRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 245));
        }
    }

    private boolean testRDD$default$4() {
        return false;
    }

    private boolean testRDD$default$5() {
        return false;
    }

    private BlockId[] fakeBlockIds(int num) {
        return (BlockId[])Array$.MODULE$.tabulate(num, (Function1 & Serializable & scala.Serializable)i -> KinesisBackedBlockRDDTests.$anonfun$fakeBlockIds$1(BoxesRunTime.unboxToInt((Object)i)), ClassTag$.MODULE$.apply(BlockId.class));
    }

    public static final /* synthetic */ int $anonfun$new$2(byte[] bytes) {
        return new StringOps(Predef$.MODULE$.augmentString(new String(bytes))).toInt();
    }

    public static final /* synthetic */ int $anonfun$new$4(byte[] bytes) {
        return new StringOps(Predef$.MODULE$.augmentString(new String(bytes))).toInt();
    }

    public static final /* synthetic */ int $anonfun$new$6(byte[] bytes) {
        return new StringOps(Predef$.MODULE$.augmentString(new String(bytes))).toInt();
    }

    public static final /* synthetic */ Assertion $anonfun$new$7(KinesisBackedBlockRDDTests $this, int[][] receivedData3$1, int i) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(receivedData3$1[i])).toSeq());
        Seq $org_scalatest_assert_macro_right = (Seq)$this.shardIdToData().apply((Object)((SequenceNumberRange)$this.allRanges().apply(i)).shardId());
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KinesisBackedBlockRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 100));
    }

    public static final /* synthetic */ void $anonfun$testRDD$6(KinesisBackedBlockRDDTests $this, BlockId x$5) {
        BlockManager qual$1 = $this.blockManager();
        BlockId x$18 = x$5;
        boolean x$19 = qual$1.removeBlock$default$2();
        qual$1.removeBlock(x$18, x$19);
    }

    public static final /* synthetic */ byte[] $anonfun$testRDD$8(int x$6) {
        return ((Object)BoxesRunTime.boxToInteger((int)x$6)).toString().getBytes();
    }

    public static final /* synthetic */ SequenceNumberRanges $anonfun$testRDD$10(KinesisBackedBlockRDDTests $this, int numPartitions$1, int numPartitionsInKinesis$1, int i) {
        SequenceNumberRange range = (SequenceNumberRange)$this.shardIdToRange().apply($this.shardIds().apply(i + (numPartitions$1 - numPartitionsInKinesis$1)));
        return new SequenceNumberRanges((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceNumberRange[]{range}));
    }

    public static final /* synthetic */ boolean $anonfun$testRDD$12(KinesisBackedBlockRDDTests $this, BlockId x$7) {
        return $this.blockManager().get(x$7, ClassTag$.MODULE$.Nothing()).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$testRDD$14(KinesisBackedBlockRDDTests $this, BlockId x$8) {
        return $this.blockManager().get(x$8, ClassTag$.MODULE$.Nothing()).isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$testRDD$17(KinesisBackedBlockRDDTests $this, SequenceNumberRange x$10) {
        String string = x$10.streamName();
        String string2 = $this.testUtils().streamName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testRDD$16(KinesisBackedBlockRDDTests $this, SequenceNumberRanges x$9) {
        return x$9.ranges().forall((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)KinesisBackedBlockRDDTests.$anonfun$testRDD$17($this, x$10)));
    }

    public static final /* synthetic */ boolean $anonfun$testRDD$20(KinesisBackedBlockRDDTests $this, SequenceNumberRange x$12) {
        String string = x$12.streamName();
        String string2 = $this.testUtils().streamName();
        return string == null ? string2 != null : !string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testRDD$19(KinesisBackedBlockRDDTests $this, SequenceNumberRanges x$11) {
        return x$11.ranges().forall((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)KinesisBackedBlockRDDTests.$anonfun$testRDD$20($this, x$12)));
    }

    public static final /* synthetic */ int $anonfun$testRDD$21(byte[] bytes) {
        return new StringOps(Predef$.MODULE$.augmentString(new String(bytes))).toInt();
    }

    public static final /* synthetic */ int $anonfun$testRDD$28(byte[] bytes) {
        return new StringOps(Predef$.MODULE$.augmentString(new String(bytes))).toInt();
    }

    public static final /* synthetic */ StreamBlockId $anonfun$fakeBlockIds$1(int i) {
        return new StreamBlockId(0, (long)i);
    }

    public KinesisBackedBlockRDDTests(boolean aggregateTestData) {
        this.aggregateTestData = aggregateTestData;
        KinesisFunSuite.$init$(this);
        BeforeAndAfterEach.$init$((BeforeAndAfterEach)this);
        LocalSparkContext.$init$((LocalSparkContext)this);
        this.testData = RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 8);
        this.testUtils = null;
        this.shardIds = null;
        this.shardIdToData = null;
        this.shardIdToSeqNumbers = null;
        this.shardIdToDataAndSeqNumbers = null;
        this.shardIdToRange = null;
        this.allRanges = null;
        this.blockManager = null;
        this.testIfEnabled("Basic reading from Kinesis", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            int[] receivedData1 = (int[])new KinesisBackedBlockRDD(this.sc(), this.testUtils().regionName(), this.testUtils().endpointUrl(), this.fakeBlockIds(1), (SequenceNumberRanges[])((Object[])new SequenceNumberRanges[]{new SequenceNumberRanges((Seq)Predef$.MODULE$.wrapRefArray((Object[])this.allRanges().toArray(ClassTag$.MODULE$.apply(SequenceNumberRange.class))))}), KinesisBackedBlockRDD$.MODULE$.$lessinit$greater$default$6(), KinesisBackedBlockRDD$.MODULE$.$lessinit$greater$default$7(), KinesisBackedBlockRDD$.MODULE$.$lessinit$greater$default$8(), KinesisBackedBlockRDD$.MODULE$.$lessinit$greater$default$9(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE))).map((Function1 & Serializable & scala.Serializable)bytes -> BoxesRunTime.boxToInteger((int)KinesisBackedBlockRDDTests.$anonfun$new$2(bytes)), ClassTag$.MODULE$.Int()).collect();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(receivedData1)).toSet());
            Set $org_scalatest_assert_macro_right = this.testData().toSet();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KinesisBackedBlockRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
            int[] receivedData2 = (int[])new KinesisBackedBlockRDD(this.sc(), this.testUtils().regionName(), this.testUtils().endpointUrl(), this.fakeBlockIds(this.allRanges().size()), (SequenceNumberRanges[])((TraversableOnce)this.allRanges().map((Function1 & Serializable & scala.Serializable)range -> new SequenceNumberRanges((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceNumberRange[]{range})), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(SequenceNumberRanges.class)), KinesisBackedBlockRDD$.MODULE$.$lessinit$greater$default$6(), KinesisBackedBlockRDD$.MODULE$.$lessinit$greater$default$7(), KinesisBackedBlockRDD$.MODULE$.$lessinit$greater$default$8(), KinesisBackedBlockRDD$.MODULE$.$lessinit$greater$default$9(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE))).map((Function1 & Serializable & scala.Serializable)bytes -> BoxesRunTime.boxToInteger((int)KinesisBackedBlockRDDTests.$anonfun$new$4(bytes)), ClassTag$.MODULE$.Int()).collect();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(receivedData2)).toSet());
            Set $org_scalatest_assert_macro_right2 = this.testData().toSet();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("KinesisBackedBlockRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91));
            int[][] receivedData3 = (int[][])new KinesisBackedBlockRDD(this.sc(), this.testUtils().regionName(), this.testUtils().endpointUrl(), this.fakeBlockIds(this.allRanges().size()), (SequenceNumberRanges[])((TraversableOnce)this.allRanges().map((Function1 & Serializable & scala.Serializable)range -> new SequenceNumberRanges((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceNumberRange[]{range})), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(SequenceNumberRanges.class)), KinesisBackedBlockRDD$.MODULE$.$lessinit$greater$default$6(), KinesisBackedBlockRDD$.MODULE$.$lessinit$greater$default$7(), KinesisBackedBlockRDD$.MODULE$.$lessinit$greater$default$8(), KinesisBackedBlockRDD$.MODULE$.$lessinit$greater$default$9(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE))).map((Function1 & Serializable & scala.Serializable)bytes -> BoxesRunTime.boxToInteger((int)KinesisBackedBlockRDDTests.$anonfun$new$6(bytes)), ClassTag$.MODULE$.Int()).collectPartitions();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)receivedData3.length));
            int $org_scalatest_assert_macro_right3 = this.allRanges().size();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("KinesisBackedBlockRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 98));
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.allRanges().size()).foreach((Function1 & Serializable & scala.Serializable)i -> KinesisBackedBlockRDDTests.$anonfun$new$7(this, receivedData3, BoxesRunTime.unboxToInt((Object)i)));
        });
        this.testIfEnabled("Read data available in both block manager and Kinesis", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testRDD(2, 2, 2, this.testRDD$default$4(), this.testRDD$default$5()));
        this.testIfEnabled("Read data available only in block manager, not in Kinesis", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testRDD(2, 2, 0, this.testRDD$default$4(), this.testRDD$default$5()));
        this.testIfEnabled("Read data available only in Kinesis, not in block manager", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testRDD(2, 0, 2, this.testRDD$default$4(), this.testRDD$default$5()));
        this.testIfEnabled("Read data available partially in block manager, rest in Kinesis", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testRDD(2, 1, 1, this.testRDD$default$4(), this.testRDD$default$5()));
        this.testIfEnabled("Test isBlockValid skips block fetching from block manager", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testRDD(2, 2, 0, true, this.testRDD$default$5()));
        this.testIfEnabled("Test whether RDD is valid after removing blocks from block manager", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            int x$13 = 2;
            int x$14 = 2;
            int x$15 = 2;
            boolean x$16 = true;
            boolean x$17 = this.testRDD$default$4();
            this.testRDD(x$13, x$14, x$15, x$17, x$16);
        });
    }
}

