/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.kinesis;

import com.amazonaws.services.kinesis.clientlibrary.lib.worker.InitialPositionInStream;
import com.amazonaws.services.kinesis.model.Record;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.LocalJavaStreamingContext;
import org.apache.spark.streaming.api.java.JavaReceiverInputDStream;
import org.apache.spark.streaming.api.java.JavaStreamingContext;
import org.apache.spark.streaming.kinesis.KinesisTestUtils;
import org.apache.spark.streaming.kinesis.KinesisUtils;
import org.junit.Test;

public class JavaKinesisStreamSuite
extends LocalJavaStreamingContext {
    private static Function<Record, String> handler = new Function<Record, String>(){

        public String call(Record record) {
            return record.getPartitionKey() + "-" + record.getSequenceNumber();
        }
    };

    @Test
    public void testKinesisStream() {
        String dummyEndpointUrl = KinesisTestUtils.defaultEndpointUrl();
        String dummyRegionName = KinesisTestUtils.getRegionNameByEndpoint((String)dummyEndpointUrl);
        JavaReceiverInputDStream kinesisStream = KinesisUtils.createStream((JavaStreamingContext)this.ssc, (String)"myAppName", (String)"mySparkStream", (String)dummyEndpointUrl, (String)dummyRegionName, (InitialPositionInStream)InitialPositionInStream.LATEST, (Duration)new Duration(2000L), (StorageLevel)StorageLevel.MEMORY_AND_DISK_2());
        this.ssc.stop();
    }

    @Test
    public void testAwsCreds() {
        String dummyEndpointUrl = KinesisTestUtils.defaultEndpointUrl();
        String dummyRegionName = KinesisTestUtils.getRegionNameByEndpoint((String)dummyEndpointUrl);
        JavaReceiverInputDStream kinesisStream = KinesisUtils.createStream((JavaStreamingContext)this.ssc, (String)"myAppName", (String)"mySparkStream", (String)dummyEndpointUrl, (String)dummyRegionName, (InitialPositionInStream)InitialPositionInStream.LATEST, (Duration)new Duration(2000L), (StorageLevel)StorageLevel.MEMORY_AND_DISK_2(), (String)"fakeAccessKey", (String)"fakeSecretKey");
        this.ssc.stop();
    }

    @Test
    public void testCustomHandler() {
        JavaReceiverInputDStream kinesisStream = KinesisUtils.createStream((JavaStreamingContext)this.ssc, (String)"testApp", (String)"mySparkStream", (String)"https://kinesis.us-west-2.amazonaws.com", (String)"us-west-2", (InitialPositionInStream)InitialPositionInStream.LATEST, (Duration)new Duration(2000L), (StorageLevel)StorageLevel.MEMORY_AND_DISK_2(), handler, String.class);
        this.ssc.stop();
    }

    @Test
    public void testCustomHandlerAwsCreds() {
        JavaReceiverInputDStream kinesisStream = KinesisUtils.createStream((JavaStreamingContext)this.ssc, (String)"testApp", (String)"mySparkStream", (String)"https://kinesis.us-west-2.amazonaws.com", (String)"us-west-2", (InitialPositionInStream)InitialPositionInStream.LATEST, (Duration)new Duration(2000L), (StorageLevel)StorageLevel.MEMORY_AND_DISK_2(), handler, String.class, (String)"fakeAccessKey", (String)"fakeSecretKey");
        this.ssc.stop();
    }

    @Test
    public void testCustomHandlerAwsStsCreds() {
        JavaReceiverInputDStream kinesisStream = KinesisUtils.createStream((JavaStreamingContext)this.ssc, (String)"testApp", (String)"mySparkStream", (String)"https://kinesis.us-west-2.amazonaws.com", (String)"us-west-2", (InitialPositionInStream)InitialPositionInStream.LATEST, (Duration)new Duration(2000L), (StorageLevel)StorageLevel.MEMORY_AND_DISK_2(), handler, String.class, (String)"fakeAccessKey", (String)"fakeSecretKey", (String)"fakeSTSRoleArn", (String)"fakeSTSSessionName", (String)"fakeSTSExternalId");
        this.ssc.stop();
    }
}

