/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class StringMap
extends AbstractMap
implements Externalizable {
    public static final boolean CASE_INSENSTIVE = true;
    protected static final int __HASH_WIDTH = 17;
    protected int _width = 17;
    protected Node _root = new Node();
    protected boolean _ignoreCase = false;
    protected NullEntry _nullEntry = null;
    protected Object _nullValue = null;
    protected HashSet _entrySet = new HashSet(3);
    protected Set _umEntrySet = Collections.unmodifiableSet(this._entrySet);

    public StringMap() {
    }

    public StringMap(boolean ignoreCase) {
        this();
        this._ignoreCase = ignoreCase;
    }

    public StringMap(boolean ignoreCase, int width) {
        this();
        this._ignoreCase = ignoreCase;
        this._width = width;
    }

    public void setIgnoreCase(boolean ic) {
        if (this._root._children != null) {
            throw new IllegalStateException("Must be set before first put");
        }
        this._ignoreCase = ic;
    }

    public boolean isIgnoreCase() {
        return this._ignoreCase;
    }

    public void setWidth(int width) {
        this._width = width;
    }

    public int getWidth() {
        return this._width;
    }

    public Object put(Object key, Object value2) {
        if (key == null) {
            return this.put(null, value2);
        }
        return this.put(key.toString(), value2);
    }

    public Object put(String key, Object value2) {
        if (key == null) {
            Object oldValue = this._nullValue;
            this._nullValue = value2;
            if (this._nullEntry == null) {
                this._nullEntry = new NullEntry();
                this._entrySet.add(this._nullEntry);
            }
            return oldValue;
        }
        Node node = this._root;
        int ni = -1;
        Node prev = null;
        Node parent = null;
        block0: for (int i = 0; i < key.length(); ++i) {
            char c = key.charAt(i);
            if (ni == -1) {
                parent = node;
                prev = null;
                ni = 0;
                Node node2 = node = node._children == null ? null : node._children[c % this._width];
            }
            while (node != null) {
                if (node._char[ni] == c || this._ignoreCase && node._ochar[ni] == c) {
                    prev = null;
                    if (++ni != node._char.length) continue block0;
                    ni = -1;
                    continue block0;
                }
                if (ni == 0) {
                    prev = node;
                    node = node._next;
                    continue;
                }
                node.split(this, ni);
                --i;
                ni = -1;
                continue block0;
            }
            node = new Node(this._ignoreCase, key, i);
            if (prev != null) {
                prev._next = node;
                break;
            }
            if (parent != null) {
                if (parent._children == null) {
                    parent._children = new Node[this._width];
                }
                parent._children[c % this._width] = node;
                int oi = node._ochar[0] % this._width;
                if (node._ochar == null || node._char[0] % this._width == oi) break;
                if (parent._children[oi] == null) {
                    parent._children[oi] = node;
                    break;
                }
                Node n = parent._children[oi];
                while (n._next != null) {
                    n = n._next;
                }
                n._next = node;
                break;
            }
            this._root = node;
            break;
        }
        if (node != null) {
            if (ni > 0) {
                node.split(this, ni);
            }
            Object old = node._value;
            node._key = key;
            node._value = value2;
            this._entrySet.add(node);
            return old;
        }
        return null;
    }

    public Object get(Object key) {
        if (key == null) {
            return this._nullValue;
        }
        if (key instanceof String) {
            return this.get((String)key);
        }
        return this.get(key.toString());
    }

    public Object get(String key) {
        if (key == null) {
            return this._nullValue;
        }
        Map.Entry entry2 = this.getEntry(key, 0, key.length());
        if (entry2 == null) {
            return null;
        }
        return entry2.getValue();
    }

    public Map.Entry getEntry(String key, int offset, int length) {
        if (key == null) {
            return this._nullEntry;
        }
        Node node = this._root;
        int ni = -1;
        block0: for (int i = 0; i < length; ++i) {
            char c = key.charAt(offset + i);
            if (ni == -1) {
                ni = 0;
                Node node2 = node = node._children == null ? null : node._children[c % this._width];
            }
            while (node != null) {
                if (node._char[ni] == c || this._ignoreCase && node._ochar[ni] == c) {
                    if (++ni != node._char.length) continue block0;
                    ni = -1;
                    continue block0;
                }
                if (ni > 0) {
                    return null;
                }
                node = node._next;
            }
            return null;
        }
        if (ni > 0) {
            return null;
        }
        if (node != null && node._key == null) {
            return null;
        }
        return node;
    }

    public Map.Entry getEntry(char[] key, int offset, int length) {
        if (key == null) {
            return this._nullEntry;
        }
        Node node = this._root;
        int ni = -1;
        block0: for (int i = 0; i < length; ++i) {
            char c = key[offset + i];
            if (ni == -1) {
                ni = 0;
                Node node2 = node = node._children == null ? null : node._children[c % this._width];
            }
            while (node != null) {
                if (node._char[ni] == c || this._ignoreCase && node._ochar[ni] == c) {
                    if (++ni != node._char.length) continue block0;
                    ni = -1;
                    continue block0;
                }
                if (ni > 0) {
                    return null;
                }
                node = node._next;
            }
            return null;
        }
        if (ni > 0) {
            return null;
        }
        if (node != null && node._key == null) {
            return null;
        }
        return node;
    }

    public Map.Entry getBestEntry(byte[] key, int offset, int maxLength) {
        if (key == null) {
            return this._nullEntry;
        }
        Node node = this._root;
        int ni = -1;
        block0: for (int i = 0; i < maxLength; ++i) {
            char c = (char)key[offset + i];
            if (ni == -1) {
                Node child;
                ni = 0;
                Node node2 = child = node._children == null ? null : node._children[c % this._width];
                if (child == null && i > 0) {
                    return node;
                }
                node = child;
            }
            while (node != null) {
                if (node._char[ni] == c || this._ignoreCase && node._ochar[ni] == c) {
                    if (++ni != node._char.length) continue block0;
                    ni = -1;
                    continue block0;
                }
                if (ni > 0) {
                    return null;
                }
                node = node._next;
            }
            return null;
        }
        if (ni > 0) {
            return null;
        }
        if (node != null && node._key == null) {
            return null;
        }
        return node;
    }

    public Object remove(Object key) {
        if (key == null) {
            return this.remove(null);
        }
        return this.remove(key.toString());
    }

    public Object remove(String key) {
        if (key == null) {
            Object oldValue = this._nullValue;
            if (this._nullEntry != null) {
                this._entrySet.remove(this._nullEntry);
                this._nullEntry = null;
                this._nullValue = null;
            }
            return oldValue;
        }
        Node node = this._root;
        int ni = -1;
        block0: for (int i = 0; i < key.length(); ++i) {
            char c = key.charAt(i);
            if (ni == -1) {
                ni = 0;
                Node node2 = node = node._children == null ? null : node._children[c % this._width];
            }
            while (node != null) {
                if (node._char[ni] == c || this._ignoreCase && node._ochar[ni] == c) {
                    if (++ni != node._char.length) continue block0;
                    ni = -1;
                    continue block0;
                }
                if (ni > 0) {
                    return null;
                }
                node = node._next;
            }
            return null;
        }
        if (ni > 0) {
            return null;
        }
        if (node != null && node._key == null) {
            return null;
        }
        Object old = node._value;
        this._entrySet.remove(node);
        node._value = null;
        node._key = null;
        return old;
    }

    public Set entrySet() {
        return this._umEntrySet;
    }

    public int size() {
        return this._entrySet.size();
    }

    public boolean isEmpty() {
        return this._entrySet.isEmpty();
    }

    public boolean containsKey(Object key) {
        if (key == null) {
            return this._nullEntry != null;
        }
        return this.getEntry(key.toString(), 0, key == null ? 0 : key.toString().length()) != null;
    }

    public void clear() {
        this._root = new Node();
        this._nullEntry = null;
        this._nullValue = null;
        this._entrySet.clear();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        HashMap map2 = new HashMap(this);
        out.writeBoolean(this._ignoreCase);
        out.writeObject(map2);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        boolean ic = in.readBoolean();
        HashMap map2 = (HashMap)in.readObject();
        this.setIgnoreCase(ic);
        this.putAll(map2);
    }

    private class NullEntry
    implements Map.Entry {
        private NullEntry() {
        }

        public Object getKey() {
            return null;
        }

        public Object getValue() {
            return StringMap.this._nullValue;
        }

        public Object setValue(Object o) {
            Object old = StringMap.this._nullValue;
            StringMap.this._nullValue = o;
            return old;
        }

        public String toString() {
            return "[:null=" + StringMap.this._nullValue + "]";
        }
    }

    private static class Node
    implements Map.Entry {
        char[] _char;
        char[] _ochar;
        Node _next;
        Node[] _children;
        String _key;
        Object _value;

        Node() {
        }

        Node(boolean ignoreCase, String s2, int offset) {
            int l = s2.length() - offset;
            this._char = new char[l];
            this._ochar = new char[l];
            for (int i = 0; i < l; ++i) {
                char c;
                this._char[i] = c = s2.charAt(offset + i);
                if (!ignoreCase) continue;
                char o = c;
                if (Character.isUpperCase(c)) {
                    o = Character.toLowerCase(c);
                } else if (Character.isLowerCase(c)) {
                    o = Character.toUpperCase(c);
                }
                this._ochar[i] = o;
            }
        }

        Node split(StringMap map2, int offset) {
            Node split2 = new Node();
            int sl = this._char.length - offset;
            char[] tmp = this._char;
            this._char = new char[offset];
            split2._char = new char[sl];
            System.arraycopy(tmp, 0, this._char, 0, offset);
            System.arraycopy(tmp, offset, split2._char, 0, sl);
            if (this._ochar != null) {
                tmp = this._ochar;
                this._ochar = new char[offset];
                split2._ochar = new char[sl];
                System.arraycopy(tmp, 0, this._ochar, 0, offset);
                System.arraycopy(tmp, offset, split2._ochar, 0, sl);
            }
            split2._key = this._key;
            split2._value = this._value;
            this._key = null;
            this._value = null;
            if (map2._entrySet.remove(this)) {
                map2._entrySet.add(split2);
            }
            split2._children = this._children;
            this._children = new Node[map2._width];
            this._children[split2._char[0] % map2._width] = split2;
            if (split2._ochar != null && this._children[split2._ochar[0] % map2._width] != split2) {
                this._children[split2._ochar[0] % map2._width] = split2;
            }
            return split2;
        }

        public Object getKey() {
            return this._key;
        }

        public Object getValue() {
            return this._value;
        }

        public Object setValue(Object o) {
            Object old = this._value;
            this._value = o;
            return old;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            StringBuffer buf;
            StringBuffer stringBuffer = buf = new StringBuffer();
            synchronized (stringBuffer) {
                this.toString(buf);
            }
            return buf.toString();
        }

        private void toString(StringBuffer buf) {
            int i;
            buf.append("{[");
            if (this._char == null) {
                buf.append('-');
            } else {
                for (i = 0; i < this._char.length; ++i) {
                    buf.append(this._char[i]);
                }
            }
            buf.append(':');
            buf.append(this._key);
            buf.append('=');
            buf.append(this._value);
            buf.append(']');
            if (this._children != null) {
                for (i = 0; i < this._children.length; ++i) {
                    buf.append('|');
                    if (this._children[i] != null) {
                        this._children[i].toString(buf);
                        continue;
                    }
                    buf.append("-");
                }
            }
            buf.append('}');
            if (this._next != null) {
                buf.append(",\n");
                this._next.toString(buf);
            }
        }
    }
}

