/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.nio.transport;

import java.io.EOFException;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.ConnectionProbe;
import org.glassfish.grizzly.Context;
import org.glassfish.grizzly.EmptyCompletionHandler;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.GrizzlyFuture;
import org.glassfish.grizzly.IOEvent;
import org.glassfish.grizzly.IOEventProcessingHandler;
import org.glassfish.grizzly.PortRange;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.ProcessorExecutor;
import org.glassfish.grizzly.ProcessorSelector;
import org.glassfish.grizzly.Reader;
import org.glassfish.grizzly.SocketBinder;
import org.glassfish.grizzly.SocketConnectorHandler;
import org.glassfish.grizzly.StandaloneProcessor;
import org.glassfish.grizzly.StandaloneProcessorSelector;
import org.glassfish.grizzly.ThreadCache;
import org.glassfish.grizzly.Transport;
import org.glassfish.grizzly.WriteResult;
import org.glassfish.grizzly.Writer;
import org.glassfish.grizzly.asyncqueue.AsyncQueueEnabledTransport;
import org.glassfish.grizzly.asyncqueue.AsyncQueueIO;
import org.glassfish.grizzly.asyncqueue.AsyncQueueReader;
import org.glassfish.grizzly.asyncqueue.AsyncQueueWriter;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChainEnabledTransport;
import org.glassfish.grizzly.memory.BufferArray;
import org.glassfish.grizzly.memory.ByteBufferArray;
import org.glassfish.grizzly.monitoring.jmx.JmxObject;
import org.glassfish.grizzly.nio.DefaultSelectionKeyHandler;
import org.glassfish.grizzly.nio.DefaultSelectorHandler;
import org.glassfish.grizzly.nio.NIOConnection;
import org.glassfish.grizzly.nio.NIOTransport;
import org.glassfish.grizzly.nio.RegisterChannelResult;
import org.glassfish.grizzly.nio.RoundRobinConnectionDistributor;
import org.glassfish.grizzly.nio.SelectorRunner;
import org.glassfish.grizzly.nio.tmpselectors.TemporarySelectorIO;
import org.glassfish.grizzly.nio.tmpselectors.TemporarySelectorPool;
import org.glassfish.grizzly.nio.tmpselectors.TemporarySelectorsEnabledTransport;
import org.glassfish.grizzly.nio.transport.TCPNIOAsyncQueueReader;
import org.glassfish.grizzly.nio.transport.TCPNIOAsyncQueueWriter;
import org.glassfish.grizzly.nio.transport.TCPNIOConnection;
import org.glassfish.grizzly.nio.transport.TCPNIOConnectorHandler;
import org.glassfish.grizzly.nio.transport.TCPNIOServerConnection;
import org.glassfish.grizzly.nio.transport.TCPNIOTemporarySelectorReader;
import org.glassfish.grizzly.nio.transport.TCPNIOTemporarySelectorWriter;
import org.glassfish.grizzly.nio.transport.TCPNIOTransportFilter;
import org.glassfish.grizzly.strategies.SameThreadIOStrategy;
import org.glassfish.grizzly.strategies.WorkerThreadIOStrategy;
import org.glassfish.grizzly.threadpool.AbstractThreadPool;
import org.glassfish.grizzly.threadpool.GrizzlyExecutorService;
import org.glassfish.grizzly.threadpool.ThreadPoolProbe;
import org.glassfish.grizzly.threadpool.WorkerThread;
import org.glassfish.grizzly.utils.Exceptions;

public final class TCPNIOTransport
extends NIOTransport
implements SocketBinder,
SocketConnectorHandler,
AsyncQueueEnabledTransport,
FilterChainEnabledTransport,
TemporarySelectorsEnabledTransport {
    private static final Logger LOGGER = Grizzly.logger(TCPNIOTransport.class);
    private static final int DEFAULT_READ_BUFFER_SIZE = -1;
    private static final int DEFAULT_WRITE_BUFFER_SIZE = -1;
    private static final String DEFAULT_TRANSPORT_NAME = "TCPNIOTransport";
    final Collection<TCPNIOServerConnection> serverConnections;
    final AsyncQueueIO<SocketAddress> asyncQueueIO;
    TemporarySelectorIO temporarySelectorIO;
    int serverSocketSoTimeout = 0;
    boolean tcpNoDelay = true;
    boolean reuseAddress = true;
    int linger = -1;
    boolean isKeepAlive = false;
    int clientSocketSoTimeout = -1;
    int serverConnectionBackLog = 4096;
    int connectionTimeout = 30000;
    private final int maxReadAttempts = 3;
    private final Filter defaultTransportFilter;
    final RegisterChannelCompletionHandler selectorRegistrationHandler;
    private final TCPNIOConnectorHandler connectorHandler = new TransportConnectorHandler();
    private static final ThreadCache.CachedTypeIndex<DirectByteBufferRecord> CACHE_IDX = ThreadCache.obtainIndex("direct-buffer-cache", DirectByteBufferRecord.class, 4);

    public TCPNIOTransport() {
        this(DEFAULT_TRANSPORT_NAME);
    }

    TCPNIOTransport(String name) {
        super(name);
        this.readBufferSize = -1;
        this.writeBufferSize = -1;
        this.selectorRegistrationHandler = new RegisterChannelCompletionHandler();
        this.asyncQueueIO = new AsyncQueueIO<SocketAddress>(new TCPNIOAsyncQueueReader(this), new TCPNIOAsyncQueueWriter(this));
        this.temporarySelectorIO = new TemporarySelectorIO(new TCPNIOTemporarySelectorReader(this), new TCPNIOTemporarySelectorWriter(this));
        this.attributeBuilder = Grizzly.DEFAULT_ATTRIBUTE_BUILDER;
        this.defaultTransportFilter = new TCPNIOTransportFilter(this);
        this.serverConnections = new ConcurrentLinkedQueue<TCPNIOServerConnection>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws IOException {
        this.state.getStateLocker().writeLock().lock();
        try {
            Transport.State currentState = (Transport.State)((Object)this.state.getState());
            if (currentState != Transport.State.STOP) {
                LOGGER.log(Level.WARNING, "Transport is not in STOP or BOUND state!");
            }
            this.state.setState(Transport.State.STARTING);
            if (this.selectorHandler == null) {
                this.selectorHandler = new DefaultSelectorHandler();
            }
            if (this.selectionKeyHandler == null) {
                this.selectionKeyHandler = new DefaultSelectionKeyHandler();
            }
            if (this.processor == null && this.processorSelector == null) {
                this.processor = new StandaloneProcessor();
            }
            if (this.selectorRunnersCount <= 0) {
                this.selectorRunnersCount = Runtime.getRuntime().availableProcessors();
            }
            if (this.nioChannelDistributor == null) {
                this.nioChannelDistributor = new RoundRobinConnectionDistributor(this);
            }
            if (this.kernelPool == null) {
                this.kernelPoolConfig.setMemoryManager(this.memoryManager);
                this.setKernelPool0(GrizzlyExecutorService.createInstance(this.kernelPoolConfig));
            }
            if (this.workerThreadPool == null && this.workerPoolConfig != null) {
                this.workerPoolConfig.getInitialMonitoringConfig().addProbes((ThreadPoolProbe[])this.getThreadPoolMonitoringConfig().getProbes());
                this.workerPoolConfig.setMemoryManager(this.memoryManager);
                this.setWorkerThreadPool0(GrizzlyExecutorService.createInstance(this.workerPoolConfig));
            }
            int selectorPoolSize = 32;
            if (this.workerThreadPool instanceof AbstractThreadPool) {
                selectorPoolSize = this.strategy instanceof SameThreadIOStrategy ? this.selectorRunnersCount : Math.min(((AbstractThreadPool)this.workerThreadPool).getConfig().getMaxPoolSize(), selectorPoolSize);
            }
            if (this.strategy == null) {
                this.strategy = WorkerThreadIOStrategy.getInstance();
            }
            this.temporarySelectorIO.setSelectorPool(new TemporarySelectorPool(selectorPoolSize));
            this.startSelectorRunners();
            this.listenServerConnections();
            this.state.setState(Transport.State.START);
            TCPNIOTransport.notifyProbesStart(this);
        }
        finally {
            this.state.getStateLocker().writeLock().unlock();
        }
    }

    private void listenServerConnections() {
        for (TCPNIOServerConnection serverConnection : this.serverConnections) {
            try {
                this.listenServerConnection(serverConnection);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Exception occurred when starting server connection: " + serverConnection, e);
            }
        }
    }

    private void listenServerConnection(TCPNIOServerConnection serverConnection) throws IOException {
        serverConnection.listen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws IOException {
        this.state.getStateLocker().writeLock().lock();
        try {
            this.unbindAll();
            this.state.setState(Transport.State.STOP);
            this.stopSelectorRunners();
            if (this.workerThreadPool != null && this.managedWorkerPool) {
                this.workerThreadPool.shutdown();
                this.workerThreadPool = null;
            }
            if (this.kernelPool != null) {
                this.kernelPool.shutdownNow();
                this.kernelPool = null;
            }
            TCPNIOTransport.notifyProbesStop(this);
        }
        finally {
            this.state.getStateLocker().writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pause() throws IOException {
        this.state.getStateLocker().writeLock().lock();
        try {
            if (this.state.getState() != Transport.State.START) {
                LOGGER.log(Level.WARNING, "Transport is not in START state!");
            }
            this.state.setState(Transport.State.PAUSE);
            TCPNIOTransport.notifyProbesPause(this);
        }
        finally {
            this.state.getStateLocker().writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resume() throws IOException {
        this.state.getStateLocker().writeLock().lock();
        try {
            if (this.state.getState() != Transport.State.PAUSE) {
                LOGGER.log(Level.WARNING, "Transport is not in PAUSE state!");
            }
            this.state.setState(Transport.State.START);
            TCPNIOTransport.notifyProbesResume(this);
        }
        finally {
            this.state.getStateLocker().writeLock().unlock();
        }
    }

    @Override
    public TCPNIOServerConnection bind(int port) throws IOException {
        return this.bind(new InetSocketAddress(port));
    }

    @Override
    public TCPNIOServerConnection bind(String host, int port) throws IOException {
        return this.bind(host, port, this.serverConnectionBackLog);
    }

    @Override
    public TCPNIOServerConnection bind(String host, int port, int backlog) throws IOException {
        return this.bind(new InetSocketAddress(host, port), backlog);
    }

    @Override
    public TCPNIOServerConnection bind(SocketAddress socketAddress) throws IOException {
        return this.bind(socketAddress, this.serverConnectionBackLog);
    }

    @Override
    public TCPNIOServerConnection bind(SocketAddress socketAddress, int backlog) throws IOException {
        this.state.getStateLocker().writeLock().lock();
        NIOConnection serverConnection = null;
        ServerSocketChannel serverSocketChannel = ServerSocketChannel.open();
        try {
            ServerSocket serverSocket = serverSocketChannel.socket();
            serverSocket.setReuseAddress(this.reuseAddress);
            serverSocket.setSoTimeout(this.serverSocketSoTimeout);
            serverSocket.bind(socketAddress, backlog);
            serverSocketChannel.configureBlocking(false);
            serverConnection = this.obtainServerNIOConnection(serverSocketChannel);
            this.serverConnections.add((TCPNIOServerConnection)serverConnection);
            ((TCPNIOConnection)serverConnection).resetProperties();
            if (!this.isStopped()) {
                this.listenServerConnection((TCPNIOServerConnection)serverConnection);
            }
            NIOConnection nIOConnection = serverConnection;
            return nIOConnection;
        }
        catch (Exception e) {
            if (serverConnection != null) {
                this.serverConnections.remove(serverConnection);
                try {
                    serverConnection.close();
                }
                catch (IOException ignored) {}
            } else {
                try {
                    serverSocketChannel.close();
                }
                catch (IOException ignored) {
                    // empty catch block
                }
            }
            throw Exceptions.makeIOException(e);
        }
        finally {
            this.state.getStateLocker().writeLock().unlock();
        }
    }

    @Override
    public TCPNIOServerConnection bind(String host, PortRange portRange, int backlog) throws IOException {
        int offset;
        int lower = portRange.getLower();
        int range2 = portRange.getUpper() - lower + 1;
        int start = offset = RANDOM.nextInt(range2);
        while (true) {
            int port = lower + offset;
            try {
                return this.bind(host, port, backlog);
            }
            catch (IOException e) {
                IOException ioException = e;
                if ((offset = (offset + 1) % range2) != start) continue;
                throw ioException;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unbind(Connection connection) throws IOException {
        block8: {
            this.state.getStateLocker().writeLock().lock();
            try {
                if (connection == null || !this.serverConnections.remove(connection)) break block8;
                GrizzlyFuture<Connection> future = connection.close();
                try {
                    future.get(1000L, TimeUnit.MILLISECONDS);
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Error unbinding connection: " + connection, e);
                }
                finally {
                    future.markForRecycle(true);
                }
            }
            finally {
                this.state.getStateLocker().writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unbindAll() throws IOException {
        this.state.getStateLocker().writeLock().lock();
        try {
            for (TCPNIOServerConnection serverConnection : this.serverConnections) {
                try {
                    this.unbind(serverConnection);
                }
                catch (Exception e) {
                    LOGGER.log(Level.FINE, "Exception occurred when closing server connection: " + serverConnection, e);
                }
            }
            this.serverConnections.clear();
        }
        finally {
            this.state.getStateLocker().writeLock().unlock();
        }
    }

    public GrizzlyFuture<Connection> connect(String host, int port) throws IOException {
        return this.connectorHandler.connect(host, port);
    }

    public GrizzlyFuture<Connection> connect(SocketAddress remoteAddress) throws IOException {
        return this.connectorHandler.connect(remoteAddress);
    }

    public GrizzlyFuture<Connection> connect(SocketAddress remoteAddress, CompletionHandler<Connection> completionHandler) throws IOException {
        return this.connectorHandler.connect(remoteAddress, completionHandler);
    }

    public GrizzlyFuture<Connection> connect(SocketAddress remoteAddress, SocketAddress localAddress) throws IOException {
        return this.connectorHandler.connect(remoteAddress, localAddress);
    }

    public GrizzlyFuture<Connection> connect(SocketAddress remoteAddress, SocketAddress localAddress, CompletionHandler<Connection> completionHandler) throws IOException {
        return this.connectorHandler.connect(remoteAddress, localAddress, completionHandler);
    }

    @Override
    protected void closeConnection(Connection connection) throws IOException {
        SelectableChannel nioChannel = ((NIOConnection)connection).getChannel();
        if (nioChannel != null) {
            try {
                nioChannel.close();
            }
            catch (IOException e) {
                LOGGER.log(Level.FINE, "TCPNIOTransport.closeChannel exception", e);
            }
        }
        if (this.asyncQueueIO != null) {
            AsyncQueueWriter<SocketAddress> writer;
            AsyncQueueReader<SocketAddress> reader = this.asyncQueueIO.getReader();
            if (reader != null) {
                reader.onClose(connection);
            }
            if ((writer = this.asyncQueueIO.getWriter()) != null) {
                writer.onClose(connection);
            }
        }
    }

    TCPNIOConnection obtainNIOConnection(SocketChannel channel) {
        TCPNIOConnection connection = new TCPNIOConnection(this, channel);
        this.configureNIOConnection(connection);
        return connection;
    }

    TCPNIOServerConnection obtainServerNIOConnection(ServerSocketChannel channel) {
        TCPNIOServerConnection connection = new TCPNIOServerConnection(this, channel);
        this.configureNIOConnection(connection);
        return connection;
    }

    void configureNIOConnection(TCPNIOConnection connection) {
        connection.configureBlocking(this.isBlocking);
        connection.configureStandalone(this.isStandalone);
        connection.setProcessor(this.processor);
        connection.setProcessorSelector(this.processorSelector);
        connection.setMonitoringProbes((ConnectionProbe[])this.connectionMonitoringConfig.getProbes());
    }

    void configureChannel(SocketChannel channel) throws IOException {
        Socket socket = channel.socket();
        channel.configureBlocking(false);
        try {
            if (this.linger >= 0) {
                socket.setSoLinger(true, this.linger);
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Can not set linger to " + this.linger, e);
        }
        try {
            socket.setKeepAlive(this.isKeepAlive);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Can not set keepAlive to " + this.isKeepAlive, e);
        }
        try {
            socket.setTcpNoDelay(this.tcpNoDelay);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Can not set TcpNoDelay to " + this.tcpNoDelay, e);
        }
        socket.setReuseAddress(this.reuseAddress);
    }

    @Override
    public AsyncQueueIO<SocketAddress> getAsyncQueueIO() {
        return this.asyncQueueIO;
    }

    @Override
    public synchronized void configureStandalone(boolean isStandalone) {
        if (this.isStandalone != isStandalone) {
            this.isStandalone = isStandalone;
            if (isStandalone) {
                this.processor = StandaloneProcessor.INSTANCE;
                this.processorSelector = StandaloneProcessorSelector.INSTANCE;
            } else {
                this.processor = null;
                this.processorSelector = null;
            }
        }
    }

    public int getLinger() {
        return this.linger;
    }

    public void setLinger(int linger) {
        this.linger = linger;
        TCPNIOTransport.notifyProbesConfigChanged(this);
    }

    public int getServerConnectionBackLog() {
        return this.serverConnectionBackLog;
    }

    public void setServerConnectionBackLog(int serverConnectionBackLog) {
        this.serverConnectionBackLog = serverConnectionBackLog;
    }

    public boolean isKeepAlive() {
        return this.isKeepAlive;
    }

    public void setKeepAlive(boolean isKeepAlive) {
        this.isKeepAlive = isKeepAlive;
        TCPNIOTransport.notifyProbesConfigChanged(this);
    }

    public boolean isReuseAddress() {
        return this.reuseAddress;
    }

    public void setReuseAddress(boolean reuseAddress) {
        this.reuseAddress = reuseAddress;
        TCPNIOTransport.notifyProbesConfigChanged(this);
    }

    public int getClientSocketSoTimeout() {
        return this.clientSocketSoTimeout;
    }

    public void setClientSocketSoTimeout(int socketTimeout) {
        this.clientSocketSoTimeout = socketTimeout;
        TCPNIOTransport.notifyProbesConfigChanged(this);
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        TCPNIOTransport.notifyProbesConfigChanged(this);
    }

    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
        TCPNIOTransport.notifyProbesConfigChanged(this);
    }

    public int getServerSocketSoTimeout() {
        return this.serverSocketSoTimeout;
    }

    public void setServerSocketSoTimeout(int serverSocketSoTimeout) {
        this.serverSocketSoTimeout = serverSocketSoTimeout;
        TCPNIOTransport.notifyProbesConfigChanged(this);
    }

    @Override
    public Filter getTransportFilter() {
        return this.defaultTransportFilter;
    }

    @Override
    public TemporarySelectorIO getTemporarySelectorIO() {
        return this.temporarySelectorIO;
    }

    @Override
    public void setTemporarySelectorIO(TemporarySelectorIO temporarySelectorIO) {
        this.temporarySelectorIO = temporarySelectorIO;
        TCPNIOTransport.notifyProbesConfigChanged(this);
    }

    @Override
    public Transport.IOEventReg fireIOEvent(IOEvent ioEvent, Connection connection, IOEventProcessingHandler processingHandler) throws IOException {
        try {
            if (ioEvent == IOEvent.SERVER_ACCEPT) {
                ((TCPNIOServerConnection)connection).onAccept();
                return Transport.IOEventReg.REGISTER;
            }
            if (ioEvent == IOEvent.CLIENT_CONNECTED) {
                ((TCPNIOConnection)connection).onConnect();
                return Transport.IOEventReg.REGISTER;
            }
            Processor conProcessor = connection.obtainProcessor(ioEvent);
            if (ProcessorExecutor.execute(Context.create(connection, conProcessor, ioEvent, processingHandler))) {
                return Transport.IOEventReg.REGISTER;
            }
            return Transport.IOEventReg.DEREGISTER;
        }
        catch (IOException e) {
            LOGGER.log(Level.FINE, "IOException occurred on fireIOEvent(). Connection={0} event={1}", new Object[]{connection, ioEvent});
            throw e;
        }
        catch (Exception e) {
            String text2 = new StringBuilder(256).append("Unexpected exception occurred fireIOEvent().").append("connection=").append(connection).append(" event=").append((Object)ioEvent).toString();
            LOGGER.log(Level.WARNING, text2, e);
            throw new IOException(e.getClass() + ": " + text2);
        }
    }

    @Override
    public Reader<SocketAddress> getReader(Connection connection) {
        return this.getReader(connection.isBlocking());
    }

    @Override
    public Reader<SocketAddress> getReader(boolean isBlocking) {
        if (isBlocking) {
            return this.getTemporarySelectorIO().getReader();
        }
        return this.getAsyncQueueIO().getReader();
    }

    @Override
    public Writer<SocketAddress> getWriter(Connection connection) {
        return this.getWriter(connection.isBlocking());
    }

    @Override
    public Writer<SocketAddress> getWriter(boolean isBlocking) {
        if (isBlocking) {
            return this.getTemporarySelectorIO().getWriter();
        }
        return this.getAsyncQueueIO().getWriter();
    }

    public Buffer read(Connection connection, Buffer buffer) throws IOException {
        boolean isAllocate;
        Thread currentThread = Thread.currentThread();
        boolean isSelectorThread = currentThread instanceof WorkerThread && ((WorkerThread)((Object)currentThread)).isSelectorThread();
        TCPNIOConnection tcpConnection = (TCPNIOConnection)connection;
        boolean bl = isAllocate = buffer == null;
        if (isAllocate) {
            int read2;
            try {
                int receiveBufferSize = connection.getReadBufferSize();
                if (!this.memoryManager.willAllocateDirect(receiveBufferSize)) {
                    DirectByteBufferRecord directByteBufferRecord = TCPNIOTransport.obtainDirectByteBuffer(receiveBufferSize);
                    ByteBuffer directByteBuffer = directByteBufferRecord.strongRef;
                    read2 = this.readSimpleByteBuffer(tcpConnection, directByteBuffer, isSelectorThread);
                    directByteBuffer.flip();
                    buffer = this.memoryManager.allocate(read2);
                    buffer.put(directByteBuffer);
                    TCPNIOTransport.releaseDirectByteBuffer(directByteBufferRecord);
                } else {
                    buffer = this.memoryManager.allocateAtLeast(receiveBufferSize);
                    read2 = this.readSimple(tcpConnection, buffer, isSelectorThread);
                }
                tcpConnection.onRead(buffer, read2);
            }
            catch (Exception e) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "TCPNIOConnection (" + connection + ") (allocated) read exception", e);
                }
                read2 = -1;
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "TCPNIOConnection ({0}) (allocated) read {1} bytes", new Object[]{connection, read2});
            }
            if (read2 > 0) {
                buffer.position(read2);
            } else {
                if (buffer != null) {
                    buffer.dispose();
                    buffer = null;
                }
                if (read2 < 0) {
                    throw new EOFException();
                }
            }
        } else if (buffer.hasRemaining()) {
            int read3;
            int oldPos = buffer.position();
            SocketChannel socketChannel = (SocketChannel)tcpConnection.getChannel();
            if (buffer.isComposite()) {
                ByteBufferArray array = buffer.toByteBufferArray();
                ByteBuffer[] byteBuffers = (ByteBuffer[])array.getArray();
                int size2 = array.size();
                read3 = !isSelectorThread ? this.doReadInLoop(socketChannel, byteBuffers, 0, size2) : (int)socketChannel.read(byteBuffers, 0, size2);
                array.restore();
                array.recycle();
            } else {
                read3 = this.readSimple(tcpConnection, buffer, isSelectorThread);
            }
            if (read3 > 0) {
                buffer.position(oldPos + read3);
            }
            tcpConnection.onRead(buffer, read3);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "TCPNIOConnection ({0}) (nonallocated) read {1} bytes", new Object[]{connection, read3});
            }
            if (read3 < 0) {
                throw new EOFException();
            }
        }
        return buffer;
    }

    private int readSimple(TCPNIOConnection tcpConnection, Buffer buffer, boolean isSelectorThread) throws IOException {
        SocketChannel socketChannel = (SocketChannel)tcpConnection.getChannel();
        int read2 = !isSelectorThread ? this.doReadInLoop(socketChannel, buffer.toByteBuffer()) : socketChannel.read(buffer.toByteBuffer());
        return read2;
    }

    private int readSimpleByteBuffer(TCPNIOConnection tcpConnection, ByteBuffer byteBuffer, boolean isSelectorThread) throws IOException {
        SocketChannel socketChannel = (SocketChannel)tcpConnection.getChannel();
        int read2 = !isSelectorThread ? this.doReadInLoop(socketChannel, byteBuffer) : socketChannel.read(byteBuffer);
        return read2;
    }

    private int doReadInLoop(SocketChannel socketChannel, ByteBuffer byteBuffer) throws IOException {
        int readNow;
        int read2 = 0;
        int readAttempt = 0;
        while ((readNow = socketChannel.read(byteBuffer)) >= 0) {
            read2 += readNow;
            if (byteBuffer.hasRemaining() && ++readAttempt < 3) continue;
            return read2;
        }
        if (read2 == 0) {
            read2 = readNow;
        }
        return read2;
    }

    private int doReadInLoop(SocketChannel socketChannel, ByteBuffer[] byteBuffers, int offset, int length) throws IOException {
        int readNow;
        int read2 = 0;
        int readAttempt = 0;
        ByteBuffer lastByteBuffer = byteBuffers[length - 1];
        while ((readNow = (int)socketChannel.read(byteBuffers, offset, length)) >= 0) {
            read2 += readNow;
            if (lastByteBuffer.hasRemaining() && ++readAttempt < 3) continue;
            return read2;
        }
        if (read2 == 0) {
            read2 = readNow;
        }
        return read2;
    }

    public int write(Connection connection, Buffer buffer) throws IOException {
        return this.write(connection, buffer, null);
    }

    public int write(Connection connection, Buffer buffer, WriteResult currentResult) throws IOException {
        boolean hasWritten;
        int written;
        TCPNIOConnection tcpConnection = (TCPNIOConnection)connection;
        int oldPos = buffer.position();
        if (buffer.isComposite()) {
            BufferArray array = buffer.toBufferArray();
            written = TCPNIOTransport.writeGathered(tcpConnection, array);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "TCPNIOConnection ({0}) (composite) write {1} bytes", new Object[]{connection, written});
            }
            array.restore();
            array.recycle();
        } else {
            written = TCPNIOTransport.writeSimple(tcpConnection, buffer);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "TCPNIOConnection ({0}) (plain) write {1} bytes", new Object[]{connection, written});
            }
        }
        boolean bl = hasWritten = written >= 0;
        if (hasWritten) {
            buffer.position(oldPos + written);
        }
        tcpConnection.onWrite(buffer, written);
        if (hasWritten) {
            if (currentResult != null) {
                currentResult.setMessage(buffer);
                currentResult.setWrittenSize(currentResult.getWrittenSize() + written);
                currentResult.setDstAddress(connection.getPeerAddress());
            }
        } else {
            throw new IOException("Error writing to peer");
        }
        return written;
    }

    private static int writeSimple(TCPNIOConnection tcpConnection, Buffer buffer) throws IOException {
        SocketChannel socketChannel = (SocketChannel)tcpConnection.getChannel();
        if (!buffer.hasRemaining()) {
            return 0;
        }
        return TCPNIOTransport.flushByteBuffer(socketChannel, buffer.toByteBuffer());
    }

    private static int writeGathered(TCPNIOConnection tcpConnection, BufferArray bufferArray) throws IOException {
        Buffer[] buffers = (Buffer[])bufferArray.getArray();
        int length = bufferArray.size();
        SocketChannel socketChannel = (SocketChannel)tcpConnection.getChannel();
        int written = 0;
        DirectByteBufferRecord record = null;
        ByteBuffer directByteBuffer = null;
        int i = TCPNIOTransport.findNextAvailBuffer(buffers, -1, length);
        while (i < length) {
            boolean isFlush;
            Buffer buffer = buffers[i];
            int next2 = TCPNIOTransport.findNextAvailBuffer(buffers, i, length);
            boolean bl = isFlush = next2 == length || buffers[next2].isDirect();
            if (!buffer.isDirect()) {
                int currentBufferRemaining;
                boolean isAdaptByteBuffer;
                if (record == null) {
                    record = TCPNIOTransport.obtainDirectByteBuffer(tcpConnection.getWriteBufferSize());
                    directByteBuffer = record.strongRef;
                }
                boolean bl2 = isAdaptByteBuffer = (currentBufferRemaining = buffer.remaining()) < directByteBuffer.remaining();
                if (isAdaptByteBuffer) {
                    directByteBuffer.limit(directByteBuffer.position() + currentBufferRemaining);
                }
                buffer.get(directByteBuffer);
                if (isAdaptByteBuffer) {
                    directByteBuffer.limit(directByteBuffer.capacity());
                }
                if (!directByteBuffer.hasRemaining() || isFlush) {
                    int remaining;
                    directByteBuffer.flip();
                    written += TCPNIOTransport.flushByteBuffer(socketChannel, directByteBuffer);
                    if (remaining > 0) {
                        int shift;
                        for (remaining = directByteBuffer.remaining(); remaining > 0; remaining -= shift) {
                            Buffer revertBuffer = buffers[i];
                            shift = Math.min(remaining, revertBuffer.position() - bufferArray.getInitialPosition(i));
                            revertBuffer.position(revertBuffer.position() - shift);
                            --i;
                        }
                        break;
                    }
                    directByteBuffer.clear();
                    if (buffer.hasRemaining()) {
                        next2 = i;
                    }
                }
            } else {
                ByteBuffer byteBuffer = buffer.toByteBuffer();
                written += socketChannel.write(byteBuffer);
                if (byteBuffer.hasRemaining()) break;
            }
            i = next2;
        }
        if (record != null) {
            directByteBuffer.clear();
            TCPNIOTransport.releaseDirectByteBuffer(record);
        }
        return written;
    }

    private static int findNextAvailBuffer(Buffer[] buffers, int start, int end) {
        for (int i = start + 1; i < end; ++i) {
            if (!buffers[i].hasRemaining()) continue;
            return i;
        }
        return end;
    }

    static int flushByteBuffer(SocketChannel channel, ByteBuffer byteBuffer) throws IOException {
        return channel.write(byteBuffer);
    }

    static DirectByteBufferRecord obtainDirectByteBuffer(int size2) {
        DirectByteBufferRecord record = ThreadCache.takeFromCache(CACHE_IDX);
        if (record != null) {
            ByteBuffer byteBuffer = record.switchToStrong();
            if (byteBuffer != null && byteBuffer.remaining() >= size2) {
                return record;
            }
        } else {
            record = new DirectByteBufferRecord();
        }
        record.reset(ByteBuffer.allocateDirect(size2));
        return record;
    }

    static void releaseDirectByteBuffer(DirectByteBufferRecord directByteBufferRecord) {
        directByteBufferRecord.strongRef.clear();
        directByteBufferRecord.switchToSoft();
        ThreadCache.putToCache(CACHE_IDX, directByteBufferRecord);
    }

    @Override
    protected JmxObject createJmxManagementObject() {
        return new org.glassfish.grizzly.nio.transport.jmx.TCPNIOTransport(this);
    }

    class TransportConnectorHandler
    extends TCPNIOConnectorHandler {
        public TransportConnectorHandler() {
            super(TCPNIOTransport.this);
        }

        @Override
        public Processor getProcessor() {
            return TCPNIOTransport.this.getProcessor();
        }

        @Override
        public ProcessorSelector getProcessorSelector() {
            return TCPNIOTransport.this.getProcessorSelector();
        }
    }

    class RegisterChannelCompletionHandler
    extends EmptyCompletionHandler<RegisterChannelResult> {
        RegisterChannelCompletionHandler() {
        }

        @Override
        public void completed(RegisterChannelResult result2) {
            SelectionKey selectionKey = result2.getSelectionKey();
            TCPNIOConnection connection = (TCPNIOConnection)TCPNIOTransport.this.getSelectionKeyHandler().getConnectionForKey(selectionKey);
            if (connection != null) {
                SelectorRunner selectorRunner = result2.getSelectorRunner();
                connection.setSelectionKey(selectionKey);
                connection.setSelectorRunner(selectorRunner);
            }
        }
    }

    static final class DirectByteBufferRecord {
        ByteBuffer strongRef;
        private SoftReference<ByteBuffer> softRef;

        DirectByteBufferRecord() {
        }

        void reset(ByteBuffer byteBuffer) {
            this.strongRef = byteBuffer;
            this.softRef = null;
        }

        ByteBuffer switchToStrong() {
            if (this.strongRef == null && this.softRef != null) {
                this.strongRef = this.softRef.get();
            }
            return this.strongRef;
        }

        void switchToSoft() {
            if (this.strongRef != null && this.softRef == null) {
                this.softRef = new SoftReference<ByteBuffer>(this.strongRef);
            }
            this.strongRef = null;
        }
    }
}

