/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.nio;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.util.Queue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.ConnectionProbe;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.GrizzlyFuture;
import org.glassfish.grizzly.IOEvent;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.ProcessorSelector;
import org.glassfish.grizzly.ReadResult;
import org.glassfish.grizzly.StandaloneProcessor;
import org.glassfish.grizzly.StandaloneProcessorSelector;
import org.glassfish.grizzly.Transport;
import org.glassfish.grizzly.WriteResult;
import org.glassfish.grizzly.asyncqueue.AsyncReadQueueRecord;
import org.glassfish.grizzly.asyncqueue.AsyncWriteQueueRecord;
import org.glassfish.grizzly.asyncqueue.TaskQueue;
import org.glassfish.grizzly.attributes.AttributeHolder;
import org.glassfish.grizzly.attributes.IndexedAttributeHolder;
import org.glassfish.grizzly.impl.ReadyFutureImpl;
import org.glassfish.grizzly.impl.SafeFutureImpl;
import org.glassfish.grizzly.monitoring.MonitoringConfig;
import org.glassfish.grizzly.monitoring.MonitoringConfigImpl;
import org.glassfish.grizzly.nio.NIOTransport;
import org.glassfish.grizzly.nio.RegisterChannelResult;
import org.glassfish.grizzly.nio.SelectorHandler;
import org.glassfish.grizzly.nio.SelectorRunner;
import org.glassfish.grizzly.utils.CompletionHandlerAdapter;
import org.glassfish.grizzly.utils.DataStructures;

public abstract class NIOConnection
implements Connection<SocketAddress> {
    private static final boolean WIN32 = "\\".equals(System.getProperty("file.separator"));
    private static final Logger logger = Grizzly.logger(NIOConnection.class);
    private static final short MAX_ZERO_READ_COUNT = 100;
    protected final NIOTransport transport;
    protected volatile int readBufferSize;
    protected volatile int writeBufferSize;
    protected volatile long readTimeoutMillis = 30000L;
    protected volatile long writeTimeoutMillis = 30000L;
    protected volatile SelectorRunner selectorRunner;
    protected volatile SelectableChannel channel;
    protected volatile SelectionKey selectionKey;
    protected volatile Processor processor;
    protected volatile ProcessorSelector processorSelector;
    protected final AttributeHolder attributes;
    protected final TaskQueue<AsyncReadQueueRecord> asyncReadQueue;
    protected final TaskQueue<AsyncWriteQueueRecord> asyncWriteQueue;
    protected final AtomicBoolean isClosed = new AtomicBoolean(false);
    protected volatile boolean isBlocking;
    protected volatile boolean isStandalone;
    protected short zeroByteReadCount;
    private final Queue<Connection.CloseListener> closeListeners = DataStructures.getLTQInstance(Connection.CloseListener.class);
    protected final MonitoringConfigImpl<ConnectionProbe> monitoringConfig = new MonitoringConfigImpl<ConnectionProbe>(ConnectionProbe.class);

    public NIOConnection(NIOTransport transport) {
        this.transport = transport;
        this.asyncReadQueue = TaskQueue.createTaskQueue();
        this.asyncWriteQueue = TaskQueue.createTaskQueue();
        this.attributes = new IndexedAttributeHolder(transport.getAttributeBuilder());
    }

    @Override
    public void configureBlocking(boolean isBlocking) {
        this.isBlocking = isBlocking;
    }

    @Override
    public boolean isBlocking() {
        return this.isBlocking;
    }

    @Override
    public synchronized void configureStandalone(boolean isStandalone) {
        if (this.isStandalone != isStandalone) {
            this.isStandalone = isStandalone;
            if (isStandalone) {
                this.processor = StandaloneProcessor.INSTANCE;
                this.processorSelector = StandaloneProcessorSelector.INSTANCE;
            } else {
                this.processor = this.transport.getProcessor();
                this.processorSelector = this.transport.getProcessorSelector();
            }
        }
    }

    @Override
    public boolean isStandalone() {
        return this.isStandalone;
    }

    @Override
    public Transport getTransport() {
        return this.transport;
    }

    @Override
    public int getReadBufferSize() {
        return this.readBufferSize;
    }

    @Override
    public void setReadBufferSize(int readBufferSize) {
        this.readBufferSize = readBufferSize;
    }

    @Override
    public int getWriteBufferSize() {
        return this.writeBufferSize;
    }

    @Override
    public void setWriteBufferSize(int writeBufferSize) {
        this.writeBufferSize = writeBufferSize;
    }

    @Override
    public long getReadTimeout(TimeUnit timeUnit) {
        return timeUnit.convert(this.readTimeoutMillis, TimeUnit.MILLISECONDS);
    }

    @Override
    public void setReadTimeout(long timeout, TimeUnit timeUnit) {
        this.readTimeoutMillis = TimeUnit.MILLISECONDS.convert(timeout, timeUnit);
    }

    @Override
    public long getWriteTimeout(TimeUnit timeUnit) {
        return timeUnit.convert(this.writeTimeoutMillis, TimeUnit.MILLISECONDS);
    }

    @Override
    public void setWriteTimeout(long timeout, TimeUnit timeUnit) {
        this.writeTimeoutMillis = TimeUnit.MILLISECONDS.convert(timeout, timeUnit);
    }

    public SelectorRunner getSelectorRunner() {
        return this.selectorRunner;
    }

    protected void setSelectorRunner(SelectorRunner selectorRunner) {
        this.selectorRunner = selectorRunner;
    }

    public void attachToSelectorRunner(SelectorRunner selectorRunner) throws IOException {
        this.detachSelectorRunner();
        SelectorHandler selectorHandler = this.transport.getSelectorHandler();
        GrizzlyFuture<RegisterChannelResult> future = selectorHandler.registerChannelAsync(selectorRunner, this.channel, 0, this, null);
        try {
            RegisterChannelResult result2 = (RegisterChannelResult)future.get(this.readTimeoutMillis, TimeUnit.MILLISECONDS);
            this.selectorRunner = selectorRunner;
            this.selectionKey = result2.getSelectionKey();
        }
        catch (InterruptedException e) {
            throw new IOException("", e);
        }
        catch (ExecutionException e) {
            throw new IOException("", e.getCause());
        }
        catch (TimeoutException e) {
            throw new IOException("", e);
        }
    }

    public void detachSelectorRunner() throws IOException {
        SelectorRunner selectorRunnerLocal = this.selectorRunner;
        this.selectionKey = null;
        this.selectorRunner = null;
        if (selectorRunnerLocal != null) {
            this.transport.getSelectorHandler().deregisterChannel(selectorRunnerLocal, this.channel);
        }
    }

    public SelectableChannel getChannel() {
        return this.channel;
    }

    protected void setChannel(SelectableChannel channel) {
        this.channel = channel;
    }

    public SelectionKey getSelectionKey() {
        return this.selectionKey;
    }

    protected void setSelectionKey(SelectionKey selectionKey) {
        this.selectionKey = selectionKey;
        this.setChannel(selectionKey.channel());
    }

    @Override
    public Processor obtainProcessor(IOEvent ioEvent) {
        Processor selectedProcessor;
        if (this.processor == null && this.processorSelector == null) {
            return this.transport.obtainProcessor(ioEvent, this);
        }
        if (this.processor != null && this.processor.isInterested(ioEvent)) {
            return this.processor;
        }
        if (this.processorSelector != null && (selectedProcessor = this.processorSelector.select(ioEvent, this)) != null) {
            return selectedProcessor;
        }
        return null;
    }

    @Override
    public Processor getProcessor() {
        return this.processor;
    }

    @Override
    public void setProcessor(Processor preferableProcessor) {
        this.processor = preferableProcessor;
    }

    @Override
    public ProcessorSelector getProcessorSelector() {
        return this.processorSelector;
    }

    @Override
    public void setProcessorSelector(ProcessorSelector preferableProcessorSelector) {
        this.processorSelector = preferableProcessorSelector;
    }

    public TaskQueue<AsyncReadQueueRecord> getAsyncReadQueue() {
        return this.asyncReadQueue;
    }

    public TaskQueue<AsyncWriteQueueRecord> getAsyncWriteQueue() {
        return this.asyncWriteQueue;
    }

    @Override
    public AttributeHolder getAttributes() {
        return this.attributes;
    }

    @Override
    public <M> GrizzlyFuture<ReadResult<M, SocketAddress>> read() throws IOException {
        return this.read((CompletionHandler<ReadResult<M, SocketAddress>>)null);
    }

    @Override
    public <M> GrizzlyFuture<ReadResult<M, SocketAddress>> read(CompletionHandler<ReadResult<M, SocketAddress>> completionHandler) throws IOException {
        Processor obtainedProcessor = this.obtainProcessor(IOEvent.READ);
        return obtainedProcessor.read(this, completionHandler);
    }

    @Override
    public <M> GrizzlyFuture<WriteResult<M, SocketAddress>> write(M message) throws IOException {
        return this.write(null, message, null);
    }

    @Override
    public <M> GrizzlyFuture<WriteResult<M, SocketAddress>> write(M message, CompletionHandler<WriteResult<M, SocketAddress>> completionHandler) throws IOException {
        return this.write(null, message, completionHandler);
    }

    @Override
    public <M> GrizzlyFuture<WriteResult<M, SocketAddress>> write(SocketAddress dstAddress, M message, CompletionHandler<WriteResult<M, SocketAddress>> completionHandler) throws IOException {
        Processor obtainedProcessor = this.obtainProcessor(IOEvent.WRITE);
        return obtainedProcessor.write(this, dstAddress, message, completionHandler);
    }

    @Override
    public boolean isOpen() {
        return this.channel != null && this.channel.isOpen() && !this.isClosed.get();
    }

    @Override
    public GrizzlyFuture<Connection> close() throws IOException {
        return this.close((CompletionHandler<Connection>)null);
    }

    @Override
    public GrizzlyFuture<Connection> close(CompletionHandler<Connection> completionHandler) throws IOException {
        if (!this.isClosed.getAndSet(true)) {
            this.preClose();
            this.notifyCloseListeners();
            NIOConnection.notifyProbesClose(this);
            try {
                SafeFutureImpl<Connection> resultFuture = SafeFutureImpl.create();
                this.transport.getSelectorHandler().executeInSelectorThread(this.selectorRunner, new Runnable(){

                    @Override
                    public void run() {
                        try {
                            NIOConnection.this.transport.closeConnection(NIOConnection.this);
                        }
                        catch (IOException e) {
                            logger.log(Level.FINE, "Error during connection close", e);
                        }
                    }
                }, (CompletionHandler<Runnable>)new CompletionHandlerAdapter<Connection, Runnable>(resultFuture, completionHandler){

                    @Override
                    protected Connection adapt(Runnable result2) {
                        return NIOConnection.this;
                    }

                    @Override
                    public void failed(Throwable throwable) {
                        try {
                            NIOConnection.this.transport.closeConnection(NIOConnection.this);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        this.completed(null);
                    }
                });
                return resultFuture;
            }
            catch (Exception e) {
                this.transport.closeConnection(this);
            }
        }
        return ReadyFutureImpl.create(this);
    }

    @Override
    public void addCloseListener(Connection.CloseListener closeListener) {
        if (!this.isClosed.get()) {
            this.closeListeners.add(closeListener);
            if (this.isClosed.get() && this.closeListeners.remove(closeListener)) {
                try {
                    closeListener.onClosed(this);
                }
                catch (IOException ignored) {}
            }
        } else {
            try {
                closeListener.onClosed(this);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean removeCloseListener(Connection.CloseListener closeListener) {
        return this.closeListeners.remove(closeListener);
    }

    @Override
    public void notifyConnectionError(Throwable error) {
        NIOConnection.notifyProbesError(this, error);
    }

    @Override
    public final MonitoringConfig<ConnectionProbe> getMonitoringConfig() {
        return this.monitoringConfig;
    }

    protected static void notifyProbesBind(NIOConnection connection) {
        ConnectionProbe[] probes = connection.monitoringConfig.getProbesUnsafe();
        if (probes != null) {
            for (ConnectionProbe probe : probes) {
                probe.onBindEvent(connection);
            }
        }
    }

    protected static void notifyProbesAccept(NIOConnection serverConnection, NIOConnection clientConnection) {
        ConnectionProbe[] probes = serverConnection.monitoringConfig.getProbesUnsafe();
        if (probes != null) {
            for (ConnectionProbe probe : probes) {
                probe.onAcceptEvent(serverConnection, clientConnection);
            }
        }
    }

    protected static void notifyProbesConnect(NIOConnection connection) {
        ConnectionProbe[] probes = connection.monitoringConfig.getProbesUnsafe();
        if (probes != null) {
            for (ConnectionProbe probe : probes) {
                probe.onConnectEvent(connection);
            }
        }
    }

    protected static void notifyProbesRead(NIOConnection connection, Buffer data, int size2) {
        ConnectionProbe[] probes = connection.monitoringConfig.getProbesUnsafe();
        if (probes != null) {
            for (ConnectionProbe probe : probes) {
                probe.onReadEvent(connection, data, size2);
            }
        }
    }

    protected static void notifyProbesWrite(NIOConnection connection, Buffer data, int size2) {
        ConnectionProbe[] probes = connection.monitoringConfig.getProbesUnsafe();
        if (probes != null) {
            for (ConnectionProbe probe : probes) {
                probe.onWriteEvent(connection, data, size2);
            }
        }
    }

    protected static void notifyIOEventReady(NIOConnection connection, IOEvent ioEvent) {
        ConnectionProbe[] probes = connection.monitoringConfig.getProbesUnsafe();
        if (probes != null) {
            for (ConnectionProbe probe : probes) {
                probe.onIOEventReadyEvent(connection, ioEvent);
            }
        }
    }

    protected static void notifyIOEventEnabled(NIOConnection connection, IOEvent ioEvent) {
        ConnectionProbe[] probes = connection.monitoringConfig.getProbesUnsafe();
        if (probes != null) {
            for (ConnectionProbe probe : probes) {
                probe.onIOEventEnableEvent(connection, ioEvent);
            }
        }
    }

    protected static void notifyIOEventDisabled(NIOConnection connection, IOEvent ioEvent) {
        ConnectionProbe[] probes = connection.monitoringConfig.getProbesUnsafe();
        if (probes != null) {
            for (ConnectionProbe probe : probes) {
                probe.onIOEventDisableEvent(connection, ioEvent);
            }
        }
    }

    protected static void notifyProbesClose(NIOConnection connection) {
        ConnectionProbe[] probes = connection.monitoringConfig.getProbesUnsafe();
        if (probes != null) {
            for (ConnectionProbe probe : probes) {
                probe.onCloseEvent(connection);
            }
        }
    }

    protected static void notifyProbesError(NIOConnection connection, Throwable error) {
        ConnectionProbe[] probes = connection.monitoringConfig.getProbesUnsafe();
        if (probes != null) {
            for (ConnectionProbe probe : probes) {
                probe.onErrorEvent(connection, error);
            }
        }
    }

    private void notifyCloseListeners() {
        Connection.CloseListener closeListener;
        while ((closeListener = this.closeListeners.poll()) != null) {
            try {
                closeListener.onClosed(this);
            }
            catch (IOException iOException) {}
        }
    }

    protected abstract void preClose();

    @Override
    public final void enableIOEvent(IOEvent ioEvent) throws IOException {
        int interest = ioEvent.getSelectionKeyInterest();
        if (interest == 0) {
            return;
        }
        NIOConnection.notifyIOEventEnabled(this, ioEvent);
        SelectorHandler selectorHandler = this.transport.getSelectorHandler();
        selectorHandler.registerKeyInterest(this.selectorRunner, this.selectionKey, interest);
    }

    @Override
    public final void disableIOEvent(IOEvent ioEvent) throws IOException {
        int interest = ioEvent.getSelectionKeyInterest();
        if (interest == 0) {
            return;
        }
        NIOConnection.notifyIOEventDisabled(this, ioEvent);
        SelectorHandler selectorHandler = this.transport.getSelectorHandler();
        selectorHandler.deregisterKeyInterest(this.selectorRunner, this.selectionKey, interest);
    }

    protected final void checkEmptyRead(int size2) {
        if (WIN32) {
            if (size2 == 0) {
                this.zeroByteReadCount = (short)(this.zeroByteReadCount + 1);
                short count2 = this.zeroByteReadCount;
                if (count2 >= 100) {
                    try {
                        this.close();
                    }
                    catch (IOException iOException) {}
                }
            } else {
                this.zeroByteReadCount = 0;
            }
        }
    }
}

